/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSNTSECURITYDESCRIPTOR_P_H
#define RDSNTSECURITYDESCRIPTOR_P_H

#include <QxtPimpl>
#include "rdsntsecuritydescriptor.h"

#include <QSharedDataPointer>
#include <QString>

#include <RdsSid>
#include <RdsGuid>
#include <ReturnValue>

/**
	@author Chris Vickery <chris@resara.com>
 */
class RdsNtSecurityDescriptorData : public QSharedData
{
public:
	RdsNtSecurityDescriptor::Flags flags;
	RdsSid owner;
	RdsSid group;
	RdsNtSecurityDescriptor::AclFlags daclFlags;
	RdsNtSecurityDescriptor::AclFlags saclFlags;
	QList<RdsAce> dacl;
	QList<RdsAce> sacl;
};

class RdsNtSecurityDescriptorPrivate : public QxtPrivate<RdsNtSecurityDescriptor>
{
public:
	RdsNtSecurityDescriptorPrivate()
	{
	}
	QSharedDataPointer<RdsNtSecurityDescriptorData> data;
	ReturnValue parseString(const QString &str);
	ReturnValue parseByteArray(const QByteArray &data);
	static QString aclFlagsToString(RdsNtSecurityDescriptor::AclFlags flags);
	static RdsNtSecurityDescriptor::AclFlags stringToAclFlags(const QString &str);
};

class RdsAceData : public QSharedData
{
public:
	RdsAceData() :
			access(0)
	{
		type = (RdsAce::Type)0;
		flags = (RdsAce::Flags)0;
	}
	RdsAce::Type type;
	RdsAce::Flags flags;
	quint32 access;
	RdsGuid object;
	RdsGuid inheritedObject;
	RdsSid sid;
};

class RdsAcePrivate : public QxtPrivate<RdsAce>
{
public:
	RdsAcePrivate()
	{
	}
	ReturnValue parseString(const QString &str);
	ReturnValue parseByteArray(const QByteArray &data);

	static RdsAce::Type stringToType(const QString &str);
	static QString typeToString(const RdsAce::Type &type);
	static RdsAce::Flags stringToFlags(const QString &str);
	static QString flagsToString(const RdsAce::Flags &type);
	static RdsAce::AccessFlags stringToAccess(const QString &str);
	static QString accessToString(const RdsAce::AccessFlags &type);

	QSharedDataPointer<RdsAceData> data;
};

#endif
