/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSNTSECURITYDESCRIPTOR_H
#define RDSNTSECURITYDESCRIPTOR_H

#include <QxtPimpl>
#include <QFlags>
#include <QMetaType>
#include <QVariant>
#include <rdsglobal.h>

class QString;
class QByteArray;
class RdsNtSecurityDescriptorPrivate;
class RdsNtSecurityDescriptor;
class RdsAce;
class RdsAcePrivate;
class RdsSid;
class RdsGuid;

/**
	@author Chris Vickery <chris@resara.com>
*/

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsNtSecurityDescriptor& desc);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsNtSecurityDescriptor& desc);

class RDS_SHARED_EXPORT RdsNtSecurityDescriptor
{
	QXT_DECLARE_PRIVATE(RdsNtSecurityDescriptor);
        friend RDS_SHARED_EXPORT QDataStream& ::operator>> (QDataStream& s, RdsNtSecurityDescriptor& p);
        friend RDS_SHARED_EXPORT QDataStream& ::operator<< (QDataStream& s, const RdsNtSecurityDescriptor& p);
public:
	enum Flag
	{
		OwnerDefaulted = (0x0001),
		GroupDefaulted = (0x0002),
		DaclPresent = (0x0004),
		DaclDefaulted = (0x0008),
		SaclPresent = (0x0010),
		SaclDefaulted = (0x0020),
		DaclTrusted = (0x0040),
		ServerSecurity = (0x0080),
		RMControlValid = (0x4000),
		SelfRelative = (0x8000),
	};
	Q_DECLARE_FLAGS(Flags, Flag);

	enum AclFlag
	{
		Protected = 0x10,			// "P" 	SDDL_PROTECTED 	The SE_DACL_PROTECTED flag is set.
		AutoInheritReq = 0x01,		// "AR" 	SDDL_AUTO_INHERIT_REQ 	The SE_DACL_AUTO_INHERIT_REQ flag is set.
		AutoInherited = 0x04,		// "AI" 	SDDL_AUTO_INHERITED 	The SE_DACL_AUTO_INHERITED flag is set.
	};
	Q_DECLARE_FLAGS(AclFlags, AclFlag);

	RdsNtSecurityDescriptor();
	RdsNtSecurityDescriptor(const char *securityString);
	RdsNtSecurityDescriptor(const QString &securityString);
	RdsNtSecurityDescriptor(const QByteArray &securityString);
	RdsNtSecurityDescriptor(const RdsNtSecurityDescriptor &other);
	~RdsNtSecurityDescriptor();


	RdsSid owner() const;
	void setOwner(const RdsSid &sid);
	RdsSid group() const;
	void setGroup(const RdsSid &sid);
	RdsNtSecurityDescriptor::AclFlags daclFlags() const;
	void setDaclFlags(RdsNtSecurityDescriptor::AclFlags flags);
	RdsNtSecurityDescriptor::AclFlags saclFlags() const;
	void setSaclFlags(RdsNtSecurityDescriptor::AclFlags flags);
	const QList<RdsAce> &dacl() const;
	const QList<RdsAce> &daclConst() const;
	QList<RdsAce> &dacl();
	void setDacl(const QList<RdsAce> &list);
	const QList<RdsAce> &sacl() const;
	const QList<RdsAce> &saclConst() const;
	QList<RdsAce> &sacl();
	void setSacl(const QList<RdsAce> &list);

	QString toString() const;
	QByteArray toBinary(qint32 offset = 0) const;

	RdsNtSecurityDescriptor& operator=(const RdsNtSecurityDescriptor &other);
	RdsNtSecurityDescriptor& operator=(const QString &str);
	RdsNtSecurityDescriptor& operator=(const QByteArray &str);
	RdsNtSecurityDescriptor& operator=(const char *str);
	bool operator==(const RdsNtSecurityDescriptor &other) const;
	bool operator!=(const RdsNtSecurityDescriptor &other) const;
	bool operator==(const QString &str) const;
	bool operator!=(const QString &str) const;
	bool operator==(const QByteArray &str) const;
	bool operator!=(const QByteArray &str) const;
	bool operator==(const char *str) const;
	bool operator!=(const char *str) const;
	inline operator QVariant() const
	{
		return QVariant::fromValue(*this);
	}
	
protected:
	virtual QList<RdsAce> sortDacl(QList<RdsAce> dacl) const;
	virtual QList<RdsAce> sortSacl(QList<RdsAce> sacl) const;
};

RDS_SHARED_EXPORT QDebug operator<<(QDebug dbg, const RdsNtSecurityDescriptor& desc);

Q_DECLARE_OPERATORS_FOR_FLAGS(RdsNtSecurityDescriptor::AclFlags);
Q_DECLARE_OPERATORS_FOR_FLAGS(RdsNtSecurityDescriptor::Flags);

Q_DECLARE_METATYPE(RdsNtSecurityDescriptor);
Q_DECLARE_TYPEINFO(RdsNtSecurityDescriptor, Q_MOVABLE_TYPE);

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsAce& ace);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsAce& ace);

class RDS_SHARED_EXPORT RdsAce
{
	QXT_DECLARE_PRIVATE(RdsAce);
	friend RDS_SHARED_EXPORT QDataStream& ::operator>> (QDataStream& s, RdsAce& p);
	friend RDS_SHARED_EXPORT QDataStream& ::operator<< (QDataStream& s, const RdsAce& p);
public:
	enum Type
	{
		Allow,			// "A" 	SDDL_ACCESS_ALLOWED 	ACCESS_ALLOWED_ACE_TYPE
		Deny,			// "D" 	SDDL_ACCESS_DENIED 	ACCESS_DENIED_ACE_TYPE
		Audit,			// "AU" 	SDDL_AUDIT 	SYSTEM_AUDIT_ACE_TYPE
		Alarm,			// "AL" 	SDDL_ALARM 	SYSTEM_ALARM_ACE_TYPE
		MandatoryLabel,	// "ML"	SDDL_MANDATORY_LABEL	SYSTEM_MANDATORY_LABEL_ACE
		ObjectAllow,		// "OA" 	SDDL_OBJECT_ACCESS_ALLOWED 	ACCESS_ALLOWED_OBJECT_ACE_TYPE
		ObjectDeny,		// "OD" 	SDDL_OBJECT_ACCESS_DENIED 	ACCESS_DENIED_OBJECT_ACE_TYPE
		ObjectAudit,		// "OU" 	SDDL_OBJECT_AUDIT 	SYSTEM_AUDIT_OBJECT_ACE_TYPE
		ObjectAlarm,		// "OL" 	SDDL_OBJECT_ALARM 	SYSTEM_ALARM_OBJECT_ACE_TYPE
		Unknown,
	};

	enum Flag
	{
		ObjectInherit = 1 << 1,		// "OI" 	SDDL_OBJECT_INHERIT 	OBJECT_INHERIT_ACE
  		FolderInherit = 1 << 1,			//same as ObjectInherit
		ContainerInherit = 1 << 0,	// "CI" 	SDDL_CONTAINER_INHERIT 	CONTAINER_INHERIT_ACE
  		FileInherit = 1 << 0,	//Same as ContainerInherit
		NoPropogate = 1 << 2,		// "NP" 	SDDL_NO_PROPAGATE 	NO_PROPAGATE_INHERIT_ACE
		InheritOnly = 1 << 3,		// "IO" 	SDDL_INHERIT_ONLY 	INHERIT_ONLY_ACE
		Inherited = 1 << 4,			// "ID" 	SDDL_INHERITED 	INHERITED_ACE
		Success = 1 << 5,			// "SA" 	SDDL_AUDIT_SUCCESS 	SUCCESSFUL_ACCESS_ACE_FLAG
		Failure = 1 << 6,			// "FA" 	SDDL_AUDIT_FAILURE 	FAILED_ACCESS_ACE_FLAG
	};
	Q_DECLARE_FLAGS(Flags, Flag);

	enum AccessFlag
	{
// 		Generic access rights
		All = 0x10000000,			// "GA" 	SDDL_GENERIC_ALL 	GENERIC_ALL
		Read = 0x80000000,		// "GR" 	SDDL_GENERIC_READ 	GENERIC_READ
		Write = 0x40000000,		// "GW" 	SDDL_GENERIC_WRITE 	GENERIC_WRITE
		Execute = 0x20000000,		// "GX" 	SDDL_GENERIC_EXECUTE 	GENERIC_EXECUTE

// 		Standard access rights
		StandardAll = 0x001F0000,
		ReadControl = 0x00020000,	// "RC" 	SDDL_READ_CONTROL 	READ_CONTROL
		Delete = 0x00010000,		// "SD" 	SDDL_STANDARD_DELETE 	DELETE
		WriteDac = 0x00040000,		// "WD" 	SDDL_WRITE_DAC 	WRITE_DAC
		WriteOwner = 0x00080000,	// "WO" 	SDDL_WRITE_OWNER 	WRITE_OWNER

// 		Directory service object access rights
		ReadProperty = 0x00000010,	// "RP" 	SDDL_READ_PROPERTY 	ADS_RIGHT_DS_READ_PROP
		WriteProperty = 0x00000020,	// "WP" 	SDDL_WRITE_PROPERTY 	ADS_RIGHT_DS_WRITE_PROP
		CreateChild = 0x00000001,	// "CC" 	SDDL_CREATE_CHILD 	ADS_RIGHT_DS_CREATE_CHILD
		DeleteChild = 0x00000002,	// "DC" 	SDDL_DELETE_CHILD 	ADS_RIGHT_DS_DELETE_CHILD
		ListChildren = 0x00000004,	// "LC" 	SDDL_LIST_CHILDREN 	ADS_RIGHT_ACTRL_DS_LIST
		SelfWrite = 0x00000008,		// "SW" 	SDDL_SELF_WRITE 	ADS_RIGHT_DS_SELF
		ListObject = 0x00000080,		// "LO" 	SDDL_LIST_OBJECT 	ADS_RIGHT_DS_LIST_OBJECT
		DeleteTree = 0x00000040,	// "DT" 	SDDL_DELETE_TREE 	ADS_RIGHT_DS_DELETE_TREE
		ControlAccess = 0x00000100,	// "CR" 	SDDL_CONTROL_ACCESS 	ADS_RIGHT_DS_CONTROL_ACCESS

// 		File access rights
		FileAll = 0x000001ff,		// "FA" 	SDDL_FILE_ALL 	FILE_ALL_ACCESS
		ReadFile = 0x00000001,		// "FR" 	SDDL_FILE_READ 	FILE_GENERIC_READ
		WriteFile = 0x00000002,		// "FW" 	SDDL_FILE_WRITE 	FILE_GENERIC_WRITE
		ExecuteFile = 0x00000020,	// "FX" 	SDDL_FILE_EXECUTE 	FILE_GENERIC_EXECUTE

// 		Registry key access rights
		KeyAll = 0x0ce0fe00,	//1 << 21,		// "KA" 	SDDL_KEY_ALL 	KEY_ALL_ACCESS
		ReadKey = 0x0ce0fe00,	//1 << 22,		// "KR" 	SDDL_KEY_READ 	KEY_READ
		WriteKey = 0x0ce0fe00,	// 1 << 23,		// "KW" 	SDDL_KEY_WRITE 	KEY_WRITE
		ExecuteKey = 0x0ce0fe00,	//1 << 24,	// "KX" 	SDDL_KEY_EXECUTE 	KEY_EXECUTE

// 		Mandatory label rights
		MLNoWrite = 0x0ce0fe00,	//1 << 25,	// "NR"	SDDL_NO_WRITE_UP	SYSTEM_MANDATORY_LABEL_NO_WRITE_UP
		MLNoRead = 0x0ce0fe00,	//1 << 26,	// "NW"	SDDL_NO_READ_UP	SYSTEM_MANDATORY_LABEL_NO_READ_UP
		MLNoExecute = 0x0ce0fe00,	//1 << 27,	// "NX"	SDDL_NO_EXECUTE_UP	SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP
	};
	Q_DECLARE_FLAGS(AccessFlags, AccessFlag);

	RdsAce();
	RdsAce(const char *ace);
	RdsAce(const QString &ace);
	RdsAce(const QByteArray &ace);
	RdsAce(const RdsAce &other);
	~RdsAce();

	Type type() const;
	void setType(Type type);
	Flags flags() const;
	void setFlags(Flags flags);
	AccessFlags access() const;
	void setAccess(AccessFlags access);
	RdsGuid object() const;
	void setObject(const RdsGuid &object);
	RdsGuid inheritedObject() const;
	void setInheritedObject(const RdsGuid &object);
	RdsSid sid() const;
	void setSid(const RdsSid &sid);

	QString toString() const;
	QByteArray toBinary() const;

	RdsAce& operator=(const RdsAce &other);
	RdsAce& operator=(const QString &str);
	RdsAce& operator=(const QByteArray &str);
	RdsAce& operator=(const char *str);
	bool operator==(const RdsAce &other) const;
	bool operator!=(const RdsAce &other) const;
	bool operator==(const QString &str) const;
	bool operator!=(const QString &str) const;
	bool operator==(const QByteArray &str) const;
	bool operator!=(const QByteArray &str) const;
	bool operator==(const char *str) const;
	bool operator!=(const char *str) const;

	inline operator QVariant() const
	{
		return QVariant::fromValue(*this);
	}
};

RDS_SHARED_EXPORT QDebug operator<<(QDebug dbg, const RdsAce& ace);


Q_DECLARE_OPERATORS_FOR_FLAGS(RdsAce::AccessFlags);
Q_DECLARE_OPERATORS_FOR_FLAGS(RdsAce::Flags);

Q_DECLARE_METATYPE(RdsAce);
Q_DECLARE_TYPEINFO(RdsAce, Q_MOVABLE_TYPE);

/*
	enum AccessFlag
{
// 		Generic access rights
		All = 0x10000000,			// "GA" 	SDDL_GENERIC_ALL 	GENERIC_ALL
		Read = 0x80000000,		// "GR" 	SDDL_GENERIC_READ 	GENERIC_READ
		Write = 0x40000000,		// "GW" 	SDDL_GENERIC_WRITE 	GENERIC_WRITE
		Execute = 0x20000000,		// "GX" 	SDDL_GENERIC_EXECUTE 	GENERIC_EXECUTE

// 		Standard access rights
		StandardAll = 0x001F0000,
		ReadControl = 0x00020000,	// "RC" 	SDDL_READ_CONTROL 	READ_CONTROL
		Delete = 0x00010000,		// "SD" 	SDDL_STANDARD_DELETE 	DELETE
		WriteDac = 0x00040000,		// "WD" 	SDDL_WRITE_DAC 	WRITE_DAC
		WriteOwner = 0x00080000,	// "WO" 	SDDL_WRITE_OWNER 	WRITE_OWNER

// 		Directory service object access rights
		ReadProperty = 0x00000010,	// "RP" 	SDDL_READ_PROPERTY 	ADS_RIGHT_DS_READ_PROP
		WriteProperty = 0x00000020,	// "WP" 	SDDL_WRITE_PROPERTY 	ADS_RIGHT_DS_WRITE_PROP
		CreateChild = 0x00000001,	// "CC" 	SDDL_CREATE_CHILD 	ADS_RIGHT_DS_CREATE_CHILD
		DeleteChild = 0x00000002,	// "DC" 	SDDL_DELETE_CHILD 	ADS_RIGHT_DS_DELETE_CHILD
		ListChildren = 0x00000004,	// "LC" 	SDDL_LIST_CHILDREN 	ADS_RIGHT_ACTRL_DS_LIST
		SelfWrite = 0x00000008,		// "SW" 	SDDL_SELF_WRITE 	ADS_RIGHT_DS_SELF
		ListObject = 0x00000080,		// "LO" 	SDDL_LIST_OBJECT 	ADS_RIGHT_DS_LIST_OBJECT
		DeleteTree = 0x00000040,	// "DT" 	SDDL_DELETE_TREE 	ADS_RIGHT_DS_DELETE_TREE
		ControlAccess = 0x00000100,	// "CR" 	SDDL_CONTROL_ACCESS 	ADS_RIGHT_DS_CONTROL_ACCESS

// 		File access rights
		FileAll = 0x000001ff,		// "FA" 	SDDL_FILE_ALL 	FILE_ALL_ACCESS
		ReadFile = 0x00000001,		// "FR" 	SDDL_FILE_READ 	FILE_GENERIC_READ
		WriteFile = 0x00000002,		// "FW" 	SDDL_FILE_WRITE 	FILE_GENERIC_WRITE
		ExecuteFile = 0x00000020,	// "FX" 	SDDL_FILE_EXECUTE 	FILE_GENERIC_EXECUTE

// 		Registry key access rights
		KeyAll = 0x0ce0fe00,	//1 << 21,		// "KA" 	SDDL_KEY_ALL 	KEY_ALL_ACCESS
		ReadKey = 0x0ce0fe00,	//1 << 22,		// "KR" 	SDDL_KEY_READ 	KEY_READ
		WriteKey = 0x0ce0fe00,	// 1 << 23,		// "KW" 	SDDL_KEY_WRITE 	KEY_WRITE
		ExecuteKey = 0x0ce0fe00,	//1 << 24,	// "KX" 	SDDL_KEY_EXECUTE 	KEY_EXECUTE

// 		Mandatory label rights
		MLNoWrite = 0x0ce0fe00,	//1 << 25,	// "NR"	SDDL_NO_WRITE_UP	SYSTEM_MANDATORY_LABEL_NO_WRITE_UP
		MLNoRead = 0x0ce0fe00,	//1 << 26,	// "NW"	SDDL_NO_READ_UP	SYSTEM_MANDATORY_LABEL_NO_READ_UP
		MLNoExecute = 0x0ce0fe00,	//1 << 27,	// "NX"	SDDL_NO_EXECUTE_UP	SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP
};
*/

#endif
