/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSNTACL_H
#define RDSNTACL_H

#include <QxtPimpl>
#include <RdsNtSecurityDescriptor>
#include <rdsglobal.h>

namespace QtRpc
{
class ReturnValue;
}

using QtRpc::ReturnValue;
class RdsNtAclPrivate;
class QString;
class QStringList;
class QDebug;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RDS_SHARED_EXPORT RdsNtAcl : public RdsNtSecurityDescriptor
{
	QXT_DECLARE_PRIVATE(RdsNtAcl);
public:
	/*
		enum PermissionFlag
		{
			TraverseFolder = 1 << 0,
			ExecuteFile = 1 << 0,
			ListFolder = 1 << 1,
			ReadData = 1 << 1,
			ReadAttributes = 1 << 2,
			ReadExtendedAttributes = 1 << 3,
			CreateFiles = 1 << 4,
			WriteData = 1 << 4,
			CreateFolders = 1 << 5,
			AppendData = 1 << 5,
			WriteAttributes = 1 << 6,
			WriteExtendedAttributes = 1 << 7,
			DeleteFiles = 1 << 8,
			Delete = 1 << 9,
			ReadPermissions = 1 << 10,
			WritePermissions = 1 << 11,
			TakeOwnership = 1 << 12,
		};
		Q_DECLARE_FLAGS(PermissionFlags, PermissionFlag);
		enum InheritenceFlag
		{
			ThisFolder = 1 << 0,
			Folders = 1 << 1,
			Files = 1 << 2,
			Inherited = 1 << 3
		};
		Q_DECLARE_FLAGS(Inheritence, InheritenceFlag);
	// */
	RdsNtAcl();
	RdsNtAcl(const char *str);
	RdsNtAcl(const QString &str);
	RdsNtAcl(const QByteArray &str);
	RdsNtAcl(const RdsNtAcl &other);
	~RdsNtAcl();

	QByteArray toBinary() const;
	/**
	 *        Saves the Acl to a file
	 * @param path the path to the file where the acl will be saved
	 * @return true on success, error on failure.
	 */
	ReturnValue save(const QString& path, bool forceinherit = false) const;

	RdsNtAcl operator=(const RdsNtAcl &other);


	/**
	 *        Gets the ACL from a file
	 * @param path the location of the file the ACL is in
	 * @return RdsNtAcl with the acl from the file.
	 */
	static ReturnValue fromFile(const QString &path);
	/**
	 *        Gets a string of the ACL
	 * @param path the location of the ACL file
	 * @return QString
	 */
	static QString getNtAclString(const QString &path);
	static ReturnValue getInheritedPermissions(const QString &path);
	static ReturnValue propagateInheritedPermissions(const QString &path, bool forceinherit = false);
	static ReturnValue updateInheritedPermissions(const QString &path, bool forceinherit = false);

protected:
	virtual QList<RdsAce> sortDacl(QList<RdsAce> dacl) const;
};

Q_DECLARE_METATYPE(RdsNtAcl);

RDS_SHARED_EXPORT QDebug operator<<(QDebug, const RdsNtAcl& acl);

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsNtAcl& acl);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsNtAcl& acl);

#endif
