/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSGUID_H
#define RDSGUID_H

#include <QxtPimpl>
#include <QMetaType>
#include <QVariant>
#include <ReturnValue>
#include <rdsglobal.h>

class QString;
class QByteArray;
class RdsGuidPrivate;
class RdsGuid;

/**
	@author Chris Vickery <chris@resara.com>
 */

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsGuid& guid);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsGuid& guid);

class RDS_SHARED_EXPORT RdsGuid
{
	QXT_DECLARE_PRIVATE(RdsGuid);
        friend RDS_SHARED_EXPORT QDataStream& ::operator>> (QDataStream& d, RdsGuid& guid);
        friend RDS_SHARED_EXPORT QDataStream& ::operator<< (QDataStream& d, const RdsGuid& guid);
public:
	RdsGuid();
	RdsGuid(const char *str);
	RdsGuid(const QString &str);
	RdsGuid(const QByteArray &data);
	RdsGuid(const RdsGuid &other);
	~RdsGuid();

	quint32 timeLow() const;
	ReturnValue setTimeLow(quint32 timeLow);
	quint16 timeMiddle() const;
	ReturnValue setTimeMiddle(quint16 timeMiddle);
	quint16 timeHiAndVersion() const;
	ReturnValue setTimeHiAndVersion(quint16 timeHiAndVersion);
	quint16 clockSequence() const;
	ReturnValue setClockSequence(const quint16 clockSequence);
	quint64 node() const;
	ReturnValue setNode(const quint64 node);
	bool isNull() const;

	QString toString() const;
	QByteArray toBinary() const;

	RdsGuid& operator=(const RdsGuid &other);
	RdsGuid& operator=(const QString &other);
	RdsGuid& operator=(const QByteArray &other);
	RdsGuid& operator=(const char *other);
	bool operator==(const RdsGuid &other) const;
	bool operator!=(const RdsGuid &other) const;
	bool operator==(const QString &str) const;
	bool operator!=(const QString &str) const;
	bool operator==(const QByteArray &str) const;
	bool operator!=(const QByteArray &str) const;
	bool operator==(const char *str) const;
	bool operator!=(const char *str) const;
	inline operator QVariant() const
	{
		return(QVariant::fromValue(*this));
	}
	inline operator ReturnValue() const
	{
		return(ReturnValue::fromValue(*this));
	}
};

RDS_SHARED_EXPORT QDebug operator<<(QDebug dbg, const RdsGuid& guid);

Q_DECLARE_METATYPE(RdsGuid);
Q_DECLARE_TYPEINFO(RdsGuid, Q_MOVABLE_TYPE);

#endif
