/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsentity.h"
#include "rdsentity_p.h"
#include <ReturnValue>

QTRPC_REGISTER_METATYPE(RdsEntity);

RdsEntity::RdsEntity(const RdsEntity &object)
{
	qxt_d().data = object.qxt_d().data;
}

RdsEntity::RdsEntity()
{
	qxt_d().data->group = false;
	qxt_d().data->hasmore = false;
}

RdsEntity::~RdsEntity()
{
}

RdsEntity &RdsEntity::operator =(const RdsEntity &object)
{
	qxt_d().data = object.qxt_d().data;
	return(*this);
}

QString RdsEntity::name() const
{
	return(qxt_d().data->name);
}

void RdsEntity::setName(QString name)
{
	qxt_d().data->name = name;
}

QString RdsEntity::id() const
{
	return(qxt_d().data->id);
}

void RdsEntity::setId(QString name)
{
	qxt_d().data->id = name;
}

QString RdsEntity::type() const
{
	return(qxt_d().data->type);
}

void RdsEntity::setType(QString type)
{
	qxt_d().data->type= type;
}

bool RdsEntity::visible() const
{
	return(qxt_d().data->visible);
}

void RdsEntity::setVisible(bool visible)
{
	qxt_d().data->visible = visible;
}

QVariantMap &RdsEntity::metadata()
{
	return(qxt_d().data->metadata);
}

QList<RdsEntity> &RdsEntity::children()
{
	return(qxt_d().data->children);
}

QVariantMap RdsEntity::metadata() const
{
	return(qxt_d().data->metadata);
}

QList<RdsEntity> RdsEntity::children() const
{
	return(qxt_d().data->children);
}

QDataStream& operator<<(QDataStream& d, const RdsEntity& object)
{
	d << object.qxt_d().data->name;
	d << object.qxt_d().data->id;
	d << object.qxt_d().data->type;
	d << object.qxt_d().data->visible;
	d << object.qxt_d().data->metadata;
	d << object.qxt_d().data->children;
	d << object.qxt_d().data->parent;
	d << object.qxt_d().data->group;
	d << object.qxt_d().data->hasmore;
	return d;
}

QDataStream& operator>>(QDataStream& d, RdsEntity& object)
{
	d >> object.qxt_d().data->name;
	d >> object.qxt_d().data->id;
	d >> object.qxt_d().data->type;
	d >> object.qxt_d().data->visible;
	d >> object.qxt_d().data->metadata;
	d >> object.qxt_d().data->children;
	d >> object.qxt_d().data->parent;
	d >> object.qxt_d().data->group;
	d >> object.qxt_d().data->hasmore;
	return d;
}

QString RdsEntity::parent() const
{
	return(qxt_d().data->parent);
}

void RdsEntity::setParent(QString parent)
{
	qxt_d().data->parent = parent;
}

bool RdsEntity::isGroup() const
{
	return(qxt_d().data->group);
}

void RdsEntity::setGroup(bool isgroup)
{
	qxt_d().data->group = isgroup;
}


bool RdsEntity::hasMore() const
{
	return(qxt_d().data->hasmore);
}

void RdsEntity::setHasMore(bool more)
{
	qxt_d().data->hasmore = more;
}
