/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSADOBJECT_H
#define RDSADOBJECT_H

#include <RdsLdapObject>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsAdObjectPrivate;
class RdsSid;
class RdsNtSecurityDescriptor;
class RdsGuid;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_SHARED_EXPORT RdsAdObject : public RdsLdapObject
{
	QXT_DECLARE_PRIVATE(RdsAdObject);
public:
	RdsAdObject();
	RdsAdObject(const QString &dn);
	RdsAdObject(QString dn, RdsLdapSession *session);
	RdsAdObject(const RdsAdObject &other);
	~RdsAdObject();
	RdsAdObject& operator=(const RdsAdObject &other);

	//Util Functions
	/**
	 *         Gets the sid
	 * @return RdsSid on success, error on failure
	 */
	virtual ReturnValue sid() const;
	/**
	 *        Sets the sid
	 * @param sid
	 * @return true on success, error on failure
	 */
	virtual ReturnValue setSid(const RdsSid &sid);
	/**
	 *        Gets the security descriptor
	 * @return RdsNtSecurityDescriptor on success, error on failure.
	 */
	virtual ReturnValue securityDescriptor() const;
	/**
	 *        Sets the security descriptor
	 * @param desc the security descriptor
	 * @return true on success, error on failure
	 */
	virtual ReturnValue setSecurityDescriptor(const RdsNtSecurityDescriptor &desc);
	/**
	 *        Gets the GUID
	 * @return RdsGuid on success, error on failure
	 */
	virtual ReturnValue guid() const;
	/**
	 *        Sets the GUID
	 * @param guid
	 * @return true on success, error on failure
	 */
	virtual ReturnValue setGuid(const RdsGuid &guid);
};

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsAdObject& object);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsAdObject& object);
Q_DECLARE_METATYPE(RdsAdObject);

#endif
