/***************************************************************************
 *   Copyright (C) 2009 by Brendan Powers   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RDSTHREADEDJOB_P_H
#define RDSTHREADEDJOB_P_H

#include <QxtPimpl>
#include "rdsthreadedjob.h"

#include <QThread>
#include <QMutex>
#include <QWaitCondition>

class RdsThreadedJobHelper : public QObject
{
	Q_OBJECT;
public:
	explicit RdsThreadedJobHelper(RdsJob* job);
	ReturnValue invokeMethod(const QString &slot);
private slots:
	void doInvokeMethod(const QString &slot);
private:
	QMutex _mutex;
	ReturnValue _ret;
	RdsJob* _job;
};

class RdsThreadedJobThread : public QThread
{
public:
	RdsThreadedJobThread()
			: _parentJob(0),
			_parentD(0),
			_job(0),
			_helper(0)
	{
	}
	void run();
	RdsThreadedJob* _parentJob;
	RdsThreadedJobPrivate* _parentD;
	RdsJob* _job;
	RdsThreadedJobHelper* _helper;
};

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsThreadedJobPrivate : public QxtPrivate<RdsThreadedJob>
{
public:
	RdsThreadedJobPrivate()
			: spawner(0)
	{
	}

	RdsThreadedJobThread thread;
	RdsThreadedJob::JobSpawnerBase* spawner;
	QMutex mutex;
	QWaitCondition waiter;
};

#endif
