/***************************************************************************
 *   Copyright (C) 2009 by Brendan Powers   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RDSTHREADEDJOB_H
#define RDSTHREADEDJOB_H

#include <RdsJob>
#include <QxtPimpl>

class RdsThreadedJobPrivate;
class RdsThreadedJobThread;

/**
	@author Chris Vickery <chris@resara.com>
*/

class RdsThreadedJob : public RdsJob
{
	Q_OBJECT;
	QTRPC_SERVICEPROXY_PIMPL(RdsThreadedJob);
	QXT_DECLARE_PRIVATE(RdsThreadedJob);
	friend class RdsThreadedJobThread;

	class JobSpawnerBase
	{
	public:
		virtual RdsJob* getNewJobInstance() = 0;
	};
	template<class T>
class JobSpawner : public JobSpawnerBase
	{
	public:
		// This is called from the appropriate thread to initialize it properly.
		RdsJob* getNewJobInstance()
		{
			return new T();
		}
	};
	void setSpawner(JobSpawnerBase* spawner);
public:
	RdsThreadedJob();
	RdsThreadedJob(const RdsThreadedJob&other);
	~RdsThreadedJob();

	RdsThreadedJob& operator=(const RdsThreadedJob & other);


	template<class T>
	void initialize()
	{
		setSpawner(new JobSpawner<T>());
	}

	RdsJob* getJob();

private slots:
	void progressChangedSlot(int percent, const QString& progressText, const QString& progressDetails);
	void statusChangedSlot(RdsJob::Status status);
	void newLogMessagesSlot(const QList<RdsJob::LogEntry> &logs);
	void finishedSlot(const ReturnValue& ret);

protected:
	virtual ReturnValue pauseInternal();
	virtual ReturnValue resumeInternal();
	virtual ReturnValue startInternal();
	virtual ReturnValue stopInternal();

};

#endif
