/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSTORAGEMANAGER_P_H
#define RDSSTORAGEMANAGER_P_H

#include <QxtPimpl>
#include "rdsstoragemanager.h"

class RdsVolumeRegistryBase;
class RdsVolume;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsStorageManagerPrivate : public QxtPrivate<RdsStorageManager>
{
public:
	RdsStorageManagerPrivate()
	{
	}

	static QString volumeType(const QString &device);
	static QHash<QString, RdsVolumeRegistryBase*> &staticHash();
	static void registerRdsVolume(const QString &name, RdsVolumeRegistryBase* volume);
};

class RdsVolumeRegistryBase
{
public:
	virtual ReturnValue list() const = 0;
	virtual RdsVolume* newInstance(const QString &path) const = 0;
};

template<class T>
class RdsVolumeRegistry : public RdsVolumeRegistryBase
{
public:
	RdsVolumeRegistry(const QString &name)
	{
		RdsStorageManagerPrivate::registerRdsVolume(name, this);
	}
	virtual ReturnValue list() const
	{
		return T::list();
	}
	virtual RdsVolume* newInstance(const QString &path) const
	{
		return new T(path);
	}
};

#define RDS_REGISTER_VOLUME(class) \
	RdsVolumeRegistry<class> reg##class(#class);

#endif
