/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsstoragemanager.h"
#include "rdsstoragemanager_p.h"

#include <QDebug>
#include <QStringList>

using namespace QtRpc;

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsStorageManager);

RdsStorageManager::RdsStorageManager()
		: ServiceProxy(NULL)
{
}

RdsStorageManager::~RdsStorageManager()
{
}

RdsStorageManager &RdsStorageManager::operator=(const RdsStorageManager & object)
{
	Q_UNUSED(object);
	return(*this);
}

ReturnValue RdsStorageManager::list()
{
	QStringList list;
	foreach(RdsVolumeRegistryBase* volume, qxt_d().staticHash())
	{
		list << volume->list().toStringList();
	}
	return list;
}

ReturnValue RdsStorageManager::getVolume(const QString& device)
{
	return qxt_d().staticHash().value(qxt_d().volumeType(device))->newInstance(device);
}

ReturnValue RdsStorageManager::addVolume()
{
	return ReturnValue(1, "Not implemented");
}

ReturnValue RdsStorageManager::removeVolume()
{
	return ReturnValue(1, "Not implemented");
}

QString RdsStorageManagerPrivate::volumeType(const QString &device)
{
	Q_UNUSED(device);
	return "RdsVolume";
}

QHash<QString, RdsVolumeRegistryBase*> &RdsStorageManagerPrivate::staticHash()
{
	static QHash<QString, RdsVolumeRegistryBase*> hash;
	return hash;
}

void RdsStorageManagerPrivate::registerRdsVolume(const QString &name, RdsVolumeRegistryBase* volume)
{
	staticHash().insert(name, volume);
}


