/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSTORAGEDEVICE_P_H
#define RDSSTORAGEDEVICE_P_H

#include <QxtPimpl>
#include <QString>
#include "rdsstoragedevice.h"
#include "rdsudisksinterface.h"
#include <parted/parted.h>

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsStorageDevicePrivate : public QxtPrivate<RdsStorageDevice>
{
public:
	RdsStorageDevicePrivate()
	{
	}
	QString path;

	// A few static functions for parted stuff
	static QSharedPointer<PedDevice> getDevice(const QString &path);
	static QStringList getPartitions(const QString &drive);
	static QStringList getPartitions(PedDevice *dev);
	static ReturnValue createPartitionTable(PedDevice *dev); // this deletes any old partition tables that may have previously existed
	static ReturnValue removePartitionTable(PedDevice *dev);
	static ReturnValue createSinglePartition(PedDevice *dev);
	static ReturnValue setPartitionType(const QString &dev, const QString &fstype);
	static ReturnValue createFilesystem(const QString &dev, const QString &fstype);
	static const PedDiskType* getGoodType();
	static bool isStorageDevice(RdsUDisksDeviceInterface* device);
	static bool isVolume(RdsUDisksDeviceInterface* device);
};

#endif
