/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSHAREMANAGER_H
#define RDSSHAREMANAGER_H

#include <QxtPimpl>
#include <ReturnValue>
#include <ServiceProxy>
#include <RdsEntityManager>

class RdsShareManagerPrivate;
class QStringList;
class QString;
class RdsShare;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsShareManager : public RdsEntityManager
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsShareManager);
	QTRPC_SERVICEPROXY_PIMPL(RdsShareManager);
public:
	RdsShareManager();
	RdsShareManager(const QString &fileName);
	RdsShareManager(const RdsShareManager &other);
	RdsShareManager& operator=(const RdsShareManager &other);
	~RdsShareManager();

	QtRpc::ReturnValue auth(QtRpc::AuthToken token);

public slots:
	ReturnValue listEntities(const QString &id, bool loadmore) const;
	/**
	 *        Sets the file name of the config file
	 * @param fileName config file
	 * @return True on success, error on failure
	 */
	ReturnValue setFileName(const QString &fileName);
	/**
	 *        Gets the file name/path of the config file
	 * @return a QString with the file name/path
	 */
	ReturnValue fileName() const;
	/**
	 *         Gets a list of the names of the available shares
	 * @return QStringList on success, error on failure
	 */
	ReturnValue listShares() const;
	/**
	 *        Gets an RdsShare object
	 * @param str The share to fetch
	 * @return RdsShare on success, error on failure
	 */
	ReturnValue share(const QString &str) const;
	/**
	 *        Removes a share from the config
	 * @param share The share to remove
	 * @return True on success, error on failure
	 */
	ReturnValue removeShare(const QString &share);
	/**
	 *        Removes a share from the config
	 * @param share The share to remove
	 * @return True on success, error on failure
	 */
	ReturnValue removeShare(const RdsShare &share);
	/**
	 *        Adds a share to the config
	 * @param share The name of the share
	 * @param path The location of the share
	 * @return True on success, Error on failure
	 */
	ReturnValue addShare(const QString &share, const QString &path);

	/**
	 *  Save the config file
	 * @return True on success, Error on failure
	 */
	ReturnValue save();

private slots:
	void volumeAdded(QString id);
	void volumeRemoved(QString id);
	void volumeUpdated(QString id);
};

#endif
