/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSHARE_H
#define RDSSHARE_H

#include <QxtPimpl>
#include <ReturnValue>
#include <ServiceProxy>

class RdsSharePrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsShare : public QtRpc::ServiceProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsShare);
	QTRPC_SERVICEPROXY_PIMPL(RdsShare);
public:
	RdsShare();
	RdsShare(const QString &name);
	RdsShare(const RdsShare &other);
	~RdsShare();

	RdsShare& operator=(const RdsShare &other);
	bool operator==(const RdsShare &other) const;
	
public slots:
	ReturnValue name() const;
	ReturnValue setName(const QString &name);
	ReturnValue setPath(const QString &path);
	ReturnValue path() const;
	ReturnValue setReadOnly(bool readOnly);
	ReturnValue readOnly() const;
	ReturnValue setHidden(bool hidden);
	ReturnValue hidden() const;
	ReturnValue description();
	ReturnValue setDescription(QString desc);
	ReturnValue mapString();
	ReturnValue setMapString(const QString &mapstring);
	
	ReturnValue getValue(const QString &key) const;
	ReturnValue setValue(const QString &key, const QString &value);
	ReturnValue mountPoint() const;
};

#endif
