/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsshare.h"
#include "rdsshare_p.h"

#include "rdsglobal.h"
#include <QStringList>
#include <QFile>
#include <QDebug>
#include <RdsMountPoint>

using namespace QtRpc;

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsShare);

RdsShare::RdsShare()
	: ServiceProxy(NULL)
{
}

RdsShare::RdsShare(const QString &name)
	: ServiceProxy(NULL)
{
	qxt_d().data = new RdsShareData();
	qxt_d().data->name = name;
}

RdsShare::RdsShare(const RdsShare &other)
	: ServiceProxy(NULL)
{
	qxt_d().data = other.qxt_d().data;
}

RdsShare::~RdsShare()
{
}

ReturnValue RdsShare::setName(const QString &name)
{
	ReturnValue ret = qxt_d().data->parser.renameSection(qxt_d().data->name,name);
	if(ret.isError()) return(ret);
	
	qxt_d().data->name = name;
	return name;
}

ReturnValue RdsShare::name() const
{
	return qxt_d().data->name;
}

ReturnValue RdsShare::setPath(const QString &path)
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	qxt_d().data->parser.setValue(qxt_d().data->name, "path", path);
	return true;
}

ReturnValue RdsShare::path() const
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	return qxt_d().data->parser.getValue(qxt_d().data->name, "path");
}

ReturnValue RdsShare::setReadOnly(bool readOnly)
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	qxt_d().data->parser.setValue(qxt_d().data->name, "read only", (readOnly ? "yes" : "no"));
	return true;
}

ReturnValue RdsShare::readOnly() const
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	return (qxt_d().data->parser.getValue(qxt_d().data->name, "read only") == "yes");
}

ReturnValue RdsShare::setHidden(bool hidden)
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	qxt_d().data->parser.setValue(qxt_d().data->name, "browsable", (hidden ? "no" : "yes"));
	return true;
}

ReturnValue RdsShare::hidden() const
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	return (!(qxt_d().data->parser.getValue(qxt_d().data->name, "browsable") == "yes"));
}

ReturnValue RdsShare::description()
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");
	
	return(qxt_d().data->parser.getRdsValue(qxt_d().data->name, "description"));
}

ReturnValue RdsShare::setDescription(QString desc)
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");
	
	qxt_d().data->parser.setRdsValue(qxt_d().data->name, "description", desc);
	return(true);
}

ReturnValue RdsShare::mapString()
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");
	
	return(qxt_d().data->parser.getRdsValue(qxt_d().data->name, "map"));
}

ReturnValue RdsShare::setMapString(const QString &mapstring)
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");
	
	qxt_d().data->parser.setRdsValue(qxt_d().data->name, "map", mapstring);
	return(true);
}

ReturnValue RdsShare::getValue(const QString &key) const
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	return qxt_d().data->parser.getRdsValue(qxt_d().data->name, key);
}

ReturnValue RdsShare::setValue(const QString &key, const QString &value)
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	qxt_d().data->parser.setRdsValue(qxt_d().data->name, key, value);
	return true;
}

ReturnValue RdsShare::mountPoint() const
{
	if (!qxt_d().data->parser.listSections().toStringList().contains(qxt_d().data->name))
		return ReturnValue(1, "Share does not exist.");

	QString path =  qxt_d().data->parser.getValue(qxt_d().data->name, "path").toString();
	
	return (new RdsMountPoint(RdsMountPoint::mountPointOfPath(path)));
}

RdsShare& RdsShare::operator=(const RdsShare & other)
{
	qxt_d().data = other.qxt_d().data;
	return *this;
}

bool RdsShare::operator==(const RdsShare &other) const
{
	VERIFY_VALUES(name);
	VERIFY_VALUES(parser.fileName());
	return true;
}



