/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef RDSNETWORKSETTINGS_H
#define RDSNETWORKSETTINGS_H

#include <QThread>
#include <QMutex>
#include <QMap>
#include <ReturnValue>
#include <QxtPimpl>
#include <ServiceProxy>

class RdsNetworkSettingsInterfacePrivate;
class RdsNetworkSettingsPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsNetworkSettings : public QtRpc::ServiceProxy
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsNetworkSettings);
	QTRPC_SERVICEPROXY_PIMPL(RdsNetworkSettings);
public:
	class Interface
	{
		friend class RdsNetworkSettingsInterfacePrivate;
		QxtPrivateInterface<Interface, RdsNetworkSettingsInterfacePrivate> qxt_d;
		friend QDataStream& operator<<(QDataStream& d, const RdsNetworkSettings::Interface& iface);
		friend QDataStream& operator>>(QDataStream& d, RdsNetworkSettings::Interface& iface);
	public:
		Interface();
		Interface(const Interface &other);
		~Interface();
		Interface &operator=(const Interface &other);

		QString name() const;
		void setName(const QString &name);
		QString type() const;
		void setType(const QString &type);
		bool autoUp() const;
		void setAutoUp(bool up);
		QMap<QString, QString> &options();
		const QMap<QString, QString> &options() const;
		const QMap<QString, QString> &optionsConst() const;
		QString comment();
		void setComment(const QString &comment);
	};

	RdsNetworkSettings(QObject *parent = 0);
	RdsNetworkSettings(const RdsNetworkSettings &other);
	~RdsNetworkSettings();
	RdsNetworkSettings &operator=(const RdsNetworkSettings &other);

	ReturnValue auth(QtRpc::AuthToken token);

	ReturnValue loadNetworkConfig();
	ReturnValue saveNetworkConfig();
	ReturnValue setInterface(const QString &name, const QString &type, bool autoup, const QMap<QString, QString> &options, const QString &comment = "");
	ReturnValue removeInterface(const QString &name);
	ReturnValue listInterfaces() const;
	QList<Interface> getInterfaces();
	Interface getInterface(QString interface);
	ReturnValue ifUp(const QString &interface);
	ReturnValue ifDown(const QString &interface);
	ReturnValue allIfUp();
	ReturnValue allIfDown();

	ReturnValue getInterfaceLinkState(const QString &interface) const;
	ReturnValue getInterfaceLinkSpeed(const QString &interface) const;
	ReturnValue getInterfaceIp(QString interface) const;
	ReturnValue getInterfaceNetmask(QString interface) const;
	ReturnValue getInterfaceMac(QString interface) const;
	ReturnValue listAllInterfaces() const;
	ReturnValue getDefaultInterface() const;
	ReturnValue getDefaultGateway() const;
	ReturnValue getDnsServers() const;
	ReturnValue getDomain() const;
	ReturnValue killDhcpClient();
};

QDataStream& operator<<(QDataStream& d, const RdsNetworkSettings::Interface& iface);
QDataStream& operator>>(QDataStream& d, RdsNetworkSettings::Interface& iface);

#endif
