/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSMOUNTPOINTMANAGER_H
#define RDSMOUNTPOINTMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>

class RdsMountPointManagerPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsMountPointManager : public RdsEntityManager
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsMountPointManager);
	QTRPC_SERVICEPROXY_PIMPL(RdsMountPointManager);
public:
	RdsMountPointManager(QObject *parent = 0);
	RdsMountPointManager(const RdsMountPointManager &other);
	RdsMountPointManager& operator=(const RdsMountPointManager &other);
	~RdsMountPointManager();

	QtRpc::ReturnValue auth(QtRpc::AuthToken token);

public slots:
	ReturnValue list() const;
	ReturnValue mountPoint(QString path) const;
	ReturnValue listEntities(const QString &id, bool loadmore) const;
};

#endif
