/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSLDAPACTIONS_H
#define RDSLDAPACTIONS_H

#include <QObject>
#include <QHash>
#include <QString>
#include <QMetaType>
#include <QxtPimpl>
#include <ReturnValue>
#include <QStringList>
#include <ServiceProxy>
#include <RdsLdapActions>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsLdapActionsPrivate;
struct LdapAction;
class RdsLdapSessionPrivate;

struct ldapmod;
typedef ldapmod LDAPMod;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsLdapActions
{

	QXT_DECLARE_PRIVATE(RdsLdapActions);
public:
	enum ActionType
	{
		Add,
		Replace,
		Remove
	};

	RdsLdapActions();
	RdsLdapActions(const RdsLdapActions &actions);
	RdsLdapActions(const QList<LdapAction> &actions);
	~RdsLdapActions();

	/**
	 *        Adds an action to a list of actions to be performed
	 * @param type RdsLdapActions::ActionType (Add, Replace, Remove)
	 * @param name The attribute name
	 * @param value the value of the attribute
	 */
	void add(const ActionType &type, const QString &name, const QString &value);
	/**
	 *        Adds an action to a list of actions to be performed
	 * @param type RdsLdapActions::ActionType (Add, Replace, Remove)
	 * @param name attribute name
	 * @param value data values associated with that attribute
	 */
	void addData(const ActionType &type, const QString &name, const QByteArray &value);
	/**
	 * 	  Adds an action to a list of actions to be performed
	 * @param type RdsLdapActions::ActionType (Add, Replace, Remove)
	 * @param name attribute name
	 * @param value unicode associated with that attribute
	 */
	void addUnicode(const ActionType &type, const QString &name, const QString &value);
	/**
	 *        Overloaded add function that takes a list of values
	 * @param type RdsLdapActions::ActionType (Add, Replace, Remove)
	 * @param name the attribute name
	 * @param values the unicode values associated with that attribute
	 */
	void addUnicode(const ActionType &type, const QString &name, const QStringList &values);
	/**
	 *        Overloaded function that takes a list of attribute values
	 * @param type RdsLdapActions::ActionType (Add, Replace, Remove)
	 * @param name attribute name
	 * @param values the values associated with the attribute
	 */
	void add(const ActionType &type, const QString &name, const QList<QString> &values);
	/**
	 *        overloaded function that adds multiple values of an attribute to a list of actions to be performed
	 * @param type RdsLdapActions::ActionType (Add, Replace, Remove)
	 * @param name attribute name
	 * @param values the data values associated with the attribute
	 */
	void addData(const ActionType &type, const QString &name, const QList<QByteArray> &values);
	/**
	 *        Clears the list of actions
	 */
	void clear();
	/**
	 *        Gets the current list of actions to be performed
	 * @return Returns a list of LdapActions that are going to be performed
	 */
	QList<LdapAction> getActions() const;
#ifndef __RDS_CLIENT
	LDAPMod **getLdapActions() const;
#endif

	RdsLdapActions &operator=(const RdsLdapActions &object);


};

QDataStream& operator<<(QDataStream& d, const RdsLdapActions& object);
QDataStream& operator>>(QDataStream& d, RdsLdapActions& object);
Q_DECLARE_METATYPE(RdsLdapActions);

#endif
