/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSERVICE_H
#define RDSSERVICE_H

#include <ServiceProxy>
#include <ReturnValue>
#include <AuthToken>
#include <QDateTime>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsService : public QtRpc::ServiceProxy
{
	Q_OBJECT
public:
	RdsService(QObject *parent = 0);
	~RdsService();

	ReturnValue auth(QtRpc::AuthToken token);

public slots:
	ReturnValue isProvisioned();
	ReturnValue ldapSession();
	ReturnValue domainData();
	ReturnValue provisionator();
	ReturnValue status();
	ReturnValue dateTime();
	ReturnValue setDateTime(QDateTime now);
	ReturnValue timeZone();
	ReturnValue setTimeZone(QString timezone);
	ReturnValue listTimeZones();
	ReturnValue listLogs();
	ReturnValue shutdown();
	ReturnValue reboot();
	ReturnValue buildVersion();
	ReturnValue hostname();
	ReturnValue listInterfaces();
};

#endif
