/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSPROVISIONTHREAD_H
#define RDSPROVISIONTHREAD_H

#include <QThread>
#include <QxtPimpl>

#include <ReturnValue>

class RdsProvisionThreadPrivate;
class RdsProvisionator;
class QMutex;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsProvisionThread : public QThread
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsProvisionThread);

public:
	RdsProvisionThread(const QVariantMap &settings, QObject *parent = 0);
	RdsProvisionThread(QObject *parent = 0);
	~RdsProvisionThread();
	ReturnValue start(RdsProvisionator* service, const QVariantMap &settings);
	void run();
	ReturnValue setDateTime();
	ReturnValue provisionKerberos();
	ReturnValue provisionSamba();
	ReturnValue provisionDns();
	ReturnValue prepareDns();
	ReturnValue provisionDhcp();
	ReturnValue provisionHostname();
	ReturnValue provisionSambaConfig();
	ReturnValue provisionRds();
	ReturnValue setSettings(const QVariantMap &settings);
	
	static ReturnValue provisionNtpd();

private:
	using QThread::start;
	Q_DISABLE_COPY(RdsProvisionThread);
};

#endif
