/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef STORAGEMANAGERWIDGET_H
#define STORAGEMANAGERWIDGET_H

#include <QWidget>
#include "ui_storagemanagerwidget.h"
#include <RdsEntityWidget>
#include "rdsstoragesortmodel.h"
#include "rdsstoragemodel.h"

class StorageManagerWidget : public QWidget, private Ui::StorageManagerWidget
{
	Q_OBJECT

public:
	StorageManagerWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~StorageManagerWidget();

public slots:
	void inputChanged(QString id, QString type);
	void outputsChanged(QStringList outputs);

protected slots:
	void on_AddButton_clicked();
	void remove();
	void contextMenu(const QPoint & pos);
	void eject();
	void initialize();
	void volumeUpdate(QString id);
	void addUnusedDevice();

private:
	RdsStorageModel *_model;
	RdsStorageSortModel *_sort;
	RdsVolumeManager *_manager;
	QItemSelectionModel *_selection;
	RdsEntityWidget *_edit;
	QString _input;
	QAction *_ejectaction;
	QAction *_initializeaction;
	QAction *_removeaction;
	QAction *_adddeviceaction;
};

#endif

