/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef SHAREMANAGERWIDGET_H
#define SHAREMANAGERWIDGET_H

#include <QWidget>
#include "ui_sharemanagerwidget.h"
#include "rdssharemodel.h"
#include <RdsShareManager>
#include <RdsEntitySortModel>
#include <QItemSelectionModel>
#include <RdsEntityWidget>

class ShareManagerWidget : public QWidget, private Ui::ShareManagerWidget
{
	Q_OBJECT

public:
	ShareManagerWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~ShareManagerWidget();

public slots:
	void inputChanged(QString id, QString type);
	void outputsChanged(QStringList outputs);

protected slots:
	void addShare();
	void addFolder();
	void on_DeleteButton_clicked();
	void contextMenu(const QPoint & pos);
	void showSystemObjects(bool show);
	void on_ReloadButton_clicked();

private:
	RdsShareModel *_model;
	RdsEntitySortModel *_sort;
	RdsShareManager *_manager;
	QItemSelectionModel *_selection;
	RdsEntityWidget *_edit;
	QString _input;
	QAction *_newshareaction;
	QAction *_newfolderaction;
	QAction *_removeaction;
	QAction *_showsystemaction;
};

#endif

