/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "servermanagerwidget.h"
#include "config.h"
#include "serverstatuswidget.h"
#include "datetimewidget.h"
#include "logswidget.h"
#include "passwordpolicywidget.h"
#include "networkwidget.h"

ServerManagerWidget::ServerManagerWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::ServerManagerWidget()
{
	setupUi(this);
	_datetime = new QListWidgetItem(QPixmap(findRdsIcon("icons/16x16/clock.png")),"Date and Time", SectionList);
	_logs = new QListWidgetItem(QPixmap(findRdsIcon("icons/16x16/logs.png")),"Logs", SectionList);
	_network = new QListWidgetItem(QPixmap(findRdsIcon("icons/16x16/network.png")),"Network Settings", SectionList);
	_pwpolicy = new QListWidgetItem(QPixmap(findRdsIcon("icons/16x16/password.png")),"Password Policy", SectionList);
	_status = new QListWidgetItem(QPixmap(findRdsIcon("icons/16x16/status.png")),"Status", SectionList);

	_currentwidget = NULL;
	SectionList->setCurrentItem(_status);
}

ServerManagerWidget::~ServerManagerWidget()
{
}

void ServerManagerWidget::on_SectionList_currentItemChanged(QListWidgetItem *item, QListWidgetItem *prev)
{
	Q_UNUSED(prev);
	if(_currentwidget != NULL) delete _currentwidget;
	
	if(item == _status)
	{
		ServerStatusWidget *w = new ServerStatusWidget(EditWidget);
		EditLayout->addWidget(w);
		_currentwidget = w;
	}
	else if(item == _datetime)
	{
		DateTimeWidget *w = new DateTimeWidget(EditWidget);
		EditLayout->addWidget(w);
		_currentwidget = w;
	}
	else if(item == _logs)
	{
		LogsWidget *w = new LogsWidget(EditWidget);
		EditLayout->addWidget(w);
		_currentwidget = w;
	}
	else if(item == _pwpolicy)
	{
		PasswordPolicyWidget *w = new PasswordPolicyWidget(EditWidget);
		EditLayout->addWidget(w);
		_currentwidget = w;
	}
	else if(item == _network)
	{
		NetworkWidget *w = new NetworkWidget(EditWidget);
		EditLayout->addWidget(w);
		_currentwidget = w;
	}
}


