/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSTORAGEDEVICEMODEL_H
#define RDSSTORAGEDEVICEMODEL_H

#include <RdsEntityModel>
#include <RdsStorageDeviceManager>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsStorageDeviceModel : public RdsEntityModel
{
	Q_OBJECT
public:
	RdsStorageDeviceModel(RdsStorageDeviceManager *manager, QObject *parent = 0);
	~RdsStorageDeviceModel();
	
	QVariant userData(const QModelIndex &index, int role, RdsEntityModel::Cache *cache) const;
	QVariant userHeaderData(int section, int role = Qt::DisplayRole) const;
	Qt::ItemFlags flags(const QModelIndex &index) const;
	bool setData(const QModelIndex &index, const QVariant &value, int role, Cache *cache);
	void move(Cache *entity, Cache *parent);

private:
	QString toHumanReadableFormat(qlonglong size) const;
	RdsStorageDeviceManager *_manager;
};

#endif
