/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSHAREMODEL_H
#define RDSSHAREMODEL_H

#include <rdsentitymodel.h>
#include <RdsDnsManager>
#include <RdsDnsZone>

/**
	@author Chris Vickery <chris@resara.com>
 */
class RdsDnsModel : public RdsEntityModel
{
	Q_OBJECT
public:
	RdsDnsModel(RdsDnsManager *manager, QObject *parent = 0);
	~RdsDnsModel();

	QVariant userData(const QModelIndex &index, int role, RdsEntityModel::Cache *cache) const;
	QVariant userHeaderData(int section, int role = Qt::DisplayRole) const;
	Qt::ItemFlags flags(const QModelIndex &index, Cache *cache) const;
	bool setData(const QModelIndex &index, const QVariant &value, int role, Cache *cache);
	void move(Cache *entity, Cache *parent);
	QString getZoneFromId(const QString& id);
	QString getOriginFromId(const QString& id);
	bool save();

	static bool validateRecord(const QString &value, int type);
	static bool validateRecord(const QStringList &value, int type);
private:
	RdsDnsManager *_manager;
};

#endif
