/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "primarygroupwidget.h"
#include <RdsGroup>
#include "selectiondialog.h"

PrimaryGroupWidget::PrimaryGroupWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::PrimaryGroupWidget()
{
	setupUi(this);
}

PrimaryGroupWidget::~PrimaryGroupWidget()
{
}

QString PrimaryGroupWidget::dn()
{
	return(_dn);
}

void PrimaryGroupWidget::setDn(QString dn)
{
	_dn = dn;
	RdsGroup group(dn);
	PrimaryGroup->setText(group.cn().toString());
}


void PrimaryGroupWidget::on_PrimaryGroupButton_clicked()
{
	SelectionDialog dialog(SelectionDialog::Group,this);
	if(dialog.exec())
	{
		setDn(dialog.selectedItem());
		emit(changed());
	}
}
