/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QAction>
#include <QHash>
#include <QList>
#include "ui_mainwindow.h"


class MainWindow : public QMainWindow, private Ui::MainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget* parent = 0, Qt::WFlags fl = 0);
	~MainWindow();

	void addTab(QString text, QString icon, QWidget *widget = NULL);
	void setTab(QString tab);
	void setTabEnabled(QString tab, bool enabled);

private:
	QList<QAction *> _tabs;
	QHash<QAction *, QWidget *> _widgets;
	QAction *_currenttab;
	
private slots:
	void setTab();
	void on_New_Window_triggered();
	void on_Quit_triggered();
	void on_CloseWindow_triggered();
	void disconnected();
	void on_AboutAction_triggered();
	void on_DocumentationAction_triggered();
	void prev();
	void next();
};

#endif

