/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "mainwindow.h"
#include <QApplication>
#include <QToolButton>
#include <QPushButton>
#include <QDebug>
#include <QMessageBox>
#include <QDesktopServices>
#include <QShortcut>
#include <RdsClient>
#include "usermanagerwidget.h"
#include "selectiondialog.h"
#include "computermanagerwidget.h"
#include "sharemanagerwidget.h"
#include "storagemanagerwidget.h"
#include "dnsmanagerwidget.h"
#include "servermanagerwidget.h"
#include "dhcpmanagerwidget.h"
#include "config.h"
#include "aboutdialog.h"
#include "main.h"

MainWindow::MainWindow(QWidget* parent, Qt::WFlags fl)
		: QMainWindow(parent, fl), Ui::MainWindow()
{
	setupUi(this);
	show();
	setWindowIcon(QPixmap(findRdsIcon("icons/32x32/kcontrol.png")));
	setFocus();
	resize(790, 550);

	new QShortcut(QKeySequence("Shift+Ctrl+Tab"), this, SLOT(prev()));
	new QShortcut(QKeySequence("Ctrl+Tab"), this, SLOT(next()));

	QObject::connect(rdsClient(), SIGNAL(disconnected()), this, SLOT(disconnected()));

	addTab("Users", findRdsIcon("./icons/32x32/userconfig.png"), new UserManagerWidget(this));
	addTab("Computers", findRdsIcon("./icons/32x32/system.png"), new ComputerManagerWidget(this));
	addTab("Shares", findRdsIcon("./icons/64x64/folder_html.png"), new ShareManagerWidget(this));
	addTab("Storage", findRdsIcon("./icons/32x32/disksfilesystems.png"), new StorageManagerWidget(this));
	addTab("DHCP", findRdsIcon("./icons/32x32/network_local.png"), new DhcpManagerWidget(this));
	addTab("DNS", findRdsIcon("./icons/32x32/network.png"), new DnsManagerWidget(this));
	addTab("Server", findRdsIcon("./icons/48x48/server.png"), new ServerManagerWidget(this));
	setTab("");
}

MainWindow::~MainWindow()
{
}

void MainWindow::addTab(QString text, QString icon, QWidget *widget)
{
	QAction *action = new QAction(QPixmap(icon), text, this);
	action->setCheckable(true);
        QObject::connect(action, SIGNAL(triggered(bool)), this, SLOT(setTab()));
	ToolBar->addAction(action);

	QWidget *button = ToolBar->widgetForAction(action);
	button->setMinimumWidth(70);
	button->setMaximumWidth(70);

	_tabs << action;
	_widgets[action] = widget;
	ContentWidget->addWidget(widget);
}

void MainWindow::setTab(QString tab)
{
	if ((tab == "") && (_tabs.size() != 0))
	{
		tab = _tabs[0]->text();
	}

	foreach(QAction *action, _tabs)
	{
		if (action->text() == tab)
		{
			action->setChecked(true);
			ContentWidget->setCurrentWidget(_widgets[action]);
			_currenttab = action;
		}
		else
		{
			action->setChecked(false);
		}
	}
}

void MainWindow::setTab()
{
	if (this->sender() == NULL) return;
	QAction *action = (QAction *)sender();

	setTab(action->text());
}

void MainWindow::setTabEnabled(QString tab, bool enabled)
{
	foreach(QAction *action, _tabs)
	{
		if (action->text() == tab)
		{
			action->setEnabled(enabled);
		}
	}
}

void MainWindow::on_New_Window_triggered()
{
	MainWindow *w = new MainWindow(NULL);
	w->show();
}

void MainWindow::on_Quit_triggered()
{
	qApp->quit();
}

void MainWindow::on_CloseWindow_triggered()
{
	deleteLater();
}


void MainWindow::disconnected()
{
	if (ConnectionSettings::ignoredisconnect) return;
	QMessageBox::critical(this, "Disconnected", "The connection to the server has been lost. This application will now exit.");
	qApp->quit();
}

void MainWindow::on_AboutAction_triggered()
{
	AboutDialog dialog;
	dialog.exec();
}

void MainWindow::on_DocumentationAction_triggered()
{
	QDesktopServices::openUrl(QUrl("http://www.resara.org/wiki/"));
}

void MainWindow::prev()
{
	int index = _tabs.indexOf(_currenttab);

	int tmp = 0;
	do
	{
		if (tmp == _tabs.size()) break;
		tmp ++;
		index--;
		if (index == -1) index = _tabs.size() - 1;
	}
	while (!_tabs[index]->isEnabled());

	setTab(_tabs[index]->text());
}

void MainWindow::next()
{
	int index = _tabs.indexOf(_currenttab);

	int tmp = 0;
	do
	{
		if (tmp == _tabs.size()) break;
		tmp ++;
		index++;
		if (index == _tabs.size()) index = 0;
	}
	while (!_tabs[index]->isEnabled());

	setTab(_tabs[index]->text());
}

