/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef SHAREEDITWIDGET_H
#define SHAREEDITWIDGET_H

#include <QWidget>
#include "rdsentitywidget.h"
#include "ui_dnseditwidget.h"
#include <RdsDnsManager>

class DnsEditWidget : public RdsEntityWidget, private Ui::DnsEditWidget
{
	Q_OBJECT;
public:
	DnsEditWidget(RdsDnsManager *manager, QWidget* parent = 0);
	~DnsEditWidget();

protected slots:
	void entityRenamed(QString oldid, QString newid);

protected:
	ReturnValue getData();
	bool setData(QString id, QVariantMap fields);
	bool endSetData();
	void entityUpdated(QString id);

private:
	RdsDnsManager *_dnsmgr;
};

#endif

