/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "dhcpinterfacewidget.h"
#include <QDebug>
#include "config.h"


DhcpInterfaceWidget::DhcpInterfaceWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::DhcpInterfaceWidget()
{
	setupUi(this);
	QObject::connect(Interfaces, SIGNAL(changed()), this, SIGNAL(changed()));
	QObject::connect(AllCheck, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
}

DhcpInterfaceWidget::~DhcpInterfaceWidget()
{
}


QStringList DhcpInterfaceWidget::list() const
{
	return(Interfaces->list());
}

void DhcpInterfaceWidget::setList(const QStringList& newlist)
{
	Interfaces->setList(newlist);
}

QStringList DhcpInterfaceWidget::checked() const
{
	if(AllCheck->isChecked())
	{
		return(QStringList());
	}
	else
	{
		return(Interfaces->checked());
	}
}

void DhcpInterfaceWidget::setChecked(const QStringList& newchecked)
{
	Interfaces->setChecked(newchecked);
	if(newchecked.size() == 0)
	{
		AllCheck->setChecked(true);
	}
	else
	{
		SelectedCheck->setChecked(true);
	}
}
