/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSTORAGEDEVICEMANAGER_H
#define RDSSTORAGEDEVICEMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsStorageDeviceManagerPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsStorageDeviceManager : public RdsEntityManager
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsStorageDeviceManager);
	QTRPC_CLIENTPROXY_PIMPL(RdsStorageDeviceManager);
public:
	RdsStorageDeviceManager(QObject *parent = 0);
	RdsStorageDeviceManager(const RdsStorageDeviceManager &other);
	~RdsStorageDeviceManager();
	RdsStorageDeviceManager &operator=(const RdsStorageDeviceManager &other);
	ReturnValue init();

signals:
	ReturnValue device(const QString &id) const;
};

#endif
