/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSFILEMANAGER_H
#define RDSFILEMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsFileManagerPrivate;
class RdsNtAcl;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsFileManager : public RdsEntityManager
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsFileManager);
	QTRPC_CLIENTPROXY_PIMPL(RdsFileManager);
public:
	RdsFileManager(QObject *parent = 0);
	RdsFileManager(const RdsFileManager &other);
	~RdsFileManager();
	
	RdsFileManager &operator=(const RdsFileManager &other);
	ReturnValue init();

signals:
	ReturnValue showVolumes();
	ReturnValue setShowVolumes(bool show);
	ReturnValue showShares();
	ReturnValue setShowShares(bool show);
	ReturnValue showFileSystem();
	ReturnValue setShowFileSystem(bool show);
	ReturnValue showFiles();
        ReturnValue setShowFiles(bool show);
	
	ReturnValue createDirectory(const QString &path, bool recursive = false);
	ReturnValue createDirectory(QObject *object, const char *slot, const QString &path, bool recursive = false);
	ReturnValue remove(const QString &path, bool recursive = false);
	ReturnValue move(const QString &path, const QString &newpath);
	ReturnValue rename(const QString &path, const QString &newname);
	ReturnValue fileContents(const QString &path) const;
	ReturnValue setFileContents(const QString &path, const QByteArray &data);
	ReturnValue unixPermissions(const QString &path) const;
	ReturnValue setUnixPermissions(const QString &path, int mode);
	ReturnValue owner(const QString &path) const;
	ReturnValue setOwner(const QString &path, const QString &owner);
	ReturnValue setOwner(const QString &path, int owner);
	ReturnValue group(const QString &path) const;
	ReturnValue setGroup(const QString &path, const QString &group);
	ReturnValue setGroup(const QString &path,  int group);
	ReturnValue ntPermissions(const QString &path) const;
	ReturnValue setNtPermissions(const QString &path, const RdsNtAcl &permissions);
	ReturnValue exists(const QString &path);
	ReturnValue isFile(const QString &path);
	ReturnValue isDirectory(const QString &path);
	ReturnValue updateInheritedPermissions(const QString &path);
	ReturnValue propagateInheritedPermissions(const QString &path); // I have a thing against default params....
	ReturnValue propagateInheritedPermissions(const QString &path, bool forceinherit);
};

#endif
