/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDNSMANAGER_H
#define RDSDNSMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsDnsManagerPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RDS_CLIENT_EXPORT RdsDnsManager : public RdsEntityManager
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsDnsManager);
	QTRPC_CLIENTPROXY_PIMPL(RdsDnsManager);
public:
	RdsDnsManager(QObject *parent = 0);
	RdsDnsManager(const RdsDnsManager &other);
	~RdsDnsManager();
	RdsDnsManager &operator=(const RdsDnsManager &other);
	ReturnValue init();

signals:
	/**
	 *         Saves the config
	 * @return true on success, error on failure.
	 */
	ReturnValue save() const;
	/**
		 *        reloads the config file
		 * @return true on success, error on failure.
	 */
	ReturnValue reload();
	/**
	 *        Returns a list of zones
	 * @return QStringList of zones
	 */
	ReturnValue zones() const;
	/**
		 *        Creates a Zone object named zone if it doesn't already exists, otherwise it returns the existing object
		 * @param zone the name of the zone to create
		 * @return RdsDnsZone object for zone
	 */
	ReturnValue addZone(const QString &zone);
	/**
		 *        Removes a zone from the configuration
		 * @param zone the name of zone to remove
		 * @return true on success, error on failure.
	 */
	ReturnValue removeZone(const QString &zone);
	/**
		 *        Gets a RdsDnsZone object for zone
		 * @param zone the name of the zone to get an object for
		 * @return RdsDnsZone on success (When assigning the ReturnValue to a new RdsDnsZone object, construct the object and assign the ReturnValue to it on separate lines), error on failure.
	 */
	ReturnValue zone(const QString &zone) const;
	ReturnValue forwarders() const;
	ReturnValue setForwarders(const QStringList& f);

	ReturnValue listValues() const;
	ReturnValue containsValue(const QString& key) const;
	ReturnValue value(const QString& key) const;
	ReturnValue setValue(const QString& key, const QString& value);

};

#endif
