/***************************************************************************
 *  Copyright (c) 2011, Resara LLC                                         *
 *  All rights reserved.                                                   *
 *                                                                         *
 *  Redistribution and use in source and binary forms, with or without     *
 *  modification, are permitted provided that the following conditions are *
 *  met:                                                                   *
 *      * Redistributions of source code must retain the above copyright   *
 *        notice, this list of conditions and the following disclaimer.    *
 *      * Redistributions in binary form must reproduce the above          *
 *        copyright notice, this list of conditions and the following      *
 *        disclaimer in the documentation and/or other materials           *
 *        provided with the distribution.                                  *
 *      * Neither the name of Resara LLC nor the names of its              *
 *        contributors may be used to endorse or promote products          *
 *        derived from this software without specific prior written        *
 *        permission.                                                      *
 *                                                                         *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS    *
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT      *
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR  *
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL RESARA LLC BE   *
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR    *
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF   *
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        *
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,  *
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE   *
 *  OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN *
 *  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef QTRPCSERVERPROTOCOLINSTANCETCP_H
#define QTRPCSERVERPROTOCOLINSTANCETCP_H

#include <QObject>
#include <QxtPimpl>
#include <qtrpcprivate.h>

#include <ServerProtocolInstanceIODevice>

namespace QtRpc
{

class ServerProtocolInstanceTcpPrivate;
/**
	This class is the Tcp implementation of the service side protocol instance object. It uses the ServerProtocolInstanceIODevice object to handle all of it's communications. This instance object is used for the TCP and TCPS protocols, and supports encryption accordingly. Encryption mode and certificates should be set in the ServerProtocolListenerTcp class.

	@sa ClientProtocolTcp ServerProtocolListenerTcp ServerProtocolInstanceIODevice
	@brief The TCP implementation of the server side protocol
	@author Chris Vickery <chris@resara.com>
 */
class ServerProtocolInstanceTcp : public ServerProtocolInstanceIODevice
{
	QXT_DECLARE_PRIVATE(ServerProtocolInstanceTcp);
	Q_OBJECT
public:
	ServerProtocolInstanceTcp(Server* serv, QObject* parent = 0);
	~ServerProtocolInstanceTcp();
	virtual void disconnect();
	virtual void setProperty(QString, QVariant);
	virtual QVariant getProperty(QString);
	virtual void protocolFunction(Signature, Arguments);
public slots:
	virtual void init();

};

}

#endif
