/*
 * Decompiled with CFR 0.152.
 */
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;

public class RcovrtService
implements BasicLibraryService {
    private static RubyObjectAdapter rubyApi;

    public boolean basicLoad(Ruby ruby) {
        RubyModule rubyModule = ruby.getOrCreateModule("Rcov");
        RubyModule rubyModule2 = ruby.defineModuleUnder("RCOV__", rubyModule);
        IRubyObject iRubyObject = ruby.getObject().getConstantAt("SCRIPT_LINES__");
        if (iRubyObject == null) {
            ruby.getObject().setConstant("SCRIPT_LINES__", (IRubyObject)RubyHash.newHash((Ruby)ruby));
        }
        rubyApi = JavaEmbedUtils.newObjectAdapter();
        rubyModule2.defineAnnotatedMethods(RcovrtService.class);
        return true;
    }

    @JRubyMethod(name={"reset_callsite"}, meta=true)
    public static IRubyObject resetCallsite(IRubyObject iRubyObject) {
        CallsiteHook callsiteHook = CallsiteHook.getCallsiteHook();
        if (callsiteHook.isActive()) {
            throw RaiseException.createNativeRaiseException((Ruby)iRubyObject.getRuntime(), (Throwable)new RuntimeException("Cannot reset the callsite info in the middle of a traced run."));
        }
        return callsiteHook.resetDefsites();
    }

    @JRubyMethod(name={"reset_coverage"}, meta=true)
    public static IRubyObject resetCoverage(IRubyObject iRubyObject) {
        CoverageHook coverageHook = CoverageHook.getCoverageHook();
        if (coverageHook.isActive()) {
            throw RaiseException.createNativeRaiseException((Ruby)iRubyObject.getRuntime(), (Throwable)new RuntimeException("Cannot reset the coverage info in the middle of a traced run."));
        }
        return coverageHook.resetCoverage(iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"remove_coverage_hook"}, meta=true)
    public static IRubyObject removeCoverageHook(IRubyObject iRubyObject) {
        return RcovrtService.removeRcovHook(iRubyObject, CoverageHook.getCoverageHook());
    }

    @JRubyMethod(name={"install_coverage_hook"}, meta=true)
    public static IRubyObject installCoverageHook(IRubyObject iRubyObject) {
        return RcovrtService.installRcovHook(iRubyObject, CoverageHook.getCoverageHook());
    }

    @JRubyMethod(name={"generate_coverage_info"}, meta=true)
    public static IRubyObject generateCoverageInfo(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyHash rubyHash = CoverageHook.getCoverageHook().getCover(ruby);
        RubyHash rubyHash2 = RubyHash.newHash((Ruby)ruby);
        RubyArray rubyArray = rubyHash.keys();
        ThreadContext threadContext = ruby.getCurrentContext();
        int n = 0;
        while ((long)n < rubyArray.length().getLongValue()) {
            IRubyObject iRubyObject2 = rubyArray.aref(JavaUtil.convertJavaToRuby((Ruby)ruby, (Object)n));
            RubyArray rubyArray2 = ((RubyArray)rubyHash.op_aref(threadContext, iRubyObject2)).aryDup();
            rubyHash2.op_aset(threadContext, iRubyObject2, (IRubyObject)rubyArray2);
            ++n;
        }
        RubyModule rubyModule = (RubyModule)iRubyObject.getRuntime().getModule("Rcov").getConstant("RCOV__");
        if (rubyModule.const_defined_p(threadContext, (IRubyObject)RubySymbol.newSymbol((Ruby)iRubyObject.getRuntime(), (String)"COVER")).isTrue()) {
            rubyModule.remove_const(threadContext, (IRubyObject)iRubyObject.getRuntime().newString("COVER"));
        }
        rubyModule.defineConstant("COVER", (IRubyObject)rubyHash2);
        return rubyHash2;
    }

    @JRubyMethod(name={"remove_callsite_hook"}, meta=true)
    public static IRubyObject removeCallsiteHook(IRubyObject iRubyObject) {
        return RcovrtService.removeRcovHook(iRubyObject, CallsiteHook.getCallsiteHook());
    }

    @JRubyMethod(name={"install_callsite_hook"}, meta=true)
    public static IRubyObject installCallsiteHook(IRubyObject iRubyObject) {
        return RcovrtService.installRcovHook(iRubyObject, CallsiteHook.getCallsiteHook());
    }

    @JRubyMethod(name={"generate_callsite_info"}, meta=true)
    public static IRubyObject generateCallsiteInfo(IRubyObject iRubyObject) {
        return CallsiteHook.getCallsiteHook().getCallsiteInfo(iRubyObject.getRuntime()).dup();
    }

    @JRubyMethod(name={"ABI"}, meta=true)
    public static IRubyObject getAbi(IRubyObject iRubyObject) {
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        rubyArray.add((Object)RubyFixnum.int2fix((Ruby)iRubyObject.getRuntime(), (long)2L));
        rubyArray.add((Object)RubyFixnum.int2fix((Ruby)iRubyObject.getRuntime(), (long)0L));
        rubyArray.add((Object)RubyFixnum.int2fix((Ruby)iRubyObject.getRuntime(), (long)0L));
        return rubyArray;
    }

    private static IRubyObject removeRcovHook(IRubyObject iRubyObject, RcovHook rcovHook) {
        rcovHook.setActive(false);
        iRubyObject.getRuntime().removeEventHook((EventHook)rcovHook);
        return iRubyObject.getRuntime().getFalse();
    }

    private static IRubyObject installRcovHook(IRubyObject iRubyObject, RcovHook rcovHook) {
        if (!rcovHook.isActive()) {
            rcovHook.setActive(true);
            iRubyObject.getRuntime().addEventHook((EventHook)rcovHook);
            return iRubyObject.getRuntime().getTrue();
        }
        return iRubyObject.getRuntime().getFalse();
    }
}

