// generated by Fast Light User Interface Designer (fluid) version 1.0109

#include <libintl.h>
#include "rakarrack.h"
#include "icono_rakarrack_128x128.xpm"
static Fl_Color leds_color; 
static Fl_Color back_color; 
static Fl_Color fore_color; 
static Fl_Color label_color; 

NewVum::NewVum(int x,int y, int w, int h, const char *label):Fl_Slider(x,y,w,h,label) {
}

void NewVum::draw_bg(int X, int Y, int W, int H) {
  fl_push_clip(X, Y, W, H);
  draw_box(FL_THIN_DOWN_BOX,X,Y,W,H,back_color);
  fl_pop_clip();

//Fl_Color black = active_r() ? FL_FOREGROUND_COLOR : FL_INACTIVE_COLOR;
}

void NewVum::draw_rest(int X, int Y, int W, int H) {
  double val;
int x = X;
int y = Y;
int h = H;
int w = W;

float fred,fyel,fora;

fred=.239;
fora=.35;
fyel=.508;


    val = 1.0-((value() + 48.0) / 63.0);
    if (val > 1.0) val = 1.0;
    else if (val < 0.0) val = 0.0;
  
  
  int S,S1,S2,S3;
  
   
   S = h - int(val*h+.5); 
  
   S1 = h - int(fred*h+.5);
   S2 = h - int(fora*h+.5); 
   S3 = h - int(fyel*h+.5);
 

    draw_bg(X, Y, W, H);
 
  int ko=H+Y-S;

 if (val < fred)  
  {
  
   
  
  fl_color(fl_darker(FL_RED)); 
  fl_rectf(x+1,h+y-S,3,S-S1);
  fl_color(FL_RED); 
  fl_rectf(x+4,h+y-S,w-7,S-S1); 
  fl_color(fl_darker(FL_RED)); 
  fl_rectf(x+w-3,h+y-S,2,S-S1);
 
   S=S1;
  }   
  
 if (val < fora)  
  {
   
   
 
 
 fl_color(fl_darker((Fl_Color) 93)); 
  fl_rectf(x+1,h+y-S,3,S-S2);
  fl_color((Fl_Color)93); 
  fl_rectf(x+4,h+y-S,w-7,S-S2); 
 fl_color(fl_darker((Fl_Color)93)); 
  fl_rectf(x+w-3,h+y-S,2,S-S2);
 
   S=S2;
  }       

  if (val < fyel)  
  {
  
  
  
  fl_color(fl_darker(FL_YELLOW)); 
  fl_rectf(x+1,h+y-S,3,S-S3);
  fl_color(FL_YELLOW); 
  fl_rectf(x+4,h+y-S,w-7,S-S3); 
  fl_color(fl_darker(FL_YELLOW)); 
  fl_rectf(x+w-3,h+y-S,2,S-S3);
  
  
   S=S3;
  }   
   
  
  fl_color(fl_darker(FL_GREEN)); 
  fl_rectf(x+1,h+y-S,3,S);
  fl_color(FL_GREEN); 
  fl_rectf(x+4,h+y-S,w-7,S); 
  fl_color(fl_darker(FL_GREEN)); 
  fl_rectf(x+w-3,h+y-S,2,S);
  
 
if (val < 1.0)
 {
 fl_color(FL_BLACK);
   
 for(int i=H+Y-4;i>ko;i=i-4)   
  fl_line(x, i, x+w-1,i);
  
}
}

void NewVum::draw() {
  if (damage()&FL_DAMAGE_ALL) draw_box();


  draw_rest(x()+Fl::box_dx(box()),
       y()+Fl::box_dy(box()),
       w()-Fl::box_dw(box()),
       h()-Fl::box_dh(box()));
}

int NewVum::handle(int event) {
  switch(event)
{
case FL_SHOW:
             
             
case FL_HIDE:
             

case FL_RELEASE:

{
return 0;
}


case FL_DRAG: 
{
return 0;
}

case FL_SHORTCUT:
return 0;

default:
return 0;
}

return 1;
}

SliderW::SliderW(int x,int y, int w, int h, const char *label):Fl_Value_Slider(x,y,w,h,label) {
}

int SliderW::handle(int event) {
  if (event == FL_PUSH && Fl::visible_focus()) {
    Fl::focus(this);
    redraw();
}  
  
  int sxx = x(), syy = y(), sww = w(), shh = h();
  
  if (horizontal()) {
    sxx += 35; sww -= 35;
  } else {
    syy += 25; shh -= 25;
 }
  
return handle2(event,
                  sxx+Fl::box_dx(box()),
                  syy+Fl::box_dy(box()),
                  sww-Fl::box_dw(box()),
                  shh-Fl::box_dh(box()));
}

int SliderW::handle2(int event, int X, int Y, int W, int H) {
  switch (event) {
  case FL_PUSH:
    if (!Fl::event_inside(X, Y, W, H)) return 0;
    handle_push();
  case FL_DRAG: {

    double val;
    if (minimum() == maximum())
      val = 0.5;
    else {
      val = (value()-minimum())/(maximum()-minimum());
      if (val > 1.0) val = 1.0;
      else if (val < 0.0) val = 0.0;
    }

    int ww = (horizontal() ? W : H);
    int mx = (horizontal() ? Fl::event_x()-X : Fl::event_y()-Y);
    int S=0;
    static int offcenter;

    if (type() == FL_HOR_FILL_SLIDER || type() == FL_VERT_FILL_SLIDER) {

      S = 1;
      if (event == FL_PUSH) {
        int xx = int(val*ww+.5);
        offcenter = mx-xx;
        if (offcenter < -10 || offcenter > 10) offcenter = 0;
        else return 1;
      }

    } else {

      S = int(0*ww+.5); if (S >= ww) return 0;
      int T = (horizontal() ? H : W)/2+1;
      if (type()==FL_VERT_NICE_SLIDER || type()==FL_HOR_NICE_SLIDER) T += 4;
      if (S < T) S = T;
      if (event == FL_PUSH) {
       int xx = int(val*(ww-S)+.5);
        offcenter = mx-xx;
        if (offcenter < 0) offcenter = 0;
        else if (offcenter > S) offcenter = S;
        else return 1;
      }
    }

    int xx = mx-offcenter;
    double v;
    char tryAgain = 1;
    while (tryAgain)
    {
      tryAgain = 0;
      if (xx < 0) {
        xx = 0;
        offcenter = mx; if (offcenter < 0) offcenter = 0;
      } else if (xx > (ww-S)) {
        xx = ww-S;
        offcenter = mx-xx; if (offcenter > S) offcenter = S;
      }
      v = round(xx*(maximum()-minimum())/(ww-S) + minimum());
      // make sure a click outside the sliderbar moves it:
      if (event == FL_PUSH && v == value()) {
        offcenter = S/2;
        event = FL_DRAG;
        tryAgain = 1;
      }
    }


   handle_drag(clamp(v));
    } return 1;
 
    case FL_MOUSEWHEEL :
  
      if (Fl::e_dy==0) return 0;
      handle_push();
      handle_drag(clamp(increment(value(),Fl::e_dy)));
      handle_release();
      return 1;
    
 
  case FL_RELEASE:
    handle_release();
    return 1;
  case FL_KEYBOARD :
    switch (Fl::event_key()) {
      case FL_Up:
        if (horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),-1)));
        handle_release();
        return 1;
      case FL_Down:
        if (horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),1)));
        handle_release();
        return 1;
      case FL_Left:
        if (!horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),-1)));
        handle_release();
        return 1;
      case FL_Right:
        if (!horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),1)));
        handle_release();
        return 1;
      default:
        return 0;
    }
    // break not required because of switch...
  case FL_FOCUS :
  case FL_UNFOCUS :
    if (Fl::visible_focus()) {
      redraw();
      return 1;
    } else return 0;
  case FL_ENTER :
  case FL_LEAVE :
    return 1;
  default:
    return 0;
  }
}

void SliderW::draw() {
  int X,Y,W,H;





int sxx = x(), syy = y(), sww = w(), shh = h();
int bxx = x(), byy = y(), bww = w(), bhh = h();
 
  if (horizontal()) {
    bww = 35; sxx += 35; sww -= 35;
  } else {
    syy += 25; bhh = 25; shh -= 25;
  }
  if (damage()&FL_DAMAGE_ALL) draw_box(box(),sxx,syy,sww,shh,back_color);
 
                  X=sxx+Fl::box_dx(box());
                  Y=syy+Fl::box_dy(box());
                  W=sww-Fl::box_dw(box());
                  H=shh-Fl::box_dh(box());
 
 
 
 
  double val;
  if (minimum() == maximum())
    val = 0.5;
  else {
    val = (value()-minimum())/(maximum()-minimum());
    if (val > 1.0) val = 1.0;
    else if (val < 0.0) val = 0.0;
  }

 int ww = (horizontal() ? W : H);
  int xx, S;

    S = int(.25*ww+.5);
    // S= 1;
 
    int T = (horizontal() ? H : W)/2+1;
    if (type()==FL_VERT_NICE_SLIDER || type()==FL_HOR_NICE_SLIDER) T += 12;
    // if (S < T) S = T;
    xx = int(val*(ww-S)+.5);
  
  int xsl, ysl, wsl, hsl;
  if (horizontal()) {
    xsl = X+xx;
    wsl = S;
    ysl = Y;
    hsl = H-2;
  } else {
    ysl = Y+xx;
    hsl = S;
    xsl = X;
    wsl = W-2;
  }


  Fl_Color Fondo = back_color;
  
  fl_push_clip(X, Y, W, H);
  //draw_box();

  if (( Fl::scheme_) && (strcmp(Fl::scheme_, "plastic")==0)) 
  draw_box(FL_PLASTIC_DOWN_BOX,X,Y,W,H,Fondo);
  else draw_box(FL_FLAT_BOX,X,Y,W,H,Fondo);
    
  fl_pop_clip();

  Fl_Color black = active_r() ? FL_FOREGROUND_COLOR : FL_INACTIVE_COLOR;
 
  if (type() == FL_VERT_NICE_SLIDER) {
   draw_box(FL_THIN_DOWN_BOX, X+W/2-2, Y, 4, H, black);
  
  } else if (type() == FL_HOR_NICE_SLIDER) {
   
  draw_box(FL_THIN_DOWN_BOX, X, Y+H/2-2, W, 4, black);
  }

  
  
  Fl_Color juan,pepe;
  float vval=fabsf(val);
  
  juan = fl_color_average(fl_darker(leds_color),fl_lighter(leds_color),vval);
  pepe = fl_color_average(fl_lighter(leds_color),fl_darker(leds_color),vval);
  
  

 Fl_Boxtype box1 = slider();
  if (!box1) {box1 = (Fl_Boxtype)(box()&-2); if (!box1) box1 = FL_UP_BOX;}
  if (type() == FL_VERT_NICE_SLIDER) {
    draw_box(box1, xsl, ysl, wsl, hsl, fore_color);
    int d = (hsl-4)/2;
    draw_box(FL_THIN_DOWN_BOX, xsl+2, ysl+d, wsl-4, hsl-2*d,juan);
  } else if (type() == FL_HOR_NICE_SLIDER) {
    draw_box(box1, xsl, ysl, wsl, hsl, fore_color);
    int d = (wsl-4)/2;
    draw_box(FL_THIN_DOWN_BOX, xsl+d, ysl+2, wsl-2*d, hsl-4,pepe);
  } else {
    if (wsl>0 && hsl>0) draw_box(box1, xsl, ysl, wsl, hsl, juan);

    if (type()!=FL_HOR_FILL_SLIDER && type() != FL_VERT_FILL_SLIDER &&
        Fl::scheme_ && !strcmp(Fl::scheme_, "gtk+")) {
      if (W>H && wsl>(hsl+8)) {
        // Draw horizontal grippers
        int yy, hh;
        hh = hsl-8;
        xx = xsl+(wsl-hsl-4)/2;
        yy = ysl+3;

        fl_color(fl_darker(pepe));
        fl_line(xx, yy+hh, xx+hh, yy);
        fl_line(xx+6, yy+hh, xx+hh+6, yy);
        fl_line(xx+12, yy+hh, xx+hh+12, yy);

        xx++;
        fl_color(fl_lighter(pepe));
        fl_line(xx, yy+hh, xx+hh, yy);
        fl_line(xx+6, yy+hh, xx+hh+6, yy);
        fl_line(xx+12, yy+hh, xx+hh+12, yy);
      } else if (H>W && hsl>(wsl+8)) {
        // Draw vertical grippers
        int yy;
        xx = xsl+4;
        ww = wsl-8;
        yy = ysl+(hsl-wsl-4)/2;

        fl_color(fl_darker(juan));
        fl_line(xx, yy+ww, xx+ww, yy);
        fl_line(xx, yy+ww+6, xx+ww, yy+6);
        fl_line(xx, yy+ww+12, xx+ww, yy+12);



        yy++;
        fl_color(fl_lighter(juan));
        fl_line(xx, yy+ww, xx+ww, yy);
        fl_line(xx, yy+ww+6, xx+ww, yy+6);
        fl_line(xx, yy+ww+12, xx+ww, yy+12);
      }
    }
  }

  
  labelcolor(label_color);
 
  draw_label(xsl, ysl, wsl, hsl);


   
  if (Fl::focus() == this) {
    if (type() == FL_HOR_FILL_SLIDER || type() == FL_VERT_FILL_SLIDER) draw_focus();
    else draw_focus(box1, xsl, ysl, wsl, hsl);
  }
  
  if (( Fl::scheme_) && (strcmp(Fl::scheme_, "plastic")==0)) 
  {
  if (type() == FL_HOR_NICE_SLIDER)
  draw_box(FL_PLASTIC_DOWN_BOX,bxx+2,byy,bww-4,bhh,Fondo); 
  else
  draw_box(FL_PLASTIC_DOWN_BOX,bxx,byy,bww,bhh,Fondo); 
  }
  else
  draw_box(box(),bxx,byy,bww,bhh,Fondo);

  char buf[128];
  format(buf);
  fl_font(textfont(), textsize());
  if (( Fl::scheme_) && (strcmp(Fl::scheme_, "plastic")==0)) 
  fl_color(active_r() ? label_color: fl_inactive(textcolor()));
  else
  fl_color(active_r() ? textcolor(): fl_inactive(textcolor()));
  fl_draw(buf, bxx, byy, bww, bhh, FL_ALIGN_CLIP);
}

void RKRGUI::cb_Principal_i(Fl_Double_Window*, void*) {
  is_modified();
save_stat(0);
Pexitprogram=1;
}
void RKRGUI::cb_Principal(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Principal_i(o,v);
}

void RKRGUI::cb_Menu_New_i(Fl_Menu_*, void*) {
  S_new->do_callback();
}
void RKRGUI::cb_Menu_New(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Menu_New_i(o,v);
}

void RKRGUI::cb_Load_Preset_i(Fl_Menu_*, void*) {
  L_preset->do_callback();
}
void RKRGUI::cb_Load_Preset(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Preset_i(o,v);
}

void RKRGUI::cb_Save_Preset_i(Fl_Menu_*, void*) {
  S_preset->do_callback();
}
void RKRGUI::cb_Save_Preset(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Preset_i(o,v);
}

void RKRGUI::cb_Load_Bank_M_i(Fl_Menu_* o, void*) {
  Load_Bank->do_callback(o);
}
void RKRGUI::cb_Load_Bank_M(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Bank_M_i(o,v);
}

void RKRGUI::cb_Save_Bank_M_i(Fl_Menu_* o, void*) {
  Save_Bank->do_callback(o);
}
void RKRGUI::cb_Save_Bank_M(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Bank_M_i(o,v);
}

void RKRGUI::cb_salir_i(Fl_Menu_*, void*) {
  Principal->do_callback();
}
void RKRGUI::cb_salir(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_salir_i(o,v);
}

void RKRGUI::cb_Bank_Menu_i(Fl_Menu_*, void*) {
  B_preset->do_callback();
}
void RKRGUI::cb_Bank_Menu(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Bank_Menu_i(o,v);
}

void RKRGUI::cb_Ajustes_i(Fl_Menu_*, void*) {
  MiraClientes();
MiraConfig();
Settings->show();
put_icon(Settings);
}
void RKRGUI::cb_Ajustes(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Ajustes_i(o,v);
}

void RKRGUI::cb_Contenido_i(Fl_Menu_*, void*) {
  show_help();
}
void RKRGUI::cb_Contenido(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Contenido_i(o,v);
}

void RKRGUI::cb_Acerca_de_i(Fl_Menu_*, void*) {
  int x,y;

x = Principal->x()+((Principal->w()-420)/2);
y = Principal->y()+((Principal->h()-230)/2);

AboutWin->position(x,y);
AboutWin->show();
put_icon(AboutWin);
}
void RKRGUI::cb_Acerca_de(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Acerca_de_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_MenuP[] = {
 {gettext("&File"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("New"), 0,  (Fl_Callback*)RKRGUI::cb_Menu_New, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Load Preset"), 0,  (Fl_Callback*)RKRGUI::cb_Load_Preset, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Save Preset"), 0,  (Fl_Callback*)RKRGUI::cb_Save_Preset, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Load Bank"), 0,  (Fl_Callback*)RKRGUI::cb_Load_Bank_M, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Save Bank"), 0,  (Fl_Callback*)RKRGUI::cb_Save_Bank_M, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Exit"), 0,  (Fl_Callback*)RKRGUI::cb_salir, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {gettext("&Bank"), 0x62,  (Fl_Callback*)RKRGUI::cb_Bank_Menu, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Settings"), 0x69,  (Fl_Callback*)RKRGUI::cb_Ajustes, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("&Help"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("Help Contents"), 0xffbe,  (Fl_Callback*)RKRGUI::cb_Contenido, 0, 128, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("About..."), 0,  (Fl_Callback*)RKRGUI::cb_Acerca_de, 0, 128, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* RKRGUI::Archivo = RKRGUI::menu_MenuP + 0;
Fl_Menu_Item* RKRGUI::Menu_New = RKRGUI::menu_MenuP + 1;
Fl_Menu_Item* RKRGUI::Load_Preset = RKRGUI::menu_MenuP + 2;
Fl_Menu_Item* RKRGUI::Save_Preset = RKRGUI::menu_MenuP + 3;
Fl_Menu_Item* RKRGUI::Load_Bank_M = RKRGUI::menu_MenuP + 4;
Fl_Menu_Item* RKRGUI::Save_Bank_M = RKRGUI::menu_MenuP + 5;
Fl_Menu_Item* RKRGUI::salir = RKRGUI::menu_MenuP + 6;
Fl_Menu_Item* RKRGUI::Bank_Menu = RKRGUI::menu_MenuP + 8;
Fl_Menu_Item* RKRGUI::Ajustes = RKRGUI::menu_MenuP + 9;
Fl_Menu_Item* RKRGUI::Ayuda = RKRGUI::menu_MenuP + 10;
Fl_Menu_Item* RKRGUI::Contenido = RKRGUI::menu_MenuP + 11;
Fl_Menu_Item* RKRGUI::Acerca_de = RKRGUI::menu_MenuP + 12;

void RKRGUI::cb_MT_i(Fl_Box*, void*) {
  if (rkr->Tuner_Bypass)
{

if(rkr->efx_Tuner->note_actual != rkr->note_old)
{
char notas[3];
sprintf(notas,"%-2s",rkr->efx_Tuner->notes[rkr->efx_Tuner->note_actual]);
WNote->copy_label(notas);
rkr->note_old=rkr->efx_Tuner->note_actual;
}

if(rkr->efx_Tuner->nfreq != rkr->nfreq_old)
{
char refreq[60];
sprintf(refreq,"%8.3f",rkr->efx_Tuner->nfreq);
WRfreq->copy_label(refreq);
rkr->nfreq_old=rkr->efx_Tuner->nfreq;
}

if(rkr->efx_Tuner->afreq != rkr->afreq_old)
{
char nofreq[60];
sprintf(nofreq,"%8.3f",rkr->efx_Tuner->afreq);
if (abs(rkr->efx_Tuner->cents)>5) WNfreq->labelcolor(FL_RED); else WNfreq->labelcolor(label_color);
WNfreq->copy_label(nofreq);
rkr->afreq_old=rkr->efx_Tuner->afreq;
}


if(rkr->efx_Tuner->cents != rkr->cents_old)
{
tuner_bar->value(rkr->efx_Tuner->cents);
rkr->cents_old=rkr->efx_Tuner->cents;
}

}






if (rkr->midivol)
{ 
Nivel_Salida->value((int) (rkr->Master_Volume*100.0)-50);
rkr->midivol=0;
}



if (preset!=1000)
{
 Preset_Counter->value(preset);
 Preset_Counter->do_callback();
 preset=1000;
}



if (rkr->Bypass)
{ 
  if (rkr->val_i_sum != rkr->old_i_sum)
  {
  input_vu->value(rkr->val_i_sum);
  rkr->old_i_sum=rkr->val_i_sum;
  }
  
  if (rkr->val_v_sum != rkr->old_v_sum)
  {
  output_vu->value(rkr->val_v_sum);
  rkr->old_v_sum=rkr->val_v_sum;
  }

ActMIDI();

}



if (rkr->MIDIConverter_Bypass)
{
  if ((rkr->efx_MIDIConverter->hay) && ( (int) Mled->color() != (int) fl_lighter(FL_RED)))
  
     {
       Mled->color(fl_lighter(FL_RED));
       Mled->redraw();
     }  
  
  if ((!rkr->efx_MIDIConverter->hay) && ( (int) Mled->color() != (int) fl_darker(FL_RED)))   
     {  
     Mled->color(fl_darker(FL_RED));
     Mled->redraw();
     } 
}


if (rkr->Harmonizer_Bypass)
{

    if((rkr->efx_Har->PSELECT)|| (rkr->efx_Har->PMIDI))
     {

    if (rkr->RC->cc) 
    {
    har_chordname->copy_label(rkr->RC->NombreAcorde);
    rkr->RC->cc=0;  
    har_chordname->redraw(); 
    rkr->RC->Vamos(rkr->efx_Har->Pinterval-12);      
    }
     }




};
}
void RKRGUI::cb_MT(Fl_Box* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_MT_i(o,v);
}

void RKRGUI::cb_Open_Order_i(Fl_Button*, void*) {
  int i,j,k,t;
Order_Bro->clear();
Avail_Bro->clear();

for (i=0; i<10;i++) 
{
rkr->new_order[i]=rkr->efx_order[i];
rkr->saved_order[i]=rkr->efx_order[i];
Order_Bro->add(rkr->efx_names[rkr->efx_order[i]].Nom);
}


t=1;

for (i=0; i<17;i++)
{
    k=0;
 for (j=0;j<10;j++)
   { 
     if (rkr->efx_order[j]==i) k=1;
   }     
 
 if(!k)
 
 { 
  Avail_Bro->add(rkr->efx_names[i].Nom);
  rkr->availables[t]=i;
  t++;
 }

}

Order_Bro->select(1);
Avail_Bro->select(1);

Order->show();
put_icon(Order);
}
void RKRGUI::cb_Open_Order(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Open_Order_i(o,v);
}

void RKRGUI::cb_eq_activar_i(Fl_Light_Button* o, void*) {
  rkr->EQ1_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_EQ1->cleanup();
}
void RKRGUI::cb_eq_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_activar_i(o,v);
}

void RKRGUI::cb_eq_preset_i(Fl_Choice* o, void*) {
  int i=0;
i=rkr->EQ1_setpreset(0,0,(int)o->value());
eq_1->value(rkr->EQ1_setpreset(1,0,(int)o->value())-64);
eq_2->value(rkr->EQ1_setpreset(1,1,(int)o->value())-64);
eq_3->value(rkr->EQ1_setpreset(1,2,(int)o->value())-64);
eq_4->value(rkr->EQ1_setpreset(1,3,(int)o->value())-64);
eq_5->value(rkr->EQ1_setpreset(1,4,(int)o->value())-64);
eq_6->value(rkr->EQ1_setpreset(1,5,(int)o->value())-64);
eq_7->value(rkr->EQ1_setpreset(1,6,(int)o->value())-64);
eq_8->value(rkr->EQ1_setpreset(1,7,(int)o->value())-64);
eq_9->value(rkr->EQ1_setpreset(1,8,(int)o->value())-64);
eq_10->value(rkr->EQ1_setpreset(1,9,(int)o->value())-64);
eq_Gain->value(rkr->EQ1_setpreset(1,10,(int)o->value())-64);
eq_Q->value(rkr->EQ1_setpreset(1,11,(int)o->value())-64);
}
void RKRGUI::cb_eq_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_eq_preset[] = {
 {gettext("Plain"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Pop"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Jazz"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_eq_Gain_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_eq_Gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_Gain_i(o,v);
}

void RKRGUI::cb_eq_Q_i(SliderW* o, void*) {
  int i;
for(i=0;i<10;i++) rkr->efx_EQ1->changepar(i*5+13,(int)o->value()+64);
}
void RKRGUI::cb_eq_Q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_Q_i(o,v);
}

void RKRGUI::cb_eq_1_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(12,(int)o->value()+64);
}
void RKRGUI::cb_eq_1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_1_i(o,v);
}

void RKRGUI::cb_eq_2_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(5+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_2_i(o,v);
}

void RKRGUI::cb_eq_3_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(10+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_3_i(o,v);
}

void RKRGUI::cb_eq_4_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(15+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_4(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_4_i(o,v);
}

void RKRGUI::cb_eq_5_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(20+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_5(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_5_i(o,v);
}

void RKRGUI::cb_eq_6_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(25+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_6(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_6_i(o,v);
}

void RKRGUI::cb_eq_7_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(30+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_7(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_7_i(o,v);
}

void RKRGUI::cb_eq_8_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(35+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_8(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_8_i(o,v);
}

void RKRGUI::cb_eq_9_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(40+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_9(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_9_i(o,v);
}

void RKRGUI::cb_eq_10_i(SliderW* o, void*) {
  rkr->efx_EQ1->changepar(45+12,(int)o->value()+64);
}
void RKRGUI::cb_eq_10(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_10_i(o,v);
}

void RKRGUI::cb_compress_activar_i(Fl_Light_Button* o, void*) {
  rkr->Compressor_Bypass=(int)o->value();
rkr->efx_Compressor->cleanup();
}
void RKRGUI::cb_compress_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_activar_i(o,v);
}

void RKRGUI::cb_compress_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Compressor->Compressor_Change_Preset((int) o->value());
compress_ATime->value(rkr->efx_Compressor->getpar(4));
compress_RTime->value(rkr->efx_Compressor->getpar(5));
compress_Ratio->value(rkr->efx_Compressor->getpar(2));
compress_threshold->value(rkr->efx_Compressor->getpar(1));
compress_output->value(rkr->efx_Compressor->getpar(3));
Auto_Output->value(rkr->efx_Compressor->getpar(6));
}
void RKRGUI::cb_compress_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_compress_preset[] = {
 {gettext("2:1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("4:1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("8:1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_compress_ATime_i(SliderW* o, void*) {
  rkr->efx_Compressor->Compressor_Change(4,(int)o->value());
}
void RKRGUI::cb_compress_ATime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_ATime_i(o,v);
}

void RKRGUI::cb_compress_RTime_i(SliderW* o, void*) {
  rkr->efx_Compressor->Compressor_Change(5, (int) o->value());
}
void RKRGUI::cb_compress_RTime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_RTime_i(o,v);
}

void RKRGUI::cb_compress_Ratio_i(SliderW* o, void*) {
  rkr->efx_Compressor->Compressor_Change(2, (int) o->value());
}
void RKRGUI::cb_compress_Ratio(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_Ratio_i(o,v);
}

void RKRGUI::cb_compress_output_i(SliderW* o, void*) {
  rkr->efx_Compressor->Compressor_Change(3,(int)o->value());
}
void RKRGUI::cb_compress_output(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_output_i(o,v);
}

void RKRGUI::cb_compress_threshold_i(SliderW* o, void*) {
  rkr->efx_Compressor->Compressor_Change(1, (int)o->value());
}
void RKRGUI::cb_compress_threshold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_threshold_i(o,v);
}

void RKRGUI::cb_Auto_Output_i(Fl_Check_Button* o, void*) {
  rkr->efx_Compressor->Compressor_Change(6,(int)o->value());
if ((int) o->value() == 0) compress_output->do_callback();
}
void RKRGUI::cb_Auto_Output(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Auto_Output_i(o,v);
}

void RKRGUI::cb_dist_activar_i(Fl_Light_Button* o, void*) {
  rkr->Distorsion_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Distorsion->cleanup();
}
void RKRGUI::cb_dist_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_activar_i(o,v);
}

void RKRGUI::cb_dist_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Distorsion->setpreset((int) o->value()+2);
dist_WD->value(rkr->efx_Distorsion->getpar(0)-64);
dist_LRc->value(rkr->efx_Distorsion->getpar(2)-64);
dist_drive->value(rkr->efx_Distorsion->getpar(3));
dist_level->value(rkr->efx_Distorsion->getpar(4));
dist_tipo->value(rkr->efx_Distorsion->getpar(5));
dist_neg->value(rkr->efx_Distorsion->getpar(6));
dist_st->value(rkr->efx_Distorsion->getpar(9));
dist_pan->value(rkr->efx_Distorsion->getpar(1)-64);
dist_pf->value(rkr->efx_Distorsion->getpar(10));
dist_lpf->value(rkr->efx_Distorsion->getpar(7));
dist_hpf->value(rkr->efx_Distorsion->getpar(8));
}
void RKRGUI::cb_dist_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_dist_preset[] = {
 {gettext("Distorsion 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Distorsion 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Distorsion 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Guitar Amp"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_dist_WD_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_dist_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_WD_i(o,v);
}

void RKRGUI::cb_dist_LRc_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(2,(int) o->value()+64);
}
void RKRGUI::cb_dist_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_LRc_i(o,v);
}

void RKRGUI::cb_dist_drive_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_dist_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_drive_i(o,v);
}

void RKRGUI::cb_dist_level_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_dist_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_level_i(o,v);
}

void RKRGUI::cb_dist_tipo_i(Fl_Choice* o, void*) {
  rkr->efx_Distorsion->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_dist_tipo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_tipo_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_dist_tipo[] = {
 {gettext("Atan"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Asym1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Pow"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Qnts"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Zigzg"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Lmt"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("LmtU"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("LmtL"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("ILmt"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Clip"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Asym2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Pow2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Sgm"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_dist_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_Distorsion->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_dist_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_neg_i(o,v);
}

void RKRGUI::cb_dist_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_Distorsion->changepar(9,(unsigned char)o->value());
}
void RKRGUI::cb_dist_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_st_i(o,v);
}

void RKRGUI::cb_dist_pan_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_dist_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_pan_i(o,v);
}

void RKRGUI::cb_dist_pf_i(Fl_Check_Button* o, void*) {
  rkr->efx_Distorsion->changepar(10,(unsigned char)o->value());
}
void RKRGUI::cb_dist_pf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_pf_i(o,v);
}

void RKRGUI::cb_dist_lpf_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_dist_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_lpf_i(o,v);
}

void RKRGUI::cb_dist_hpf_i(SliderW* o, void*) {
  rkr->efx_Distorsion->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_dist_hpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_hpf_i(o,v);
}

void RKRGUI::cb_ovrd_activar_i(Fl_Light_Button* o, void*) {
  rkr->Overdrive_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Overdrive->cleanup();
}
void RKRGUI::cb_ovrd_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_activar_i(o,v);
}

void RKRGUI::cb_ovrd_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Overdrive->setpreset((int) o->value());
ovrd_WD->value(rkr->efx_Overdrive->getpar(0)-64);
ovrd_LRc->value(rkr->efx_Overdrive->getpar(2)-64);
ovrd_drive->value(rkr->efx_Overdrive->getpar(3));
ovrd_level->value(rkr->efx_Overdrive->getpar(4));
ovrd_tipo->value(rkr->efx_Overdrive->getpar(5));
ovrd_neg->value(rkr->efx_Overdrive->getpar(6));
ovrd_st->value(rkr->efx_Overdrive->getpar(9));
ovrd_pan->value(rkr->efx_Overdrive->getpar(1)-64);
ovrd_pf->value(rkr->efx_Overdrive->getpar(10));
ovrd_lpf->value(rkr->efx_Overdrive->getpar(7));
ovrd_hpf->value(rkr->efx_Overdrive->getpar(8));
}
void RKRGUI::cb_ovrd_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_ovrd_preset[] = {
 {gettext("Overdrive 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Overdrive 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_ovrd_WD_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_ovrd_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_WD_i(o,v);
}

void RKRGUI::cb_ovrd_LRc_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(2,(int)o->value()+64);;
}
void RKRGUI::cb_ovrd_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_LRc_i(o,v);
}

void RKRGUI::cb_ovrd_drive_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_drive_i(o,v);
}

void RKRGUI::cb_ovrd_level_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_level_i(o,v);
}

void RKRGUI::cb_ovrd_tipo_i(Fl_Choice* o, void*) {
  rkr->efx_Overdrive->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_tipo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_tipo_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_ovrd_tipo[] = {
 {gettext("Atan"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Asym1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Pow"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Qnts"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Zigzg"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Lmt"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("LmtU"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("LmtL"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("ILmt"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Clip"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Asym2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Pow2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {gettext("Sgm"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_ovrd_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_Overdrive->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_neg_i(o,v);
}

void RKRGUI::cb_ovrd_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_Overdrive->changepar(9,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_st_i(o,v);
}

void RKRGUI::cb_ovrd_pan_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_ovrd_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_pan_i(o,v);
}

void RKRGUI::cb_ovrd_pf_i(Fl_Check_Button* o, void*) {
  rkr->efx_Overdrive->changepar(10,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_pf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_pf_i(o,v);
}

void RKRGUI::cb_ovrd_lpf_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_lpf_i(o,v);
}

void RKRGUI::cb_ovrd_hpf_i(SliderW* o, void*) {
  rkr->efx_Overdrive->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_ovrd_hpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_hpf_i(o,v);
}

void RKRGUI::cb_echo_activar_i(Fl_Light_Button* o, void*) {
  rkr->Echo_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Echo->cleanup();
}
void RKRGUI::cb_echo_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_activar_i(o,v);
}

void RKRGUI::cb_echo_preset_i(Fl_Choice* o, void*) {
  rkr->Echo_Bypass=0;
rkr->efx_Echo->setpreset((int) o->value());
echo_WD->value(rkr->efx_Echo->getpar(0)-64);
echo_pan->value(rkr->efx_Echo->getpar(1)-64);
echo_delay->value(rkr->efx_Echo->getpar(2));
echo_LRdl->value(rkr->efx_Echo->getpar(3));
echo_LRc->value(rkr->efx_Echo->getpar(4)-64);
echo_fb->value(rkr->efx_Echo->getpar(5));
echo_damp->value(rkr->efx_Echo->getpar(8));
if((int)echo_activar->value())rkr->Echo_Bypass=1;
}
void RKRGUI::cb_echo_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_echo_preset[] = {
 {gettext("Echo 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Echo 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Echo 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Simple Echo"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Canyon"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Panning Echo 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Panning Echo 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Panning Echo 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Feedback Echo"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_echo_WD_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_echo_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_WD_i(o,v);
}

void RKRGUI::cb_echo_pan_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_echo_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_pan_i(o,v);
}

void RKRGUI::cb_echo_delay_i(SliderW* o, void*) {
  rkr->Echo_Bypass=0;
rkr->efx_Echo->changepar(2,(unsigned char)o->value());
if((int)echo_activar->value())rkr->Echo_Bypass=1;
}
void RKRGUI::cb_echo_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_delay_i(o,v);
}

void RKRGUI::cb_echo_LRdl_i(SliderW* o, void*) {
  rkr->Echo_Bypass=0;
rkr->efx_Echo->changepar(3,(unsigned char)o->value());
if((int)echo_activar->value())rkr->Echo_Bypass=1;
}
void RKRGUI::cb_echo_LRdl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_LRdl_i(o,v);
}

void RKRGUI::cb_echo_LRc_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(4,(int)o->value()+64);
}
void RKRGUI::cb_echo_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_LRc_i(o,v);
}

void RKRGUI::cb_echo_fb_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_echo_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_fb_i(o,v);
}

void RKRGUI::cb_echo_damp_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_echo_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_damp_i(o,v);
}

void RKRGUI::cb_chorus_activar_i(Fl_Light_Button* o, void*) {
  rkr->Chorus_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Chorus->cleanup();
}
void RKRGUI::cb_chorus_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_activar_i(o,v);
}

void RKRGUI::cb_chorux_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Chorus->setpreset((int) o->value());
chorus_WD->value(rkr->efx_Chorus->getpar(0)-64);
chorus_pan->value(rkr->efx_Chorus->getpar(1)-64);
chorus_freq->value(rkr->efx_Chorus->getpar(2));
chorus_rnd->value(rkr->efx_Chorus->getpar(3));
chorus_lfotype->value(rkr->efx_Chorus->getpar(4));
chorus_stdf->value(rkr->efx_Chorus->getpar(5));
chorus_dpth->value(rkr->efx_Chorus->getpar(6));
chorus_delay->value(rkr->efx_Chorus->getpar(7));
chorus_fb->value(rkr->efx_Chorus->getpar(8));
chorus_LR->value(rkr->efx_Chorus->getpar(9)-64);
chorus_subs->value(rkr->efx_Chorus->getpar(11));
}
void RKRGUI::cb_chorux_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorux_preset_i(o,v);
}

void RKRGUI::cb_Chorus_i(Fl_Menu_* o, void*) {
  rkr->efx_Chorus->setpreset((int) o->value() +1);
}
void RKRGUI::cb_Chorus(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Chorus_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_chorux_preset[] = {
 {gettext("Chorus 1"), 0,  (Fl_Callback*)RKRGUI::cb_Chorus, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Chorus 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Chorus 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Celeste 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Celeste 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_chorus_WD_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_chorus_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_WD_i(o,v);
}

void RKRGUI::cb_chorus_pan_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_chorus_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_pan_i(o,v);
}

void RKRGUI::cb_chorus_freq_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_freq_i(o,v);
}

void RKRGUI::cb_chorus_rnd_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_rnd_i(o,v);
}

void RKRGUI::cb_chorus_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Chorus->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_chorus_lfotype[] = {
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tri"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_chorus_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Chorus->changepar(11,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_subs_i(o,v);
}

void RKRGUI::cb_chorus_stdf_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_stdf_i(o,v);
}

void RKRGUI::cb_chorus_dpth_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_dpth_i(o,v);
}

void RKRGUI::cb_chorus_delay_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_delay_i(o,v);
}

void RKRGUI::cb_chorus_fb_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_chorus_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_fb_i(o,v);
}

void RKRGUI::cb_chorus_LR_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(9,(int)o->value()+64);
}
void RKRGUI::cb_chorus_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_LR_i(o,v);
}

void RKRGUI::cb_phaser_activar_i(Fl_Light_Button* o, void*) {
  rkr->Phaser_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Phaser->cleanup();
}
void RKRGUI::cb_phaser_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_activar_i(o,v);
}

void RKRGUI::cb_phaser_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Phaser->setpreset((int) o->value());
phaser_WD->value(rkr->efx_Phaser->getpar(0)-64);
phaser_pan->value(rkr->efx_Phaser->getpar(1)-64);
phaser_freq->value(rkr->efx_Phaser->getpar(2));
phaser_rnd->value(rkr->efx_Phaser->getpar(3));
phaser_lfotype->value(rkr->efx_Phaser->getpar(4));
phaser_stdf->value(rkr->efx_Phaser->getpar(5));
phaser_dpth->value(rkr->efx_Phaser->getpar(6));
phaser_stages->value(rkr->efx_Phaser->getpar(8));
phaser_fb->value(rkr->efx_Phaser->getpar(7));
phaser_stages->value(rkr->efx_Phaser->getpar(8));
phaser_LR->value(rkr->efx_Phaser->getpar(9)-64);
phaser_subs->value(rkr->efx_Phaser->getpar(10));
phaser_phase->value(rkr->efx_Phaser->getpar(11));
}
void RKRGUI::cb_phaser_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_phaser_preset[] = {
 {gettext("Phaser 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Phaser 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Phaser 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Phaser 4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Phaser 5"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Phaser 6"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_phaser_WD_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_phaser_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_WD_i(o,v);
}

void RKRGUI::cb_phaser_pan_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_phaser_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_pan_i(o,v);
}

void RKRGUI::cb_phaser_freq_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_freq_i(o,v);
}

void RKRGUI::cb_phaser_rnd_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_rnd_i(o,v);
}

void RKRGUI::cb_phaser_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Phaser->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_phaser_lfotype[] = {
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tri"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_phaser_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Phaser->changepar(10,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_subs_i(o,v);
}

void RKRGUI::cb_phaser_phase_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(11,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_phase(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_phase_i(o,v);
}

void RKRGUI::cb_phaser_stdf_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_stdf_i(o,v);
}

void RKRGUI::cb_phaser_dpth_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_dpth_i(o,v);
}

void RKRGUI::cb_phaser_fb_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_fb_i(o,v);
}

void RKRGUI::cb_phaser_stages_i(Fl_Counter* o, void*) {
  rkr->efx_Phaser->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_phaser_stages(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_stages_i(o,v);
}

void RKRGUI::cb_phaser_LR_i(SliderW* o, void*) {
  rkr->efx_Phaser->changepar(9,(int)o->value()+64);
}
void RKRGUI::cb_phaser_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_LR_i(o,v);
}

void RKRGUI::cb_flanger_activar_i(Fl_Light_Button* o, void*) {
  rkr->Flanger_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Flanger->cleanup();
}
void RKRGUI::cb_flanger_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_activar_i(o,v);
}

void RKRGUI::cb_flanger_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Flanger->setpreset((int) o->value()+5);
flanger_WD->value(rkr->efx_Flanger->getpar(0)-64);
flanger_pan->value(rkr->efx_Flanger->getpar(1)-64);
flanger_freq->value(rkr->efx_Flanger->getpar(2));
flanger_rnd->value(rkr->efx_Flanger->getpar(3));
flanger_lfotype->value(rkr->efx_Flanger->getpar(4));
flanger_stdf->value(rkr->efx_Flanger->getpar(5));
flanger_dpth->value(rkr->efx_Flanger->getpar(6));
flanger_delay->value(rkr->efx_Flanger->getpar(7));
flanger_fb->value(rkr->efx_Flanger->getpar(8));
flanger_LR->value(rkr->efx_Flanger->getpar(9)-64);
flanger_subs->value(rkr->efx_Flanger->getpar(11));
}
void RKRGUI::cb_flanger_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_flanger_preset[] = {
 {gettext("Flange 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Flange 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Flange 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Flange 4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Flange 5"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_flanger_WD_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_flanger_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_WD_i(o,v);
}

void RKRGUI::cb_flanger_pan_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_flanger_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_pan_i(o,v);
}

void RKRGUI::cb_flanger_freq_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_freq_i(o,v);
}

void RKRGUI::cb_flanger_rnd_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_rnd_i(o,v);
}

void RKRGUI::cb_flanger_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Flanger->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_flanger_lfotype[] = {
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tri"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_flanger_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Flanger->changepar(11,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_subs_i(o,v);
}

void RKRGUI::cb_flanger_stdf_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_stdf_i(o,v);
}

void RKRGUI::cb_flanger_dpth_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_dpth_i(o,v);
}

void RKRGUI::cb_flanger_delay_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_delay_i(o,v);
}

void RKRGUI::cb_flanger_fb_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_flanger_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_fb_i(o,v);
}

void RKRGUI::cb_flanger_LR_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(9,(int)o->value()+64);
}
void RKRGUI::cb_flanger_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_LR_i(o,v);
}

void RKRGUI::cb_reverb_activar_i(Fl_Light_Button* o, void*) {
  rkr->Reverb_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Rev->cleanup();
}
void RKRGUI::cb_reverb_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_activar_i(o,v);
}

void RKRGUI::cb_reverb_preset_i(Fl_Choice* o, void*) {
  rkr->Reverb_Bypass=0;
rkr->efx_Rev->setpreset((int) o->value());
reverb_WD->value(rkr->efx_Rev->getpar(0)-64);
reverb_pan->value(rkr->efx_Rev->getpar(1)-64);
reverb_time->value(rkr->efx_Rev->getpar(2));
reverb_ldel->value(rkr->efx_Rev->getpar(3));
reverb_ldelft->value(rkr->efx_Rev->getpar(4));
reverb_LPF->value(rkr->efx_Rev->getpar(7));
reverb_HPF->value(rkr->efx_Rev->getpar(8));
reverb_damp->value(rkr->efx_Rev->getpar(9));
reverb_RS->value(rkr->efx_Rev->getpar(11));
reverb_type->value(rkr->efx_Rev->getpar(10));
if((int)reverb_activar->value())rkr->Reverb_Bypass=1;
}
void RKRGUI::cb_reverb_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_reverb_preset[] = {
 {gettext("Cathedral 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Cathedral 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Cathedral 3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Hall 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Hall 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Room 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Room 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Basement"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tunnel"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Echoed 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Echoed 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Very Long 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Very Long 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_reverb_WD_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_reverb_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_WD_i(o,v);
}

void RKRGUI::cb_reverb_pan_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_reverb_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_pan_i(o,v);
}

void RKRGUI::cb_reverb_time_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_time(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_time_i(o,v);
}

void RKRGUI::cb_reverb_ldel_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_ldel(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_ldel_i(o,v);
}

void RKRGUI::cb_reverb_ldelft_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_ldelft(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_ldelft_i(o,v);
}

void RKRGUI::cb_reverb_type_i(Fl_Choice* o, void*) {
  rkr->efx_Rev->changepar(10,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_type(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_type_i(o,v);
}

void RKRGUI::cb_Random_i(Fl_Menu_*, void*) {
  rkr->efx_Rev->changepar(10,1);
}
void RKRGUI::cb_Random(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Random_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_reverb_type[] = {
 {gettext("Freeverb"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Random"), 0,  (Fl_Callback*)RKRGUI::cb_Random, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_reverb_RS_i(SliderW* o, void*) {
  rkr->Reverb_Bypass=0;
rkr->efx_Rev->changepar(11,(unsigned char)o->value());
if((int)reverb_activar->value())rkr->Reverb_Bypass=1;
}
void RKRGUI::cb_reverb_RS(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_RS_i(o,v);
}

void RKRGUI::cb_reverb_LPF_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_LPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_LPF_i(o,v);
}

void RKRGUI::cb_reverb_HPF_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_HPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_HPF_i(o,v);
}

void RKRGUI::cb_reverb_damp_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(9,(unsigned char)o->value());
}
void RKRGUI::cb_reverb_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_damp_i(o,v);
}

void RKRGUI::cb_eqp_activar_i(Fl_Light_Button* o, void*) {
  rkr->EQ2_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_EQ2->cleanup();
}
void RKRGUI::cb_eqp_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_activar_i(o,v);
}

void RKRGUI::cb_eqp_preset_i(Fl_Choice* o, void*) {
  int i=0;

i=rkr->EQ2_setpreset(0,0,(int)o->value());
eqp_LF->value(rkr->EQ2_setpreset(1,0,(int)o->value()));
eqp_LFg->value(rkr->EQ2_setpreset(1,1,(int)o->value())-64);
eqp_LQ->value(rkr->EQ2_setpreset(1,2,(int)o->value())-64);
eqp_MF->value(rkr->EQ2_setpreset(1,3,(int)o->value()));
eqp_MFg->value(rkr->EQ2_setpreset(1,4,(int)o->value())-64);
eqp_MQ->value(rkr->EQ2_setpreset(1,5,(int)o->value())-64);
eqp_HF->value(rkr->EQ2_setpreset(1,6,(int)o->value()));
eqp_HFg->value(rkr->EQ2_setpreset(1,7,(int)o->value())-64);
eqp_HQ->value(rkr->EQ2_setpreset(1,8,(int)o->value())-64);
eqp_Gain->value(rkr->EQ2_setpreset(1,9,(int)o->value())-64);
}
void RKRGUI::cb_eqp_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_eqp_preset[] = {
 {gettext("Plain"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Pop"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Jazz"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_eqp_Gain_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_eqp_Gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_Gain_i(o,v);
}

void RKRGUI::cb_eqp_LF_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(11,(int)o->value());
}
void RKRGUI::cb_eqp_LF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_LF_i(o,v);
}

void RKRGUI::cb_eqp_LFg_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(12,(int)o->value()+64);
}
void RKRGUI::cb_eqp_LFg(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_LFg_i(o,v);
}

void RKRGUI::cb_eqp_LQ_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(13,(int)o->value()+64);
}
void RKRGUI::cb_eqp_LQ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_LQ_i(o,v);
}

void RKRGUI::cb_eqp_MF_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(5+11,(int)o->value());
}
void RKRGUI::cb_eqp_MF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_MF_i(o,v);
}

void RKRGUI::cb_eqp_MFg_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(5+12,(int)o->value()+64);
}
void RKRGUI::cb_eqp_MFg(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_MFg_i(o,v);
}

void RKRGUI::cb_eqp_MQ_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(5+13,(int)o->value()+64);
}
void RKRGUI::cb_eqp_MQ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_MQ_i(o,v);
}

void RKRGUI::cb_eqp_HF_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(10+11,(int)o->value());
}
void RKRGUI::cb_eqp_HF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_HF_i(o,v);
}

void RKRGUI::cb_eqp_HFg_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(10+12,(int)o->value()+64);
}
void RKRGUI::cb_eqp_HFg(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_HFg_i(o,v);
}

void RKRGUI::cb_eqp_HQ_i(SliderW* o, void*) {
  rkr->efx_EQ2->changepar(10+13,(int)o->value()+64);
}
void RKRGUI::cb_eqp_HQ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_HQ_i(o,v);
}

void RKRGUI::cb_WhaWha_activar_i(Fl_Light_Button* o, void*) {
  rkr->WhaWha_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_WhaWha->cleanup();
}
void RKRGUI::cb_WhaWha_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_activar_i(o,v);
}

void RKRGUI::cb_WhaWha_preset_i(Fl_Choice* o, void*) {
  rkr->WhaWha_Bypass=0;
rkr->efx_WhaWha->setpreset((int) o->value());
WhaWha_WD->value(rkr->efx_WhaWha->getpar(0)-64);
WhaWha_pan->value(rkr->efx_WhaWha->getpar(1)-64);
WhaWha_freq->value(rkr->efx_WhaWha->getpar(2));
WhaWha_rnd->value(rkr->efx_WhaWha->getpar(3));
WhaWha_lfotype->value(rkr->efx_WhaWha->getpar(4));
WhaWha_stdf->value(rkr->efx_WhaWha->getpar(5));
WhaWha_dpth->value(rkr->efx_WhaWha->getpar(6));
WhaWha_ampsns->value(rkr->efx_WhaWha->getpar(7));
WhaWha_ampsnsinv->value(rkr->efx_WhaWha->getpar(8));
WhaWha_smooth->value(rkr->efx_WhaWha->getpar(9));
if((int)WhaWha_activar->value()) rkr->WhaWha_Bypass=1;
}
void RKRGUI::cb_WhaWha_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_WhaWha_preset[] = {
 {gettext("WahWah"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("AutoWah"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Sweep"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("VocalMorph1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("VocalMorph2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_WhaWha_WD_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_WhaWha_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_WD_i(o,v);
}

void RKRGUI::cb_WhaWha_pan_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_WhaWha_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_pan_i(o,v);
}

void RKRGUI::cb_WhaWha_freq_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_freq_i(o,v);
}

void RKRGUI::cb_WhaWha_rnd_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_rnd_i(o,v);
}

void RKRGUI::cb_WhaWha_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_WhaWha->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_WhaWha_lfotype[] = {
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tri"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_WhaWha_stdf_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_stdf_i(o,v);
}

void RKRGUI::cb_WhaWha_dpth_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_dpth_i(o,v);
}

void RKRGUI::cb_WhaWha_ampsns_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_ampsns(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_ampsns_i(o,v);
}

void RKRGUI::cb_WhaWha_ampsnsinv_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_WhaWha_ampsnsinv(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_ampsnsinv_i(o,v);
}

void RKRGUI::cb_WhaWha_smooth_i(SliderW* o, void*) {
  rkr->efx_WhaWha->changepar(9,(int)o->value());
}
void RKRGUI::cb_WhaWha_smooth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_smooth_i(o,v);
}

void RKRGUI::cb_Alienwah_activar_i(Fl_Light_Button* o, void*) {
  rkr->Alienwah_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Alienwah->cleanup();
}
void RKRGUI::cb_Alienwah_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_activar_i(o,v);
}

void RKRGUI::cb_Alienwah_preset_i(Fl_Choice* o, void*) {
  rkr->Alienwah_Bypass=0;
rkr->efx_Alienwah->setpreset((int) o->value());
Alienwah_WD->value(rkr->efx_Alienwah->getpar(0)-64);
Alienwah_pan->value(rkr->efx_Alienwah->getpar(1)-64);
Alienwah_freq->value(rkr->efx_Alienwah->getpar(2));
Alienwah_rnd->value(rkr->efx_Alienwah->getpar(3));
Alienwah_lfotype->value(rkr->efx_Alienwah->getpar(4));
Alienwah_stdf->value(rkr->efx_Alienwah->getpar(5));
Alienwah_dpth->value(rkr->efx_Alienwah->getpar(6));
Alienwah_delay->value(rkr->efx_Alienwah->getpar(8));
Alienwah_fb->value(rkr->efx_Alienwah->getpar(7));
Alienwah_LR->value(rkr->efx_Alienwah->getpar(9)-64);
Alienwah_phase->value(rkr->efx_Alienwah->getpar(10));
if (Alienwah_activar->value()) rkr->Alienwah_Bypass=1;
}
void RKRGUI::cb_Alienwah_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Alienwah_preset[] = {
 {gettext("AlienWah1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("AlienWah2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("AlienWah3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("AlienWah4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Alienwah_WD_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_Alienwah_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_WD_i(o,v);
}

void RKRGUI::cb_Alienwah_pan_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_Alienwah_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_pan_i(o,v);
}

void RKRGUI::cb_Alienwah_freq_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_Alienwah_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_freq_i(o,v);
}

void RKRGUI::cb_Alienwah_rnd_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_Alienwah_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_rnd_i(o,v);
}

void RKRGUI::cb_Alienwah_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Alienwah->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_Alienwah_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Alienwah_lfotype[] = {
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tri"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Alienwah_phase_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(10,(int)o->value());
}
void RKRGUI::cb_Alienwah_phase(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_phase_i(o,v);
}

void RKRGUI::cb_Alienwah_stdf_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_Alienwah_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_stdf_i(o,v);
}

void RKRGUI::cb_Alienwah_dpth_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_Alienwah_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_dpth_i(o,v);
}

void RKRGUI::cb_Alienwah_delay_i(SliderW* o, void*) {
  rkr->Alienwah_Bypass=0;
rkr->efx_Alienwah->changepar(8,(unsigned char)o->value());
if (Alienwah_activar->value()) rkr->Alienwah_Bypass=1;
}
void RKRGUI::cb_Alienwah_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_delay_i(o,v);
}

void RKRGUI::cb_Alienwah_fb_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_Alienwah_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_fb_i(o,v);
}

void RKRGUI::cb_Alienwah_LR_i(SliderW* o, void*) {
  rkr->efx_Alienwah->changepar(9,(int)o->value()+64);
}
void RKRGUI::cb_Alienwah_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_LR_i(o,v);
}

void RKRGUI::cb_Cabinet_activar_i(Fl_Light_Button* o, void*) {
  rkr->Cabinet_Bypass=(int)o->value();
}
void RKRGUI::cb_Cabinet_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Cabinet_activar_i(o,v);
}

void RKRGUI::cb_Cabinet_preset_i(Fl_Choice* o, void*) {
  rkr->Cabinet_setpreset((int) o->value());
}
void RKRGUI::cb_Cabinet_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Cabinet_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Cabinet_preset[] = {
 {gettext("E. Delta Demon"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("E. Legend1058"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("E. Legend1258"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("E. Legend1558"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("C. Ainico Gold"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("C. Vintage 30"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("C. G12T-75"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("C. G12-EVH"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("C. Heritage G12-65"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("J. 6-15"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("J. P15N"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("J. C15N"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("J. Neo12-100"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Cabinet_output_i(SliderW* o, void*) {
  rkr->efx_Cabinet->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_Cabinet_output(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Cabinet_output_i(o,v);
}

void RKRGUI::cb_pan_activar_i(Fl_Light_Button* o, void*) {
  rkr->Pan_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Pan->cleanup();
}
void RKRGUI::cb_pan_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_activar_i(o,v);
}

void RKRGUI::cb_pan_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Pan->setpreset((int) o->value());
pan_WD->value(rkr->efx_Pan->getpar(0)-64);
pan_pan->value(rkr->efx_Pan->getpar(1)-64);
pan_freq->value(rkr->efx_Pan->getpar(2));
pan_rnd->value(rkr->efx_Pan->getpar(3));
pan_lfotype->value(rkr->efx_Pan->getpar(4));
pan_stdf->value(rkr->efx_Pan->getpar(5));
pan_extra->value(rkr->efx_Pan->getpar(6));
pan_autopan->value(rkr->efx_Pan->getpar(7));
pan_extraon->value(rkr->efx_Pan->getpar(8));
}
void RKRGUI::cb_pan_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_pan_preset[] = {
 {gettext("AutoPan"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Extra Stereo"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_pan_WD_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(0,(unsigned char)o->value()+64);
}
void RKRGUI::cb_pan_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_WD_i(o,v);
}

void RKRGUI::cb_pan_autopan_i(Fl_Check_Button* o, void*) {
  rkr->efx_Pan->changepar(7,(unsigned char)o->value());
}
void RKRGUI::cb_pan_autopan(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_autopan_i(o,v);
}

void RKRGUI::cb_pan_pan_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_pan_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_pan_i(o,v);
}

void RKRGUI::cb_pan_freq_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(2,(unsigned char)o->value());
}
void RKRGUI::cb_pan_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_freq_i(o,v);
}

void RKRGUI::cb_pan_rnd_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(3,(unsigned char)o->value());
}
void RKRGUI::cb_pan_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_rnd_i(o,v);
}

void RKRGUI::cb_pan_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Pan->changepar(4,(unsigned char)o->value());
}
void RKRGUI::cb_pan_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_pan_lfotype[] = {
 {gettext("Sine"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Tri"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_pan_stdf_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(5,(unsigned char)o->value());
}
void RKRGUI::cb_pan_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_stdf_i(o,v);
}

void RKRGUI::cb_pan_extraon_i(Fl_Check_Button* o, void*) {
  rkr->efx_Pan->changepar(8,(unsigned char)o->value());
}
void RKRGUI::cb_pan_extraon(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_extraon_i(o,v);
}

void RKRGUI::cb_pan_extra_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(6,(unsigned char)o->value());
}
void RKRGUI::cb_pan_extra(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_extra_i(o,v);
}

void RKRGUI::cb_har_activar_i(Fl_Light_Button* o, void*) {
  rkr->Harmonizer_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Har->cleanup();
}
void RKRGUI::cb_har_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_activar_i(o,v);
}

void RKRGUI::cb_har_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Har->setpreset((int)o->value());
har_WD->value(rkr->efx_Har->getpar(0)-64);

har_pan->value(rkr->efx_Har->getpar(1)-64);
har_gan->value(rkr->efx_Har->getpar(2)-64);
har_int->value(rkr->efx_Har->getpar(3)-12);
har_SELECT->value(rkr->efx_Har->getpar(5));
har_note->value(rkr->efx_Har->getpar(6));
har_type->value(rkr->efx_Har->getpar(7));
har_freq1->value(rkr->efx_Har->getpar(4));
har_gan1->value(rkr->efx_Har->getpar(8)-64);
har_q1->value(rkr->efx_Har->getpar(9)-64);
har_MIDI->value(rkr->efx_Har->getpar(10));
Chord();
}
void RKRGUI::cb_har_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_har_preset[] = {
 {gettext("Plain"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Octavator"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("3m Down"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_har_WD_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_har_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_WD_i(o,v);
}

void RKRGUI::cb_har_int_i(SliderW* o, void*) {
  rkr->Harmonizer_Bypass=0;
rkr->efx_Har->changepar(3,(int)o->value()+12);
if((int)har_activar->value())rkr->Harmonizer_Bypass=1;
}
void RKRGUI::cb_har_int(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_int_i(o,v);
}

void RKRGUI::cb_har_gan_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(2,(int)o->value()+64);
}
void RKRGUI::cb_har_gan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_gan_i(o,v);
}

void RKRGUI::cb_har_pan_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_har_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_pan_i(o,v);
}

void RKRGUI::cb_har_freq1_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(4,(int)o->value());
}
void RKRGUI::cb_har_freq1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_freq1_i(o,v);
}

void RKRGUI::cb_har_gan1_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(8,(int)o->value()+64);
}
void RKRGUI::cb_har_gan1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_gan1_i(o,v);
}

void RKRGUI::cb_har_q1_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(9,(int)o->value()+64);
}
void RKRGUI::cb_har_q1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_q1_i(o,v);
}

void RKRGUI::cb_har_MIDI_i(Fl_Check_Button* o, void*) {
  rkr->efx_Har->changepar(10,(unsigned char)o->value());
rkr->RC->cleanup();
}
void RKRGUI::cb_har_MIDI(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_MIDI_i(o,v);
}

void RKRGUI::cb_har_SELECT_i(Fl_Check_Button* o, void*) {
  rkr->efx_Har->changepar(5,(unsigned char)o->value());
rkr->RC->cleanup();
Chord();
}
void RKRGUI::cb_har_SELECT(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_SELECT_i(o,v);
}

void RKRGUI::cb_har_note_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(6,(int)o->value());
Chord();
}
void RKRGUI::cb_har_note(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_note_i(o,v);
}

void RKRGUI::cb_har_type_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(7,(int)o->value());
Chord();
}
void RKRGUI::cb_har_type(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_type_i(o,v);
}

void RKRGUI::cb_musdelay_activar_i(Fl_Light_Button* o, void*) {
  rkr->MusDelay_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_MusDelay->cleanup();
}
void RKRGUI::cb_musdelay_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_activar_i(o,v);
}

void RKRGUI::cb_musdelay_preset_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->setpreset(o->value());
musdelay_WD->value(rkr->efx_MusDelay->getpar(0)-64);
musdelay_tempo->value(rkr->efx_MusDelay->getpar(10));
musdelay_pan1->value(rkr->efx_MusDelay->getpar(1)-64);
musdelay_pan2->value(rkr->efx_MusDelay->getpar(7)-64);
musdelay_delay1->value(rkr->efx_MusDelay->getpar(2)-1);
musdelay_delay2->value(rkr->efx_MusDelay->getpar(8)-1);
musdelay_delay3->value(rkr->efx_MusDelay->getpar(3)-1);
musdelay_fb1->value(rkr->efx_MusDelay->getpar(5));
musdelay_fb2->value(rkr->efx_MusDelay->getpar(9));
musdelay_LRc->value(rkr->efx_MusDelay->getpar(4)-64);
musdelay_gain1->value(rkr->efx_MusDelay->getpar(11)-64);
musdelay_gain2->value(rkr->efx_MusDelay->getpar(12)-64);
musdelay_damp->value(rkr->efx_MusDelay->getpar(6));
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_preset[] = {
 {gettext("Echo 1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("Echo 2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_WD_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_WD_i(o,v);
}

void RKRGUI::cb_musdelay_LRc_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(4,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_LRc_i(o,v);
}

void RKRGUI::cb_musdelay_tempo_i(SliderW* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(10,(int)o->value());
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_tempo(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_tempo_i(o,v);
}

void RKRGUI::cb_musdelay_pan1_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_pan1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_pan1_i(o,v);
}

void RKRGUI::cb_musdelay_pan2_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(7,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_pan2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_pan2_i(o,v);
}

void RKRGUI::cb_musdelay_delay1_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(2,o->value()+1);
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_delay1(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_delay1_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_delay1[] = {
 {gettext("1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/5"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/6"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_delay2_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(8,o->value()+1);
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_delay2(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_delay2_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_delay2[] = {
 {gettext("1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/5"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/6"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_delay3_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(3,o->value()+1);
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_delay3(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_delay3_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_delay3[] = {
 {gettext("1"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/2"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/3"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/5"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("1/6"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("0"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_gain1_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(11,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_gain1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_gain1_i(o,v);
}

void RKRGUI::cb_musdelay_gain2_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(12,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_gain2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_gain2_i(o,v);
}

void RKRGUI::cb_musdelay_fb1_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(5,(int)o->value());
}
void RKRGUI::cb_musdelay_fb1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_fb1_i(o,v);
}

void RKRGUI::cb_musdelay_fb2_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(9,(int)o->value());
}
void RKRGUI::cb_musdelay_fb2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_fb2_i(o,v);
}

void RKRGUI::cb_musdelay_damp_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(6,(int)o->value());
}
void RKRGUI::cb_musdelay_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_damp_i(o,v);
}

void RKRGUI::cb_gate_activar_i(Fl_Light_Button* o, void*) {
  rkr->Gate_Bypass=(int)o->value();
}
void RKRGUI::cb_gate_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_activar_i(o,v);
}

void RKRGUI::cb_gate_preset_i(Fl_Choice* o, void*) {
  rkr->efx_Gate->Gate_Change_Preset((int) o->value());
gate_ATime->value(rkr->efx_Gate->getpar(3));
gate_RTime->value(rkr->efx_Gate->getpar(4));
gate_range->value(rkr->efx_Gate->getpar(2));
gate_threshold->value(rkr->efx_Gate->getpar(1));
gate_hold->value(rkr->efx_Gate->getpar(7));
gate_HPF->value(rkr->efx_Gate->getpar(6));
gate_LPF->value(rkr->efx_Gate->getpar(5));
}
void RKRGUI::cb_gate_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_gate_preset[] = {
 {gettext("0dB"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("-10dB"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("-20dB"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_gate_ATime_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(3,(int)o->value());
}
void RKRGUI::cb_gate_ATime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_ATime_i(o,v);
}

void RKRGUI::cb_gate_RTime_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(4, (int) o->value());
}
void RKRGUI::cb_gate_RTime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_RTime_i(o,v);
}

void RKRGUI::cb_gate_range_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(2, (int) o->value());
}
void RKRGUI::cb_gate_range(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_range_i(o,v);
}

void RKRGUI::cb_gate_threshold_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(1, (int)o->value());
}
void RKRGUI::cb_gate_threshold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_threshold_i(o,v);
}

void RKRGUI::cb_gate_hold_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(7,(int)o->value());
}
void RKRGUI::cb_gate_hold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_hold_i(o,v);
}

void RKRGUI::cb_gate_LPF_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(5, (int)o->value());
}
void RKRGUI::cb_gate_LPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_LPF_i(o,v);
}

void RKRGUI::cb_gate_HPF_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(6, (int)o->value());
}
void RKRGUI::cb_gate_HPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_HPF_i(o,v);
}

void RKRGUI::cb_tuner_activar_i(Fl_Light_Button* o, void*) {
  rkr->Tuner_Bypass=(int)o->value();
tuner_bar->value(-32);
WNote->copy_label("");
WRfreq->copy_label("");
WNfreq->copy_label("");
}
void RKRGUI::cb_tuner_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_tuner_activar_i(o,v);
}

void RKRGUI::cb_ActivarGeneral_i(Fl_Light_Button* o, void*) {
  rkr->Bypass=o->value();
rkr->val_i_sum=-50;
rkr->val_v_sum=-50;
rkr->old_v_sum=-50;
rkr->old_i_sum=-50;


input_vu->value(-50);
output_vu->value(-50);

if (!o->value())
   {
    if (rkr->Tuner_Bypass)
        {
           tuner_activar->value(0);
           tuner_activar->do_callback();
        } 
    if (rkr->MIDIConverter_Bypass)  
        {
            nidi_activar->value(0);
            nidi_activar->do_callback();
        }
             
  
rkr->cleanup_efx();
  
  
};
}
void RKRGUI::cb_ActivarGeneral(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ActivarGeneral_i(o,v);
}

void RKRGUI::cb_Nivel_Entrada_i(SliderW* o, void*) {
  rkr->Input_Gain=(float)((o->value()+50)/100.0);
rkr->calculavol(1);
}
void RKRGUI::cb_Nivel_Entrada(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Nivel_Entrada_i(o,v);
}

void RKRGUI::cb_Nivel_Salida_i(SliderW* o, void*) {
  rkr->Master_Volume=(float)((o->value()+50)/100.0);
rkr->calculavol(2);
}
void RKRGUI::cb_Nivel_Salida(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Nivel_Salida_i(o,v);
}

void RKRGUI::cb_nidi_activar_i(Fl_Light_Button* o, void*) {
  if ((int)o->value()==0)
{ 
rkr->efx_MIDIConverter->panic();
  Mled->color(fl_darker(FL_RED));
  Mled->redraw();
}


rkr->MIDIConverter_Bypass=(int)o->value();
}
void RKRGUI::cb_nidi_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_nidi_activar_i(o,v);
}

void RKRGUI::cb_Midi_out_Counter_i(Fl_Counter* o, void*) {
  rkr->efx_MIDIConverter->setmidichannel((int)o->value()-1);
}
void RKRGUI::cb_Midi_out_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Midi_out_Counter_i(o,v);
}

void RKRGUI::cb_Trig_Adj_i(SliderW* o, void*) {
  rkr->efx_MIDIConverter->setTriggerAdjust((int)o->value());
}
void RKRGUI::cb_Trig_Adj(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Trig_Adj_i(o,v);
}

void RKRGUI::cb_Vel_Adj_i(SliderW* o, void*) {
  rkr->efx_MIDIConverter->setVelAdjust((int)o->value());
}
void RKRGUI::cb_Vel_Adj(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Vel_Adj_i(o,v);
}

void RKRGUI::cb_MIDI_LABEL_i(Fl_Box*, void*) {
  int ok;
char *filename;

#define EXT ".rkrb"
filename=fl_file_chooser("Save Bank:","(*"EXT")",rkr->Bank_Saved,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT
ok=rkr->savebank(filename);
if (ok)
{
strcpy(rkr->Bank_Saved,filename);
BankWin_Label(filename);
rkr->modified=0;
};
}
void RKRGUI::cb_MIDI_LABEL(Fl_Box* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_MIDI_LABEL_i(o,v);
}

void RKRGUI::cb_S_new_i(Fl_Button*, void*) {
  rkr->New();
Put_Loaded();
}
void RKRGUI::cb_S_new(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_S_new_i(o,v);
}

void RKRGUI::cb_L_preset_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Load Preset:","(*.rkr)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkr");
rkr->loadfile(filename);
Put_Loaded();
}
void RKRGUI::cb_L_preset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_preset_i(o,v);
}

void RKRGUI::cb_S_preset_i(Fl_Button*, void*) {
  char *filename;
#define EXT ".rkr"
filename=fl_file_chooser("Save Preset:","(*"EXT")",rkr->Preset_Name,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT
rkr->savefile(filename);
}
void RKRGUI::cb_S_preset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_S_preset_i(o,v);
}

void RKRGUI::cb_Compare_i(Fl_Light_Button* o, void*) {
  if ((int) o->value())
{
rkr->Preset_to_Bank(0);
rkr->Bank_to_Preset((int)Preset_Counter->value());
Put_Loaded();
}

else
{
 rkr->Bank_to_Preset(0);
 Put_Loaded();
};
}
void RKRGUI::cb_Compare(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Compare_i(o,v);
}

void RKRGUI::cb_B_preset_i(Fl_Button*, void*) {
  BankWindow->show();
put_icon(BankWindow);
if(!made) make_window_banks();
}
void RKRGUI::cb_B_preset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_B_preset_i(o,v);
}

void RKRGUI::cb_WPreset_Name_i(Fl_Input* o, void*) {
  strcpy(rkr->Preset_Name,o->value());
}
void RKRGUI::cb_WPreset_Name(Fl_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WPreset_Name_i(o,v);
}

void RKRGUI::cb_Preset_Counter_i(Fl_Counter* o, void*) {
  rkr->Bank_to_Preset((int) o->value());
Put_Loaded();
}
void RKRGUI::cb_Preset_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Preset_Counter_i(o,v);
}

void RKRGUI::cb_BankWindow_i(Fl_Double_Window* o, void*) {
  o->hide();
save_stat(1);
}
void RKRGUI::cb_BankWindow(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_BankWindow_i(o,v);
}

void RKRGUI::cb_NewB_i(Fl_Menu_*, void*) {
  rkr->New_Bank();
BankWindow->redraw();
}
void RKRGUI::cb_NewB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_NewB_i(o,v);
}

void RKRGUI::cb_Load_Bank_i(Fl_Menu_*, void*) {
  int ok;
char *filename;
is_modified();
filename=fl_file_chooser("Load File:","(*.rkrb)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkrb");
ok=rkr->loadbank(filename);
if(ok) 
{
BankWin_Label(filename);
Put_Loaded_Bank();

};
}
void RKRGUI::cb_Load_Bank(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Bank_i(o,v);
}

void RKRGUI::cb_Save_Bank_i(Fl_Menu_*, void*) {
  MIDI_LABEL->do_callback();
}
void RKRGUI::cb_Save_Bank(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Bank_i(o,v);
}

void RKRGUI::cb_salirB_i(Fl_Menu_*, void*) {
  BankWindow->do_callback();
}
void RKRGUI::cb_salirB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_salirB_i(o,v);
}

void RKRGUI::cb_ContenidoB_i(Fl_Menu_*, void*) {
  show_help();
}
void RKRGUI::cb_ContenidoB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ContenidoB_i(o,v);
}

void RKRGUI::cb_Acerca_deB_i(Fl_Menu_*, void*) {
  int x,y;

x = BankWindow->x()+((BankWindow->w()-420)/2);
y = BankWindow->y()+((BankWindow->h()-230)/2);

AboutWin->position(x,y);
AboutWin->show();
put_icon(AboutWin);
}
void RKRGUI::cb_Acerca_deB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Acerca_deB_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_MenuB[] = {
 {gettext("&File"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("New"), 0,  (Fl_Callback*)RKRGUI::cb_NewB, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Load Bank"), 0,  (Fl_Callback*)RKRGUI::cb_Load_Bank, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Save Bank"), 0,  (Fl_Callback*)RKRGUI::cb_Save_Bank, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {gettext("Close"), 0,  (Fl_Callback*)RKRGUI::cb_salirB, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {gettext("&Help"), 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("Help Contents"), 0,  (Fl_Callback*)RKRGUI::cb_ContenidoB, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {gettext("About..."), 0,  (Fl_Callback*)RKRGUI::cb_Acerca_deB, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* RKRGUI::ArchivoB = RKRGUI::menu_MenuB + 0;
Fl_Menu_Item* RKRGUI::NewB = RKRGUI::menu_MenuB + 1;
Fl_Menu_Item* RKRGUI::Load_Bank = RKRGUI::menu_MenuB + 2;
Fl_Menu_Item* RKRGUI::Save_Bank = RKRGUI::menu_MenuB + 3;
Fl_Menu_Item* RKRGUI::salirB = RKRGUI::menu_MenuB + 4;
Fl_Menu_Item* RKRGUI::AyudaB = RKRGUI::menu_MenuB + 6;
Fl_Menu_Item* RKRGUI::ContenidoB = RKRGUI::menu_MenuB + 7;
Fl_Menu_Item* RKRGUI::Acerca_deB = RKRGUI::menu_MenuB + 8;

void RKRGUI::cb_Order_i(Fl_Double_Window*, void*) {
  save_stat(2);
Order->hide();
}
void RKRGUI::cb_Order(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Order_i(o,v);
}

void RKRGUI::cb_Pon_i(Fl_Button*, void*) {
  int x;



int i = Order_Bro->value();
int j = Avail_Bro->value();


Avail_Bro->insert(j,Order_Bro->text(i));
Order_Bro->insert(i,Avail_Bro->text(j+1));

Avail_Bro->remove(j+1);
Order_Bro->remove(i+1);

Order_Bro->select(1);
Avail_Bro->select(1);

x=rkr->new_order[i-1];
rkr->new_order[i-1]=rkr->availables[j];

rkr->availables[j]=x;
}
void RKRGUI::cb_Pon(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Pon_i(o,v);
}

void RKRGUI::cb_Sube_i(Fl_Button*, void*) {
  int x,x1;

int i = Order_Bro->value();

Order_Bro->move(i,i-1);

i--;

if (i>0) 
{
x=rkr->new_order[i];
x1=rkr->new_order[i-1];

rkr->new_order[i]=x1;
rkr->new_order[i-1]=x;
};
}
void RKRGUI::cb_Sube(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Sube_i(o,v);
}

void RKRGUI::cb_Baja_i(Fl_Button*, void*) {
  int x,x1;

int i = Order_Bro->value();

Order_Bro->move(i,i+1);

i--;

if (i<9)
{
x=rkr->new_order[i];
x1=rkr->new_order[i+1];

rkr->new_order[i]=x1;
rkr->new_order[i+1]=x;
};
}
void RKRGUI::cb_Baja(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Baja_i(o,v);
}

void RKRGUI::cb_ok_order_i(Fl_Button*, void*) {
  int i;
for (i=0;i<14;i++) rkr->efx_order[i]=rkr->new_order[i];
reordena();
Order->do_callback();
}
void RKRGUI::cb_ok_order(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ok_order_i(o,v);
}

void RKRGUI::cb_Cancel_order_i(Fl_Button*, void*) {
  int i;
for (i=0;i<14;i++) rkr->efx_order[i]=rkr->saved_order[i];
Order->do_callback();
}
void RKRGUI::cb_Cancel_order(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Cancel_order_i(o,v);
}

void RKRGUI::cb_Settings_i(Fl_Double_Window*, void*) {
  save_stat(3);
Settings->hide();
}
void RKRGUI::cb_Settings(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Settings_i(o,v);
}

void RKRGUI::cb_Prefs_OK_i(Fl_Button*, void*) {
  Settings->do_callback();
}
void RKRGUI::cb_Prefs_OK(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Prefs_OK_i(o,v);
}

void RKRGUI::cb_B_C_i(Fl_Button*, void*) {
  uchar r,g,b;

Fl::get_color(fore_color,r,g,b);
if (!fl_color_chooser("rakarrak buttons color:",r,g,b)) return;
fore_color=fl_rgb_color(r,g,b);
Buttons_Color_Change(fore_color);
}
void RKRGUI::cb_B_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_B_C_i(o,v);
}

void RKRGUI::cb_L_C_i(Fl_Button*, void*) {
  uchar r,g,b;
Fl::get_color(leds_color,r,g,b);
if (!fl_color_chooser("rakarrack leds color:",r,g,b)) return;
leds_color=fl_rgb_color(r,g,b);
Leds_Color_Change(leds_color);
}
void RKRGUI::cb_L_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_C_i(o,v);
}

void RKRGUI::cb_K_C_i(Fl_Button*, void*) {
  uchar r,g,b;
Fl::get_color(back_color,r,g,b);
if (!fl_color_chooser("rakarrack back color:",r,g,b)) return;
back_color=fl_rgb_color(r,g,b);
Background_Color_Change(back_color);
}
void RKRGUI::cb_K_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_K_C_i(o,v);
}

void RKRGUI::cb_A_C_i(Fl_Button*, void*) {
  uchar r,g,b;
Fl::get_color(label_color,r,g,b);
if (!fl_color_chooser("rakarrack label color:",r,g,b)) return;
label_color=fl_rgb_color(r,g,b);
Label_Color_Change(label_color);
}
void RKRGUI::cb_A_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_A_C_i(o,v);
}

void RKRGUI::cb_scheme_ch_i(Fl_Choice* o, void*) {
  switch ((int)o->value())

{

  case 0:

Fl::scheme("");
Fl::redraw();
break;

  case 1:

Fl::scheme("none");
Fl::redraw();
break;

  case 2:

Fl::scheme("gtk+");
Fl::redraw();
break;

  case 3:

Fl::scheme("plastic");
Fl::redraw();
break;

};
}
void RKRGUI::cb_scheme_ch(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_scheme_ch_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_scheme_ch[] = {
 {gettext("X11"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext("fltk"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext("gtk+"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext("plastic"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Pre_Serve_i(Fl_Check_Button* o, void*) {
  rkr->actuvol=(int) o->value();
}
void RKRGUI::cb_Pre_Serve(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Pre_Serve_i(o,v);
}

void RKRGUI::cb_Har_Qual_i(Fl_Choice* o, void*) {
  int i = (int) o->value();

switch(i)
{
     case 0:
       rkr->HarQual=4;
       break;
     case 1:
       rkr->HarQual=8;
       break;
}


Fl_Widget *w = fl_message_icon();
w->parent()->copy_label(rkr->jackcliname);         
fl_message("This setting will be changed the next time you run rakarrack");
}
void RKRGUI::cb_Har_Qual(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Har_Qual_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Har_Qual[] = {
 {gettext("4"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {gettext("8"), 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_D_A_Connect_i(Fl_Check_Button* o, void*) {
  rkr->aconnect_MI=(int) o->value();

if (rkr->aconnect_MI) BMidiIn->activate();
else BMidiIn->deactivate();
}
void RKRGUI::cb_D_A_Connect(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_D_A_Connect_i(o,v);
}

void RKRGUI::cb_BMidiIn_i(Fl_Browser* o, void*) {
  int valor;
valor = (int) o->value();
strcpy(rkr->MID,o->text(valor));
o->select(valor,1);
rkr->Conecta();
}
void RKRGUI::cb_BMidiIn(Fl_Browser* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_BMidiIn_i(o,v);
}

void RKRGUI::cb_Midi_In_Counter_i(Fl_Counter* o, void*) {
  rkr->MidiCh=(int)o->value()-1;
}
void RKRGUI::cb_Midi_In_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Midi_In_Counter_i(o,v);
}

void RKRGUI::cb_Har_In_Counter_i(Fl_Counter* o, void*) {
  rkr->HarCh=(int)o->value()-1;
}
void RKRGUI::cb_Har_In_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Har_In_Counter_i(o,v);
}

void RKRGUI::cb_D_J_Connect_i(Fl_Check_Button* o, void*) {
  rkr->aconnect_JA=(int) o->value();

if (rkr->aconnect_JA) JackCo->activate();
else JackCo->deactivate();
}
void RKRGUI::cb_D_J_Connect(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_D_J_Connect_i(o,v);
}

void RKRGUI::cb_Username_i(Fl_Input* o, void*) {
  rkr->UserRealName=(char*) o->value();
}
void RKRGUI::cb_Username(Fl_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Username_i(o,v);
}

void RKRGUI::cb_BF_Browser_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Browse:","(*.rkrb)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkrb");
BFiname->value(filename);
strcpy(rkr->BankFilename,filename);
}
void RKRGUI::cb_BF_Browser(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_BF_Browser_i(o,v);
}

void RKRGUI::cb_AboutWin_i(Fl_Double_Window*, void*) {
  AboutWin->hide();
}
void RKRGUI::cb_AboutWin(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_AboutWin_i(o,v);
}

#include <FL/Fl_Pixmap.H>
static const char *idata_icono_rakarrack_128x128[] = {
"128 128 2619 2",
"  \tc None",
". \tc #E8D4FD",
"+ \tc #E7D3FD",
"@ \tc #E5CEFD",
"# \tc #E5CEFC",
"$ \tc #D3A9FD",
"% \tc #E2C7FD",
"& \tc #D5AEFD",
"* \tc #DFC2FC",
"= \tc #DAB9FC",
"- \tc #C893FE",
"; \tc #D1A6FD",
"> \tc #DFC0FD",
", \tc #D0A3FD",
"\' \tc #D6B0FC",
") \tc #DBBBFD",
"! \tc #CD9EFD",
"~ \tc #C995FD",
"{ \tc #C996FD",
"] \tc #CA98FE",
"^ \tc #CB99FE",
"/ \tc #CB9AFD",
"( \tc #CC9CFD",
"_ \tc #D3AAFD",
": \tc #DDBDFD",
"< \tc #CFA2FD",
"[ \tc #C893FD",
"} \tc #C691FD",
"| \tc #DCBBFD",
"1 \tc #CEA0FD",
"2 \tc #D0A4FE",
"3 \tc #D2A7FD",
"4 \tc #D3A8FD",
"5 \tc #D8B3FD",
"6 \tc #DDBEFE",
"7 \tc #D2A8FD",
"8 \tc #CFA1FD",
"9 \tc #CD9DFD",
"0 \tc #CB98FD",
"a \tc #C995FE",
"b \tc #C892FD",
"c \tc #EAD6FD",
"d \tc #E6CFFD",
"e \tc #CA97FD",
"f \tc #D2A6FC",
"g \tc #DBBAFD",
"h \tc #DBB8FC",
"i \tc #D7B1FD",
"j \tc #D8B3FE",
"k \tc #D9B5FE",
"l \tc #DAB7FD",
"m \tc #DAB8FE",
"n \tc #DBB9FD",
"o \tc #E1C6FD",
"p \tc #D9B7FD",
"q \tc #D4ADFD",
"r \tc #D2A9FD",
"s \tc #D1A4FE",
"t \tc #CE9FFD",
"u \tc #CC9BFD",
"v \tc #C996FE",
"w \tc #C892FE",
"x \tc #E5CDFE",
"y \tc #DEC1FE",
"z \tc #C895FD",
"A \tc #DEC0FC",
"B \tc #E0C4FD",
"C \tc #DAB8FD",
"D \tc #D7B0FD",
"E \tc #D4ACFD",
"F \tc #D2A6FD",
"G \tc #D1A7FD",
"H \tc #D7B2FD",
"I \tc #DAB7FE",
"J \tc #D5AFFD",
"K \tc #D8B5FD",
"L \tc #D9B5FD",
"M \tc #D6AFFD",
"N \tc #D2A7FE",
"O \tc #CEA0FE",
"P \tc #C791FD",
"Q \tc #E0C4FE",
"R \tc #D7B2FE",
"S \tc #CB99FD",
"T \tc #CE9EFD",
"U \tc #D9B5FC",
"V \tc #C994FD",
"W \tc #D0A5FD",
"X \tc #C997FD",
"Y \tc #CA98FD",
"Z \tc #D0A4FD",
"` \tc #D5AEFE",
" .\tc #D9B6FD",
"..\tc #D6B0FD",
"+.\tc #D5ADFD",
"@.\tc #D8B4FD",
"#.\tc #D1A6FC",
"$.\tc #CC9BFC",
"%.\tc #CC9EFD",
"&.\tc #CA97FE",
"*.\tc #D4AAFD",
"=.\tc #D9B6FE",
"-.\tc #C994FE",
";.\tc #DFC2FD",
">.\tc #CD9FFD",
",.\tc #CD9DFC",
"\'.\tc #CFA2FC",
").\tc #CA96FD",
"!.\tc #D1A5FD",
"~.\tc #C894FD",
"{.\tc #C783E3",
"].\tc #C970BE",
"^.\tc #D07EC1",
"/.\tc #D6A2EA",
"(.\tc #DAB5FB",
"_.\tc #D1A5FE",
":.\tc #E0C5FD",
"<.\tc #C690FD",
"[.\tc #D2A8FC",
"}.\tc #CFA1FE",
"|.\tc #CFA2FE",
"1.\tc #D0A3FE",
"2.\tc #D1A4FD",
"3.\tc #D4ABFD",
"4.\tc #CA92F2",
"5.\tc #C97BCA",
"6.\tc #BE629B",
"7.\tc #AE487F",
"8.\tc #AF4981",
"9.\tc #BF609B",
"0.\tc #CF87CA",
"a.\tc #D9B4FA",
"b.\tc #CE9FFE",
"c.\tc #DBB8FD",
"d.\tc #CD9DFE",
"e.\tc #D4ADFC",
"f.\tc #D4ADFE",
"g.\tc #D7B3FE",
"h.\tc #D09DF1",
"i.\tc #C772B1",
"j.\tc #C06C9B",
"k.\tc #B86694",
"l.\tc #AC4C81",
"m.\tc #A9457B",
"n.\tc #AA467C",
"o.\tc #B5508A",
"p.\tc #CA7EC2",
"q.\tc #D9B3F9",
"r.\tc #DEBFFD",
"s.\tc #CC9BFE",
"t.\tc #D1A6FE",
"u.\tc #CC9AFD",
"v.\tc #CEA1FE",
"w.\tc #D8B4FE",
"x.\tc #DAB9FE",
"y.\tc #D5A6F0",
"z.\tc #CB7FBA",
"A.\tc #C06F9F",
"B.\tc #C480A8",
"C.\tc #B86595",
"D.\tc #B15489",
"E.\tc #AE4C82",
"F.\tc #AB467D",
"G.\tc #AB447C",
"H.\tc #B9508A",
"I.\tc #D28FDA",
"J.\tc #E5CEFE",
"K.\tc #DDBFFD",
"L.\tc #C792FE",
"M.\tc #DCBCFD",
"N.\tc #DDBDFE",
"O.\tc #DDBEFD",
"P.\tc #DDBFFE",
"Q.\tc #DBB5F6",
"R.\tc #D28DC2",
"S.\tc #C377A5",
"T.\tc #C684AD",
"U.\tc #C683AC",
"V.\tc #B96697",
"W.\tc #B65D91",
"X.\tc #B3568B",
"Y.\tc #B04E84",
"Z.\tc #AE477D",
"`.\tc #B64B82",
" +\tc #D48DCD",
".+\tc #E2C7FC",
"++\tc #E2C8FD",
"@+\tc #CFA3FD",
"#+\tc #CA97FC",
"$+\tc #CC9CFC",
"%+\tc #D6B1FD",
"&+\tc #E0C2FD",
"*+\tc #E0C3FD",
"=+\tc #E1C4FE",
"-+\tc #E1C5FD",
";+\tc #E1C6FE",
">+\tc #DEB0E6",
",+\tc #CE88B4",
"\'+\tc #C786AF",
")+\tc #CE95B8",
"!+\tc #C47EAA",
"~+\tc #BE6D9E",
"{+\tc #BB6698",
"]+\tc #B95F92",
"^+\tc #B6588C",
"/+\tc #B45487",
"(+\tc #C26594",
"_+\tc #DC9FD4",
":+\tc #D5ADFC",
"<+\tc #CFA0FD",
"[+\tc #DBB9FE",
"}+\tc #DCBDFD",
"|+\tc #DFC1FD",
"1+\tc #E3C8FD",
"2+\tc #E4CBFD",
"3+\tc #E5CCFE",
"4+\tc #E5CDFD",
"5+\tc #E2B7E5",
"6+\tc #D494BB",
"7+\tc #D099BC",
"8+\tc #D096BA",
"9+\tc #C781AC",
"0+\tc #C478A6",
"a+\tc #C170A0",
"b+\tc #BE689A",
"c+\tc #BD6496",
"d+\tc #C26D9A",
"e+\tc #D380B2",
"f+\tc #D39CEE",
"g+\tc #DAB7FC",
"h+\tc #E2C8FC",
"i+\tc #E3C9FD",
"j+\tc #CA98FC",
"k+\tc #D9B4FD",
"l+\tc #DDBCFE",
"m+\tc #E4CCFD",
"n+\tc #E7D1FD",
"o+\tc #E8D3FD",
"p+\tc #E9D4FE",
"q+\tc #E9D5FD",
"r+\tc #E7D2FD",
"s+\tc #E7CCF7",
"t+\tc #DEA8CD",
"u+\tc #D7A3C3",
"v+\tc #CF94B9",
"w+\tc #CB89B1",
"x+\tc #C981AC",
"y+\tc #C679A7",
"z+\tc #C474A3",
"A+\tc #C777A4",
"B+\tc #CD77A5",
"C+\tc #D28DD6",
"D+\tc #C792FD",
"E+\tc #CA95FE",
"F+\tc #CD9CFD",
"G+\tc #D4ABFC",
"H+\tc #DEC0FD",
"I+\tc #DCBAFE",
"J+\tc #E2C6FC",
"K+\tc #E3C6F7",
"L+\tc #E3BBE6",
"M+\tc #E4C1E9",
"N+\tc #E7C6EB",
"O+\tc #EAD3F7",
"P+\tc #EBDAFD",
"Q+\tc #EDDBFE",
"R+\tc #ECDBFE",
"S+\tc #EBD9FD",
"T+\tc #EAD7FD",
"U+\tc #E8C7E9",
"V+\tc #DDA9C9",
"W+\tc #D399BC",
"X+\tc #D091B7",
"Y+\tc #CE89B2",
"Z+\tc #CC83AE",
"`+\tc #CC84AD",
" @\tc #CA7AA6",
".@\tc #D37DB6",
"+@\tc #D19DF3",
"@@\tc #D6AEFE",
"#@\tc #D2A1F7",
"$@\tc #CE8FEA",
"%@\tc #CD86E3",
"&@\tc #D18BE2",
"*@\tc #D9A0E7",
"=@\tc #E1BAF0",
"-@\tc #E8C6ED",
";@\tc #EEDAF8",
">@\tc #D6AEFD",
",@\tc #D1A5FC",
"\'@\tc #E1C2F9",
")@\tc #E0B4E1",
"!@\tc #DCA9CE",
"~@\tc #D8A5C5",
"{@\tc #DAAAC8",
"]@\tc #DEB1CD",
"^@\tc #E7C3DF",
"/@\tc #EEDCF9",
"(@\tc #EFE1FE",
"_@\tc #EFE2FD",
":@\tc #EEE0FD",
"<@\tc #EDDFFD",
"[@\tc #EDDEFD",
"}@\tc #EDDDFC",
"|@\tc #E8C4E5",
"1@\tc #DDA6C7",
"2@\tc #D79BBF",
"3@\tc #D695BB",
"4@\tc #D490B6",
"5@\tc #D186AF",
"6@\tc #CA78A5",
"7@\tc #D57DB5",
"8@\tc #D3A2F4",
"9@\tc #C88FF9",
"0@\tc #D297EB",
"a@\tc #DB9FDB",
"b@\tc #D587C3",
"c@\tc #D070AA",
"d@\tc #CE6A9D",
"e@\tc #D2739E",
"f@\tc #D881A4",
"g@\tc #DB85A2",
"h@\tc #D8758D",
"i@\tc #E0768D",
"j@\tc #DF6A80",
"k@\tc #DBBAFC",
"l@\tc #DEBFFC",
"m@\tc #DEBAF6",
"n@\tc #DFB1E4",
"o@\tc #DBA3CC",
"p@\tc #D59FC2",
"q@\tc #D5A4C3",
"r@\tc #D8ABC9",
"s@\tc #DBB2CC",
"t@\tc #DEB7CF",
"u@\tc #E3BED4",
"v@\tc #EDD1E7",
"w@\tc #F2E6FD",
"x@\tc #F2E7FE",
"y@\tc #F1E6FD",
"z@\tc #F0E5FD",
"A@\tc #F0E4FD",
"B@\tc #EDDBFC",
"C@\tc #EAC7E9",
"D@\tc #E7BCDF",
"E@\tc #E6BDE6",
"F@\tc #E3B6E4",
"G@\tc #DD9BCA",
"H@\tc #D17EAB",
"I@\tc #D074A4",
"J@\tc #D882C0",
"K@\tc #D285D6",
"L@\tc #D269B0",
"M@\tc #D15D9F",
"N@\tc #D0629C",
"O@\tc #D487B8",
"P@\tc #D590BE",
"Q@\tc #CF7CAA",
"R@\tc #CC739F",
"S@\tc #C86590",
"T@\tc #C5587F",
"U@\tc #C24B6D",
"V@\tc #BE3F5B",
"W@\tc #BE354D",
"X@\tc #BC2C40",
"Y@\tc #C52837",
"Z@\tc #D52A39",
"`@\tc #C791FE",
" #\tc #D2A8FE",
".#\tc #E1ADDB",
"+#\tc #D496BD",
"@#\tc #D19ABD",
"##\tc #D4A2C3",
"$#\tc #D8ABC8",
"%#\tc #DCB4CD",
"&#\tc #DFBBD1",
"*#\tc #E2C0D4",
"=#\tc #E5C5D7",
"-#\tc #ECCEE0",
";#\tc #F4E7F9",
">#\tc #F4ECFD",
",#\tc #F4EBFD",
"\'#\tc #F4EAFD",
")#\tc #F3E8FD",
"!#\tc #F1E5FE",
"~#\tc #F0E2FD",
"{#\tc #EAD9FD",
"]#\tc #E4CDFD",
"^#\tc #E2C0F4",
"/#\tc #DD95C2",
"(#\tc #D079A6",
"_#\tc #D16FA0",
":#\tc #D66EA4",
"<#\tc #D05E93",
"[#\tc #C95588",
"}#\tc #C85385",
"|#\tc #CA5F90",
"1#\tc #D17EAD",
"2#\tc #D691C0",
"3#\tc #CD70A3",
"4#\tc #C85A8E",
"5#\tc #C44B80",
"6#\tc #C24272",
"7#\tc #C23C64",
"8#\tc #C13656",
"9#\tc #BF2F4A",
"0#\tc #BA283D",
"a#\tc #B12130",
"b#\tc #B11924",
"c#\tc #BA1219",
"d#\tc #C81114",
"e#\tc #D5ADFE",
"f#\tc #DDBDFC",
"g#\tc #DAA3D1",
"h#\tc #D8AAC8",
"i#\tc #DCB2CC",
"j#\tc #E3C2D6",
"k#\tc #E7C8D9",
"l#\tc #E9CDDC",
"m#\tc #EDD3E1",
"n#\tc #F5E6F4",
"o#\tc #F7F0FD",
"p#\tc #F6F0FD",
"q#\tc #F6EFFD",
"r#\tc #F5ECFD",
"s#\tc #ECDDFD",
"t#\tc #E4C6F8",
"u#\tc #E19DCA",
"v#\tc #D57FAB",
"w#\tc #D174A3",
"x#\tc #D06C9C",
"y#\tc #CE6495",
"z#\tc #CC5A8B",
"A#\tc #CA4E81",
"B#\tc #CA4D82",
"C#\tc #CF659A",
"D#\tc #D688BC",
"E#\tc #D16FA6",
"F#\tc #CC588F",
"G#\tc #C94980",
"H#\tc #C84073",
"I#\tc #C93B66",
"J#\tc #C73558",
"K#\tc #BF2F4B",
"L#\tc #9E293F",
"M#\tc #7D2233",
"N#\tc #9E1A26",
"O#\tc #B31219",
"P#\tc #B0090E",
"Q#\tc #B50405",
"R#\tc #C90202",
"S#\tc #C894FE",
"T#\tc #D6B0FE",
"U#\tc #DBB8FE",
"V#\tc #DEB8F3",
"W#\tc #D697C0",
"X#\tc #D199BD",
"Y#\tc #D6A5C4",
"Z#\tc #DBAFCB",
"`#\tc #DFB8D0",
" $\tc #E3C0D5",
".$\tc #E7C8DA",
"+$\tc #EACFDD",
"@$\tc #EDD4E1",
"#$\tc #EED8E5",
"$$\tc #F5E4F0",
"%$\tc #F8F3FC",
"&$\tc #F8F4FD",
"*$\tc #F8F3FD",
"=$\tc #F7F1FD",
"-$\tc #F5EDFD",
";$\tc #F3E9FD",
">$\tc #F1E5FD",
",$\tc #ECD8FB",
"\'$\tc #E9C9EF",
")$\tc #E6AED6",
"!$\tc #DE92B9",
"~$\tc #D783AD",
"{$\tc #D579A5",
"]$\tc #D36C9C",
"^$\tc #D16092",
"/$\tc #CF5488",
"($\tc #CE497E",
"_$\tc #CE457C",
":$\tc #D15890",
"<$\tc #D982B7",
"[$\tc #D675AC",
"}$\tc #D25B93",
"|$\tc #CF4B83",
"1$\tc #CF4175",
"2$\tc #CF3B68",
"3$\tc #C7365A",
"4$\tc #95314D",
"5$\tc #532A41",
"6$\tc #432334",
"7$\tc #991B27",
"8$\tc #BB131B",
"9$\tc #B60A0F",
"0$\tc #AE0203",
"a$\tc #B10000",
"b$\tc #C70000",
"c$\tc #CB98FE",
"d$\tc #D6B1FE",
"e$\tc #DBBAFE",
"f$\tc #DFB5ED",
"g$\tc #D596BD",
"h$\tc #D39DBF",
"i$\tc #D7A8C6",
"j$\tc #DDB2CC",
"k$\tc #E2BCD3",
"l$\tc #E6C5D7",
"m$\tc #EACDDD",
"n$\tc #EDD5E1",
"o$\tc #EFDAE5",
"p$\tc #F1DFE9",
"q$\tc #F8EBF3",
"r$\tc #FAF7FD",
"s$\tc #FAF8FD",
"t$\tc #F9F7FE",
"u$\tc #F2E7FC",
"v$\tc #F0DBF5",
"w$\tc #ECBFDB",
"x$\tc #E6ABCA",
"y$\tc #E19DBF",
"z$\tc #DC90B7",
"A$\tc #DA84AE",
"B$\tc #D978A6",
"C$\tc #D76D9D",
"D$\tc #D66194",
"E$\tc #D5568A",
"F$\tc #D44A80",
"G$\tc #D5447B",
"H$\tc #D6528A",
"I$\tc #DB7CB2",
"J$\tc #DB7BB1",
"K$\tc #D85E96",
"L$\tc #D64D85",
"M$\tc #D54377",
"N$\tc #D63C69",
"O$\tc #C4375C",
"P$\tc #6A314F",
"Q$\tc #392B42",
"R$\tc #422435",
"S$\tc #A61D29",
"T$\tc #C4141C",
"U$\tc #BE0B10",
"V$\tc #B60304",
"W$\tc #AF0000",
"X$\tc #B20000",
"Y$\tc #CC0000",
"Z$\tc #E0C3FE",
"`$\tc #E2C6FD",
" %\tc #DAB6FD",
".%\tc #E1BCF4",
"+%\tc #D99DC4",
"@%\tc #D59FC1",
"#%\tc #DAABC8",
"$%\tc #DFB5CE",
"%%\tc #E3BFD4",
"&%\tc #E8C9D9",
"*%\tc #EBD1DE",
"=%\tc #EFD8E3",
"-%\tc #F2DFE9",
";%\tc #F6E6EE",
">%\tc #FBF4F8",
",%\tc #FBFBFD",
"\'%\tc #FCFBFD",
")%\tc #FBF9FE",
"!%\tc #F9F6FD",
"~%\tc #F7F2FD",
"{%\tc #F5EAFA",
"]%\tc #F2D7EA",
"^%\tc #EDC2D8",
"/%\tc #E7B4CD",
"(%\tc #E4A9C7",
"_%\tc #E29EC0",
":%\tc #E093B8",
"<%\tc #DE87B0",
"[%\tc #DD7BA7",
"}%\tc #DB6F9E",
"|%\tc #DB6396",
"1%\tc #DA578C",
"2%\tc #DB4B81",
"3%\tc #DC457B",
"4%\tc #DC5087",
"5%\tc #DF77AD",
"6%\tc #DE81B5",
"7%\tc #D16199",
"8%\tc #C14F87",
"9%\tc #D04478",
"0%\tc #DE3D6A",
"a%\tc #C1375D",
"b%\tc #603250",
"c%\tc #382C44",
"d%\tc #4E2537",
"e%\tc #B51C2A",
"f%\tc #CD141D",
"g%\tc #C60C11",
"h%\tc #BD0305",
"i%\tc #B50000",
"j%\tc #AE0000",
"k%\tc #B00000",
"l%\tc #CB0000",
"m%\tc #DEBCFB",
"n%\tc #D9B2F9",
"o%\tc #D09FF7",
"p%\tc #CF9DFA",
"q%\tc #D4ACFE",
"r%\tc #DEBFFE",
"s%\tc #E1C5FC",
"t%\tc #E0AED8",
"u%\tc #D9A4C4",
"v%\tc #DBADCA",
"w%\tc #E0B7CF",
"x%\tc #E5C1D5",
"y%\tc #E9CADB",
"z%\tc #EDD3E0",
"A%\tc #F0DBE5",
"B%\tc #F5E4EC",
"C%\tc #FAF3F7",
"D%\tc #FCFCFD",
"E%\tc #FDFCFE",
"F%\tc #FBF7FC",
"G%\tc #F8ECF6",
"H%\tc #F3D9E9",
"I%\tc #EFCBDD",
"J%\tc #ECC0D5",
"K%\tc #E9B5CF",
"L%\tc #E7ABC8",
"M%\tc #E49FC1",
"N%\tc #E294BA",
"O%\tc #E188B1",
"P%\tc #E17CA9",
"Q%\tc #E070A0",
"R%\tc #E06496",
"S%\tc #E0588D",
"T%\tc #E04C82",
"U%\tc #E1457B",
"V%\tc #E04F86",
"W%\tc #E175AB",
"X%\tc #CE81B6",
"Y%\tc #9D629A",
"Z%\tc #885088",
"`%\tc #C14479",
" &\tc #E23D6B",
".&\tc #B5385E",
"+&\tc #553251",
"@&\tc #392C44",
"#&\tc #642537",
"$&\tc #C71D2A",
"%&\tc #D6151E",
"&&\tc #CE0C11",
"*&\tc #C50406",
"=&\tc #BC0000",
"-&\tc #B40000",
";&\tc #AD0000",
">&\tc #B50101",
",&\tc #CB93F4",
"\'&\tc #D090DE",
")&\tc #D597D2",
"!&\tc #CE81C0",
"~&\tc #C45FA4",
"{&\tc #C767BA",
"]&\tc #CE8EE9",
"^&\tc #E1C4FD",
"/&\tc #E4C5F4",
"(&\tc #E2B0D2",
"_&\tc #DFADCA",
":&\tc #E1B7CF",
"<&\tc #E6C1D5",
"[&\tc #EACBDB",
"}&\tc #EED4E0",
"|&\tc #F1DBE5",
"1&\tc #F7E8F0",
"2&\tc #FCF9FD",
"3&\tc #FDFDFD",
"4&\tc #FCF6F9",
"5&\tc #F9EDF4",
"6&\tc #F6DFEC",
"7&\tc #F1D4E4",
"8&\tc #EFCADC",
"9&\tc #ECC1D5",
"0&\tc #EBB8CF",
"a&\tc #E9AFCB",
"b&\tc #E8A6C5",
"c&\tc #E79CBF",
"d&\tc #E690B6",
"e&\tc #E584AE",
"f&\tc #E577A4",
"g&\tc #E46A9A",
"h&\tc #E35C8F",
"i&\tc #E24D82",
"j&\tc #E14E85",
"k&\tc #DF75AB",
"l&\tc #B480B6",
"m&\tc #81629A",
"n&\tc #7B5088",
"o&\tc #E13D6C",
"p&\tc #A0385E",
"q&\tc #4B3251",
"r&\tc #3D2C44",
"s&\tc #842537",
"t&\tc #DA1D2B",
"u&\tc #DF151E",
"v&\tc #D60D12",
"w&\tc #CD0406",
"x&\tc #C30000",
"y&\tc #BA0000",
"z&\tc #C00101",
"A&\tc #C689F2",
"B&\tc #C46AB1",
"C&\tc #C169A4",
"D&\tc #C784B9",
"E&\tc #BF71A8",
"F&\tc #B14D8A",
"G&\tc #B64F94",
"H&\tc #CA70B8",
"I&\tc #D7A6EF",
"J&\tc #DCBAFD",
"K&\tc #DEBEFD",
"L&\tc #E8CEF7",
"M&\tc #E9C4E5",
"N&\tc #E9C1DB",
"O&\tc #ECC8DD",
"P&\tc #F0D4E5",
"Q&\tc #F0D5E3",
"R&\tc #F1DAE4",
"S&\tc #F6E3EB",
"T&\tc #FBF3F8",
"U&\tc #FCF9FB",
"V&\tc #FBF5F8",
"W&\tc #FAEDF3",
"X&\tc #F6E4EE",
"Y&\tc #F4DBE8",
"Z&\tc #F1D1E1",
"`&\tc #EFC8D9",
" *\tc #EDBED3",
".*\tc #EBB6CE",
"+*\tc #EBAECA",
"@*\tc #EBA7C5",
"#*\tc #EBA2C2",
"$*\tc #EB9BBD",
"%*\tc #EA95B9",
"&*\tc #E98DB2",
"**\tc #E87FA8",
"=*\tc #E56896",
"-*\tc #E34F83",
";*\tc #E1457A",
">*\tc #E14F85",
",*\tc #AD80B6",
"\'*\tc #7D6199",
")*\tc #774F87",
"!*\tc #C04479",
"~*\tc #DA3D6B",
"{*\tc #7F385E",
"]*\tc #433250",
"^*\tc #472B44",
"/*\tc #AD2537",
"(*\tc #EA1C2A",
"_*\tc #E7141E",
":*\tc #DF0C11",
"<*\tc #D50306",
"[*\tc #CA0000",
"}*\tc #C00000",
"|*\tc #B70000",
"1*\tc #BF599D",
"2*\tc #B4528A",
"3*\tc #B7629B",
"4*\tc #C481B6",
"5*\tc #C074AC",
"6*\tc #B35294",
"7*\tc #B6579D",
"8*\tc #C674B4",
"9*\tc #DDA2DA",
"0*\tc #E3CAFD",
"a*\tc #EAD8FD",
"b*\tc #EDDCFA",
"c*\tc #F0E1FA",
"d*\tc #F3E7FB",
"e*\tc #F4E2F1",
"f*\tc #F3DBE6",
"g*\tc #F3DDE6",
"h*\tc #F7E4ED",
"i*\tc #FAEFF5",
"j*\tc #F9ECF2",
"k*\tc #F8E9F1",
"l*\tc #F7E6EF",
"m*\tc #F5DFEB",
"n*\tc #F3D7E5",
"o*\tc #F2D0DF",
"p*\tc #F0C7D9",
"q*\tc #EEBCD3",
"r*\tc #EDB1CD",
"s*\tc #EA9CBE",
"t*\tc #E992B7",
"u*\tc #E887AF",
"v*\tc #E67CA7",
"w*\tc #E472A0",
"x*\tc #E36898",
"y*\tc #E15A8D",
"z*\tc #E04B7F",
"A*\tc #E0447A",
"B*\tc #E05188",
"C*\tc #DF7CB1",
"D*\tc #AC7DB2",
"E*\tc #785D94",
"F*\tc #714D84",
"G*\tc #BC4276",
"H*\tc #C53C68",
"I*\tc #5C365B",
"J*\tc #40314E",
"K*\tc #632B42",
"L*\tc #DB2436",
"M*\tc #F51D29",
"N*\tc #EF141D",
"O*\tc #E60B10",
"P*\tc #DC0304",
"Q*\tc #D00000",
"R*\tc #C60000",
"S*\tc #B30000",
"T*\tc #AC0000",
"U*\tc #C50202",
"V*\tc #C2528F",
"W*\tc #AF437A",
"X*\tc #AF4E86",
"Y*\tc #B76098",
"Z*\tc #C47EB4",
"`*\tc #C47CB5",
" =\tc #B85CA0",
".=\tc #BD63A8",
"+=\tc #CC84BD",
"@=\tc #E2B0DC",
"#=\tc #E6CDFB",
"$=\tc #E6D0FD",
"%=\tc #E9D6FD",
"&=\tc #ECDCFD",
"*=\tc #F2E7FD",
"==\tc #F4E9FB",
"-=\tc #F5DEEB",
";=\tc #F3D9E3",
">=\tc #F4DCE7",
",=\tc #F6E0EB",
"\'=\tc #F6E1EC",
")=\tc #F5DDE9",
"!=\tc #F5D9E7",
"~=\tc #F3D1E1",
"{=\tc #F2CBDB",
"]=\tc #F2C8D9",
"^=\tc #F1C0D5",
"/=\tc #EFB2CC",
"(=\tc #EDA5C4",
"_=\tc #EB9ABD",
":=\tc #E98FB5",
"<=\tc #E583AD",
"[=\tc #DC77A4",
"}=\tc #CC6B9B",
"|=\tc #BB5F92",
"1=\tc #B25387",
"2=\tc #B8487D",
"3=\tc #C9447A",
"4=\tc #DC568D",
"5=\tc #AA77AD",
"6=\tc #775A92",
"7=\tc #704B82",
"8=\tc #B04174",
"9=\tc #993B66",
"0=\tc #4C3559",
"a=\tc #47304D",
"b=\tc #992A3F",
"c=\tc #EF2333",
"d=\tc #F71B26",
"e=\tc #F61219",
"f=\tc #EE0A0D",
"g=\tc #E20202",
"h=\tc #D60000",
"i=\tc #B60000",
"j=\tc #B70303",
"k=\tc #C96FB6",
"l=\tc #B5406F",
"m=\tc #AC4176",
"n=\tc #B04C83",
"o=\tc #B75C94",
"p=\tc #C378AE",
"q=\tc #C985BD",
"r=\tc #BC62A7",
"s=\tc #BF66AA",
"t=\tc #CD87BE",
"u=\tc #E5B4DD",
"v=\tc #E7D1FC",
"w=\tc #E1C7FE",
"x=\tc #EEDFFD",
"y=\tc #F1E3FC",
"z=\tc #F2DAEE",
"A=\tc #F1D0E0",
"B=\tc #F1D2DF",
"C=\tc #F2D6E2",
"D=\tc #F4D9E5",
"E=\tc #F4D8E4",
"F=\tc #F4D5E3",
"G=\tc #F3D1E0",
"H=\tc #F3CBDC",
"I=\tc #F2C4D7",
"J=\tc #F1BDD3",
"K=\tc #F0B9D1",
"L=\tc #EFB4CE",
"M=\tc #EDA6C5",
"N=\tc #EA97BB",
"O=\tc #E08BB3",
"P=\tc #C67FAB",
"Q=\tc #A674A3",
"R=\tc #8E699A",
"S=\tc #7E5D90",
"T=\tc #725186",
"U=\tc #6C477C",
"V=\tc #88467C",
"W=\tc #CC5D94",
"X=\tc #DE85B8",
"Y=\tc #A970A6",
"Z=\tc #75578F",
"`=\tc #6B497F",
" -\tc #8D4072",
".-\tc #693B64",
"+-\tc #493557",
"@-\tc #6A2F4A",
"#-\tc #CF293E",
"$-\tc #F42232",
"%-\tc #F81B26",
"&-\tc #F81219",
"*-\tc #F2090C",
"=-\tc #E70102",
"--\tc #DB0000",
";-\tc #C40000",
">-\tc #D10404",
",-\tc #C3436E",
"\'-\tc #AC3C66",
")-\tc #AD4174",
"!-\tc #B14B82",
"~-\tc #B85A91",
"{-\tc #C273A9",
"]-\tc #CC8DC0",
"^-\tc #C26DAB",
"/-\tc #C167A8",
"(-\tc #CC7DB8",
"_-\tc #E0A5D8",
":-\tc #E3C8FC",
"<-\tc #E0C4FC",
"[-\tc #E6D0FE",
"}-\tc #EAD4FB",
"|-\tc #EDD2F2",
"1-\tc #EEC9E2",
"2-\tc #EEC2D7",
"3-\tc #EDC5D8",
"4-\tc #EFCBDB",
"5-\tc #F1CEDC",
"6-\tc #F3D1DE",
"7-\tc #F3D1DF",
"8-\tc #F3D0DE",
"9-\tc #F3CDDD",
"0-\tc #F3CADA",
"a-\tc #F2BED4",
"b-\tc #F1B7CF",
"c-\tc #EFAECA",
"d-\tc #EB9CBE",
"e-\tc #DC91B6",
"f-\tc #B986B0",
"g-\tc #997BA8",
"h-\tc #8870A0",
"i-\tc #7E6597",
"j-\tc #735A8E",
"k-\tc #694F84",
"l-\tc #64457B",
"m-\tc #924980",
"n-\tc #D4679D",
"o-\tc #DF86BA",
"p-\tc #A869A1",
"q-\tc #71548B",
"r-\tc #63467C",
"s-\tc #613E6F",
"t-\tc #503961",
"u-\tc #543455",
"v-\tc #A62E48",
"w-\tc #E9283C",
"x-\tc #F52130",
"y-\tc #F81923",
"z-\tc #FA1117",
"A-\tc #F7080A",
"B-\tc #EC0101",
"C-\tc #E00000",
"D-\tc #D30000",
"E-\tc #C80000",
"F-\tc #BD0000",
"G-\tc #C20202",
"H-\tc #BC4267",
"I-\tc #AE4168",
"J-\tc #B14977",
"K-\tc #B75687",
"L-\tc #BE6798",
"M-\tc #C77CAC",
"N-\tc #D196C3",
"O-\tc #CA80B4",
"P-\tc #C162A2",
"Q-\tc #C765A8",
"R-\tc #D88AD0",
"S-\tc #D9B4FC",
"T-\tc #E5C8F7",
"U-\tc #E8B6DB",
"V-\tc #E7AFCE",
"W-\tc #E7B1CC",
"X-\tc #E9B7D0",
"Y-\tc #ECBED4",
"Z-\tc #EEC3D6",
"`-\tc #F0C5D7",
" ;\tc #F1C7D9",
".;\tc #F2C8DA",
"+;\tc #F2C7D9",
"@;\tc #F2C5D8",
"#;\tc #F2C1D6",
"$;\tc #F2BCD2",
"%;\tc #EFAFCB",
"&;\tc #EEA7C6",
"*;\tc #EC9EC0",
"=;\tc #E294B9",
"-;\tc #BA8AB2",
";;\tc #9980AB",
">;\tc #8D76A4",
",;\tc #836B9C",
"\';\tc #7A6094",
");\tc #70558A",
"!;\tc #664B80",
"~;\tc #78447B",
"{;\tc #C34E86",
"];\tc #E074AA",
"^;\tc #E083B8",
"/;\tc #AC649C",
"(;\tc #6F5189",
"_;\tc #5F457B",
":;\tc #563E6D",
"<;\tc #4C385F",
"[;\tc #523352",
"};\tc #832C45",
"|;\tc #B12639",
"1;\tc #DE1F2C",
"2;\tc #F51720",
"3;\tc #FA0F15",
"4;\tc #F90709",
"5;\tc #F00000",
"6;\tc #E30000",
"7;\tc #D70000",
"8;\tc #BF0000",
"9;\tc #B80303",
"0;\tc #CB5F7E",
"a;\tc #BE5F7E",
"b;\tc #C16A8D",
"c;\tc #C36E97",
"d;\tc #C36F9C",
"e;\tc #C573A4",
"f;\tc #CC85B7",
"g;\tc #CB81B6",
"h;\tc #C15A9A",
"i;\tc #CA569F",
"j;\tc #D086DF",
"k;\tc #D0A2FD",
"l;\tc #D3A9FE",
"m;\tc #DCB8FA",
"n;\tc #E3ADDE",
"o;\tc #E5A2C9",
"p;\tc #E29CBF",
"q;\tc #E2A0C1",
"r;\tc #E6A7C6",
"s;\tc #E8AFCA",
"t;\tc #EBB6CF",
"u;\tc #EDB9D1",
"v;\tc #EFBBD2",
"w;\tc #F1BED4",
"x;\tc #F1BED3",
"y;\tc #F1BBD2",
"z;\tc #F1B8D0",
"A;\tc #F0B3CD",
"B;\tc #EFAEC9",
"C;\tc #EC9FC0",
"D;\tc #E897BB",
"E;\tc #CA8DB5",
"F;\tc #9F83AE",
"G;\tc #8F79A6",
"H;\tc #886F9F",
"I;\tc #8E6597",
"J;\tc #9C5B8F",
"K;\tc #975186",
"L;\tc #85467D",
"M;\tc #B2467D",
"N;\tc #DC5A92",
"O;\tc #E282B6",
"P;\tc #E079AF",
"Q;\tc #AF5D95",
"R;\tc #6D4E85",
"S;\tc #5D4378",
"T;\tc #533D6B",
"U;\tc #4B385D",
"V;\tc #423251",
"W;\tc #3B2C44",
"X;\tc #3E2538",
"Y;\tc #611D2A",
"Z;\tc #B7151D",
"`;\tc #F20D11",
" >\tc #FA0405",
".>\tc #F30000",
"+>\tc #E60000",
"@>\tc #D90000",
"#>\tc #CD0000",
"$>\tc #C10000",
"%>\tc #B10303",
"&>\tc #D92020",
"*>\tc #A60000",
"=>\tc #B00202",
"->\tc #E5B6D7",
";>\tc #D57C99",
">>\tc #C16184",
",>\tc #BC5583",
"\'>\tc #BC5489",
")>\tc #C05C93",
"!>\tc #C770A7",
"~>\tc #CF88BC",
"{>\tc #C867A0",
"]>\tc #CE67B2",
"^>\tc #C88DF8",
"/>\tc #CE9FFB",
"(>\tc #D4A3F4",
"_>\tc #DA9EE1",
":>\tc #E097CC",
"<>\tc #DF8EB7",
"[>\tc #DD8BB3",
"}>\tc #DF90B7",
"|>\tc #E297BC",
"1>\tc #E59EC1",
"2>\tc #E8A8C6",
"3>\tc #EDAFCA",
"4>\tc #EEB1CC",
"5>\tc #F0B4CE",
"6>\tc #F0B4CD",
"7>\tc #EFAFCA",
"8>\tc #EEAAC7",
"9>\tc #EDA4C4",
"0>\tc #EB99BC",
"a>\tc #E08FB6",
"b>\tc #AF86AF",
"c>\tc #937DA9",
"d>\tc #8C73A2",
"e>\tc #9E699A",
"f>\tc #C85F91",
"g>\tc #D95589",
"h>\tc #D84B80",
"i>\tc #D0447B",
"j>\tc #DA4C83",
"k>\tc #E16BA2",
"l>\tc #E386BA",
"m>\tc #E06DA4",
"n>\tc #B5568E",
"o>\tc #6C4980",
"p>\tc #594173",
"q>\tc #563B67",
"r>\tc #64365A",
"s>\tc #4E304E",
"t>\tc #372B41",
"u>\tc #2C2435",
"v>\tc #251C29",
"w>\tc #42141C",
"x>\tc #B10C10",
"y>\tc #F50405",
"z>\tc #F40000",
"A>\tc #E70000",
"B>\tc #DA0000",
"C>\tc #CE0000",
"D>\tc #C20000",
"E>\tc #B80000",
"F>\tc #AD0101",
"G>\tc #D21B1B",
"H>\tc #9B0202",
"I>\tc #940505",
"J>\tc #9B0A0A",
"K>\tc #AD1313",
"L>\tc #CA2B2B",
"M>\tc #D78BC8",
"N>\tc #CD4E7B",
"O>\tc #C54A7F",
"P>\tc #C95691",
"Q>\tc #CA609D",
"R>\tc #CB68A2",
"S>\tc #CF83B8",
"T>\tc #D17DB3",
"U>\tc #D37DC7",
"V>\tc #CB8BF1",
"W>\tc #CE88E5",
"X>\tc #D578C1",
"Y>\tc #D876B1",
"Z>\tc #DC7AAB",
"`>\tc #DB80AB",
" ,\tc #DA7DA9",
".,\tc #DC7FAB",
"+,\tc #DF87B0",
"@,\tc #E28EB5",
"#,\tc #E696BB",
"$,\tc #E9A4C4",
"%,\tc #EBA2C3",
"&,\tc #ECA4C4",
"*,\tc #EEABC8",
"=,\tc #EFAAC7",
"-,\tc #ECA8C7",
";,\tc #E6A5C4",
">,\tc #EC9FC1",
",,\tc #EB9BBE",
"\',\tc #EA94B9",
"),\tc #D389B2",
"!,\tc #9D7EAA",
"~,\tc #8D75A3",
"{,\tc #926C9D",
"],\tc #CA6295",
"^,\tc #E0598D",
"/,\tc #E14E83",
"(,\tc #E1467B",
"_,\tc #E1457C",
":,\tc #E0588F",
"<,\tc #E37FB4",
"[,\tc #E27EB3",
"},\tc #E0629A",
"|,\tc #BD5088",
"1,\tc #6B457B",
"2,\tc #563F6F",
"3,\tc #5A3A62",
"4,\tc #AA3455",
"5,\tc #A52F49",
"6,\tc #56283D",
"7,\tc #2C2131",
"8,\tc #1F1A26",
"9,\tc #1B1119",
"0,\tc #69090D",
"a,\tc #E70203",
"b,\tc #B90000",
"c,\tc #AA0000",
"d,\tc #C71010",
"e,\tc #A70000",
"f,\tc #950101",
"g,\tc #960909",
"h,\tc #9C1313",
"i,\tc #A42222",
"j,\tc #AC3535",
"k,\tc #B84848",
"l,\tc #DF6E6F",
"m,\tc #CE7BD2",
"n,\tc #CD84E1",
"o,\tc #CC8AEA",
"p,\tc #D47DC9",
"q,\tc #D476AE",
"r,\tc #D486BB",
"s,\tc #D573AE",
"t,\tc #D362A0",
"u,\tc #D5538C",
"v,\tc #D3568B",
"w,\tc #D66998",
"x,\tc #D974A0",
"y,\tc #D86D9D",
"z,\tc #DB6E9E",
"A,\tc #DE76A4",
"B,\tc #E17DAA",
"C,\tc #E485AF",
"D,\tc #E895B9",
"E,\tc #EB9DBF",
"F,\tc #EA96BB",
"G,\tc #EB99BD",
"H,\tc #EC9CBF",
"I,\tc #ECA1C2",
"J,\tc #E99EC0",
"K,\tc #D69DBF",
"L,\tc #BF9CBE",
"M,\tc #C59ABD",
"N,\tc #E596BA",
"O,\tc #E990B7",
"P,\tc #E98BB3",
"Q,\tc #E684AE",
"R,\tc #957BA8",
"S,\tc #876E9E",
"T,\tc #A26496",
"U,\tc #DC5B8F",
"V,\tc #E15287",
"W,\tc #E14A7F",
"X,\tc #E1447A",
"Y,\tc #E14E84",
"Z,\tc #E16EA4",
"`,\tc #E389BD",
" \'\tc #E16DA4",
".\'\tc #E05991",
"+\'\tc #C84B82",
"@\'\tc #6C4176",
"#\'\tc #533D69",
"$\'\tc #50385D",
"%\'\tc #AB3251",
"&\'\tc #E62C45",
"*\'\tc #B02639",
"=\'\tc #421F2D",
"-\'\tc #1D1821",
";\'\tc #2D0F15",
">\'\tc #99070A",
",\'\tc #F20101",
"\'\'\tc #A90000",
")\'\tc #C30303",
"!\'\tc #A80000",
"~\'\tc #950000",
"{\'\tc #960606",
"]\'\tc #9F1717",
"^\'\tc #A82929",
"/\'\tc #AE3535",
"(\'\tc #AF3737",
"_\'\tc #AD2D2D",
":\'\tc #C52829",
"<\'\tc #CB97FA",
"[\'\tc #D782C7",
"}\'\tc #D680B6",
"|\'\tc #D47FB4",
"1\'\tc #CF5E95",
"2\'\tc #D05588",
"3\'\tc #D76894",
"4\'\tc #DA6B97",
"5\'\tc #D85F90",
"6\'\tc #D95E91",
"7\'\tc #DD6597",
"8\'\tc #E06C9D",
"9\'\tc #E374A3",
"0\'\tc #E680AB",
"a\'\tc #EB98BA",
"b\'\tc #E98DB4",
"c\'\tc #E98AB3",
"d\'\tc #E98EB5",
"e\'\tc #EA91B7",
"f\'\tc #DA92B9",
"g\'\tc #B292B8",
"h\'\tc #A490B6",
"i\'\tc #A890B6",
"j\'\tc #CF8CB4",
"k\'\tc #E685AF",
"l\'\tc #E780AC",
"m\'\tc #E379A7",
"n\'\tc #B874A2",
"o\'\tc #8D73A1",
"p\'\tc #876D9C",
"q\'\tc #AF5E90",
"r\'\tc #DF5388",
"s\'\tc #E14B80",
"t\'\tc #E14980",
"u\'\tc #E16097",
"v\'\tc #E283B7",
"w\'\tc #E178AE",
"x\'\tc #E05F96",
"y\'\tc #E05087",
"z\'\tc #CF467B",
"A\'\tc #753F70",
"B\'\tc #4E3A63",
"C\'\tc #483557",
"D\'\tc #87304C",
"E\'\tc #EA2A40",
"F\'\tc #EA2334",
"G\'\tc #871C29",
"H\'\tc #41141D",
"I\'\tc #A50C11",
"J\'\tc #F20405",
"K\'\tc #FB0000",
"L\'\tc #F10000",
"M\'\tc #E40000",
"N\'\tc #C11616",
"O\'\tc #960000",
"P\'\tc #990505",
"Q\'\tc #A01212",
"R\'\tc #A41818",
"S\'\tc #A51616",
"T\'\tc #A41111",
"U\'\tc #A40C0C",
"V\'\tc #AF0808",
"W\'\tc #D41718",
"X\'\tc #D17AD0",
"Y\'\tc #D566A2",
"Z\'\tc #D36DA4",
"`\'\tc #D887BA",
" )\tc #DA85B5",
".)\tc #DD80AA",
"+)\tc #DC6B97",
"@)\tc #D95184",
"#)\tc #DA4D82",
"$)\tc #DD5489",
"%)\tc #E05C8F",
"&)\tc #E26395",
"*)\tc #E46C9C",
"=)\tc #E885AE",
"-)\tc #E98CB3",
";)\tc #E77DA9",
">)\tc #E77FAA",
",)\tc #E782AD",
"\')\tc #E886B0",
"))\tc #E88DB4",
"!)\tc #CC87B0",
"~)\tc #A185AF",
"{)\tc #9984AE",
"])\tc #9983AE",
"^)\tc #B183AE",
"/)\tc #DA7BA8",
"()\tc #E675A3",
"_)\tc #E26F9F",
":)\tc #B4699A",
"<)\tc #826597",
"[)\tc #836797",
"})\tc #AE5E8F",
"|)\tc #DE4D82",
"1)\tc #E1487E",
"2)\tc #E15990",
"3)\tc #E279AF",
"4)\tc #E0689F",
"5)\tc #E0558C",
"6)\tc #E1497F",
"7)\tc #D74072",
"8)\tc #853C68",
"9)\tc #4B375D",
"0)\tc #423352",
"a)\tc #6A2D46",
"b)\tc #DF273A",
"c)\tc #F4212F",
"d)\tc #DA1924",
"e)\tc #C81118",
"f)\tc #F3090D",
"g)\tc #FC0202",
"h)\tc #F80000",
"i)\tc #EE0000",
"j)\tc #E20000",
"k)\tc #AC0101",
"l)\tc #D50707",
"m)\tc #B30303",
"n)\tc #970000",
"o)\tc #9B0000",
"p)\tc #9E0404",
"q)\tc #A00505",
"r)\tc #A30404",
"s)\tc #A40303",
"t)\tc #A50101",
"u)\tc #A80101",
"v)\tc #C60909",
"w)\tc #D57BC9",
"x)\tc #D762A2",
"y)\tc #D44E88",
"z)\tc #CE5188",
"A)\tc #D36399",
"B)\tc #DC86B5",
"C)\tc #E6ACD0",
"D)\tc #E18DB9",
"E)\tc #DB5B8F",
"F)\tc #DC477D",
"G)\tc #DF467C",
"H)\tc #E04B81",
"I)\tc #E25387",
"J)\tc #E25A8E",
"K)\tc #E56A99",
"L)\tc #E988AE",
"M)\tc #E676A3",
"N)\tc #E570A0",
"O)\tc #E573A2",
"P)\tc #E676A4",
"Q)\tc #E77CA8",
"R)\tc #BC7BA8",
"S)\tc #937AA7",
"T)\tc #9078A6",
"U)\tc #8E77A5",
"V)\tc #997CA7",
"W)\tc #C172A1",
"X)\tc #E16A9C",
"Y)\tc #E26597",
"Z)\tc #7B598D",
"`)\tc #73598C",
" !\tc #9F5F8F",
".!\tc #DB5285",
"+!\tc #E1568D",
"@!\tc #E275AB",
"#!\tc #E170A6",
"$!\tc #DD5B93",
"%!\tc #DC4D85",
"&!\tc #DF4378",
"*!\tc #DE3D6C",
"=!\tc #973960",
"-!\tc #4A3455",
";!\tc #412F4B",
">!\tc #712A40",
",!\tc #DC2435",
"\'!\tc #F71D2A",
")!\tc #F8161E",
"!!\tc #F90E13",
"~!\tc #FC0608",
"{!\tc #FB0001",
"]!\tc #F50000",
"^!\tc #EA0000",
"/!\tc #DE0000",
"(!\tc #B60707",
"_!\tc #BA0707",
":!\tc #9A0000",
"<!\tc #9D0000",
"[!\tc #A00000",
"}!\tc #A20000",
"|!\tc #A50000",
"1!\tc #B40101",
"2!\tc #D40404",
"3!\tc #DE5A8A",
"4!\tc #D8466F",
"5!\tc #D23F6C",
"6!\tc #CF4275",
"7!\tc #D35185",
"8!\tc #DB6D9C",
"9!\tc #E28BB3",
"0!\tc #E390BC",
"a!\tc #E290C0",
"b!\tc #E06EA5",
"c!\tc #E0528A",
"d!\tc #E1477D",
"e!\tc #E24A7F",
"f!\tc #E35387",
"g!\tc #E76F9C",
"h!\tc #E779A3",
"i!\tc #E46395",
"j!\tc #E46496",
"k!\tc #E4689A",
"l!\tc #E46B9C",
"m!\tc #E674A2",
"n!\tc #E580AA",
"o!\tc #AE6F9F",
"p!\tc #906C9D",
"q!\tc #8D6B9C",
"r!\tc #8971A0",
"s!\tc #A06D9D",
"t!\tc #D46093",
"u!\tc #C7558A",
"v!\tc #7A4E84",
"w!\tc #654A7F",
"x!\tc #7D5284",
"y!\tc #CF6593",
"z!\tc #E26295",
"A!\tc #E275AA",
"B!\tc #DB5F96",
"C!\tc #B65189",
"D!\tc #A1477D",
"E!\tc #AF4072",
"F!\tc #D33B65",
"G!\tc #AA3659",
"H!\tc #52314E",
"I!\tc #682C44",
"J!\tc #BE2538",
"K!\tc #F0202E",
"L!\tc #F81A24",
"M!\tc #F91219",
"N!\tc #FB0B0E",
"O!\tc #FC0304",
"P!\tc #F90000",
"Q!\tc #C50000",
"R!\tc #BB0000",
"S!\tc #AB0000",
"T!\tc #AF0101",
"U!\tc #9E0000",
"V!\tc #A10000",
"W!\tc #A40000",
"X!\tc #CE1010",
"Y!\tc #E34766",
"Z!\tc #D83552",
"`!\tc #D23556",
" ~\tc #D43B62",
".~\tc #D74772",
"+~\tc #DD618C",
"@~\tc #E1749E",
"#~\tc #E16D9D",
"$~\tc #E0699E",
"%~\tc #E179AF",
"&~\tc #E388BC",
"*~\tc #E271A7",
"=~\tc #E1578E",
"-~\tc #E25184",
";~\tc #E46C97",
">~\tc #E25E8E",
",~\tc #E2568A",
"\'~\tc #E2598D",
")~\tc #E35C90",
"!~\tc #E36092",
"~~\tc #E66D9C",
"{~\tc #DF76A2",
"]~\tc #9D6396",
"^~\tc #7C6294",
"/~\tc #986093",
"(~\tc #AA5E92",
"_~\tc #7F6495",
":~\tc #886B99",
"<~\tc #B6588B",
"[~\tc #DF5085",
"}~\tc #D74A80",
"|~\tc #8E467C",
"1~\tc #61447B",
"2~\tc #694C82",
"3~\tc #A96C9D",
"4~\tc #E195BE",
"5~\tc #E494C3",
"6~\tc #E278AD",
"7~\tc #DF6198",
"8~\tc #C1528A",
"9~\tc #78487F",
"0~\tc #5E4174",
"a~\tc #623C6A",
"b~\tc #B6385E",
"c~\tc #CA3453",
"d~\tc #952D48",
"e~\tc #C5283D",
"f~\tc #F02232",
"g~\tc #F71B27",
"h~\tc #F9151C",
"i~\tc #FA0E12",
"j~\tc #FB0608",
"k~\tc #FB0101",
"l~\tc #A30000",
"m~\tc #E73D4E",
"n~\tc #DF2A3B",
"o~\tc #D6273B",
"p~\tc #D62C43",
"q~\tc #D9314E",
"r~\tc #DC3D5E",
"s~\tc #E15477",
"t~\tc #E46288",
"u~\tc #E35786",
"v~\tc #E15085",
"w~\tc #E16299",
"x~\tc #E277AD",
"y~\tc #E285BA",
"z~\tc #DA5F96",
"A~\tc #C74E85",
"B~\tc #B75487",
"C~\tc #AC5889",
"D~\tc #AE4A7F",
"E~\tc #C94A80",
"F~\tc #DF4E83",
"G~\tc #E25186",
"H~\tc #E35489",
"I~\tc #E66997",
"J~\tc #D96E9B",
"K~\tc #90588C",
"L~\tc #71558A",
"M~\tc #995489",
"N~\tc #C55388",
"O~\tc #845589",
"P~\tc #7E6694",
"Q~\tc #905487",
"R~\tc #D2477C",
"S~\tc #DF457B",
"T~\tc #B8467D",
"U~\tc #784F86",
"V~\tc #9E81B4",
"W~\tc #C5A0CA",
"X~\tc #D696BF",
"Y~\tc #D170A1",
"Z~\tc #BA568C",
"`~\tc #814980",
" {\tc #5D4276",
".{\tc #553E6C",
"+{\tc #723A61",
"@{\tc #D33556",
"#{\tc #E9304C",
"${\tc #E72B42",
"%{\tc #F12436",
"&{\tc #F61E2B",
"*{\tc #F81821",
"={\tc #FA1016",
"-{\tc #FB090B",
";{\tc #FB0202",
">{\tc #F60000",
",{\tc #ED0000",
"\'{\tc #BE0000",
"){\tc #C40F0F",
"!{\tc #CF0606",
"~{\tc #BB0303",
"{{\tc #BF0B0B",
"]{\tc #B90202",
"^{\tc #B60101",
"/{\tc #E71B1B",
"({\tc #EF2A2F",
"_{\tc #E41A21",
":{\tc #D91720",
"<{\tc #D81B27",
"[{\tc #DB2131",
"}{\tc #DE273C",
"|{\tc #E22E46",
"1{\tc #E53C58",
"2{\tc #E84B6B",
"3{\tc #E8486E",
"4{\tc #E54371",
"5{\tc #E34478",
"6{\tc #E14A80",
"7{\tc #E0548B",
"8{\tc #DF6098",
"9{\tc #D870A8",
"0{\tc #CB84B9",
"a{\tc #B784B8",
"b{\tc #966EA4",
"c{\tc #805D94",
"d{\tc #715187",
"e{\tc #6A477E",
"f{\tc #80457B",
"g{\tc #C3457B",
"h{\tc #E0477C",
"i{\tc #E24C80",
"j{\tc #E66894",
"k{\tc #D26693",
"l{\tc #804D82",
"m{\tc #674A80",
"n{\tc #97497F",
"o{\tc #D0487E",
"p{\tc #92497F",
"q{\tc #785F8E",
"r{\tc #805C8C",
"s{\tc #BA497F",
"t{\tc #DF4E85",
"u{\tc #D75B92",
"v{\tc #B070A6",
"w{\tc #A184B8",
"x{\tc #9B81B6",
"y{\tc #9378AB",
"z{\tc #A183AE",
"A{\tc #A17CA6",
"B{\tc #7C588A",
"C{\tc #5F4578",
"D{\tc #653A63",
"E{\tc #B03659",
"F{\tc #EA324E",
"G{\tc #F12D45",
"H{\tc #F3273B",
"I{\tc #F71B25",
"J{\tc #F9131A",
"K{\tc #FB0C0F",
"L{\tc #FA0506",
"M{\tc #F70000",
"N{\tc #EF0000",
"O{\tc #DD0000",
"P{\tc #D40000",
"Q{\tc #B10404",
"R{\tc #D71C1C",
"S{\tc #9F0000",
"T{\tc #940000",
"U{\tc #930000",
"V{\tc #D70505",
"W{\tc #CD0202",
"X{\tc #E70C0C",
"Y{\tc #F12020",
"Z{\tc #E61414",
"`{\tc #DC0608",
" ]\tc #D8090D",
".]\tc #DC0F16",
"+]\tc #E01620",
"@]\tc #E41D2A",
"#]\tc #E82334",
"$]\tc #EB293E",
"%]\tc #EE314A",
"&]\tc #ED3754",
"*]\tc #EB395D",
"=]\tc #E93C65",
"-]\tc #E53F6E",
";]\tc #E24377",
">]\tc #DC4980",
",]\tc #C4518A",
"\']\tc #A05B94",
")]\tc #8E69A0",
"!]\tc #957AB0",
"~]\tc #A189BC",
"{]\tc #997FB4",
"]]\tc #886DA3",
"^]\tc #775C94",
"/]\tc #6F5188",
"(]\tc #984A82",
"_]\tc #D9487E",
":]\tc #E24B7F",
"<]\tc #E76D97",
"[]\tc #CE6190",
"}]\tc #76477D",
"|]\tc #62457B",
"1]\tc #90457B",
"2]\tc #B1457C",
"3]\tc #83497F",
"4]\tc #7A6091",
"5]\tc #8D74A0",
"6]\tc #AC6499",
"7]\tc #DD70A5",
"8]\tc #E181B6",
"9]\tc #D685B9",
"0]\tc #AF79AF",
"a]\tc #85669E",
"b]\tc #7B6394",
"c]\tc #8C77A0",
"d]\tc #7F6B93",
"e]\tc #634B76",
"f]\tc #6D3D65",
"g]\tc #AB375A",
"h]\tc #E53250",
"i]\tc #F02D46",
"j]\tc #F3293C",
"k]\tc #F52333",
"l]\tc #F71D29",
"m]\tc #F8171F",
"n]\tc #FA0F14",
"o]\tc #F50101",
"p]\tc #C50C0C",
"q]\tc #BB0B0B",
"r]\tc #980000",
"s]\tc #990000",
"t]\tc #D50303",
"u]\tc #D40202",
"v]\tc #DB0404",
"w]\tc #D80000",
"x]\tc #DC0000",
"y]\tc #E00305",
"z]\tc #E60A0F",
"A]\tc #EB1119",
"B]\tc #EF1823",
"C]\tc #F21F2D",
"D]\tc #F32536",
"E]\tc #F22A40",
"F]\tc #F02F49",
"G]\tc #EE3352",
"H]\tc #EB375B",
"I]\tc #E83B64",
"J]\tc #DA3E6C",
"K]\tc #A94175",
"L]\tc #7A477E",
"M]\tc #6D4E86",
"N]\tc #72568E",
"O]\tc #7D6098",
"P]\tc #976DA5",
"Q]\tc #B47CB2",
"R]\tc #B186BA",
"S]\tc #9F83B8",
"T]\tc #9378AE",
"U]\tc #9B6AA1",
"V]\tc #D26097",
"W]\tc #E26094",
"X]\tc #E880A9",
"Y]\tc #CD6C9B",
"Z]\tc #7F548B",
"`]\tc #6F538B",
" ^\tc #7B568D",
".^\tc #7E5A91",
"+^\tc #7E6299",
"@^\tc #9178AA",
"#^\tc #AF9BC3",
"$^\tc #B691C1",
"%^\tc #D987BB",
"&^\tc #E17BB0",
"*^\tc #DF6CA3",
"=^\tc #D05F98",
"-^\tc #9F558D",
";^\tc #794D85",
">^\tc #6E4C80",
",^\tc #7A5B87",
"\'^\tc #947596",
")^\tc #9F6181",
"!^\tc #C34364",
"~^\tc #E63554",
"{^\tc #F02F48",
"]^\tc #F2293E",
"^^\tc #F42435",
"/^\tc #F81822",
"(^\tc #F91117",
"_^\tc #F7090E",
":^\tc #F20204",
"<^\tc #EC0000",
"[^\tc #EA1E1E",
"}^\tc #D20101",
"|^\tc #EC0001",
"1^\tc #F20507",
"2^\tc #F60C11",
"3^\tc #F8131A",
"4^\tc #F71A24",
"5^\tc #F6202D",
"6^\tc #F42536",
"7^\tc #F02E48",
"8^\tc #EE3351",
"9^\tc #E93659",
"0^\tc #BC3961",
"a^\tc #673D6A",
"b^\tc #594072",
"c^\tc #5E4479",
"d^\tc #654980",
"e^\tc #865088",
"f^\tc #C65790",
"g^\tc #D86098",
"h^\tc #C46AA2",
"i^\tc #9A75AC",
"j^\tc #9C81B6",
"k^\tc #AC86BB",
"l^\tc #D587BC",
"m^\tc #E38CBD",
"n^\tc #E9A2C9",
"o^\tc #D48FBE",
"p^\tc #A17EB2",
"q^\tc #987EB3",
"r^\tc #A186BB",
"s^\tc #AB88BC",
"t^\tc #AA8CBD",
"u^\tc #B19DC5",
"v^\tc #A98EB9",
"w^\tc #C16CA2",
"x^\tc #DE5F97",
"y^\tc #E0578F",
"z^\tc #DB4980",
"A^\tc #C74478",
"B^\tc #B54172",
"C^\tc #B8446F",
"D^\tc #D25B7B",
"E^\tc #EA738B",
"F^\tc #EF566F",
"G^\tc #F03A51",
"H^\tc #F22C41",
"I^\tc #F42535",
"J^\tc #F61F2C",
"K^\tc #F51923",
"L^\tc #F51219",
"M^\tc #F20B0F",
"N^\tc #ED0406",
"O^\tc #E90000",
"P^\tc #D50000",
"Q^\tc #C10101",
"R^\tc #C20303",
"S^\tc #E70D0D",
"T^\tc #D90404",
"U^\tc #E10000",
"V^\tc #F20000",
"W^\tc #FB0102",
"X^\tc #FB0709",
"Y^\tc #FA0E13",
"Z^\tc #F9141B",
"`^\tc #F6202E",
" /\tc #F22A3F",
"./\tc #F02E47",
"+/\tc #ED324F",
"@/\tc #D43557",
"#/\tc #82395F",
"$/\tc #563C67",
"%/\tc #563E6E",
"&/\tc #5B4175",
"*/\tc #82457B",
"=/\tc #D44A82",
"-/\tc #D95088",
";/\tc #AF568D",
">/\tc #7E5B93",
",/\tc #7E6199",
"\'/\tc #9B69A0",
")/\tc #D56FA6",
"!/\tc #E37EB1",
"~/\tc #E89CC3",
"{/\tc #D189B8",
"]/\tc #9E7CB1",
"^/\tc #957BB0",
"//\tc #9979AF",
"(/\tc #B373AA",
"_/\tc #CA6DA5",
":/\tc #A66BA1",
"</\tc #957DAB",
"[/\tc #9A85AE",
"}/\tc #A55F94",
"|/\tc #D95087",
"1/\tc #E14A81",
"2/\tc #E2457B",
"3/\tc #E34274",
"4/\tc #E53E6D",
"5/\tc #E53C66",
"6/\tc #E83B60",
"7/\tc #EC4160",
"8/\tc #F15B71",
"9/\tc #F3687A",
"0/\tc #F3485A",
"a/\tc #F32D3D",
"b/\tc #F3202E",
"c/\tc #F21923",
"d/\tc #EF131A",
"e/\tc #EB0C11",
"f/\tc #E80508",
"g/\tc #E40101",
"h/\tc #DF0000",
"i/\tc #D10505",
"j/\tc #E60909",
"k/\tc #D80202",
"l/\tc #E50000",
"m/\tc #EB0000",
"n/\tc #FC0000",
"o/\tc #FB080A",
"p/\tc #F80F13",
"q/\tc #F0141B",
"r/\tc #E81A24",
"s/\tc #E71F2D",
"t/\tc #E82435",
"u/\tc #EF293D",
"v/\tc #F02D45",
"w/\tc #EC314D",
"x/\tc #CA3454",
"y/\tc #7F375B",
"z/\tc #563A63",
"A/\tc #523C69",
"B/\tc #6E3F6F",
"C/\tc #C54175",
"D/\tc #B0457B",
"E/\tc #79497F",
"F/\tc #694C84",
"G/\tc #705088",
"H/\tc #A8548C",
"I/\tc #DB5890",
"J/\tc #E3689B",
"K/\tc #E887B0",
"L/\tc #C96DA0",
"M/\tc #855F97",
"N/\tc #7A5E96",
"O/\tc #905C94",
"P/\tc #D25992",
"Q/\tc #DC578F",
"R/\tc #A8558C",
"S/\tc #806495",
"T/\tc #9480A6",
"U/\tc #9E5D8D",
"V/\tc #D7477C",
"W/\tc #E34275",
"X/\tc #E73D68",
"Y/\tc #E93A61",
"Z/\tc #EB375A",
"`/\tc #EC3454",
" (\tc #ED344F",
".(\tc #EE3C52",
"+(\tc #F05464",
"@(\tc #F05663",
"#(\tc #EE3642",
"$(\tc #EB1F29",
"%(\tc #E8131B",
"&(\tc #E50D12",
"*(\tc #E20609",
"=(\tc #DE0102",
"-(\tc #B60C0C",
";(\tc #9C0000",
">(\tc #E30E0E",
",(\tc #D90101",
"\'(\tc #E80000",
")(\tc #FA0000",
"!(\tc #ED0203",
"~(\tc #BA070B",
"{(\tc #8A0E13",
"](\tc #6A131B",
"^(\tc #5E1924",
"/(\tc #741E2C",
"((\tc #BB2333",
"_(\tc #EB283C",
":(\tc #F12C42",
"<(\tc #EC2F4A",
"[(\tc #C83251",
"}(\tc #693557",
"|(\tc #7B3C68",
"1(\tc #663E6E",
"2(\tc #5A4072",
"3(\tc #80447A",
"4(\tc #CB477D",
"5(\tc #E14B81",
"6(\tc #E45B8D",
"7(\tc #E87AA3",
"8(\tc #C45A8E",
"9(\tc #734E85",
"0(\tc #684D84",
"a(\tc #824C83",
"b(\tc #D64B82",
"c(\tc #DF4980",
"d(\tc #B1477E",
"e(\tc #715082",
"f(\tc #9A759B",
"g(\tc #CC638C",
"h(\tc #E34572",
"i(\tc #E93A62",
"j(\tc #EA385C",
"k(\tc #EA3556",
"l(\tc #EA324F",
"m(\tc #E92E49",
"n(\tc #E82C42",
"o(\tc #E72B3F",
"p(\tc #E73544",
"q(\tc #E84752",
"r(\tc #E73F47",
"s(\tc #E22027",
"t(\tc #DE0F14",
"u(\tc #DB0609",
"v(\tc #D80102",
"w(\tc #CB0E0E",
"x(\tc #B80101",
"y(\tc #DB0606",
"z(\tc #E50E0E",
"A(\tc #650000",
"B(\tc #220203",
"C(\tc #10060A",
"D(\tc #100C12",
"E(\tc #16121A",
"F(\tc #201822",
"G(\tc #4D1D29",
"H(\tc #BF2130",
"I(\tc #F12638",
"J(\tc #DC2D45",
"K(\tc #74304B",
"L(\tc #433351",
"M(\tc #453557",
"N(\tc #4B375C",
"O(\tc #4D3960",
"P(\tc #4F3B65",
"Q(\tc #553C69",
"R(\tc #833E6D",
"S(\tc #BF3F70",
"T(\tc #D74274",
"U(\tc #E25381",
"V(\tc #E86A92",
"W(\tc #C34E7E",
"X(\tc #6B4477",
"Y(\tc #5C4276",
"Z(\tc #714175",
"`(\tc #CF4174",
" _\tc #E34072",
"._\tc #C63F6F",
"+_\tc #934471",
"@_\tc #CD6285",
"#_\tc #EC6D8C",
"$_\tc #EA466A",
"%_\tc #E93556",
"&_\tc #E73351",
"*_\tc #E52F4A",
"=_\tc #E32C44",
"-_\tc #E2293E",
";_\tc #DF2537",
">_\tc #DE2130",
",_\tc #DD212E",
"\'_\tc #DC2832",
")_\tc #DD3238",
"!_\tc #D81F23",
"~_\tc #D3090B",
"{_\tc #D00102",
"]_\tc #C90000",
"^_\tc #C11A1A",
"/_\tc #A10202",
"(_\tc #BB0101",
"__\tc #B10202",
":_\tc #AF0202",
"<_\tc #B00101",
"[_\tc #C60101",
"}_\tc #ED0E0E",
"|_\tc #D90606",
"1_\tc #D20000",
"2_\tc #790000",
"3_\tc #230000",
"4_\tc #040000",
"5_\tc #010000",
"6_\tc #090103",
"7_\tc #140508",
"8_\tc #110B10",
"9_\tc #141118",
"0_\tc #21161F",
"a_\tc #831B26",
"b_\tc #E91F2D",
"c_\tc #F42433",
"d_\tc #E2273A",
"e_\tc #792A40",
"f_\tc #3B2D45",
"g_\tc #3D2F4B",
"h_\tc #423250",
"i_\tc #463455",
"j_\tc #473659",
"k_\tc #4A375C",
"l_\tc #50395F",
"m_\tc #623A62",
"n_\tc #853D66",
"o_\tc #B44B72",
"p_\tc #D8587D",
"q_\tc #BE446F",
"r_\tc #663D69",
"s_\tc #523C68",
"t_\tc #663C67",
"u_\tc #C43B66",
"v_\tc #E23A62",
"w_\tc #DB3D62",
"x_\tc #E95070",
"y_\tc #EE6A83",
"z_\tc #EA4A66",
"A_\tc #E63552",
"B_\tc #E22F4B",
"C_\tc #DF2C44",
"D_\tc #DC293F",
"E_\tc #DA2539",
"F_\tc #D82233",
"G_\tc #D61E2C",
"H_\tc #D31A25",
"I_\tc #D2161F",
"J_\tc #D0141B",
"K_\tc #CF1519",
"L_\tc #CC0E10",
"M_\tc #C80202",
"N_\tc #D81919",
"O_\tc #910000",
"P_\tc #DA1D1D",
"Q_\tc #D71515",
"R_\tc #D50C0C",
"S_\tc #D20404",
"T_\tc #E40404",
"U_\tc #E81414",
"V_\tc #D60101",
"W_\tc #450000",
"X_\tc #0B0000",
"Y_\tc #000000",
"Z_\tc #1E0000",
"`_\tc #6B0000",
" :\tc #530406",
".:\tc #0F0A0E",
"+:\tc #130F15",
"@:\tc #5F131B",
"#:\tc #E31822",
"$:\tc #EA202F",
"%:\tc #802435",
"&:\tc #34263A",
"*:\tc #34293F",
"=:\tc #582C44",
"-:\tc #742E48",
";:\tc #58304C",
">:\tc #453250",
",:\tc #433353",
"\':\tc #443456",
"):\tc #493658",
"!:\tc #5B3E60",
"~:\tc #804465",
"{:\tc #983B5E",
"]:\tc #5D375C",
"^:\tc #50375B",
"/:\tc #7E375B",
"(:\tc #D33659",
"_:\tc #EB3657",
"::\tc #EC3555",
"<:\tc #EB3554",
"[:\tc #EA405C",
"}:\tc #EA5C72",
"|:\tc #E54C62",
"1:\tc #DE3249",
"2:\tc #D9293F",
"3:\tc #D62639",
"4:\tc #D32334",
"5:\tc #D11F2E",
"6:\tc #CE1B28",
"7:\tc #CB1722",
"8:\tc #C9131B",
"9:\tc #C70E14",
"0:\tc #C4090D",
"a:\tc #C10506",
"b:\tc #BF0101",
"c:\tc #CF0707",
"d:\tc #CF0101",
"e:\tc #DD0505",
"f:\tc #900000",
"g:\tc #0E0000",
"h:\tc #030000",
"i:\tc #690000",
"j:\tc #090304",
"k:\tc #09070B",
"l:\tc #550C11",
"m:\tc #E61118",
"n:\tc #F21A24",
"o:\tc #8D1D29",
"p:\tc #2C1F2F",
"q:\tc #2B2334",
"r:\tc #642538",
"s:\tc #CB283C",
"t:\tc #BB2A40",
"u:\tc #852C43",
"v:\tc #522D46",
"w:\tc #3E2E49",
"x:\tc #3F314D",
"y:\tc #54324F",
"z:\tc #91314E",
"A:\tc #65314E",
"B:\tc #7D314E",
"C:\tc #CA304D",
"D:\tc #EC314C",
"E:\tc #EE304B",
"F:\tc #EC2F49",
"G:\tc #E72E47",
"H:\tc #E3334A",
"I:\tc #E1485B",
"J:\tc #DF485A",
"K:\tc #DB3244",
"L:\tc #DA2C3C",
"M:\tc #DD2E3D",
"N:\tc #D72431",
"O:\tc #CF1D28",
"P:\tc #CA161F",
"Q:\tc #C21017",
"R:\tc #BE0C10",
"S:\tc #BC070A",
"T:\tc #B90203",
"U:\tc #C20101",
"V:\tc #D00202",
"W:\tc #920000",
"X:\tc #B10101",
"Y:\tc #E10808",
"Z:\tc #CF0000",
"`:\tc #5A0000",
" <\tc #0A0000",
".<\tc #620000",
"+<\tc #510000",
"@<\tc #080102",
"#<\tc #770407",
"$<\tc #F2090D",
"%<\tc #F61218",
"&<\tc #A0151E",
"*<\tc #261823",
"=<\tc #221C28",
"-<\tc #471E2C",
";<\tc #CF2130",
"><\tc #F22334",
",<\tc #E72537",
"\'<\tc #BF263A",
")<\tc #77273C",
"!<\tc #44293E",
"~<\tc #442A40",
"{<\tc #932A41",
"]<\tc #D62B41",
"^<\tc #B52B41",
"/<\tc #D42B41",
"(<\tc #EF2A40",
"_<\tc #F02A3F",
":<\tc #E5283C",
"<<\tc #DF263A",
"[<\tc #DA2839",
"}<\tc #D83342",
"|<\tc #E34554",
"1<\tc #E95971",
"2<\tc #E32A33",
"3<\tc #D1161A",
"4<\tc #BC0608",
"5<\tc #B50102",
"6<\tc #BE0101",
"7<\tc #CA0808",
"8<\tc #B50404",
"9<\tc #E10606",
"0<\tc #520000",
"a<\tc #410000",
"b<\tc #680000",
"c<\tc #0F0000",
"d<\tc #440000",
"e<\tc #560000",
"f<\tc #070000",
"g<\tc #2B0000",
"h<\tc #F90203",
"i<\tc #F90A0E",
"j<\tc #B70D13",
"k<\tc #291117",
"l<\tc #17141C",
"m<\tc #2C1720",
"n<\tc #AD1924",
"o<\tc #F41C27",
"p<\tc #F61E2A",
"q<\tc #F41F2D",
"r<\tc #E22130",
"s<\tc #AC2231",
"t<\tc #A42233",
"u<\tc #E22334",
"v<\tc #F32434",
"w<\tc #F02435",
"x<\tc #F12333",
"y<\tc #EB2333",
"z<\tc #E42131",
"A<\tc #DD202F",
"B<\tc #D61F2D",
"C<\tc #D21E2B",
"D<\tc #DF2A36",
"E<\tc #D00303",
"F<\tc #C10202",
"G<\tc #BD0101",
"H<\tc #C40202",
"I<\tc #C90101",
"J<\tc #CA0202",
"K<\tc #D10E0E",
"L<\tc #D60F0F",
"M<\tc #C50B0B",
"N<\tc #EB1111",
"O<\tc #060000",
"P<\tc #660000",
"Q<\tc #240000",
"R<\tc #100000",
"S<\tc #1C0000",
"T<\tc #050000",
"U<\tc #0D0000",
"V<\tc #7E0000",
"W<\tc #FC0101",
"X<\tc #FB0203",
"Y<\tc #CC0507",
"Z<\tc #35080C",
"`<\tc #0E0B10",
" [\tc #180E14",
".[\tc #841118",
"+[\tc #EF131B",
"@[\tc #F71923",
"#[\tc #F31A25",
"$[\tc #F21B26",
"%[\tc #F61C27",
"&[\tc #F71C28",
"*[\tc #F61C28",
"=[\tc #F21B28",
"-[\tc #EA1B27",
";[\tc #E21A26",
">[\tc #DA1925",
",[\tc #D31823",
"\'[\tc #CF1721",
")[\tc #DE1C27",
"![\tc #DA0F0F",
"~[\tc #EE2D2D",
"{[\tc #DF0A0A",
"][\tc #2A0000",
"^[\tc #200000",
"/[\tc #2E0000",
"([\tc #080000",
"_[\tc #4C0000",
":[\tc #4A0102",
"<[\tc #050305",
"[[\tc #0B0609",
"}[\tc #66080C",
"|[\tc #E80B0F",
"1[\tc #FA1015",
"2[\tc #F7141C",
"3[\tc #F1141B",
"4[\tc #E9131B",
"5[\tc #E1131B",
"6[\tc #D8121A",
"7[\tc #D01118",
"8[\tc #CA1017",
"9[\tc #D8131A",
"0[\tc #CA0505",
"a[\tc #EB1616",
"b[\tc #E00707",
"c[\tc #D50202",
"d[\tc #1B0000",
"e[\tc #020000",
"f[\tc #5C0000",
"g[\tc #370000",
"h[\tc #380000",
"i[\tc #800000",
"j[\tc #670000",
"k[\tc #270001",
"l[\tc #A40102",
"m[\tc #F50204",
"n[\tc #FC0506",
"o[\tc #FB0609",
"p[\tc #FB080B",
"q[\tc #FB0A0C",
"r[\tc #FB0A0D",
"s[\tc #F90B0F",
"t[\tc #E00B0F",
"u[\tc #D70A0F",
"v[\tc #CE0A0D",
"w[\tc #C6090C",
"x[\tc #C9080C",
"y[\tc #E61A1F",
"z[\tc #E50C0C",
"A[\tc #D70202",
"B[\tc #400000",
"C[\tc #210000",
"D[\tc #320000",
"E[\tc #1A0000",
"F[\tc #4A0000",
"G[\tc #7C0000",
"H[\tc #3A0000",
"I[\tc #3E0000",
"J[\tc #F90102",
"K[\tc #F20203",
"L[\tc #DE0204",
"M[\tc #D60204",
"N[\tc #CD0103",
"O[\tc #C40102",
"P[\tc #C40203",
"Q[\tc #E00607",
"R[\tc #BA0303",
"S[\tc #D90202",
"T[\tc #EA0F0F",
"U[\tc #DC0505",
"V[\tc #730000",
"W[\tc #890000",
"X[\tc #8C0000",
"Y[\tc #3F0000",
"Z[\tc #580000",
"`[\tc #E01B1B",
" }\tc #CD0505",
".}\tc #C80101",
"+}\tc #DF0404",
"@}\tc #E71414",
"#}\tc #E00B0B",
"$}\tc #D80101",
"%}\tc #550000",
"&}\tc #280000",
"*}\tc #5F0000",
"=}\tc #760000",
"-}\tc #2D0000",
";}\tc #490000",
">}\tc #720000",
",}\tc #360000",
"\'}\tc #390000",
")}\tc #D10000",
"!}\tc #C90505",
"~}\tc #E60A0A",
"{}\tc #110000",
"]}\tc #140000",
"^}\tc #6E0000",
"/}\tc #590000",
"(}\tc #290000",
"_}\tc #E01414",
":}\tc #EC0A0A",
"<}\tc #D90A0A",
"[}\tc #810000",
"}}\tc #4F0000",
"|}\tc #120000",
"1}\tc #170000",
"2}\tc #330000",
"3}\tc #8B0000",
"4}\tc #BC0101",
"5}\tc #E82222",
"6}\tc #DD0A0A",
"7}\tc #D30101",
"8}\tc #460000",
"9}\tc #1F0000",
"0}\tc #6D0000",
"a}\tc #150000",
"b}\tc #CC0D0D",
"c}\tc #DA0202",
"d}\tc #CA0303",
"e}\tc #4D0000",
"f}\tc #860000",
"g}\tc #840000",
"h}\tc #0C0000",
"i}\tc #350000",
"j}\tc #E00101",
"k}\tc #CB0404",
"l}\tc #CD0101",
"m}\tc #CF0303",
"n}\tc #6C0000",
"o}\tc #430000",
"p}\tc #CB0101",
"q}\tc #5E0000",
"r}\tc #470000",
"s}\tc #BC0303",
"t}\tc #D50808",
"u}\tc #D71414",
"v}\tc #BF0808",
"w}\tc #340000",
"x}\tc #610000",
"y}\tc #270000",
"z}\tc #2C0000",
"A}\tc #250000",
"B}\tc #530000",
"C}\tc #3D0000",
"D}\tc #D20F0F",
"E}\tc #7F0000",
"F}\tc #4E0000",
"G}\tc #500000",
"H}\tc #700000",
"I}\tc #C70909",
"J}\tc #260000",
"K}\tc #5D0000",
"L}\tc #8F0000",
"M}\tc #770000",
"N}\tc #DD1A1A",
"O}\tc #740000",
"P}\tc #4B0000",
"Q}\tc #C30101",
"R}\tc #180000",
"S}\tc #160000",
"T}\tc #7B0000",
"U}\tc #090000",
"V}\tc #3C0000",
"W}\tc #D20303",
"X}\tc #BE0202",
"Y}\tc #640000",
"Z}\tc #710000",
"`}\tc #190000",
" |\tc #CA0101",
".|\tc #8E0000",
"+|\tc #BF0202",
"@|\tc #7A0000",
"#|\tc #480000",
"$|\tc #CA0606",
"%|\tc #C90404",
"&|\tc #420000",
"*|\tc #D60202",
"=|\tc #C90606",
"-|\tc #130000",
";|\tc #CB0606",
">|\tc #8A0000",
",|\tc #DA0909",
"\'|\tc #B60303",
")|\tc #C90303",
"!|\tc #2F0000",
"~|\tc #C10505",
"{|\tc #BD0202",
"]|\tc #D10C0C",
"^|\tc #C00202",
"/|\tc #B90101",
"(|\tc #CB0505",
"_|\tc #CF0505",
":|\tc #D30707",
"<|\tc #D40707",
"[|\tc #D80606",
"}|\tc #CF0404",
"||\tc #C30A0A",
"1|\tc #BA0101",
"2|\tc #C60808",
"3|\tc #D00707",
"4|\tc #BB0202",
"5|\tc #C70303",
"6|\tc #D40808",
"7|\tc #BE0505",
"8|\tc #E22121",
"9|\tc #C40101",
"0|\tc #D72424",
"a|\tc #9D0101",
"b|\tc #AC0505",
"c|\tc #A70707",
"d|\tc #B90707",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                   .                                                          \
                       ",
"                                                                             \
                                                                             +\
                   @                                                          \
                       ",
"                                                                             \
                                                                             #\
                 $ % &                                                        \
                       ",
"                                                                             \
                                                                             *\
 =             - ; > ,                                                        \
                       ",
"                                                                             \
                                                                             \
\' ) ! ~ { ] ^ / ( _ : < { [ }                                                \
                         ",
"                                                                             \
                                                                           ~ ;\
 | _ 1 < 2 ; 3 4 5 6 7 8 9 / 0 a b                                            \
                       ",
"                                                                             \
                                                         c d           [ e ( f\
 g h i j k l m n > o p i q r s t u v w                                        \
                       ",
"                                                                             \
                                                           x y     } z / 8 7 i\
 A B C D E $ F G H I J i K l L M N O u { P                                    \
                       ",
"                                                                             \
                                                           5 Q R / S T ; i C L\
 H U < e V [ b [ < W X Y 9 Z `  .C i N t ^ -                                  \
                       ",
"                                                                             \
                                                             ..y & W +. .@._ 9\
 S #.$.          1 %.      w &.t *.=.=.+., u -.                               \
                       ",
"                                                                             \
                                                           w T l ;.g  .& >.~  \
   ,.\'.).&.] S u !.1 { ~.b     {.].^./.(..._.( ~                             \
                        ",
"                                                                             \
                                                           { t & :.% q S <.   \
 ~ ,.[.8 }.|.1.2.3.; 1 9 u 4.5.6.7.8.9.0.a. .3 b.2 @.c.                       \
                       ",
"                                                                             \
                                                         ~ 9 $ I m @.$ z   ~.Y\
 d., e.E _ 3.f.+.g.+.r ; h.i.j.k.l.m.n.o.p.q.l k r.C <                        \
                       ",
"                                                                             \
                                                       - s.t.=.k 8 u.Z v.S ( 8\
 ; *.i @.5 w.L =.x.L H y.z.A.B.C.D.E.F.G.H.I.;.J.K.; ).                       \
                       ",
"                                                                             \
                                                     L.S 1.i k < -   s.7 !.!.r\
 & 5 l M.| N.: O.P.M.Q.R.S.T.U.V.W.X.Y.Z.`. +.+++ .@+#+                       \
                       ",
"                                                                             \
                                                   u $+8 & l N a   - u.; ..J %\
+L g O.&+*+=+-+;+o B >+,+\'+)+!+~+{+]+^+/+(+_+..& l r ( V                     \
                        ",
"                                                                             \
                                                   :+K @.g M S     ^ <+7 i [+n\
 }+|+-+1+2+3+4+4+4+2+5+6+7+8+9+0+a+b+c+d+e+f+V u i K _./ L.                   \
                       ",
"                                                                             \
                                                   < g+h+i+..j+  &.b.3 +.k+l+;\
.B ++m+d n+o+p+q+. r+s+t+u+v+w+x+y+z+A+B+C+#+  D+,  .` b.E+                   \
                       ",
"                                                                             \
                                                 b F+G+H+|+: 5 Z t Z E 5 I+> J\
+K+L+M+N+O+P+Q+R+P+S+T+U+V+W+X+Y+Z+`+ @.@+@$.[   ] @@L #@$@%@&@*@=@-@;@       \
                       ",
"                                                                             \
                                                 ~ t >@l ,@2.U r.l ..H c.r.\'@\
)@!@~@{@]@^@/@(@_@:@<@[@}@|@1@2@3@4@5@6@7@8@<+0   9@0@a@b@c@d@e@f@g@h@i@j@    \
                        ",
"                                                                             \
                                                 ] 1.k+M Y   / *.k@l@O.m@n@o@p\
@q@r@s@t@u@v@w@x@y@z@A@(@B@C@D@E@F@G@H@I@J@f+K@L@M@N@O@P@Q@R@S@T@U@V@W@X@Y@Z@ \
                       ",
"                                                                             \
                                               `@u  #I !.w   Y }.E g+|+.#+#@##\
#$#%#&#*#=#-#;#>#,#\'#)#!#~#[@{#o+]#^#/#(#_#:#<#[#}#|#1#2#3#4#5#6#7#8#9#0#a#b#\
c#d#                    ",
"                                                                             \
                                               - d.e#l !   D+u 2.e#L f#g#@###h\
#i#&#j#k#l#m#n#o#p#q#r#\'#y@_@s#T+n+t#u#v#w#x#y#z#A#B#C#D#E#F#G#H#I#J#K#L#M#N#\
O#P#Q#R#                ",
"                                                                             \
                                               Y < H @.u.  S#d.3 T#U#V#W#X#Y#Z\
#`# $.$+$@$#$$$%$&$*$=$-$;$>$:@,$\'$)$!$~${$]$^$/$($_$:$<$[$}$|$1$2$3$4$5$6$7$\
8$9$0$a$b$              ",
"                                                                             \
                                         *+g D >@5 }+l %.V c$O  #d$e$f$g$h$i$j\
$k$l$m$n$o$p$q$r$s$t$&$q#>#u$v$w$x$y$z$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T\
$U$V$W$X$Y$            ",
"                                                                             \
                                         o Z$;.Z$-+4+`$ %e#3.& R C O..%+%@%#%$\
%%%&%*%=%-%;%>%,%\'%)%!%~%{%]%^%/%(%_%:%<%[%}%|%1%2%3%4%5%6%7%8%9%0%a%b%c%d%e%\
f%g%h%i%j%k%l%          ",
"                                                                             \
                                             9 s M m%n%o%p%s q%g.[+r%s%t%u%v%w\
%x%y%z%A%B%C%\'%D%E%\'%F%G%H%I%J%K%L%M%N%O%P%Q%R%S%T%U%V%W%X%Y%Z%`% &.&+&@&#&$\
&%&&&*&=&-&;&>&          ",
"                                                                             \
                                               ,&\'&)&!&~&{&]&F ..l N.^&/&(&_&\
:&<&[&}&|&1&2&D%3&\'%4&5&6&7&8&9&0&a&b&c&d&e&f&g&h&i&U%j&k&l&m&n&`%o&p&q&r&s&t\
&u&v&w&x&y&X$;&z&        ",
"                                                                             \
                                             A&B&C&D&E&F&G&H&I&J&K&r.Q 2+L&M&N\
&O&P&Q&R&S&T&\'%U&V&W&X&Y&Z&`& *.*+*@*#*$*%*&***=*-*;*>*5%,*\'*)*!*~*{*]*^*/*(\
*_*:*<*[*}*|*W$k%        ",
"                                                                             \
                                             1*2*3*4*5*6*7*8*9*J+o *+:.0*r+a*b\
*c*d*e*f*g*h*i*j*k*l*m*n*o*p*q*r*@*s*t*u*v*w*x*y*z*A*B*C*D*E*F*G*H*I*J*K*L*M*N\
*O*P*Q*R*=&S*T*U*      ",
"                                                                             \
                                           V*W*X*Y*Z*`* =.=+=@=#=4+m+`$i+$=%=&\
=_@*===-=;=>=,=\'=,=)=!=~={=]=^=/=(=_=:=<=[=}=|=1=2=3=4=6%5=6=7=8=9=0=a=b=c=d=\
e=f=g=h=l%}*i=j%j=      ",
"                                                                             \
                                         k=l=m=n=o=p=q=r=s=t=u=v=4+% B w=]#. S\
+x=y=z=A=B=C=D=D=E=F=G=H=I=J=K=L=M=N=O=P=Q=R=S=T=U=V=W=X=Y=Z=`= -.-+-@-#-$-%-&\
-*-=---Q*;-y&a$j%>-    ",
"                                                                             \
                                         ,-\'-)-!-~-{-]-^-/-(-_-:-<-O.: Z$0*[-\
}-|-1-2-3-4-5-6-7-8-9-0-I=a-b-c-(=d-e-f-g-h-i-j-k-l-m-n-o-p-q-r-s-t-u-v-w-x-y-\
z-A-B-C-D-E-F-S*T*G-    ",
"                                                                             \
                                         H-I-J-K-L-M-N-O-P-Q-R-S-l L c.r.`$T-U\
-V-W-X-Y-Z-`- ;.;+;@;#;$;b-%;&;*;=;-;;;>;,;\';);!;~;{;];^;/;(;_;:;<;[;};|;1;2;\
3;4;5;6;7;[*8;i%;&9;    ",
"                                                                             \
                                         0;a;b;c;d;e;f;g;h;i;j;k;l;` 5 m;n;o;p\
;q;r;s;t;u;v;w;w;x;y;z;A;B;&;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z;`\
; >.>+>@>#>$>|*j%%>&>  ",
"                                                                             \
                     *>=>                ->;>>>,>\'>)>!>~>{>]>^>&./>(>_>:><>[>\
}>|>1>2>+*3>4>5>6>A;/=7>8>9>*;0>a>b>c>d>e>f>g>h>i>j>k>l>m>n>o>p>q>r>s>t>u>v>w>\
x>y>z>A>B>C>D>E>W$F>G>  ",
"                                                                             \
                 j%H>I>J>K>L>              M>N>O>P>Q>R>S>T>U>V>W>X>Y>Z>`> ,.,+\
,@,#,$,%,&,&;*,=,-,r;;,>,,,\',:=),!,~,{,],^,/,(,_,:,<,[,},|,1,2,3,4,5,6,7,8,9,\
0,a,.>A>--C>x&b,W$c,d,  ",
"                                                                             \
               e,f,g,h,i,j,k,l,                m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B\
,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,9+R,S,T,U,V,W,X,Y,Z,`, \'.\'+\'@\'#\'$\'%\'&\'*\
\'=\'-\';\'>\',\'.>+>B>C>x&E>W$\'\')\'  ",
"                                                                             \
             !\'~\'{\']\'^\'/\'(\'_\':\'                      <\'[\'}\'|\'1\'2\
\'3\'4\'5\'6\'7\'8\'9\'0\'a\'b\'c\'d\'e\'F,f\'g\'h\'i\'j\'k\'l\'m\'n\'o\'p\'q\
\'r\'s\'U%t\'u\'v\'w\'x\'y\'z\'A\'B\'C\'D\'E\'F\'G\'H\'I\'J\'K\'L\'M\'@>#>D>E>\
W$!\'l%  ",
"                                                                             \
           N\'O\'~\'P\'Q\'R\'S\'T\'U\'V\'W\'                    X\'Y\'Z\'`\' )\
.)+)@)#)$)%)&)*)=)-);)>),)\')))!)~){)])^)/)()_):)<)[)})|)U%1)2)3)O;4)5)6)7)8)9\
)0)a)b)c)d)e)f)g)h)i)j)h=l%$>|*j%k)l)  ",
"                                                                             \
           m)O\'n)o)p)q)r)s)t)u)v)                w)x)y)z)A)B)C)D)E)F)G)H)I)J)\
K)L)M)N)O)P)Q)Q,R)S)T)U)V)W)X)Y)]+Z)`) !.!6)+!@!l>#!$!%!&!*!=!-!;!>!,!\'!)!!!~\
!{!]!^!/!D-E-8;i%;&(!    ",
"                                                                             \
           _!:!o)<![!}!|!e,\'\'1!2!              3!4!5!6!7!8!9!0!a!b!c!d!U%e!f\
!g!h!i!j!k!l!m!n!o!S,p!q!r!s!t!J)u!v!w!x!y!z!A!`,@!B!C!D!E!F!G!H!I!J!K!L!M!N!O\
!P!5;+>B>Q*Q!R!S*S!T!    ",
"                                                                             \
           D>}!U!V!W!*>\'\'S!W$X!              Y!Z!`! ~.~+~@~#~$~%~&~*~=~6)U%-\
~;~>~,~\'~)~!~~~{~]~^~/~(~_~:~<~[~}~|~1~2~3~4~5~6~7~8~9~0~a~b~c~d~e~f~g~h~i~j~\
k~z>^!C-h=l%D>b,k%\'\'i%    ",
"                                                                             \
             X$l~|!\'\'S!j%k%x&            m~n~o~p~q~r~s~t~u~v~5)w~x~y~w\'z~A~\
B~C~D~E~F~G~H~I~J~K~L~M~N~O~P~Q~R~S~T~U~\'*V~W~X~Y~Z~`~ {.{+{@{#{${%{&{*{={-{;\
{>{,{M\'B>Q*b$\'{i%;&!\'){    ",
"                                                                  -&S!e,k%   \
             !{~{{{]{^{-&i=Q!/{      ({_{:{<{[{}{|{1{2{3{4{5{6{7{8{9{0{a{b{c{d\
{e{f{g{h{i{j{k{l{m{n{o{p{q{r{s{t{u{v{w{x{y{z{A{B{C{:;D{E{F{G{H{x-I{J{K{L{M{N{A\
>O{P{[*D>b,a$c,Q{R{    ",
"                                                              a$S{T{U{T{n)V!i\
=                    V{l%=&}*W{X{Y{Z{`{ ].]+]@]#]$]%]&]*]=]-];]>],]\'])]!]~]{]\
]]^]/](]_]:]<][]}]|]1]2]3]4]5]6]7]8]9]0]a]E*b]c]d]e]f]g]h]i]j]k]l]m]n]4;o]i)+>\
/!h=C>Q!=&i%;&\'\'p]      ",
"                                                            q]r]U{T{O\'n)s]o)\
[!z&                      t]b$[*u]v]w]x]y]z]A]B]C]D]E]F]G]H]I]J]K]L]M]N]O]P]Q]\
R]S]T]U]V]W]X]Y]Z]`] ^.^+^@^#^$^%^&^*^=^-^;^>^,^\'^)^!^~^{^]^^^&{/^(^_^:^<^+>/\
!7;C>b$8;E>a$c,W$        ",
"                                                            s)T{O\'r]:!o)<!U!\
V!]{                      [^}^D-w]O{j)A>|^1^2^3^4^5^6^E]7^8^9^0^a^b^c^d^e^f^g^\
h^i^j^k^l^m^n^o^p^q^x{r^s^t^u^v^w^x^y^y\'z^A^B^C^D^E^F^G^H^I^J^K^L^M^N^O^6;x]P\
^C>b$}*b,X$S!e,Q^        ",
"                                                          i%r]n):!o)<!S{V!W!|\
!R^                    S^T^7;x]U^A>,{V^h)W^X^Y^Z^4^`^6^ /./+/@/#/$/%/&/*/=/-/;\
/>/,/\'/)/!/~/{/]/^///(/_/:/</[/}/|/1/2/3/4/5/6/7/8/9/0/a/b/c/d/e/f/g/h/@>D-#>\
R*}*y&-&;&\'\'i%          ",
"                                                          ;&s]:!<!S{V!l~*>!\'\
;&i/                  j/k/@>h/l/m/L\'M{K\'n/n/g)o/p/q/r/s/t/u/v/w/x/y/z/A/B/C/\
D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/-]X/Y/Z/`/ (.(+(@(#($(%(&(*(=(B>P^Q*[*\
Q!8;b,-&;&!\'-(            ",
"                                                          X$;(U![!l~*>!\'c,;&\
z&                >(v],(x]j)\'(N{]!)(n/n/n/n/K\'!(~({(](^(/(((_(:(<([(}(U;z/|(\
1(2( {3(4(5(6(7(8(9(0(a(b(c(d(e(f(g(h(X/i(j(k(l(m(n(o(p(q(r(s(t(u(v(P{Q*l%b$D>\
=&|*X$;&e,S!w(            ",
"                                        8;                z&V!}!|!e,c,;&W$x(y\
(            z(T^P^B>h/+>,{.>P!n/n/n/n/K\'5;$>A(B(C(D(E(F(G(H(I( /J(K(L(M(N(O(\
P(Q(R(S(T(U(V(W(X(Y(Z(`( _._+_@_#_$_j(%_&_*_=_-_;_>_,_\'_)_!_~_{_#>]_Q!D>F-b,i\
%k%S!!\'T*D>              ",
"                                    ^_/_T{l~=&              (___:_<_a$S*-&[_ \
         }_|_P^w]O{6;^!5;M{K\'n/n/n/n/h)1_2_3_4_5_6_7_8_9_0_a_b_c_d_e_f_g_h_i_\
j_k_l_m_n_o_p_q_r_s_t_u_I]v_w_x_y_z_A_B_C_D_E_F_G_H_I_J_K_L_M_Q!x&8;R!E>i%a$;&\
c,!\'x(N_                ",
"                                  *>~\'O_U{~\'U!S*              P_&>Q_R_S_F-x\
&T_    U_y(V_7;--U^A>,{z>)(n/n/n/n/n/)($>W_X_Y_Y_Z_`_f, :.:+:@:#:l]$:%:&:*:=:-\
:;:>:,:\':):!:~:{:]:^:/:(:_:::<:[:}:|:1:2:3:4:5:6:7:8:9:0:a:b:F-R!b,|*S*a$;&c,\
\'\'T*=&                    ",
"                                |!T{O_T{O\'r]:!U!y&                      c:;-\
d:e:y(V_h=--C-l/m/L\'M{K\'n/n/n/K\'n/n/M{f:g:Y_Y_h:i:A>]!n)j:k:l:m:)!n:o:p:q:r\
:s:t:u:v:w:g_x:y:z:A:B:C:D:E:F:G:H:I:J:K:L:M:N:O:P:Q:R:S:T:|*i%-&X$k%j%T*\'\'c\
,a$U:V:                      ",
"                              *>W:W:~\'n)s]o)U![!X:                      Y:#>\
C>D-7;x]C-l/^!5;>{)(n/n/n/)(6;Z:L\'n/K\'7;`: <Y_h:.<m/7;+<5_@<#<$<i~%<&<*<=<-<\
;<><,<\'<)<!<~<{<]<^</<(<_<$]:<<<[<}<|<1<        2<3<4<5<W$j%;&;&;&;&T*S*6<7< \
                           ",
"                            \'{U{W:~\'r]:!;(S{}!W!8<                      9<D\
-h=--C-l/m/5;]!)(n/n/n/n/>{|*0<a<b,h)n/)(Q*b<c<5_d<W!e<f<5_g<y&h<~!i<j<k<l<m<n\
<o<p<q<r<s<t<u<v<w<><x<y<z<A<B<C<D<                  E<F<G<H<I<J<K<L<         \
                         ",
"                            b,~\'T{r]o)U![!l~*>\'\'M<                  N<e:7;\
B>h/l/m/N{]!)(n/n/n/n/n/n/C-+<O<f<P<l/n/n/P!b,Q<Y_R<S<T<Y_U<V<\'(K\'W<X<Y<Z<`<\
 [.[+[)!*{@[#[$[%[&[*[=[-[;[>[,[\'[)[                                         \
                             ",
"                            8;:!O\':!U!V!W!e,c,i=![              ~[{[k/@>/!M\
\'O^N{z>P!K\'n/n/K\'P!)(n/K\'l%][Y_Y_^[W$P!n/K\'#>/[Y_Y_Y_Y_Y_([_[r]D-V^K\'U^:\
[<[[[}[|[i~1[z-M!J{Z^2[3[4[5[6[7[8[9[                                         \
                               ",
"                              e,:!;(V!|!!\'S!k%0[            a[b[c[h=x]U^A>,{\
.>P!K\'n/n/n/M{P{l~w]n/)(-&d[5_e[T<f[l/n/n/h=g[5_Y_([T<Y_Y_h:R<h[i[l%l/j[4_k[l\
[m[n[o[p[q[r[s[M^|[t[u[v[w[x[y[                                               \
                         ",
"                                k%!\'*>!\'T*k%R!h/          z[A[h=B>C-+><^V^M\
{K\'n/n/n/n/)(R!B[C[a$K\'h);(g:c<D[O<E[j%P!n/U^F[5_O<e<G[H[c<e[Y_Y_([I[F-O\'B[\
c,L\'n/n/n/W<W<J[K[a,L[M[N[O[P[Q[                                             \
                             ",
"                                    )\'R[9;i%R!S[      T[U[h=@>/!M\'O^N{>{)(n\
/n/n/K\'n/n/z>V[O<S<=&K\']!W[ <C[X[Q<e[`:O^n/m/f[h:h:A(+>--T{Y[g:5_O<Z[w]/!C>]\
!n/n/n/n/n/P!L\'A>O{P{l%x&F-!{                                                \
                            ",
"                                        `[ }$>.}+}@}#}$}@>O{j)\'(i)z>P!n/n/n/\
K\'m/;-j)K\',{%}5_&}Y$n/L\'V[T<][D>*}4_d[b,)(.>=}T<5_I[/!K\'.>#>V<-};}[*P!K\'K\
\'n/n/n/n/n/h)5;A>O{P{[*D>=&l%                                                \
                              ",
"                                            }^[*Q*P^w]O{j)A><^V^h)K\'n/n/n/K\
\'w]>},}a$)(--\'}e[W_/!n/<^j[4_D[1_W:g:T<=}.>h)r] <Y_Z_}*K\'n/K\'N{E-)}P!n/n/n\
/n/n/n/n/h)N{+>O{P{l%D>y&!}                                                   \
                             ",
"                                          ~})})}h=x]U^+><^L\'M{K\'n/n/n/n/n/M\
{O_{}]}*>M{b,S<f<^},{n/l//}h:(}W[0< <5_I[w])(i=E[Y_c<~\'M{n/n/n/K\'K\'n/n/n/n/\
n/n/n/M{N{+>O{P^Y$x&R!=&_}                                                    \
                            ",
"                                      :}<}}^P{B>C-l/m/L\'>{)(n/n/n/n/n/n/n/>{\
V<f<{}l~N{[}([]}S{M{n/j)}}e[([|}4_Y_Y_1}*>M{)}2}5_]}3}z>n/n/n/n/n/n/n/n/n/n/K\
\'M{i)+>O{P{l%x&R!4}V_                                                        \
                          ",
"                                  5}6}7}Q*h=x]6;^!N{]!)(n/n/n/>{+><^K\'n/n/h)\
[}T< <<!x]Y[5_,}P{K\'n/U^8}e[Y_T<9}9}e[T<0}<^+>0<a}i:h=)(n/n/n/n/n/n/n/n/n/K\'\
>{N{A>O{P{Y$;-=&i=b}                                                          \
                          ",
"                                c}d}[*Q*w]h/+>,{.>P!n/n/n/n/<^;(e}f}N{n/n/>{g\
}T<([X[[!R<O<2_.>n/n/6;Y[Y_h:0<k%X[h}Y_i}P^]!r][}x])(n/n/n/n/n/n/n/n/n/K\'M{N{\
A>/!h=#>Q!F-i=R!                                                              \
                        ",
"                            j}k}Q!]_)}@>U^O^5;M{K\'n/n/n/n/P!W$9}e[-}8;)(n/]!\
X[([f<e<Y[h:D[[*K\'n/n/h/I[Y_]}R!h)b,1}5_D[#>K\'m/m/K\'n/n/n/n/n/n/n/n/n/K\'M{\
N{A>h/7;Z:R*\'{|*i=l}                                                         \
                             ",
"                          m}D>D>]_)}--M\'m/z>)(n/n/n/n/n/n/.>V<f<Y_([n}m/n/>{\
T{U<5_X_T<U<f}i)K\'n/n/O{o}5_1}F-K\'D-2}][U!L\'n/n/n/n/n/n/n/n/n/n/n/n/K\'M{5;\
\'(C-w]Q*E-}*E>S*p}                                                           \
                             ",
"                        Q!b,$>]_)}x]l/i)>{K\'n/n/n/n/n/n/n/i)q}e[5_Y_Q<=&P!h)\
U!{}Y_Y_Y_h}f[S{P^]!n/h/r}5_R<T*)(^!3}S!5;n/n/n/n/n/n/n/n/n/n/n/n/n/M{5;O^U^@>\
)}]_$>y&-&G<                                                                  \
                        ",
"                    J<F-E>8;]_1_x]+>5;h)n/n/n/n/n/n/n/n/n/M\'W_e[Z_g:T<0}<^)(\
W$]}Y_Y_Y_5_O<|}a<}!N{l/e}5_ <U!P!K\'i)]!n/n/n/n/n/n/n/n/n/n/n/n/n/M{5;^!j)B>D\
-l%x&R!-&s}t}                                                                 \
                         ",
"                u}v}a$i=\'{E-1_x]+>5;P!n/K\')(P!K\'n/n/n/n/n/w]w}O<x}0<4_y}F-\
h)8;9}Y_O<z}A}T<Y_e[^[[!j)B}O<C}]_K\'n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/h)L\'m/M\'x\
]P{Y$Q!\'{i=S*D}                                                              \
                              ",
"              8;T*T*S*=&Q!Q*--l/5;P!P!M\'$>W!O\';&C-P!n/n/K\'l%y}([E}U!1}f<>}\
m/C>z}Y_U<f}-&F}f<Y_e[G}h=H}e}}*h)n/n/n/n/n/n/n/n/n/n/n/n/n/n/K\'M{V^<^l/O{h=C\
>b$8;E>S*I}                                                                   \
                           ",
"            [*\'\'!\'k%b,x&Y$w]6;N{>{\'(!\'0<J}|}([]}K}w]K\'n/K\'F-d[ <L}#>h[\
5_D[l%/!Y[Y_O<M},{b$B[h:Z_n)m/Y$h=h)n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/h).>,{+>h/w]\
Q*E-D>y&S*>&N}                                                                \
                              ",
"            R!*>T*i%\'{E-P{C-^!l/-&`:a}h:5_e[Y_Y_g:3}]!n/)(S*a}([O}T{&}Y_{}:!\
A>`:5_5_P}l/>{}!H[:!,{K\')(K\'n/n/n/n/n/n/n/n/n/n/n/n/n/n/K\'h).>i)\'(C-B>D-l%\
x&=&i%a$Q}                                                                    \
                            ",
"            i=!\'k%b,;-Z:B>M\'l%M}Q<4_Y_f<g<8}Z_5_h:%}A>n/h)*>{}e[R}S}h:Y_4_f\
[/!V<4_Y_][Q*n/m/#>L\'n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/P!z>N{O^j)x]P^#>R*8;\
|*a$R!                                                                        \
                          ",
"            b,S!-&\'{]_P^U^U^T}]}5_Y_4_P}8;C-[}X_5_r}C-n/M{S{|}Y_Y_f<R}U}5_z}\
=&[!c<h:V}C>n/n/K\'n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(]!N{^!M\'O{h=Q*]_$>y&\
S*S*W}                                                                        \
                          ",
"            X}j%E>D>#>B>A>5;;&g<5_Y_4_Y}m/i)Z}f<e[`:O^n/M{n)c<Y_`}`_[!g[5_c<X\
[E>&}\'}S!V^n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(]!5;m/l/h/@>1_l%x&=&i%a$\
 |                                                                            \
                        ",
"            G<a$R!R*1_h/<^P!V^S{g<e[5_F[D-f:1}Y_c<o)M{n/P!O\'h}e[/}h/O^/}h: <\
T}7;.|b,L\'n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(>{L\',{\'(U^B>P{#>R*\'{E>\
a$j=                                                                          \
                            ",
"            +|-&\'{]_P^j)5;K\'n/L\'l~]}Y_C[+<a}Y_T<e<U^n/n/P!:!U}e[.<N{]!@|h}\
#|R*M{L\'h)n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(>{V^,{O^6;O{h=Z:E-$>y&S*X\
$$|                                                                           \
                           ",
"            F<|*}*Y$w]+>.>n/n/K\';-Q<Y_5_h:Y_Y_c<Z}#>V^K\'h)U!U<e[B}O^P!j%Y}E\
-h)n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(M{.>N{^!l/h/w]1_[*;-F-i=k%6< \
                                                                              \
                         ",
"            %|b,x&Z:--\'(>{n/n/n/Q*/[Y_Y_e[5_Y_5_U<2}O}y&j)U!R<5_&|O{n/5;O^)(\
n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(M{z>N{m/+>C-B>P{#>R*\'{E>a$i=*| \
                                                                              \
                         ",
"            =|y&Q!)}O{m/M{n/n/n/x]h[Y_e[(}i}R<e[Y_5_f<A}n}V<|}g:>}\'(n/n/n/n/\
n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(M{z>5;<^\'(j)x]h=Z:]_D>R!-&k%7<   \
                                                                              \
                         ",
"            $|=&b$1_h/m/h)n/n/n/O^P}Y_h:K}R*:!F[-|e[Y_e[2}G[y}0}--)(n/n/n/n/n\
/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(M{z>L\',{O^M\'/!w])}l%;-F-i=W$x(     \
                                                                              \
                         ",
"            ;|\'{E-P{C-<^h)n/n/n/N{.<e[e[#|h/M{x]n)&|h}9}~\'Z:T*A>K\'n/n/n/n/\
n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(M{]!L\',{^!+>C---P{#>R*8;E>X$a$p}   \
                                                                              \
                           ",
"            %|}*]_P^U^<^h)n/n/n/>{[}O<Y_A}x&K\'K\'z>D->|V!,{P!P!n/n/n/n/n/n/n\
/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/K\'P!M{z>V^i)m/+>U^x]h=Q*]_D>R!-&W$b:      \
                                                                              \
                          ",
"          ,|+|}*l%P^U^<^M{n/n/n/)(l~U<Y_U<U!)(n/n/K\']!>{n/n/n/n/n/n/n/n/n/n/\
n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/K\')(h)>{z>L\'i)<^\'(j)O{7;)}l%;-F-|*k%\'|      \
                                                                              \
                            ",
"          }*E>$>l%h=U^m/>{n/n/n/n/R*S<Y_O<V<M{n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n\
/n/n/n/n/n/n/n/n/n/n/n/K\')(P!h)>{z>.>5;i)m/\'(6;/!@>D-#>R*8;b,X$X$)|         \
                                                                              \
                         ",
"      Y$E>a$b,D>l%h=C-^!z>K\'n/n/n/--\'}4_!|W$)(n/n/n/n/n/n/n/n/n/n/n/n/n/n/n\
/n/n/n/n/n/n/n/n/n/K\')(P!h)M{>{z>.>L\'N{,{m/A>6;h/B>P{C>E-$>y&-&W$~|         \
                                                                              \
                           ",
"    x&k%\'\'a$b,$>[*P{h/O^L\')(n/n/n/^!b<B[e,L\'n/n/n/n/n/n/n/n/n/n/n/n/n/n/n\
/n/n/n/n/n/n/K\')(P!h)>{>{z>z>V^L\'5;N{,{<^O^+>j)/!B>P^Z:]_x&=&i=k%X$>-       \
                                                                              \
                             ",
"  =&*>}!\'\'a$b,$>[*P{O{+>N{h)n/n/n/P![*Q!.>n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n\
/n/n/K\')(h)M{]!z>.>L\'L\'5;N{i),{<^m/O^A>M\'U^O{B>P^Q*]_;-\'{|*a$;&x&        \
                                                                              \
                              ",
"  V!o)V!\'\'k%|*}*]_1_--M\'<^]!K\'n/n/n/P!)(n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n\
/K\')(P!>{z>.>L\'N{i),{,{<^m/m/^!\'(A>l/6;U^h/--w]P{Z:[*;-8;b,S*;&i%          \
                                                                              \
                              ",
"}*r]:!V!!\'W$i=\'{b$Q*@>j)^!L\'P!n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/K\'P\
!M{]!V^L\'N{,{<^^!O^\'(A>+>l/M\'6;j)U^h/O{--@>h=D-C>]_Q!8;y&-&j%a$Y$          \
                                                                              \
                              ",
"8;U!:![!e,j%i%=&Q!#>h=O{l/,{z>)(n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/n/K\'h)]!.>L\
\'i),{m/O^A>l/M\'j)j)C-C-h/O{O{x]B>@>7;P^1_Q*Y$E-x&8;y&-&j%c,{|               \
                                                                              \
                           ",
"  i%V!S{|!T*S*y&D>[*1_B>U^O^N{]!)(n/n/n/n/n/n/n/n/n/n/n/n/n/n/)(h)]!V^N{,{m/\
\'(A>M\'j)C-/!O{--B>@>w]7;h=h=P{D-1_Z:C>l%]_Q!D>=&E>S*W$c,T*]|                \
                                                                              \
                          ",
"    b,W!l~c,k%|*\'{R*C>h=O{M\'m/N{]!)(K\'n/n/n/n/n/n/n/n/n/K\'P!M{z>V^N{<^O^A\
>M\'U^h/x]--@>7;P^P{D-1_)}Z:C>C>#>Y$[*E-R*;-$>\'{y&|*X$j%\'\'!\'^|            \
                                                                              \
                                ",
"      =&!\'e,;&-&R!D>[*)}w]h/l/m/N{z>h))(K\'n/n/n/n/K\')(P!M{z>L\'i)<^O^+>j)h\
/O{B>7;P^D-)}Z:C>Y$l%[*E-E-b$R*Q!;-D>$>8;=&y&|*-&k%T*!\'|!1!                  \
                                                                              \
                            ",
"        }*c,c,k%|*8;Q!Y$D-@>C-l/m/i)V^]!M{P!)(P!h)M{]!.>L\'i)m/O^l/j)h/x]w]h=\
1_Q*#>Y$]_b$Q!;-x&D>}*8;8;\'{F-=&y&b,|*i%S*k%;&c,e,W!X$                       \
                                                                              \
                         ",
"          $>T*;&S*b,}*b$#>P{B>h/l/O^<^N{L\'.>.>.>.>L\'N{,{<^O^l/j)/!--w]P{)}C\
>l%E-Q!x&$>8;F-=&y&b,E>|*|*i=i%-&X$a$k%j%T*c,e,W!}!k%                         \
                                                                              \
                         ",
"            D>;&j%-&R!$>E-C>P{@>h/6;A>^!<^,{i)i)i)<^^!\'(l/j)/!--7;P{Q*#>]_R*\
x&}*F-R!b,|*i=i%-&i%i%|*i%i%S*j%j%T*\'\'!\'|!l~V!S{j%                         \
                                                                              \
                           ",
"              Q!j%k%i==&D>E-C>D-@>O{U^M\'+>\'(O^O^\'(+>M\'U^h/--w]P{Q*Y$]_Q!$\
>\'{R!E>i=-&i%/|)\'k}(|_|:|  <|  [|}|J<||R[i=a$W!U!;&                         \
                                                                              \
                             ",
"                x&W$a$i==&D>E-#>1_7;--O{C-U^j)j)U^h//!--w]P{Q*Y$]_Q!$>F-y&|*-\
&-&1|2|3|                                  }*                                 \
                                                                              \
                       ",
"                  x&W$a$i==&$>b$Y$Q*P^7;B>----x]--@>7;P{Q*#>]_Q!D>\'{b,i=-&4|\
5|6|                                                                          \
                                                                              \
                        ",
"                    $>k%k%i=R!}*Q![*#>Q*1_P{P^P{D-1_Z:Y$]_R*$>F-y&|*x(7|k}8| \
                                                                              \
                                                                              \
                       ",
"                      8;j%k%i%y&8;D>b$]_Y$#>C>#>l%[*E-Q!D>\'{R!|*i=z&l)      \
                                                                              \
                                                                              \
                        ",
"                        $>T*W$-&E>=&}*x&Q!b$R*R*Q!x&}*\'{R!|*-&-&b$          \
                                                                              \
                                                                              \
                        ",
"                          F-T*j%X$i=b,=&F-\'{8;\'{\'{R!b,|*S*k%k%E-          \
                                                                              \
                                                                              \
                          ",
"                            R!c,T*W$X$i%i=|*E>|*i=-&S*k%;&W$R*               \
                                                                              \
                                                                              \
                       ",
"                              |*e,!\'T*j%W$k%a$k%W$j%T*c,__9|                \
                                                                              \
                                                                              \
                        ",
"                                S*|!*>e,c,c,c,c,\'\'e,e,]{0|                 \
                                                                              \
                                                                              \
                         ",
"                                  k%[!V!l~W!W!l~}!}!i%                       \
                                                                              \
                                                                              \
                       ",
"                                    c,;(;(U!<!<![!X$                         \
                                                                              \
                                                                              \
                       ",
"                                      |!r]r]a|b|6<                           \
                                                                              \
                                                                              \
                       ",
"                                        l~c|d|                               \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       ",
"                                                                             \
                                                                              \
                                                                              \
                       "
};
static Fl_Pixmap image_icono_rakarrack_128x128(idata_icono_rakarrack_128x128);

void RKRGUI::cb_OK_i(Fl_Button*, void*) {
  AboutWin->hide();
}
void RKRGUI::cb_OK(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_OK_i(o,v);
}

void RKRGUI::cb_LICENSE_i(Fl_Button*, void*) {
  show_lic();
}
void RKRGUI::cb_LICENSE(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_LICENSE_i(o,v);
}

Fl_Double_Window* RKRGUI::make_window() {
  { Principal = new Fl_Double_Window(800, 599);
    Principal->box(FL_DOWN_BOX);
    Principal->color((Fl_Color)178);
    Principal->callback((Fl_Callback*)cb_Principal, (void*)(this));
    { MenuP = new Fl_Menu_Bar(2, 2, 795, 18);
      MenuP->down_box(FL_DOWN_BOX);
      MenuP->color((Fl_Color)178);
      MenuP->selection_color(FL_BACKGROUND2_COLOR);
      MenuP->labelcolor(FL_BACKGROUND2_COLOR);
      MenuP->textcolor(7);
      MenuP->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      MenuP->menu(menu_MenuP);
    } // Fl_Menu_Bar* MenuP
    { MT = new Fl_Box(579, 128, 20, 22);
      MT->labelsize(18);
      MT->callback((Fl_Callback*)cb_MT);
    } // Fl_Box* MT
    { TITTLE_L = new Fl_Box(545, 23, 226, 32, gettext("Rakarrack"));
      TITTLE_L->labelfont(1);
      TITTLE_L->labelsize(40);
      TITTLE_L->labelcolor(FL_BACKGROUND2_COLOR);
      TITTLE_L->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    } // Fl_Box* TITTLE_L
    { DESC_L = new Fl_Box(588, 59, 142, 14, gettext("Guitar Effects"));
      DESC_L->labelfont(1);
      DESC_L->labelsize(16);
      DESC_L->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* DESC_L
    { Open_Order = new Fl_Button(258, 154, 195, 25, gettext("Put Order in your Rack"));
      Open_Order->shortcut(0x6f);
      Open_Order->color((Fl_Color)62);
      Open_Order->callback((Fl_Callback*)cb_Open_Order);
      Open_Order->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
      Open_Order->when(FL_WHEN_RELEASE_ALWAYS);
    } // Fl_Button* Open_Order
    { E1 = new Fl_Box(2, 212, 1, 1);
      E1->labelsize(18);
      E1->hide();
      E1->deactivate();
    } // Fl_Box* E1
    { E2 = new Fl_Box(162, 212, 1, 1);
      E2->labelsize(18);
      E2->hide();
      E2->deactivate();
    } // Fl_Box* E2
    { E3 = new Fl_Box(321, 212, 1, 1);
      E3->labelsize(18);
      E3->hide();
      E3->deactivate();
    } // Fl_Box* E3
    { E4 = new Fl_Box(480, 212, 1, 1);
      E4->labelsize(18);
      E4->hide();
      E4->deactivate();
    } // Fl_Box* E4
    { E5 = new Fl_Box(639, 212, 1, 1);
      E5->labelsize(18);
      E5->hide();
      E5->deactivate();
    } // Fl_Box* E5
    { E6 = new Fl_Box(2, 413, 1, 1);
      E6->labelsize(18);
      E6->hide();
      E6->deactivate();
    } // Fl_Box* E6
    { E7 = new Fl_Box(161, 413, 1, 1);
      E7->labelsize(18);
      E7->hide();
      E7->deactivate();
    } // Fl_Box* E7
    { E8 = new Fl_Box(321, 413, 1, 1);
      E8->labelsize(18);
      E8->hide();
      E8->deactivate();
    } // Fl_Box* E8
    { E9 = new Fl_Box(480, 413, 1, 1);
      E9->labelsize(18);
      E9->hide();
      E9->deactivate();
    } // Fl_Box* E9
    { E10 = new Fl_Box(639, 413, 1, 1);
      E10->labelsize(18);
      E10->hide();
      E10->deactivate();
    } // Fl_Box* E10
    { EQ = new Fl_Group(2, 212, 158, 184, gettext("EQ"));
      EQ->box(FL_PLASTIC_DOWN_FRAME);
      EQ->color(FL_BACKGROUND2_COLOR);
      EQ->selection_color(FL_BACKGROUND2_COLOR);
      EQ->labelfont(1);
      EQ->labelcolor(FL_BACKGROUND2_COLOR);
      { eq_activar = new Fl_Light_Button(7, 216, 34, 18, gettext("On"));
        eq_activar->shortcut(0x31);
        eq_activar->color((Fl_Color)62);
        eq_activar->selection_color((Fl_Color)1);
        eq_activar->labelsize(10);
        eq_activar->callback((Fl_Callback*)cb_eq_activar);
        eq_activar->align(68|FL_ALIGN_INSIDE);
        eq_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* eq_activar
      { eq_preset = new Fl_Choice(79, 216, 76, 18, gettext("Preset"));
        eq_preset->down_box(FL_BORDER_BOX);
        eq_preset->selection_color(FL_FOREGROUND_COLOR);
        eq_preset->labelsize(10);
        eq_preset->labelcolor(FL_BACKGROUND2_COLOR);
        eq_preset->textsize(10);
        eq_preset->callback((Fl_Callback*)cb_eq_preset);
        eq_preset->when(FL_WHEN_RELEASE_ALWAYS);
        eq_preset->menu(menu_eq_preset);
      } // Fl_Choice* eq_preset
      { eq_Gain = new SliderW(51, 238, 100, 10, gettext("Gain"));
        eq_Gain->type(5);
        eq_Gain->box(FL_FLAT_BOX);
        eq_Gain->color((Fl_Color)178);
        eq_Gain->selection_color((Fl_Color)62);
        eq_Gain->labeltype(FL_NORMAL_LABEL);
        eq_Gain->labelfont(0);
        eq_Gain->labelsize(10);
        eq_Gain->labelcolor(FL_BACKGROUND2_COLOR);
        eq_Gain->minimum(-64);
        eq_Gain->maximum(63);
        eq_Gain->step(1);
        eq_Gain->textcolor(7);
        eq_Gain->callback((Fl_Callback*)cb_eq_Gain);
        eq_Gain->align(FL_ALIGN_LEFT);
        eq_Gain->when(FL_WHEN_CHANGED);
      } // SliderW* eq_Gain
      { eq_Q = new SliderW(51, 251, 100, 10, gettext("Q"));
        eq_Q->type(5);
        eq_Q->box(FL_FLAT_BOX);
        eq_Q->color((Fl_Color)178);
        eq_Q->selection_color((Fl_Color)62);
        eq_Q->labeltype(FL_NORMAL_LABEL);
        eq_Q->labelfont(0);
        eq_Q->labelsize(10);
        eq_Q->labelcolor(FL_BACKGROUND2_COLOR);
        eq_Q->minimum(-64);
        eq_Q->maximum(63);
        eq_Q->step(1);
        eq_Q->textcolor(7);
        eq_Q->callback((Fl_Callback*)cb_eq_Q);
        eq_Q->align(FL_ALIGN_LEFT);
        eq_Q->when(FL_WHEN_CHANGED);
      } // SliderW* eq_Q
      { eq_1 = new SliderW(51, 270, 100, 10, gettext("31 Hz"));
        eq_1->type(5);
        eq_1->box(FL_FLAT_BOX);
        eq_1->color((Fl_Color)178);
        eq_1->selection_color((Fl_Color)62);
        eq_1->labeltype(FL_NORMAL_LABEL);
        eq_1->labelfont(0);
        eq_1->labelsize(10);
        eq_1->labelcolor(FL_BACKGROUND2_COLOR);
        eq_1->minimum(-64);
        eq_1->maximum(63);
        eq_1->step(1);
        eq_1->textcolor(7);
        eq_1->callback((Fl_Callback*)cb_eq_1);
        eq_1->align(FL_ALIGN_LEFT);
        eq_1->when(FL_WHEN_CHANGED);
      } // SliderW* eq_1
      { eq_2 = new SliderW(51, 282, 100, 10, gettext("63 Hz"));
        eq_2->type(5);
        eq_2->box(FL_FLAT_BOX);
        eq_2->color((Fl_Color)178);
        eq_2->selection_color((Fl_Color)62);
        eq_2->labeltype(FL_NORMAL_LABEL);
        eq_2->labelfont(0);
        eq_2->labelsize(10);
        eq_2->labelcolor(FL_BACKGROUND2_COLOR);
        eq_2->minimum(-64);
        eq_2->maximum(63);
        eq_2->step(1);
        eq_2->textcolor(7);
        eq_2->callback((Fl_Callback*)cb_eq_2);
        eq_2->align(FL_ALIGN_LEFT);
        eq_2->when(FL_WHEN_CHANGED);
      } // SliderW* eq_2
      { eq_3 = new SliderW(51, 294, 100, 10, gettext("125 Hz"));
        eq_3->type(5);
        eq_3->box(FL_FLAT_BOX);
        eq_3->color((Fl_Color)178);
        eq_3->selection_color((Fl_Color)62);
        eq_3->labeltype(FL_NORMAL_LABEL);
        eq_3->labelfont(0);
        eq_3->labelsize(10);
        eq_3->labelcolor(FL_BACKGROUND2_COLOR);
        eq_3->minimum(-64);
        eq_3->maximum(63);
        eq_3->step(1);
        eq_3->textcolor(7);
        eq_3->callback((Fl_Callback*)cb_eq_3);
        eq_3->align(FL_ALIGN_LEFT);
        eq_3->when(FL_WHEN_CHANGED);
      } // SliderW* eq_3
      { eq_4 = new SliderW(51, 307, 100, 10, gettext("250 Hz"));
        eq_4->type(5);
        eq_4->box(FL_FLAT_BOX);
        eq_4->color((Fl_Color)178);
        eq_4->selection_color((Fl_Color)62);
        eq_4->labeltype(FL_NORMAL_LABEL);
        eq_4->labelfont(0);
        eq_4->labelsize(10);
        eq_4->labelcolor(FL_BACKGROUND2_COLOR);
        eq_4->minimum(-64);
        eq_4->maximum(63);
        eq_4->step(1);
        eq_4->textcolor(7);
        eq_4->callback((Fl_Callback*)cb_eq_4);
        eq_4->align(FL_ALIGN_LEFT);
        eq_4->when(FL_WHEN_CHANGED);
      } // SliderW* eq_4
      { eq_5 = new SliderW(51, 319, 100, 10, gettext("500 Hz"));
        eq_5->type(5);
        eq_5->box(FL_FLAT_BOX);
        eq_5->color((Fl_Color)178);
        eq_5->selection_color((Fl_Color)62);
        eq_5->labeltype(FL_NORMAL_LABEL);
        eq_5->labelfont(0);
        eq_5->labelsize(10);
        eq_5->labelcolor(FL_BACKGROUND2_COLOR);
        eq_5->minimum(-64);
        eq_5->maximum(63);
        eq_5->step(1);
        eq_5->textcolor(7);
        eq_5->callback((Fl_Callback*)cb_eq_5);
        eq_5->align(FL_ALIGN_LEFT);
        eq_5->when(FL_WHEN_CHANGED);
      } // SliderW* eq_5
      { eq_6 = new SliderW(51, 331, 100, 10, gettext("1 Khz"));
        eq_6->type(5);
        eq_6->box(FL_FLAT_BOX);
        eq_6->color((Fl_Color)178);
        eq_6->selection_color((Fl_Color)62);
        eq_6->labeltype(FL_NORMAL_LABEL);
        eq_6->labelfont(0);
        eq_6->labelsize(10);
        eq_6->labelcolor(FL_BACKGROUND2_COLOR);
        eq_6->minimum(-64);
        eq_6->maximum(63);
        eq_6->step(1);
        eq_6->textcolor(7);
        eq_6->callback((Fl_Callback*)cb_eq_6);
        eq_6->align(FL_ALIGN_LEFT);
        eq_6->when(FL_WHEN_CHANGED);
      } // SliderW* eq_6
      { eq_7 = new SliderW(51, 344, 100, 10, gettext("2 Khz"));
        eq_7->type(5);
        eq_7->box(FL_FLAT_BOX);
        eq_7->color((Fl_Color)178);
        eq_7->selection_color((Fl_Color)62);
        eq_7->labeltype(FL_NORMAL_LABEL);
        eq_7->labelfont(0);
        eq_7->labelsize(10);
        eq_7->labelcolor(FL_BACKGROUND2_COLOR);
        eq_7->minimum(-64);
        eq_7->maximum(63);
        eq_7->step(1);
        eq_7->textcolor(7);
        eq_7->callback((Fl_Callback*)cb_eq_7);
        eq_7->align(FL_ALIGN_LEFT);
        eq_7->when(FL_WHEN_CHANGED);
      } // SliderW* eq_7
      { eq_8 = new SliderW(51, 356, 100, 10, gettext("4 Khz"));
        eq_8->type(5);
        eq_8->box(FL_FLAT_BOX);
        eq_8->color((Fl_Color)178);
        eq_8->selection_color((Fl_Color)62);
        eq_8->labeltype(FL_NORMAL_LABEL);
        eq_8->labelfont(0);
        eq_8->labelsize(10);
        eq_8->labelcolor(FL_BACKGROUND2_COLOR);
        eq_8->minimum(-64);
        eq_8->maximum(63);
        eq_8->step(1);
        eq_8->textcolor(7);
        eq_8->callback((Fl_Callback*)cb_eq_8);
        eq_8->align(FL_ALIGN_LEFT);
        eq_8->when(FL_WHEN_CHANGED);
      } // SliderW* eq_8
      { eq_9 = new SliderW(51, 368, 100, 10, gettext("8 Khz"));
        eq_9->type(5);
        eq_9->box(FL_FLAT_BOX);
        eq_9->color((Fl_Color)178);
        eq_9->selection_color((Fl_Color)62);
        eq_9->labeltype(FL_NORMAL_LABEL);
        eq_9->labelfont(0);
        eq_9->labelsize(10);
        eq_9->labelcolor(FL_BACKGROUND2_COLOR);
        eq_9->minimum(-64);
        eq_9->maximum(63);
        eq_9->step(1);
        eq_9->textcolor(7);
        eq_9->callback((Fl_Callback*)cb_eq_9);
        eq_9->align(FL_ALIGN_LEFT);
        eq_9->when(FL_WHEN_CHANGED);
      } // SliderW* eq_9
      { eq_10 = new SliderW(51, 381, 100, 10, gettext("16 Khz"));
        eq_10->type(5);
        eq_10->box(FL_FLAT_BOX);
        eq_10->color((Fl_Color)178);
        eq_10->selection_color((Fl_Color)62);
        eq_10->labeltype(FL_NORMAL_LABEL);
        eq_10->labelfont(0);
        eq_10->labelsize(10);
        eq_10->labelcolor(FL_BACKGROUND2_COLOR);
        eq_10->minimum(-64);
        eq_10->maximum(63);
        eq_10->step(1);
        eq_10->textcolor(7);
        eq_10->callback((Fl_Callback*)cb_eq_10);
        eq_10->align(FL_ALIGN_LEFT);
        eq_10->when(FL_WHEN_CHANGED);
      } // SliderW* eq_10
      EQ->end();
    } // Fl_Group* EQ
    { COMPRESS = new Fl_Group(161, 212, 158, 184, gettext("Compressor"));
      COMPRESS->box(FL_PLASTIC_DOWN_FRAME);
      COMPRESS->color(FL_BACKGROUND2_COLOR);
      COMPRESS->labelfont(1);
      COMPRESS->labelcolor(FL_BACKGROUND2_COLOR);
      { compress_activar = new Fl_Light_Button(166, 216, 34, 18, gettext("On"));
        compress_activar->shortcut(0x32);
        compress_activar->color((Fl_Color)62);
        compress_activar->selection_color((Fl_Color)1);
        compress_activar->labelsize(10);
        compress_activar->callback((Fl_Callback*)cb_compress_activar);
        compress_activar->align(68|FL_ALIGN_INSIDE);
        compress_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* compress_activar
      { compress_preset = new Fl_Choice(239, 216, 76, 18, gettext("Preset"));
        compress_preset->down_box(FL_BORDER_BOX);
        compress_preset->selection_color(FL_FOREGROUND_COLOR);
        compress_preset->labelsize(10);
        compress_preset->labelcolor(FL_BACKGROUND2_COLOR);
        compress_preset->textsize(10);
        compress_preset->callback((Fl_Callback*)cb_compress_preset);
        compress_preset->when(FL_WHEN_RELEASE_ALWAYS);
        compress_preset->menu(menu_compress_preset);
      } // Fl_Choice* compress_preset
      { compress_ATime = new SliderW(212, 251, 100, 10, gettext("A. Time"));
        compress_ATime->type(5);
        compress_ATime->box(FL_FLAT_BOX);
        compress_ATime->color((Fl_Color)178);
        compress_ATime->selection_color((Fl_Color)62);
        compress_ATime->labeltype(FL_NORMAL_LABEL);
        compress_ATime->labelfont(0);
        compress_ATime->labelsize(10);
        compress_ATime->labelcolor(FL_BACKGROUND2_COLOR);
        compress_ATime->minimum(10);
        compress_ATime->maximum(250);
        compress_ATime->step(1);
        compress_ATime->value(2);
        compress_ATime->textcolor(7);
        compress_ATime->callback((Fl_Callback*)cb_compress_ATime);
        compress_ATime->align(FL_ALIGN_LEFT);
        compress_ATime->when(FL_WHEN_CHANGED);
      } // SliderW* compress_ATime
      { compress_RTime = new SliderW(211, 273, 100, 10, gettext("R. Time"));
        compress_RTime->type(5);
        compress_RTime->box(FL_FLAT_BOX);
        compress_RTime->color((Fl_Color)178);
        compress_RTime->selection_color((Fl_Color)62);
        compress_RTime->labeltype(FL_NORMAL_LABEL);
        compress_RTime->labelfont(0);
        compress_RTime->labelsize(10);
        compress_RTime->labelcolor(FL_BACKGROUND2_COLOR);
        compress_RTime->minimum(10);
        compress_RTime->maximum(250);
        compress_RTime->step(1);
        compress_RTime->value(120);
        compress_RTime->textcolor(7);
        compress_RTime->callback((Fl_Callback*)cb_compress_RTime);
        compress_RTime->align(FL_ALIGN_LEFT);
        compress_RTime->when(FL_WHEN_CHANGED);
      } // SliderW* compress_RTime
      { compress_Ratio = new SliderW(211, 295, 100, 10, gettext("Ratio"));
        compress_Ratio->type(5);
        compress_Ratio->box(FL_FLAT_BOX);
        compress_Ratio->color((Fl_Color)178);
        compress_Ratio->selection_color((Fl_Color)62);
        compress_Ratio->labeltype(FL_NORMAL_LABEL);
        compress_Ratio->labelfont(0);
        compress_Ratio->labelsize(10);
        compress_Ratio->labelcolor(FL_BACKGROUND2_COLOR);
        compress_Ratio->minimum(1);
        compress_Ratio->maximum(40);
        compress_Ratio->step(1);
        compress_Ratio->value(2);
        compress_Ratio->textcolor(7);
        compress_Ratio->callback((Fl_Callback*)cb_compress_Ratio);
        compress_Ratio->align(FL_ALIGN_LEFT);
        compress_Ratio->when(FL_WHEN_CHANGED);
      } // SliderW* compress_Ratio
      { compress_output = new SliderW(211, 339, 100, 10, gettext("Output"));
        compress_output->type(5);
        compress_output->box(FL_FLAT_BOX);
        compress_output->color((Fl_Color)178);
        compress_output->selection_color((Fl_Color)62);
        compress_output->labeltype(FL_NORMAL_LABEL);
        compress_output->labelfont(0);
        compress_output->labelsize(10);
        compress_output->labelcolor(FL_BACKGROUND2_COLOR);
        compress_output->minimum(-20);
        compress_output->maximum(20);
        compress_output->step(1);
        compress_output->textcolor(7);
        compress_output->callback((Fl_Callback*)cb_compress_output);
        compress_output->align(FL_ALIGN_LEFT);
        compress_output->when(FL_WHEN_CHANGED);
      } // SliderW* compress_output
      { compress_threshold = new SliderW(211, 317, 100, 10, gettext("Thrhold"));
        compress_threshold->type(5);
        compress_threshold->box(FL_FLAT_BOX);
        compress_threshold->color((Fl_Color)178);
        compress_threshold->selection_color((Fl_Color)62);
        compress_threshold->labeltype(FL_NORMAL_LABEL);
        compress_threshold->labelfont(0);
        compress_threshold->labelsize(10);
        compress_threshold->labelcolor(FL_BACKGROUND2_COLOR);
        compress_threshold->minimum(-48);
        compress_threshold->maximum(0);
        compress_threshold->step(1);
        compress_threshold->textcolor(7);
        compress_threshold->callback((Fl_Callback*)cb_compress_threshold);
        compress_threshold->align(FL_ALIGN_LEFT);
        compress_threshold->when(FL_WHEN_CHANGED);
      } // SliderW* compress_threshold
      { Auto_Output = new Fl_Check_Button(198, 362, 20, 15, gettext("Auto Output"));
        Auto_Output->down_box(FL_DOWN_BOX);
        Auto_Output->labelsize(10);
        Auto_Output->labelcolor(FL_BACKGROUND2_COLOR);
        Auto_Output->callback((Fl_Callback*)cb_Auto_Output);
      } // Fl_Check_Button* Auto_Output
      COMPRESS->end();
    } // Fl_Group* COMPRESS
    { DIST = new Fl_Group(321, 212, 158, 184, gettext("Distortion"));
      DIST->box(FL_PLASTIC_DOWN_FRAME);
      DIST->color(FL_BACKGROUND2_COLOR);
      DIST->labelfont(1);
      DIST->labelcolor(FL_BACKGROUND2_COLOR);
      { dist_activar = new Fl_Light_Button(326, 216, 34, 18, gettext("On"));
        dist_activar->shortcut(0x33);
        dist_activar->color((Fl_Color)62);
        dist_activar->selection_color((Fl_Color)1);
        dist_activar->labelsize(10);
        dist_activar->callback((Fl_Callback*)cb_dist_activar);
        dist_activar->align(68|FL_ALIGN_INSIDE);
        dist_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* dist_activar
      { dist_preset = new Fl_Choice(398, 216, 76, 18, gettext("Preset"));
        dist_preset->down_box(FL_BORDER_BOX);
        dist_preset->selection_color(FL_FOREGROUND_COLOR);
        dist_preset->labelsize(10);
        dist_preset->labelcolor(FL_BACKGROUND2_COLOR);
        dist_preset->textsize(10);
        dist_preset->callback((Fl_Callback*)cb_dist_preset);
        dist_preset->when(FL_WHEN_RELEASE_ALWAYS);
        dist_preset->menu(menu_dist_preset);
      } // Fl_Choice* dist_preset
      { dist_WD = new SliderW(373, 247, 100, 10, gettext("Wet/Dry"));
        dist_WD->type(5);
        dist_WD->box(FL_FLAT_BOX);
        dist_WD->color((Fl_Color)178);
        dist_WD->selection_color((Fl_Color)62);
        dist_WD->labeltype(FL_NORMAL_LABEL);
        dist_WD->labelfont(0);
        dist_WD->labelsize(10);
        dist_WD->labelcolor(FL_BACKGROUND2_COLOR);
        dist_WD->minimum(-64);
        dist_WD->maximum(63);
        dist_WD->step(1);
        dist_WD->textcolor(7);
        dist_WD->callback((Fl_Callback*)cb_dist_WD);
        dist_WD->align(FL_ALIGN_LEFT);
        dist_WD->when(FL_WHEN_CHANGED);
      } // SliderW* dist_WD
      { dist_LRc = new SliderW(373, 260, 100, 10, gettext("L/R.Cr"));
        dist_LRc->type(5);
        dist_LRc->box(FL_FLAT_BOX);
        dist_LRc->color((Fl_Color)178);
        dist_LRc->selection_color((Fl_Color)62);
        dist_LRc->labeltype(FL_NORMAL_LABEL);
        dist_LRc->labelfont(0);
        dist_LRc->labelsize(10);
        dist_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        dist_LRc->minimum(-64);
        dist_LRc->maximum(63);
        dist_LRc->step(1);
        dist_LRc->textcolor(7);
        dist_LRc->callback((Fl_Callback*)cb_dist_LRc);
        dist_LRc->align(FL_ALIGN_LEFT);
        dist_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* dist_LRc
      { dist_drive = new SliderW(373, 273, 100, 10, gettext("Drive"));
        dist_drive->type(5);
        dist_drive->box(FL_FLAT_BOX);
        dist_drive->color((Fl_Color)178);
        dist_drive->selection_color((Fl_Color)62);
        dist_drive->labeltype(FL_NORMAL_LABEL);
        dist_drive->labelfont(0);
        dist_drive->labelsize(10);
        dist_drive->labelcolor(FL_BACKGROUND2_COLOR);
        dist_drive->maximum(127);
        dist_drive->step(1);
        dist_drive->textcolor(7);
        dist_drive->callback((Fl_Callback*)cb_dist_drive);
        dist_drive->align(FL_ALIGN_LEFT);
        dist_drive->when(FL_WHEN_CHANGED);
      } // SliderW* dist_drive
      { dist_level = new SliderW(373, 287, 100, 10, gettext("Level"));
        dist_level->type(5);
        dist_level->box(FL_FLAT_BOX);
        dist_level->color((Fl_Color)178);
        dist_level->selection_color((Fl_Color)62);
        dist_level->labeltype(FL_NORMAL_LABEL);
        dist_level->labelfont(0);
        dist_level->labelsize(10);
        dist_level->labelcolor(FL_BACKGROUND2_COLOR);
        dist_level->maximum(127);
        dist_level->step(1);
        dist_level->textcolor(7);
        dist_level->callback((Fl_Callback*)cb_dist_level);
        dist_level->align(FL_ALIGN_LEFT);
        dist_level->when(FL_WHEN_CHANGED);
      } // SliderW* dist_level
      { dist_tipo = new Fl_Choice(355, 303, 70, 16, gettext("Type"));
        dist_tipo->down_box(FL_BORDER_BOX);
        dist_tipo->selection_color(FL_FOREGROUND_COLOR);
        dist_tipo->labelsize(10);
        dist_tipo->labelcolor(FL_BACKGROUND2_COLOR);
        dist_tipo->textsize(10);
        dist_tipo->callback((Fl_Callback*)cb_dist_tipo);
        dist_tipo->menu(menu_dist_tipo);
      } // Fl_Choice* dist_tipo
      { dist_neg = new Fl_Check_Button(431, 304, 40, 15, gettext("Neg."));
        dist_neg->down_box(FL_DOWN_BOX);
        dist_neg->labelsize(10);
        dist_neg->labelcolor(FL_BACKGROUND2_COLOR);
        dist_neg->callback((Fl_Callback*)cb_dist_neg);
      } // Fl_Check_Button* dist_neg
      { dist_st = new Fl_Check_Button(367, 322, 30, 15, gettext("Stereo"));
        dist_st->down_box(FL_DOWN_BOX);
        dist_st->labelsize(10);
        dist_st->labelcolor(FL_BACKGROUND2_COLOR);
        dist_st->callback((Fl_Callback*)cb_dist_st);
      } // Fl_Check_Button* dist_st
      { dist_pan = new SliderW(373, 337, 100, 10, gettext("Pan"));
        dist_pan->type(5);
        dist_pan->box(FL_FLAT_BOX);
        dist_pan->color((Fl_Color)178);
        dist_pan->selection_color((Fl_Color)62);
        dist_pan->labeltype(FL_NORMAL_LABEL);
        dist_pan->labelfont(0);
        dist_pan->labelsize(10);
        dist_pan->labelcolor(FL_BACKGROUND2_COLOR);
        dist_pan->minimum(-64);
        dist_pan->maximum(63);
        dist_pan->step(1);
        dist_pan->textcolor(7);
        dist_pan->callback((Fl_Callback*)cb_dist_pan);
        dist_pan->align(FL_ALIGN_LEFT);
        dist_pan->when(FL_WHEN_CHANGED);
      } // SliderW* dist_pan
      { dist_pf = new Fl_Check_Button(367, 350, 30, 15, gettext("Pre Filter"));
        dist_pf->down_box(FL_DOWN_BOX);
        dist_pf->labelsize(10);
        dist_pf->labelcolor(FL_BACKGROUND2_COLOR);
        dist_pf->callback((Fl_Callback*)cb_dist_pf);
      } // Fl_Check_Button* dist_pf
      { dist_lpf = new SliderW(373, 369, 100, 10, gettext("LPF"));
        dist_lpf->type(5);
        dist_lpf->box(FL_FLAT_BOX);
        dist_lpf->color((Fl_Color)178);
        dist_lpf->selection_color((Fl_Color)62);
        dist_lpf->labeltype(FL_NORMAL_LABEL);
        dist_lpf->labelfont(0);
        dist_lpf->labelsize(10);
        dist_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        dist_lpf->maximum(127);
        dist_lpf->step(1);
        dist_lpf->textcolor(7);
        dist_lpf->callback((Fl_Callback*)cb_dist_lpf);
        dist_lpf->align(FL_ALIGN_LEFT);
        dist_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* dist_lpf
      { dist_hpf = new SliderW(373, 381, 100, 10, gettext("HPF"));
        dist_hpf->type(5);
        dist_hpf->box(FL_FLAT_BOX);
        dist_hpf->color((Fl_Color)178);
        dist_hpf->selection_color((Fl_Color)62);
        dist_hpf->labeltype(FL_NORMAL_LABEL);
        dist_hpf->labelfont(0);
        dist_hpf->labelsize(10);
        dist_hpf->labelcolor(FL_BACKGROUND2_COLOR);
        dist_hpf->maximum(127);
        dist_hpf->step(1);
        dist_hpf->textcolor(7);
        dist_hpf->callback((Fl_Callback*)cb_dist_hpf);
        dist_hpf->align(FL_ALIGN_LEFT);
        dist_hpf->when(FL_WHEN_CHANGED);
      } // SliderW* dist_hpf
      DIST->end();
    } // Fl_Group* DIST
    { OVRD = new Fl_Group(480, 212, 158, 184, gettext("Overdrive"));
      OVRD->box(FL_PLASTIC_DOWN_FRAME);
      OVRD->color(FL_BACKGROUND2_COLOR);
      OVRD->labelfont(1);
      OVRD->labelcolor(FL_BACKGROUND2_COLOR);
      { ovrd_activar = new Fl_Light_Button(485, 216, 34, 18, gettext("On"));
        ovrd_activar->shortcut(0x34);
        ovrd_activar->color((Fl_Color)62);
        ovrd_activar->selection_color((Fl_Color)1);
        ovrd_activar->labelsize(10);
        ovrd_activar->callback((Fl_Callback*)cb_ovrd_activar);
        ovrd_activar->align(68|FL_ALIGN_INSIDE);
        ovrd_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* ovrd_activar
      { ovrd_preset = new Fl_Choice(557, 216, 76, 18, gettext("Preset"));
        ovrd_preset->down_box(FL_BORDER_BOX);
        ovrd_preset->selection_color(FL_FOREGROUND_COLOR);
        ovrd_preset->labelsize(10);
        ovrd_preset->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_preset->textsize(10);
        ovrd_preset->callback((Fl_Callback*)cb_ovrd_preset);
        ovrd_preset->when(FL_WHEN_RELEASE_ALWAYS);
        ovrd_preset->menu(menu_ovrd_preset);
      } // Fl_Choice* ovrd_preset
      { ovrd_WD = new SliderW(531, 247, 100, 10, gettext("Wet/Dry"));
        ovrd_WD->type(5);
        ovrd_WD->box(FL_FLAT_BOX);
        ovrd_WD->color((Fl_Color)178);
        ovrd_WD->selection_color((Fl_Color)62);
        ovrd_WD->labeltype(FL_NORMAL_LABEL);
        ovrd_WD->labelfont(0);
        ovrd_WD->labelsize(10);
        ovrd_WD->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_WD->minimum(-64);
        ovrd_WD->maximum(63);
        ovrd_WD->step(1);
        ovrd_WD->textcolor(7);
        ovrd_WD->callback((Fl_Callback*)cb_ovrd_WD);
        ovrd_WD->align(FL_ALIGN_LEFT);
        ovrd_WD->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_WD
      { ovrd_LRc = new SliderW(531, 260, 100, 10, gettext("L/R Cr."));
        ovrd_LRc->type(5);
        ovrd_LRc->box(FL_FLAT_BOX);
        ovrd_LRc->color((Fl_Color)178);
        ovrd_LRc->selection_color((Fl_Color)62);
        ovrd_LRc->labeltype(FL_NORMAL_LABEL);
        ovrd_LRc->labelfont(0);
        ovrd_LRc->labelsize(10);
        ovrd_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_LRc->minimum(-64);
        ovrd_LRc->maximum(63);
        ovrd_LRc->step(1);
        ovrd_LRc->textcolor(7);
        ovrd_LRc->callback((Fl_Callback*)cb_ovrd_LRc);
        ovrd_LRc->align(FL_ALIGN_LEFT);
        ovrd_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_LRc
      { ovrd_drive = new SliderW(531, 273, 100, 10, gettext("Drive"));
        ovrd_drive->type(5);
        ovrd_drive->box(FL_FLAT_BOX);
        ovrd_drive->color((Fl_Color)178);
        ovrd_drive->selection_color((Fl_Color)62);
        ovrd_drive->labeltype(FL_NORMAL_LABEL);
        ovrd_drive->labelfont(0);
        ovrd_drive->labelsize(10);
        ovrd_drive->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_drive->maximum(127);
        ovrd_drive->step(1);
        ovrd_drive->textcolor(7);
        ovrd_drive->callback((Fl_Callback*)cb_ovrd_drive);
        ovrd_drive->align(FL_ALIGN_LEFT);
        ovrd_drive->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_drive
      { ovrd_level = new SliderW(531, 287, 100, 10, gettext("Level"));
        ovrd_level->type(5);
        ovrd_level->box(FL_FLAT_BOX);
        ovrd_level->color((Fl_Color)178);
        ovrd_level->selection_color((Fl_Color)62);
        ovrd_level->labeltype(FL_NORMAL_LABEL);
        ovrd_level->labelfont(0);
        ovrd_level->labelsize(10);
        ovrd_level->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_level->maximum(127);
        ovrd_level->step(1);
        ovrd_level->textcolor(7);
        ovrd_level->callback((Fl_Callback*)cb_ovrd_level);
        ovrd_level->align(FL_ALIGN_LEFT);
        ovrd_level->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_level
      { ovrd_tipo = new Fl_Choice(513, 303, 72, 16, gettext("Type"));
        ovrd_tipo->down_box(FL_BORDER_BOX);
        ovrd_tipo->selection_color(FL_FOREGROUND_COLOR);
        ovrd_tipo->labelsize(10);
        ovrd_tipo->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_tipo->textsize(10);
        ovrd_tipo->callback((Fl_Callback*)cb_ovrd_tipo);
        ovrd_tipo->menu(menu_ovrd_tipo);
      } // Fl_Choice* ovrd_tipo
      { ovrd_neg = new Fl_Check_Button(589, 304, 46, 15, gettext("Neg."));
        ovrd_neg->down_box(FL_DOWN_BOX);
        ovrd_neg->labelsize(10);
        ovrd_neg->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_neg->callback((Fl_Callback*)cb_ovrd_neg);
      } // Fl_Check_Button* ovrd_neg
      { ovrd_st = new Fl_Check_Button(521, 322, 30, 15, gettext("Stereo"));
        ovrd_st->down_box(FL_DOWN_BOX);
        ovrd_st->labelsize(10);
        ovrd_st->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_st->callback((Fl_Callback*)cb_ovrd_st);
      } // Fl_Check_Button* ovrd_st
      { ovrd_pan = new SliderW(531, 337, 100, 10, gettext("Pan"));
        ovrd_pan->type(5);
        ovrd_pan->box(FL_FLAT_BOX);
        ovrd_pan->color((Fl_Color)178);
        ovrd_pan->selection_color((Fl_Color)62);
        ovrd_pan->labeltype(FL_NORMAL_LABEL);
        ovrd_pan->labelfont(0);
        ovrd_pan->labelsize(10);
        ovrd_pan->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_pan->minimum(-64);
        ovrd_pan->maximum(63);
        ovrd_pan->step(1);
        ovrd_pan->textcolor(7);
        ovrd_pan->callback((Fl_Callback*)cb_ovrd_pan);
        ovrd_pan->align(FL_ALIGN_LEFT);
        ovrd_pan->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_pan
      { ovrd_pf = new Fl_Check_Button(521, 350, 30, 15, gettext("Pre Filter"));
        ovrd_pf->down_box(FL_DOWN_BOX);
        ovrd_pf->labelsize(10);
        ovrd_pf->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_pf->callback((Fl_Callback*)cb_ovrd_pf);
      } // Fl_Check_Button* ovrd_pf
      { ovrd_lpf = new SliderW(531, 369, 100, 10, gettext("LPF"));
        ovrd_lpf->type(5);
        ovrd_lpf->box(FL_FLAT_BOX);
        ovrd_lpf->color((Fl_Color)178);
        ovrd_lpf->selection_color((Fl_Color)62);
        ovrd_lpf->labeltype(FL_NORMAL_LABEL);
        ovrd_lpf->labelfont(0);
        ovrd_lpf->labelsize(10);
        ovrd_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_lpf->maximum(127);
        ovrd_lpf->step(1);
        ovrd_lpf->textcolor(7);
        ovrd_lpf->callback((Fl_Callback*)cb_ovrd_lpf);
        ovrd_lpf->align(FL_ALIGN_LEFT);
        ovrd_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_lpf
      { ovrd_hpf = new SliderW(531, 381, 100, 10, gettext("HPF"));
        ovrd_hpf->type(5);
        ovrd_hpf->box(FL_FLAT_BOX);
        ovrd_hpf->color((Fl_Color)178);
        ovrd_hpf->selection_color((Fl_Color)62);
        ovrd_hpf->labeltype(FL_NORMAL_LABEL);
        ovrd_hpf->labelfont(0);
        ovrd_hpf->labelsize(10);
        ovrd_hpf->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_hpf->maximum(127);
        ovrd_hpf->step(1);
        ovrd_hpf->textcolor(7);
        ovrd_hpf->callback((Fl_Callback*)cb_ovrd_hpf);
        ovrd_hpf->align(FL_ALIGN_LEFT);
        ovrd_hpf->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_hpf
      OVRD->end();
    } // Fl_Group* OVRD
    { ECHO = new Fl_Group(639, 212, 158, 184, gettext("Echo"));
      ECHO->box(FL_PLASTIC_DOWN_FRAME);
      ECHO->color(FL_BACKGROUND2_COLOR);
      ECHO->labelfont(1);
      ECHO->labelcolor(FL_BACKGROUND2_COLOR);
      { echo_activar = new Fl_Light_Button(644, 216, 34, 18, gettext("On"));
        echo_activar->shortcut(0x35);
        echo_activar->color((Fl_Color)62);
        echo_activar->selection_color((Fl_Color)1);
        echo_activar->labelsize(10);
        echo_activar->callback((Fl_Callback*)cb_echo_activar);
        echo_activar->align(68|FL_ALIGN_INSIDE);
        echo_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* echo_activar
      { echo_preset = new Fl_Choice(716, 216, 76, 18, gettext("Preset"));
        echo_preset->down_box(FL_BORDER_BOX);
        echo_preset->selection_color(FL_FOREGROUND_COLOR);
        echo_preset->labelsize(10);
        echo_preset->labelcolor(FL_BACKGROUND2_COLOR);
        echo_preset->textsize(10);
        echo_preset->callback((Fl_Callback*)cb_echo_preset);
        echo_preset->when(FL_WHEN_RELEASE_ALWAYS);
        echo_preset->menu(menu_echo_preset);
      } // Fl_Choice* echo_preset
      { echo_WD = new SliderW(692, 247, 100, 10, gettext("Wet/Dry"));
        echo_WD->type(5);
        echo_WD->box(FL_FLAT_BOX);
        echo_WD->color((Fl_Color)178);
        echo_WD->selection_color((Fl_Color)62);
        echo_WD->labeltype(FL_NORMAL_LABEL);
        echo_WD->labelfont(0);
        echo_WD->labelsize(10);
        echo_WD->labelcolor(FL_BACKGROUND2_COLOR);
        echo_WD->minimum(-64);
        echo_WD->maximum(63);
        echo_WD->step(1);
        echo_WD->textcolor(7);
        echo_WD->callback((Fl_Callback*)cb_echo_WD);
        echo_WD->align(FL_ALIGN_LEFT);
        echo_WD->when(FL_WHEN_CHANGED);
      } // SliderW* echo_WD
      { echo_pan = new SliderW(692, 269, 100, 10, gettext("Pan"));
        echo_pan->type(5);
        echo_pan->box(FL_FLAT_BOX);
        echo_pan->color((Fl_Color)178);
        echo_pan->selection_color((Fl_Color)62);
        echo_pan->labeltype(FL_NORMAL_LABEL);
        echo_pan->labelfont(0);
        echo_pan->labelsize(10);
        echo_pan->labelcolor(FL_BACKGROUND2_COLOR);
        echo_pan->minimum(-64);
        echo_pan->maximum(63);
        echo_pan->step(1);
        echo_pan->textcolor(7);
        echo_pan->callback((Fl_Callback*)cb_echo_pan);
        echo_pan->align(FL_ALIGN_LEFT);
        echo_pan->when(FL_WHEN_CHANGED);
      } // SliderW* echo_pan
      { echo_delay = new SliderW(692, 291, 100, 10, gettext("Delay"));
        echo_delay->type(5);
        echo_delay->box(FL_FLAT_BOX);
        echo_delay->color((Fl_Color)178);
        echo_delay->selection_color((Fl_Color)62);
        echo_delay->labeltype(FL_NORMAL_LABEL);
        echo_delay->labelfont(0);
        echo_delay->labelsize(10);
        echo_delay->labelcolor(FL_BACKGROUND2_COLOR);
        echo_delay->maximum(127);
        echo_delay->step(1);
        echo_delay->textcolor(7);
        echo_delay->callback((Fl_Callback*)cb_echo_delay);
        echo_delay->align(FL_ALIGN_LEFT);
        echo_delay->when(FL_WHEN_RELEASE);
      } // SliderW* echo_delay
      { echo_LRdl = new SliderW(692, 314, 100, 10, gettext("LRdl."));
        echo_LRdl->type(5);
        echo_LRdl->box(FL_FLAT_BOX);
        echo_LRdl->color((Fl_Color)178);
        echo_LRdl->selection_color((Fl_Color)62);
        echo_LRdl->labeltype(FL_NORMAL_LABEL);
        echo_LRdl->labelfont(0);
        echo_LRdl->labelsize(10);
        echo_LRdl->labelcolor(FL_BACKGROUND2_COLOR);
        echo_LRdl->maximum(127);
        echo_LRdl->step(1);
        echo_LRdl->textcolor(7);
        echo_LRdl->callback((Fl_Callback*)cb_echo_LRdl);
        echo_LRdl->align(FL_ALIGN_LEFT);
        echo_LRdl->when(FL_WHEN_RELEASE);
      } // SliderW* echo_LRdl
      { echo_LRc = new SliderW(692, 336, 100, 10, gettext("L/R.Cr"));
        echo_LRc->type(5);
        echo_LRc->box(FL_FLAT_BOX);
        echo_LRc->color((Fl_Color)178);
        echo_LRc->selection_color((Fl_Color)62);
        echo_LRc->labeltype(FL_NORMAL_LABEL);
        echo_LRc->labelfont(0);
        echo_LRc->labelsize(10);
        echo_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        echo_LRc->minimum(-64);
        echo_LRc->maximum(63);
        echo_LRc->step(1);
        echo_LRc->textcolor(7);
        echo_LRc->callback((Fl_Callback*)cb_echo_LRc);
        echo_LRc->align(FL_ALIGN_LEFT);
        echo_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* echo_LRc
      { echo_fb = new SliderW(692, 358, 100, 10, gettext("Fb."));
        echo_fb->type(5);
        echo_fb->box(FL_FLAT_BOX);
        echo_fb->color((Fl_Color)178);
        echo_fb->selection_color((Fl_Color)62);
        echo_fb->labeltype(FL_NORMAL_LABEL);
        echo_fb->labelfont(0);
        echo_fb->labelsize(10);
        echo_fb->labelcolor(FL_BACKGROUND2_COLOR);
        echo_fb->maximum(127);
        echo_fb->step(1);
        echo_fb->textcolor(7);
        echo_fb->callback((Fl_Callback*)cb_echo_fb);
        echo_fb->align(FL_ALIGN_LEFT);
        echo_fb->when(FL_WHEN_CHANGED);
      } // SliderW* echo_fb
      { echo_damp = new SliderW(692, 381, 100, 10, gettext("Damp"));
        echo_damp->type(5);
        echo_damp->box(FL_FLAT_BOX);
        echo_damp->color((Fl_Color)178);
        echo_damp->selection_color((Fl_Color)62);
        echo_damp->labeltype(FL_NORMAL_LABEL);
        echo_damp->labelfont(0);
        echo_damp->labelsize(10);
        echo_damp->labelcolor(FL_BACKGROUND2_COLOR);
        echo_damp->maximum(127);
        echo_damp->step(1);
        echo_damp->textcolor(7);
        echo_damp->callback((Fl_Callback*)cb_echo_damp);
        echo_damp->align(FL_ALIGN_LEFT);
        echo_damp->when(FL_WHEN_CHANGED);
      } // SliderW* echo_damp
      ECHO->end();
    } // Fl_Group* ECHO
    { CHORUS = new Fl_Group(2, 413, 158, 184, gettext("Chorus"));
      CHORUS->box(FL_PLASTIC_DOWN_FRAME);
      CHORUS->color(FL_BACKGROUND2_COLOR);
      CHORUS->labelfont(1);
      CHORUS->labelcolor(FL_BACKGROUND2_COLOR);
      { chorus_activar = new Fl_Light_Button(7, 417, 34, 18, gettext("On"));
        chorus_activar->shortcut(0x36);
        chorus_activar->color((Fl_Color)62);
        chorus_activar->selection_color((Fl_Color)1);
        chorus_activar->labelsize(10);
        chorus_activar->callback((Fl_Callback*)cb_chorus_activar);
        chorus_activar->align(68|FL_ALIGN_INSIDE);
        chorus_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* chorus_activar
      { chorux_preset = new Fl_Choice(78, 417, 76, 18, gettext("Preset"));
        chorux_preset->down_box(FL_BORDER_BOX);
        chorux_preset->selection_color(FL_FOREGROUND_COLOR);
        chorux_preset->labelsize(10);
        chorux_preset->labelcolor(FL_BACKGROUND2_COLOR);
        chorux_preset->textsize(10);
        chorux_preset->callback((Fl_Callback*)cb_chorux_preset);
        chorux_preset->when(FL_WHEN_RELEASE_ALWAYS);
        chorux_preset->menu(menu_chorux_preset);
      } // Fl_Choice* chorux_preset
      { chorus_WD = new SliderW(51, 442, 100, 10, gettext("Wet/Dry"));
        chorus_WD->type(5);
        chorus_WD->box(FL_FLAT_BOX);
        chorus_WD->color((Fl_Color)178);
        chorus_WD->selection_color((Fl_Color)62);
        chorus_WD->labeltype(FL_NORMAL_LABEL);
        chorus_WD->labelfont(0);
        chorus_WD->labelsize(10);
        chorus_WD->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_WD->minimum(-64);
        chorus_WD->maximum(63);
        chorus_WD->step(1);
        chorus_WD->textcolor(7);
        chorus_WD->callback((Fl_Callback*)cb_chorus_WD);
        chorus_WD->align(FL_ALIGN_LEFT);
        chorus_WD->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_WD
      { chorus_pan = new SliderW(51, 454, 100, 10, gettext("Pan"));
        chorus_pan->type(5);
        chorus_pan->box(FL_FLAT_BOX);
        chorus_pan->color((Fl_Color)178);
        chorus_pan->selection_color((Fl_Color)62);
        chorus_pan->labeltype(FL_NORMAL_LABEL);
        chorus_pan->labelfont(0);
        chorus_pan->labelsize(10);
        chorus_pan->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_pan->minimum(-64);
        chorus_pan->maximum(63);
        chorus_pan->step(1);
        chorus_pan->textcolor(7);
        chorus_pan->callback((Fl_Callback*)cb_chorus_pan);
        chorus_pan->align(FL_ALIGN_LEFT);
        chorus_pan->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_pan
      { chorus_freq = new SliderW(51, 466, 100, 10, gettext("Freq"));
        chorus_freq->type(5);
        chorus_freq->box(FL_FLAT_BOX);
        chorus_freq->color((Fl_Color)178);
        chorus_freq->selection_color((Fl_Color)62);
        chorus_freq->labeltype(FL_NORMAL_LABEL);
        chorus_freq->labelfont(0);
        chorus_freq->labelsize(10);
        chorus_freq->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_freq->maximum(127);
        chorus_freq->step(1);
        chorus_freq->textcolor(7);
        chorus_freq->callback((Fl_Callback*)cb_chorus_freq);
        chorus_freq->align(FL_ALIGN_LEFT);
        chorus_freq->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_freq
      { chorus_rnd = new SliderW(51, 478, 100, 10, gettext("Rnd"));
        chorus_rnd->type(5);
        chorus_rnd->box(FL_FLAT_BOX);
        chorus_rnd->color((Fl_Color)178);
        chorus_rnd->selection_color((Fl_Color)62);
        chorus_rnd->labeltype(FL_NORMAL_LABEL);
        chorus_rnd->labelfont(0);
        chorus_rnd->labelsize(10);
        chorus_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_rnd->maximum(127);
        chorus_rnd->step(1);
        chorus_rnd->textcolor(7);
        chorus_rnd->callback((Fl_Callback*)cb_chorus_rnd);
        chorus_rnd->align(FL_ALIGN_LEFT);
        chorus_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_rnd
      { chorus_lfotype = new Fl_Choice(63, 490, 72, 16, gettext("LFO Type"));
        chorus_lfotype->down_box(FL_BORDER_BOX);
        chorus_lfotype->selection_color(FL_FOREGROUND_COLOR);
        chorus_lfotype->labelsize(10);
        chorus_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_lfotype->textsize(10);
        chorus_lfotype->callback((Fl_Callback*)cb_chorus_lfotype);
        chorus_lfotype->menu(menu_chorus_lfotype);
      } // Fl_Choice* chorus_lfotype
      { chorus_subs = new Fl_Check_Button(37, 507, 64, 15, gettext("Subtract"));
        chorus_subs->down_box(FL_DOWN_BOX);
        chorus_subs->labelsize(10);
        chorus_subs->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_subs->callback((Fl_Callback*)cb_chorus_subs);
      } // Fl_Check_Button* chorus_subs
      { chorus_stdf = new SliderW(51, 528, 100, 10, gettext("St.df"));
        chorus_stdf->type(5);
        chorus_stdf->box(FL_FLAT_BOX);
        chorus_stdf->color((Fl_Color)178);
        chorus_stdf->selection_color((Fl_Color)62);
        chorus_stdf->labeltype(FL_NORMAL_LABEL);
        chorus_stdf->labelfont(0);
        chorus_stdf->labelsize(10);
        chorus_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_stdf->maximum(127);
        chorus_stdf->step(1);
        chorus_stdf->textcolor(7);
        chorus_stdf->callback((Fl_Callback*)cb_chorus_stdf);
        chorus_stdf->align(FL_ALIGN_LEFT);
        chorus_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_stdf
      { chorus_dpth = new SliderW(51, 541, 100, 10, gettext("Depth"));
        chorus_dpth->type(5);
        chorus_dpth->box(FL_FLAT_BOX);
        chorus_dpth->color((Fl_Color)178);
        chorus_dpth->selection_color((Fl_Color)62);
        chorus_dpth->labeltype(FL_NORMAL_LABEL);
        chorus_dpth->labelfont(0);
        chorus_dpth->labelsize(10);
        chorus_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_dpth->maximum(127);
        chorus_dpth->step(1);
        chorus_dpth->textcolor(7);
        chorus_dpth->callback((Fl_Callback*)cb_chorus_dpth);
        chorus_dpth->align(FL_ALIGN_LEFT);
        chorus_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_dpth
      { chorus_delay = new SliderW(51, 554, 100, 10, gettext("Delay"));
        chorus_delay->type(5);
        chorus_delay->box(FL_FLAT_BOX);
        chorus_delay->color((Fl_Color)178);
        chorus_delay->selection_color((Fl_Color)62);
        chorus_delay->labeltype(FL_NORMAL_LABEL);
        chorus_delay->labelfont(0);
        chorus_delay->labelsize(10);
        chorus_delay->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_delay->maximum(127);
        chorus_delay->step(1);
        chorus_delay->textcolor(7);
        chorus_delay->callback((Fl_Callback*)cb_chorus_delay);
        chorus_delay->align(FL_ALIGN_LEFT);
        chorus_delay->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_delay
      { chorus_fb = new SliderW(51, 567, 100, 10, gettext("Fb"));
        chorus_fb->type(5);
        chorus_fb->box(FL_FLAT_BOX);
        chorus_fb->color((Fl_Color)178);
        chorus_fb->selection_color((Fl_Color)62);
        chorus_fb->labeltype(FL_NORMAL_LABEL);
        chorus_fb->labelfont(0);
        chorus_fb->labelsize(10);
        chorus_fb->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_fb->maximum(127);
        chorus_fb->step(1);
        chorus_fb->textcolor(7);
        chorus_fb->callback((Fl_Callback*)cb_chorus_fb);
        chorus_fb->align(FL_ALIGN_LEFT);
        chorus_fb->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_fb
      { chorus_LR = new SliderW(51, 581, 100, 10, gettext("L/R.Cr"));
        chorus_LR->type(5);
        chorus_LR->box(FL_FLAT_BOX);
        chorus_LR->color((Fl_Color)178);
        chorus_LR->selection_color((Fl_Color)62);
        chorus_LR->labeltype(FL_NORMAL_LABEL);
        chorus_LR->labelfont(0);
        chorus_LR->labelsize(10);
        chorus_LR->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_LR->minimum(-64);
        chorus_LR->maximum(63);
        chorus_LR->step(1);
        chorus_LR->textcolor(7);
        chorus_LR->callback((Fl_Callback*)cb_chorus_LR);
        chorus_LR->align(FL_ALIGN_LEFT);
        chorus_LR->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_LR
      CHORUS->end();
    } // Fl_Group* CHORUS
    { PHASER = new Fl_Group(161, 413, 158, 184, gettext("Phaser"));
      PHASER->box(FL_PLASTIC_DOWN_FRAME);
      PHASER->color(FL_BACKGROUND2_COLOR);
      PHASER->labelfont(1);
      PHASER->labelcolor(FL_BACKGROUND2_COLOR);
      { phaser_activar = new Fl_Light_Button(166, 417, 34, 18, gettext("On"));
        phaser_activar->shortcut(0x37);
        phaser_activar->color((Fl_Color)62);
        phaser_activar->selection_color((Fl_Color)1);
        phaser_activar->labelsize(10);
        phaser_activar->callback((Fl_Callback*)cb_phaser_activar);
        phaser_activar->align(68|FL_ALIGN_INSIDE);
        phaser_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* phaser_activar
      { phaser_preset = new Fl_Choice(238, 417, 76, 18, gettext("Preset"));
        phaser_preset->down_box(FL_BORDER_BOX);
        phaser_preset->selection_color(FL_FOREGROUND_COLOR);
        phaser_preset->labelsize(10);
        phaser_preset->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_preset->textsize(10);
        phaser_preset->callback((Fl_Callback*)cb_phaser_preset);
        phaser_preset->when(FL_WHEN_RELEASE_ALWAYS);
        phaser_preset->menu(menu_phaser_preset);
      } // Fl_Choice* phaser_preset
      { phaser_WD = new SliderW(210, 442, 100, 10, gettext("Wet/Dry"));
        phaser_WD->type(5);
        phaser_WD->box(FL_FLAT_BOX);
        phaser_WD->color((Fl_Color)178);
        phaser_WD->selection_color((Fl_Color)62);
        phaser_WD->labeltype(FL_NORMAL_LABEL);
        phaser_WD->labelfont(0);
        phaser_WD->labelsize(10);
        phaser_WD->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_WD->minimum(-64);
        phaser_WD->maximum(63);
        phaser_WD->step(1);
        phaser_WD->textcolor(7);
        phaser_WD->callback((Fl_Callback*)cb_phaser_WD);
        phaser_WD->align(FL_ALIGN_LEFT);
        phaser_WD->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_WD
      { phaser_pan = new SliderW(210, 454, 100, 10, gettext("Pan"));
        phaser_pan->type(5);
        phaser_pan->box(FL_FLAT_BOX);
        phaser_pan->color((Fl_Color)178);
        phaser_pan->selection_color((Fl_Color)62);
        phaser_pan->labeltype(FL_NORMAL_LABEL);
        phaser_pan->labelfont(0);
        phaser_pan->labelsize(10);
        phaser_pan->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_pan->minimum(-64);
        phaser_pan->maximum(63);
        phaser_pan->step(1);
        phaser_pan->value(64);
        phaser_pan->textcolor(7);
        phaser_pan->callback((Fl_Callback*)cb_phaser_pan);
        phaser_pan->align(FL_ALIGN_LEFT);
        phaser_pan->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_pan
      { phaser_freq = new SliderW(210, 466, 100, 10, gettext("Freq"));
        phaser_freq->type(5);
        phaser_freq->box(FL_FLAT_BOX);
        phaser_freq->color((Fl_Color)178);
        phaser_freq->selection_color((Fl_Color)62);
        phaser_freq->labeltype(FL_NORMAL_LABEL);
        phaser_freq->labelfont(0);
        phaser_freq->labelsize(10);
        phaser_freq->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_freq->maximum(127);
        phaser_freq->step(1);
        phaser_freq->textcolor(7);
        phaser_freq->callback((Fl_Callback*)cb_phaser_freq);
        phaser_freq->align(FL_ALIGN_LEFT);
        phaser_freq->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_freq
      { phaser_rnd = new SliderW(210, 478, 100, 10, gettext("Rnd"));
        phaser_rnd->type(5);
        phaser_rnd->box(FL_FLAT_BOX);
        phaser_rnd->color((Fl_Color)178);
        phaser_rnd->selection_color((Fl_Color)62);
        phaser_rnd->labeltype(FL_NORMAL_LABEL);
        phaser_rnd->labelfont(0);
        phaser_rnd->labelsize(10);
        phaser_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_rnd->maximum(127);
        phaser_rnd->step(1);
        phaser_rnd->textcolor(7);
        phaser_rnd->callback((Fl_Callback*)cb_phaser_rnd);
        phaser_rnd->align(FL_ALIGN_LEFT);
        phaser_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_rnd
      { phaser_lfotype = new Fl_Choice(221, 490, 72, 16, gettext("LFO Type"));
        phaser_lfotype->down_box(FL_BORDER_BOX);
        phaser_lfotype->selection_color(FL_FOREGROUND_COLOR);
        phaser_lfotype->labelsize(10);
        phaser_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_lfotype->textsize(10);
        phaser_lfotype->callback((Fl_Callback*)cb_phaser_lfotype);
        phaser_lfotype->menu(menu_phaser_lfotype);
      } // Fl_Choice* phaser_lfotype
      { phaser_subs = new Fl_Check_Button(201, 507, 64, 15, gettext("Subtract"));
        phaser_subs->down_box(FL_DOWN_BOX);
        phaser_subs->labelsize(10);
        phaser_subs->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_subs->callback((Fl_Callback*)cb_phaser_subs);
      } // Fl_Check_Button* phaser_subs
      { phaser_phase = new SliderW(210, 523, 100, 10, gettext("Phase"));
        phaser_phase->type(5);
        phaser_phase->box(FL_FLAT_BOX);
        phaser_phase->color((Fl_Color)178);
        phaser_phase->selection_color((Fl_Color)62);
        phaser_phase->labeltype(FL_NORMAL_LABEL);
        phaser_phase->labelfont(0);
        phaser_phase->labelsize(10);
        phaser_phase->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_phase->maximum(127);
        phaser_phase->step(1);
        phaser_phase->textcolor(7);
        phaser_phase->callback((Fl_Callback*)cb_phaser_phase);
        phaser_phase->align(FL_ALIGN_LEFT);
        phaser_phase->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_phase
      { phaser_stdf = new SliderW(210, 534, 100, 10, gettext("St.df"));
        phaser_stdf->type(5);
        phaser_stdf->box(FL_FLAT_BOX);
        phaser_stdf->color((Fl_Color)178);
        phaser_stdf->selection_color((Fl_Color)62);
        phaser_stdf->labeltype(FL_NORMAL_LABEL);
        phaser_stdf->labelfont(0);
        phaser_stdf->labelsize(10);
        phaser_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_stdf->maximum(127);
        phaser_stdf->step(1);
        phaser_stdf->textcolor(7);
        phaser_stdf->callback((Fl_Callback*)cb_phaser_stdf);
        phaser_stdf->align(FL_ALIGN_LEFT);
        phaser_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_stdf
      { phaser_dpth = new SliderW(210, 545, 100, 10, gettext("Depth"));
        phaser_dpth->type(5);
        phaser_dpth->box(FL_FLAT_BOX);
        phaser_dpth->color((Fl_Color)178);
        phaser_dpth->selection_color((Fl_Color)62);
        phaser_dpth->labeltype(FL_NORMAL_LABEL);
        phaser_dpth->labelfont(0);
        phaser_dpth->labelsize(10);
        phaser_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_dpth->maximum(127);
        phaser_dpth->step(1);
        phaser_dpth->textcolor(7);
        phaser_dpth->callback((Fl_Callback*)cb_phaser_dpth);
        phaser_dpth->align(FL_ALIGN_LEFT);
        phaser_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_dpth
      { phaser_fb = new SliderW(210, 557, 100, 10, gettext("Fb"));
        phaser_fb->type(5);
        phaser_fb->box(FL_FLAT_BOX);
        phaser_fb->color((Fl_Color)178);
        phaser_fb->selection_color((Fl_Color)62);
        phaser_fb->labeltype(FL_NORMAL_LABEL);
        phaser_fb->labelfont(0);
        phaser_fb->labelsize(10);
        phaser_fb->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_fb->maximum(127);
        phaser_fb->step(1);
        phaser_fb->textcolor(7);
        phaser_fb->callback((Fl_Callback*)cb_phaser_fb);
        phaser_fb->align(FL_ALIGN_LEFT);
        phaser_fb->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_fb
      { phaser_stages = new Fl_Counter(233, 569, 52, 12, gettext("Stages"));
        phaser_stages->type(1);
        phaser_stages->box(FL_THIN_UP_BOX);
        phaser_stages->labelsize(10);
        phaser_stages->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_stages->minimum(1);
        phaser_stages->maximum(12);
        phaser_stages->step(1);
        phaser_stages->value(1);
        phaser_stages->textsize(9);
        phaser_stages->callback((Fl_Callback*)cb_phaser_stages);
        phaser_stages->align(FL_ALIGN_LEFT);
      } // Fl_Counter* phaser_stages
      { phaser_LR = new SliderW(210, 584, 100, 10, gettext("L/R.Cr"));
        phaser_LR->type(5);
        phaser_LR->box(FL_FLAT_BOX);
        phaser_LR->color((Fl_Color)178);
        phaser_LR->selection_color((Fl_Color)62);
        phaser_LR->labeltype(FL_NORMAL_LABEL);
        phaser_LR->labelfont(0);
        phaser_LR->labelsize(10);
        phaser_LR->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_LR->minimum(-64);
        phaser_LR->maximum(63);
        phaser_LR->step(1);
        phaser_LR->textcolor(7);
        phaser_LR->callback((Fl_Callback*)cb_phaser_LR);
        phaser_LR->align(FL_ALIGN_LEFT);
        phaser_LR->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_LR
      PHASER->end();
    } // Fl_Group* PHASER
    { FLANGER = new Fl_Group(321, 413, 158, 185, gettext("Flanger"));
      FLANGER->box(FL_PLASTIC_DOWN_FRAME);
      FLANGER->color(FL_BACKGROUND2_COLOR);
      FLANGER->labelfont(1);
      FLANGER->labelcolor(FL_BACKGROUND2_COLOR);
      { flanger_activar = new Fl_Light_Button(326, 417, 34, 18, gettext("On"));
        flanger_activar->shortcut(0x38);
        flanger_activar->color((Fl_Color)62);
        flanger_activar->selection_color((Fl_Color)1);
        flanger_activar->labelsize(10);
        flanger_activar->callback((Fl_Callback*)cb_flanger_activar);
        flanger_activar->align(68|FL_ALIGN_INSIDE);
        flanger_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* flanger_activar
      { flanger_preset = new Fl_Choice(398, 417, 76, 18, gettext("Preset"));
        flanger_preset->down_box(FL_BORDER_BOX);
        flanger_preset->selection_color(FL_FOREGROUND_COLOR);
        flanger_preset->labelsize(10);
        flanger_preset->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_preset->textsize(10);
        flanger_preset->callback((Fl_Callback*)cb_flanger_preset);
        flanger_preset->when(FL_WHEN_RELEASE_ALWAYS);
        flanger_preset->menu(menu_flanger_preset);
      } // Fl_Choice* flanger_preset
      { flanger_WD = new SliderW(373, 442, 100, 10, gettext("Wet/Dry"));
        flanger_WD->type(5);
        flanger_WD->box(FL_FLAT_BOX);
        flanger_WD->color((Fl_Color)178);
        flanger_WD->selection_color((Fl_Color)62);
        flanger_WD->labeltype(FL_NORMAL_LABEL);
        flanger_WD->labelfont(0);
        flanger_WD->labelsize(10);
        flanger_WD->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_WD->minimum(-64);
        flanger_WD->maximum(63);
        flanger_WD->step(1);
        flanger_WD->textcolor(7);
        flanger_WD->callback((Fl_Callback*)cb_flanger_WD);
        flanger_WD->align(FL_ALIGN_LEFT);
        flanger_WD->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_WD
      { flanger_pan = new SliderW(373, 454, 100, 10, gettext("Pan"));
        flanger_pan->type(5);
        flanger_pan->box(FL_FLAT_BOX);
        flanger_pan->color((Fl_Color)178);
        flanger_pan->selection_color((Fl_Color)62);
        flanger_pan->labeltype(FL_NORMAL_LABEL);
        flanger_pan->labelfont(0);
        flanger_pan->labelsize(10);
        flanger_pan->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_pan->minimum(-64);
        flanger_pan->maximum(63);
        flanger_pan->step(1);
        flanger_pan->textcolor(7);
        flanger_pan->callback((Fl_Callback*)cb_flanger_pan);
        flanger_pan->align(FL_ALIGN_LEFT);
        flanger_pan->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_pan
      { flanger_freq = new SliderW(373, 466, 100, 10, gettext("Freq"));
        flanger_freq->type(5);
        flanger_freq->box(FL_FLAT_BOX);
        flanger_freq->color((Fl_Color)178);
        flanger_freq->selection_color((Fl_Color)62);
        flanger_freq->labeltype(FL_NORMAL_LABEL);
        flanger_freq->labelfont(0);
        flanger_freq->labelsize(10);
        flanger_freq->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_freq->maximum(127);
        flanger_freq->step(1);
        flanger_freq->textcolor(7);
        flanger_freq->callback((Fl_Callback*)cb_flanger_freq);
        flanger_freq->align(FL_ALIGN_LEFT);
        flanger_freq->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_freq
      { flanger_rnd = new SliderW(373, 478, 100, 10, gettext("Rnd"));
        flanger_rnd->type(5);
        flanger_rnd->box(FL_FLAT_BOX);
        flanger_rnd->color((Fl_Color)178);
        flanger_rnd->selection_color((Fl_Color)62);
        flanger_rnd->labeltype(FL_NORMAL_LABEL);
        flanger_rnd->labelfont(0);
        flanger_rnd->labelsize(10);
        flanger_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_rnd->maximum(127);
        flanger_rnd->step(1);
        flanger_rnd->textcolor(7);
        flanger_rnd->callback((Fl_Callback*)cb_flanger_rnd);
        flanger_rnd->align(FL_ALIGN_LEFT);
        flanger_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_rnd
      { flanger_lfotype = new Fl_Choice(384, 490, 72, 16, gettext("LFO Type"));
        flanger_lfotype->down_box(FL_BORDER_BOX);
        flanger_lfotype->selection_color(FL_FOREGROUND_COLOR);
        flanger_lfotype->labelsize(10);
        flanger_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_lfotype->textsize(10);
        flanger_lfotype->callback((Fl_Callback*)cb_flanger_lfotype);
        flanger_lfotype->menu(menu_flanger_lfotype);
      } // Fl_Choice* flanger_lfotype
      { flanger_subs = new Fl_Check_Button(363, 507, 64, 15, gettext("Subtract"));
        flanger_subs->down_box(FL_DOWN_BOX);
        flanger_subs->labelsize(10);
        flanger_subs->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_subs->callback((Fl_Callback*)cb_flanger_subs);
      } // Fl_Check_Button* flanger_subs
      { flanger_stdf = new SliderW(373, 528, 100, 10, gettext("St.df"));
        flanger_stdf->type(5);
        flanger_stdf->box(FL_FLAT_BOX);
        flanger_stdf->color((Fl_Color)178);
        flanger_stdf->selection_color((Fl_Color)62);
        flanger_stdf->labeltype(FL_NORMAL_LABEL);
        flanger_stdf->labelfont(0);
        flanger_stdf->labelsize(10);
        flanger_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_stdf->maximum(127);
        flanger_stdf->step(1);
        flanger_stdf->textcolor(7);
        flanger_stdf->callback((Fl_Callback*)cb_flanger_stdf);
        flanger_stdf->align(FL_ALIGN_LEFT);
        flanger_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_stdf
      { flanger_dpth = new SliderW(373, 541, 100, 10, gettext("Depth"));
        flanger_dpth->type(5);
        flanger_dpth->box(FL_FLAT_BOX);
        flanger_dpth->color((Fl_Color)178);
        flanger_dpth->selection_color((Fl_Color)62);
        flanger_dpth->labeltype(FL_NORMAL_LABEL);
        flanger_dpth->labelfont(0);
        flanger_dpth->labelsize(10);
        flanger_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_dpth->maximum(127);
        flanger_dpth->step(1);
        flanger_dpth->textcolor(7);
        flanger_dpth->callback((Fl_Callback*)cb_flanger_dpth);
        flanger_dpth->align(FL_ALIGN_LEFT);
        flanger_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_dpth
      { flanger_delay = new SliderW(373, 554, 100, 10, gettext("Delay"));
        flanger_delay->type(5);
        flanger_delay->box(FL_FLAT_BOX);
        flanger_delay->color((Fl_Color)178);
        flanger_delay->selection_color((Fl_Color)62);
        flanger_delay->labeltype(FL_NORMAL_LABEL);
        flanger_delay->labelfont(0);
        flanger_delay->labelsize(10);
        flanger_delay->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_delay->maximum(127);
        flanger_delay->step(1);
        flanger_delay->textcolor(7);
        flanger_delay->callback((Fl_Callback*)cb_flanger_delay);
        flanger_delay->align(FL_ALIGN_LEFT);
        flanger_delay->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_delay
      { flanger_fb = new SliderW(373, 567, 100, 10, gettext("Fb"));
        flanger_fb->type(5);
        flanger_fb->box(FL_FLAT_BOX);
        flanger_fb->color((Fl_Color)178);
        flanger_fb->selection_color((Fl_Color)62);
        flanger_fb->labeltype(FL_NORMAL_LABEL);
        flanger_fb->labelfont(0);
        flanger_fb->labelsize(10);
        flanger_fb->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_fb->maximum(127);
        flanger_fb->step(1);
        flanger_fb->textcolor(7);
        flanger_fb->callback((Fl_Callback*)cb_flanger_fb);
        flanger_fb->align(FL_ALIGN_LEFT);
        flanger_fb->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_fb
      { flanger_LR = new SliderW(373, 581, 100, 10, gettext("L/R.Cr"));
        flanger_LR->type(5);
        flanger_LR->box(FL_FLAT_BOX);
        flanger_LR->color((Fl_Color)178);
        flanger_LR->selection_color((Fl_Color)62);
        flanger_LR->labeltype(FL_NORMAL_LABEL);
        flanger_LR->labelfont(0);
        flanger_LR->labelsize(10);
        flanger_LR->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_LR->minimum(-64);
        flanger_LR->maximum(63);
        flanger_LR->step(1);
        flanger_LR->textcolor(7);
        flanger_LR->callback((Fl_Callback*)cb_flanger_LR);
        flanger_LR->align(FL_ALIGN_LEFT);
        flanger_LR->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_LR
      FLANGER->end();
    } // Fl_Group* FLANGER
    { REVERB = new Fl_Group(480, 413, 158, 184, gettext("Reverb"));
      REVERB->box(FL_PLASTIC_DOWN_FRAME);
      REVERB->color(FL_BACKGROUND2_COLOR);
      REVERB->labelfont(1);
      REVERB->labelcolor(FL_BACKGROUND2_COLOR);
      { reverb_activar = new Fl_Light_Button(485, 417, 34, 18, gettext("On"));
        reverb_activar->shortcut(0x39);
        reverb_activar->color((Fl_Color)62);
        reverb_activar->selection_color((Fl_Color)1);
        reverb_activar->labelsize(10);
        reverb_activar->callback((Fl_Callback*)cb_reverb_activar);
        reverb_activar->align(68|FL_ALIGN_INSIDE);
        reverb_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* reverb_activar
      { reverb_preset = new Fl_Choice(557, 417, 76, 18, gettext("Preset"));
        reverb_preset->down_box(FL_BORDER_BOX);
        reverb_preset->selection_color(FL_FOREGROUND_COLOR);
        reverb_preset->labelsize(10);
        reverb_preset->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_preset->textsize(10);
        reverb_preset->callback((Fl_Callback*)cb_reverb_preset);
        reverb_preset->when(FL_WHEN_RELEASE_ALWAYS);
        reverb_preset->menu(menu_reverb_preset);
      } // Fl_Choice* reverb_preset
      { reverb_WD = new SliderW(531, 440, 100, 10, gettext("Wet/Dry"));
        reverb_WD->type(5);
        reverb_WD->box(FL_FLAT_BOX);
        reverb_WD->color((Fl_Color)178);
        reverb_WD->selection_color((Fl_Color)62);
        reverb_WD->labeltype(FL_NORMAL_LABEL);
        reverb_WD->labelfont(0);
        reverb_WD->labelsize(10);
        reverb_WD->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_WD->minimum(-64);
        reverb_WD->maximum(63);
        reverb_WD->step(1);
        reverb_WD->textcolor(7);
        reverb_WD->callback((Fl_Callback*)cb_reverb_WD);
        reverb_WD->align(FL_ALIGN_LEFT);
        reverb_WD->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_WD
      { reverb_pan = new SliderW(531, 452, 100, 10, gettext("Pan"));
        reverb_pan->type(5);
        reverb_pan->box(FL_FLAT_BOX);
        reverb_pan->color((Fl_Color)178);
        reverb_pan->selection_color((Fl_Color)62);
        reverb_pan->labeltype(FL_NORMAL_LABEL);
        reverb_pan->labelfont(0);
        reverb_pan->labelsize(10);
        reverb_pan->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_pan->minimum(-64);
        reverb_pan->maximum(63);
        reverb_pan->step(1);
        reverb_pan->textcolor(7);
        reverb_pan->callback((Fl_Callback*)cb_reverb_pan);
        reverb_pan->align(FL_ALIGN_LEFT);
        reverb_pan->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_pan
      { reverb_time = new SliderW(531, 465, 100, 10, gettext("Time"));
        reverb_time->type(5);
        reverb_time->box(FL_FLAT_BOX);
        reverb_time->color((Fl_Color)178);
        reverb_time->selection_color((Fl_Color)62);
        reverb_time->labeltype(FL_NORMAL_LABEL);
        reverb_time->labelfont(0);
        reverb_time->labelsize(10);
        reverb_time->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_time->maximum(127);
        reverb_time->step(1);
        reverb_time->textcolor(7);
        reverb_time->callback((Fl_Callback*)cb_reverb_time);
        reverb_time->align(FL_ALIGN_LEFT);
        reverb_time->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_time
      { reverb_ldel = new SliderW(531, 477, 100, 10, gettext("I.Del"));
        reverb_ldel->type(5);
        reverb_ldel->box(FL_FLAT_BOX);
        reverb_ldel->color((Fl_Color)178);
        reverb_ldel->selection_color((Fl_Color)62);
        reverb_ldel->labeltype(FL_NORMAL_LABEL);
        reverb_ldel->labelfont(0);
        reverb_ldel->labelsize(10);
        reverb_ldel->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_ldel->maximum(127);
        reverb_ldel->step(1);
        reverb_ldel->textcolor(7);
        reverb_ldel->callback((Fl_Callback*)cb_reverb_ldel);
        reverb_ldel->align(FL_ALIGN_LEFT);
        reverb_ldel->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_ldel
      { reverb_ldelft = new SliderW(531, 490, 100, 10, gettext("Del.E/R"));
        reverb_ldelft->type(5);
        reverb_ldelft->box(FL_FLAT_BOX);
        reverb_ldelft->color((Fl_Color)178);
        reverb_ldelft->selection_color((Fl_Color)62);
        reverb_ldelft->labeltype(FL_NORMAL_LABEL);
        reverb_ldelft->labelfont(0);
        reverb_ldelft->labelsize(10);
        reverb_ldelft->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_ldelft->maximum(127);
        reverb_ldelft->step(1);
        reverb_ldelft->textcolor(7);
        reverb_ldelft->callback((Fl_Callback*)cb_reverb_ldelft);
        reverb_ldelft->align(FL_ALIGN_LEFT);
        reverb_ldelft->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_ldelft
      { reverb_type = new Fl_Choice(542, 505, 72, 16, gettext("Type"));
        reverb_type->down_box(FL_BORDER_BOX);
        reverb_type->selection_color(FL_FOREGROUND_COLOR);
        reverb_type->labelsize(10);
        reverb_type->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_type->textsize(10);
        reverb_type->callback((Fl_Callback*)cb_reverb_type);
        reverb_type->menu(menu_reverb_type);
      } // Fl_Choice* reverb_type
      { reverb_RS = new SliderW(531, 529, 100, 10, gettext("R.Size"));
        reverb_RS->type(5);
        reverb_RS->box(FL_FLAT_BOX);
        reverb_RS->color((Fl_Color)178);
        reverb_RS->selection_color((Fl_Color)62);
        reverb_RS->labeltype(FL_NORMAL_LABEL);
        reverb_RS->labelfont(0);
        reverb_RS->labelsize(10);
        reverb_RS->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_RS->minimum(1);
        reverb_RS->maximum(127);
        reverb_RS->step(1);
        reverb_RS->value(1);
        reverb_RS->textcolor(7);
        reverb_RS->callback((Fl_Callback*)cb_reverb_RS);
        reverb_RS->align(FL_ALIGN_LEFT);
        reverb_RS->when(FL_WHEN_RELEASE);
      } // SliderW* reverb_RS
      { reverb_LPF = new SliderW(531, 544, 100, 10, gettext("LPF"));
        reverb_LPF->type(5);
        reverb_LPF->box(FL_FLAT_BOX);
        reverb_LPF->color((Fl_Color)178);
        reverb_LPF->selection_color((Fl_Color)62);
        reverb_LPF->labeltype(FL_NORMAL_LABEL);
        reverb_LPF->labelfont(0);
        reverb_LPF->labelsize(10);
        reverb_LPF->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_LPF->maximum(127);
        reverb_LPF->step(1);
        reverb_LPF->textcolor(7);
        reverb_LPF->callback((Fl_Callback*)cb_reverb_LPF);
        reverb_LPF->align(FL_ALIGN_LEFT);
        reverb_LPF->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_LPF
      { reverb_HPF = new SliderW(531, 560, 100, 10, gettext("HPF"));
        reverb_HPF->type(5);
        reverb_HPF->box(FL_FLAT_BOX);
        reverb_HPF->color((Fl_Color)178);
        reverb_HPF->selection_color((Fl_Color)62);
        reverb_HPF->labeltype(FL_NORMAL_LABEL);
        reverb_HPF->labelfont(0);
        reverb_HPF->labelsize(10);
        reverb_HPF->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_HPF->maximum(127);
        reverb_HPF->step(1);
        reverb_HPF->textcolor(7);
        reverb_HPF->callback((Fl_Callback*)cb_reverb_HPF);
        reverb_HPF->align(FL_ALIGN_LEFT);
        reverb_HPF->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_HPF
      { reverb_damp = new SliderW(531, 576, 100, 10, gettext("Damp"));
        reverb_damp->type(5);
        reverb_damp->box(FL_FLAT_BOX);
        reverb_damp->color((Fl_Color)178);
        reverb_damp->selection_color((Fl_Color)62);
        reverb_damp->labeltype(FL_NORMAL_LABEL);
        reverb_damp->labelfont(0);
        reverb_damp->labelsize(10);
        reverb_damp->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_damp->minimum(64);
        reverb_damp->maximum(127);
        reverb_damp->step(1);
        reverb_damp->value(64);
        reverb_damp->textcolor(7);
        reverb_damp->callback((Fl_Callback*)cb_reverb_damp);
        reverb_damp->align(FL_ALIGN_LEFT);
        reverb_damp->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_damp
      REVERB->end();
    } // Fl_Group* REVERB
    { PEQ = new Fl_Group(639, 413, 158, 184, gettext("Parametric EQ"));
      PEQ->box(FL_PLASTIC_DOWN_FRAME);
      PEQ->color(FL_BACKGROUND2_COLOR);
      PEQ->labelfont(1);
      PEQ->labelcolor(FL_BACKGROUND2_COLOR);
      PEQ->align(65);
      { eqp_activar = new Fl_Light_Button(644, 417, 34, 18, gettext("On"));
        eqp_activar->shortcut(0x30);
        eqp_activar->color((Fl_Color)62);
        eqp_activar->selection_color((Fl_Color)1);
        eqp_activar->labelsize(10);
        eqp_activar->callback((Fl_Callback*)cb_eqp_activar);
        eqp_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* eqp_activar
      { eqp_preset = new Fl_Choice(714, 417, 76, 18, gettext("Preset"));
        eqp_preset->down_box(FL_BORDER_BOX);
        eqp_preset->selection_color(FL_FOREGROUND_COLOR);
        eqp_preset->labelsize(10);
        eqp_preset->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_preset->textsize(10);
        eqp_preset->callback((Fl_Callback*)cb_eqp_preset);
        eqp_preset->when(FL_WHEN_RELEASE_ALWAYS);
        eqp_preset->menu(menu_eqp_preset);
      } // Fl_Choice* eqp_preset
      { eqp_Gain = new SliderW(689, 439, 100, 10, gettext("Gain"));
        eqp_Gain->type(5);
        eqp_Gain->box(FL_FLAT_BOX);
        eqp_Gain->color((Fl_Color)178);
        eqp_Gain->selection_color((Fl_Color)62);
        eqp_Gain->labeltype(FL_NORMAL_LABEL);
        eqp_Gain->labelfont(0);
        eqp_Gain->labelsize(10);
        eqp_Gain->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_Gain->minimum(-64);
        eqp_Gain->maximum(63);
        eqp_Gain->step(1);
        eqp_Gain->textcolor(7);
        eqp_Gain->callback((Fl_Callback*)cb_eqp_Gain);
        eqp_Gain->align(FL_ALIGN_LEFT);
        eqp_Gain->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_Gain
      { eqp_LF = new SliderW(689, 463, 100, 10, gettext("Low F."));
        eqp_LF->type(5);
        eqp_LF->box(FL_FLAT_BOX);
        eqp_LF->color((Fl_Color)178);
        eqp_LF->selection_color((Fl_Color)62);
        eqp_LF->labeltype(FL_NORMAL_LABEL);
        eqp_LF->labelfont(0);
        eqp_LF->labelsize(10);
        eqp_LF->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_LF->minimum(1);
        eqp_LF->maximum(48);
        eqp_LF->step(1);
        eqp_LF->value(24);
        eqp_LF->textcolor(7);
        eqp_LF->callback((Fl_Callback*)cb_eqp_LF);
        eqp_LF->align(FL_ALIGN_LEFT);
        eqp_LF->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_LF
      { eqp_LFg = new SliderW(689, 476, 100, 10, gettext("Low G."));
        eqp_LFg->type(5);
        eqp_LFg->box(FL_FLAT_BOX);
        eqp_LFg->color((Fl_Color)178);
        eqp_LFg->selection_color((Fl_Color)62);
        eqp_LFg->labeltype(FL_NORMAL_LABEL);
        eqp_LFg->labelfont(0);
        eqp_LFg->labelsize(10);
        eqp_LFg->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_LFg->minimum(-64);
        eqp_LFg->maximum(63);
        eqp_LFg->step(1);
        eqp_LFg->textcolor(7);
        eqp_LFg->callback((Fl_Callback*)cb_eqp_LFg);
        eqp_LFg->align(FL_ALIGN_LEFT);
        eqp_LFg->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_LFg
      { eqp_LQ = new SliderW(689, 489, 100, 10, gettext("Q"));
        eqp_LQ->type(5);
        eqp_LQ->box(FL_FLAT_BOX);
        eqp_LQ->color((Fl_Color)178);
        eqp_LQ->selection_color((Fl_Color)62);
        eqp_LQ->labeltype(FL_NORMAL_LABEL);
        eqp_LQ->labelfont(0);
        eqp_LQ->labelsize(10);
        eqp_LQ->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_LQ->minimum(-64);
        eqp_LQ->maximum(63);
        eqp_LQ->step(1);
        eqp_LQ->textcolor(7);
        eqp_LQ->callback((Fl_Callback*)cb_eqp_LQ);
        eqp_LQ->align(FL_ALIGN_LEFT);
        eqp_LQ->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_LQ
      { eqp_MF = new SliderW(689, 511, 100, 10, gettext("Mid F."));
        eqp_MF->type(5);
        eqp_MF->box(FL_FLAT_BOX);
        eqp_MF->color((Fl_Color)178);
        eqp_MF->selection_color((Fl_Color)62);
        eqp_MF->labeltype(FL_NORMAL_LABEL);
        eqp_MF->labelfont(0);
        eqp_MF->labelsize(10);
        eqp_MF->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_MF->minimum(49);
        eqp_MF->maximum(99);
        eqp_MF->step(1);
        eqp_MF->value(75);
        eqp_MF->textcolor(7);
        eqp_MF->callback((Fl_Callback*)cb_eqp_MF);
        eqp_MF->align(FL_ALIGN_LEFT);
        eqp_MF->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_MF
      { eqp_MFg = new SliderW(689, 523, 100, 10, gettext("Mid G."));
        eqp_MFg->type(5);
        eqp_MFg->box(FL_FLAT_BOX);
        eqp_MFg->color((Fl_Color)178);
        eqp_MFg->selection_color((Fl_Color)62);
        eqp_MFg->labeltype(FL_NORMAL_LABEL);
        eqp_MFg->labelfont(0);
        eqp_MFg->labelsize(10);
        eqp_MFg->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_MFg->minimum(-64);
        eqp_MFg->maximum(63);
        eqp_MFg->step(1);
        eqp_MFg->textcolor(7);
        eqp_MFg->callback((Fl_Callback*)cb_eqp_MFg);
        eqp_MFg->align(FL_ALIGN_LEFT);
        eqp_MFg->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_MFg
      { eqp_MQ = new SliderW(689, 535, 100, 10, gettext("Q"));
        eqp_MQ->type(5);
        eqp_MQ->box(FL_FLAT_BOX);
        eqp_MQ->color((Fl_Color)178);
        eqp_MQ->selection_color((Fl_Color)62);
        eqp_MQ->labeltype(FL_NORMAL_LABEL);
        eqp_MQ->labelfont(0);
        eqp_MQ->labelsize(10);
        eqp_MQ->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_MQ->minimum(-64);
        eqp_MQ->maximum(63);
        eqp_MQ->step(1);
        eqp_MQ->textcolor(7);
        eqp_MQ->callback((Fl_Callback*)cb_eqp_MQ);
        eqp_MQ->align(FL_ALIGN_LEFT);
        eqp_MQ->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_MQ
      { eqp_HF = new SliderW(689, 557, 100, 10, gettext("High F."));
        eqp_HF->type(5);
        eqp_HF->box(FL_FLAT_BOX);
        eqp_HF->color((Fl_Color)178);
        eqp_HF->selection_color((Fl_Color)62);
        eqp_HF->labeltype(FL_NORMAL_LABEL);
        eqp_HF->labelfont(0);
        eqp_HF->labelsize(10);
        eqp_HF->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_HF->minimum(100);
        eqp_HF->maximum(127);
        eqp_HF->step(1);
        eqp_HF->value(106);
        eqp_HF->textcolor(7);
        eqp_HF->callback((Fl_Callback*)cb_eqp_HF);
        eqp_HF->align(FL_ALIGN_LEFT);
        eqp_HF->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_HF
      { eqp_HFg = new SliderW(689, 569, 100, 10, gettext("High G."));
        eqp_HFg->type(5);
        eqp_HFg->box(FL_FLAT_BOX);
        eqp_HFg->color((Fl_Color)178);
        eqp_HFg->selection_color((Fl_Color)62);
        eqp_HFg->labeltype(FL_NORMAL_LABEL);
        eqp_HFg->labelfont(0);
        eqp_HFg->labelsize(10);
        eqp_HFg->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_HFg->minimum(-64);
        eqp_HFg->maximum(63);
        eqp_HFg->step(1);
        eqp_HFg->textcolor(7);
        eqp_HFg->callback((Fl_Callback*)cb_eqp_HFg);
        eqp_HFg->align(FL_ALIGN_LEFT);
        eqp_HFg->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_HFg
      { eqp_HQ = new SliderW(689, 581, 100, 10, gettext("Q"));
        eqp_HQ->type(5);
        eqp_HQ->box(FL_FLAT_BOX);
        eqp_HQ->color((Fl_Color)178);
        eqp_HQ->selection_color((Fl_Color)62);
        eqp_HQ->labeltype(FL_NORMAL_LABEL);
        eqp_HQ->labelfont(0);
        eqp_HQ->labelsize(10);
        eqp_HQ->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_HQ->minimum(-64);
        eqp_HQ->maximum(63);
        eqp_HQ->step(1);
        eqp_HQ->textcolor(7);
        eqp_HQ->callback((Fl_Callback*)cb_eqp_HQ);
        eqp_HQ->align(FL_ALIGN_LEFT);
        eqp_HQ->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_HQ
      PEQ->end();
    } // Fl_Group* PEQ
    { WHAWHA = new Fl_Group(162, 26, 158, 184, gettext("WahWah"));
      WHAWHA->box(FL_PLASTIC_DOWN_FRAME);
      WHAWHA->color(FL_BACKGROUND2_COLOR);
      WHAWHA->labelfont(1);
      WHAWHA->labelcolor(FL_BACKGROUND2_COLOR);
      WHAWHA->hide();
      { WhaWha_activar = new Fl_Light_Button(166, 30, 34, 18, gettext("On"));
        WhaWha_activar->shortcut(0x36);
        WhaWha_activar->color((Fl_Color)62);
        WhaWha_activar->selection_color((Fl_Color)1);
        WhaWha_activar->labelsize(10);
        WhaWha_activar->callback((Fl_Callback*)cb_WhaWha_activar);
        WhaWha_activar->align(68|FL_ALIGN_INSIDE);
        WhaWha_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* WhaWha_activar
      { WhaWha_preset = new Fl_Choice(240, 30, 76, 18, gettext("Preset"));
        WhaWha_preset->down_box(FL_BORDER_BOX);
        WhaWha_preset->selection_color(FL_FOREGROUND_COLOR);
        WhaWha_preset->labelsize(10);
        WhaWha_preset->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_preset->textsize(10);
        WhaWha_preset->callback((Fl_Callback*)cb_WhaWha_preset);
        WhaWha_preset->when(FL_WHEN_RELEASE_ALWAYS);
        WhaWha_preset->menu(menu_WhaWha_preset);
      } // Fl_Choice* WhaWha_preset
      { WhaWha_WD = new SliderW(211, 55, 100, 10, gettext("Wet/Dry"));
        WhaWha_WD->type(5);
        WhaWha_WD->box(FL_FLAT_BOX);
        WhaWha_WD->color((Fl_Color)178);
        WhaWha_WD->selection_color((Fl_Color)62);
        WhaWha_WD->labeltype(FL_NORMAL_LABEL);
        WhaWha_WD->labelfont(0);
        WhaWha_WD->labelsize(10);
        WhaWha_WD->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_WD->minimum(-64);
        WhaWha_WD->maximum(63);
        WhaWha_WD->step(1);
        WhaWha_WD->textcolor(7);
        WhaWha_WD->callback((Fl_Callback*)cb_WhaWha_WD);
        WhaWha_WD->align(FL_ALIGN_LEFT);
        WhaWha_WD->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_WD
      { WhaWha_pan = new SliderW(211, 67, 100, 10, gettext("Pan"));
        WhaWha_pan->type(5);
        WhaWha_pan->box(FL_FLAT_BOX);
        WhaWha_pan->color((Fl_Color)178);
        WhaWha_pan->selection_color((Fl_Color)62);
        WhaWha_pan->labeltype(FL_NORMAL_LABEL);
        WhaWha_pan->labelfont(0);
        WhaWha_pan->labelsize(10);
        WhaWha_pan->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_pan->minimum(-64);
        WhaWha_pan->maximum(63);
        WhaWha_pan->step(1);
        WhaWha_pan->textcolor(7);
        WhaWha_pan->callback((Fl_Callback*)cb_WhaWha_pan);
        WhaWha_pan->align(FL_ALIGN_LEFT);
        WhaWha_pan->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_pan
      { WhaWha_freq = new SliderW(211, 79, 100, 10, gettext("Freq"));
        WhaWha_freq->type(5);
        WhaWha_freq->box(FL_FLAT_BOX);
        WhaWha_freq->color((Fl_Color)178);
        WhaWha_freq->selection_color((Fl_Color)62);
        WhaWha_freq->labeltype(FL_NORMAL_LABEL);
        WhaWha_freq->labelfont(0);
        WhaWha_freq->labelsize(10);
        WhaWha_freq->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_freq->maximum(127);
        WhaWha_freq->step(1);
        WhaWha_freq->textcolor(7);
        WhaWha_freq->callback((Fl_Callback*)cb_WhaWha_freq);
        WhaWha_freq->align(FL_ALIGN_LEFT);
        WhaWha_freq->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_freq
      { WhaWha_rnd = new SliderW(211, 91, 100, 10, gettext("Rnd"));
        WhaWha_rnd->type(5);
        WhaWha_rnd->box(FL_FLAT_BOX);
        WhaWha_rnd->color((Fl_Color)178);
        WhaWha_rnd->selection_color((Fl_Color)62);
        WhaWha_rnd->labeltype(FL_NORMAL_LABEL);
        WhaWha_rnd->labelfont(0);
        WhaWha_rnd->labelsize(10);
        WhaWha_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_rnd->maximum(127);
        WhaWha_rnd->step(1);
        WhaWha_rnd->textcolor(7);
        WhaWha_rnd->callback((Fl_Callback*)cb_WhaWha_rnd);
        WhaWha_rnd->align(FL_ALIGN_LEFT);
        WhaWha_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_rnd
      { WhaWha_lfotype = new Fl_Choice(223, 105, 72, 16, gettext("LFO Type"));
        WhaWha_lfotype->down_box(FL_BORDER_BOX);
        WhaWha_lfotype->selection_color(FL_FOREGROUND_COLOR);
        WhaWha_lfotype->labelsize(10);
        WhaWha_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_lfotype->textsize(10);
        WhaWha_lfotype->callback((Fl_Callback*)cb_WhaWha_lfotype);
        WhaWha_lfotype->menu(menu_WhaWha_lfotype);
      } // Fl_Choice* WhaWha_lfotype
      { WhaWha_stdf = new SliderW(211, 143, 100, 10, gettext("St.df"));
        WhaWha_stdf->type(5);
        WhaWha_stdf->box(FL_FLAT_BOX);
        WhaWha_stdf->color((Fl_Color)178);
        WhaWha_stdf->selection_color((Fl_Color)62);
        WhaWha_stdf->labeltype(FL_NORMAL_LABEL);
        WhaWha_stdf->labelfont(0);
        WhaWha_stdf->labelsize(10);
        WhaWha_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_stdf->maximum(127);
        WhaWha_stdf->step(1);
        WhaWha_stdf->textcolor(7);
        WhaWha_stdf->callback((Fl_Callback*)cb_WhaWha_stdf);
        WhaWha_stdf->align(FL_ALIGN_LEFT);
        WhaWha_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_stdf
      { WhaWha_dpth = new SliderW(211, 155, 100, 10, gettext("Depth"));
        WhaWha_dpth->type(5);
        WhaWha_dpth->box(FL_FLAT_BOX);
        WhaWha_dpth->color((Fl_Color)178);
        WhaWha_dpth->selection_color((Fl_Color)62);
        WhaWha_dpth->labeltype(FL_NORMAL_LABEL);
        WhaWha_dpth->labelfont(0);
        WhaWha_dpth->labelsize(10);
        WhaWha_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_dpth->maximum(127);
        WhaWha_dpth->step(1);
        WhaWha_dpth->textcolor(7);
        WhaWha_dpth->callback((Fl_Callback*)cb_WhaWha_dpth);
        WhaWha_dpth->align(FL_ALIGN_LEFT);
        WhaWha_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_dpth
      { WhaWha_ampsns = new SliderW(211, 167, 100, 10, gettext("Amp.S."));
        WhaWha_ampsns->type(5);
        WhaWha_ampsns->box(FL_FLAT_BOX);
        WhaWha_ampsns->color((Fl_Color)178);
        WhaWha_ampsns->selection_color((Fl_Color)62);
        WhaWha_ampsns->labeltype(FL_NORMAL_LABEL);
        WhaWha_ampsns->labelfont(0);
        WhaWha_ampsns->labelsize(10);
        WhaWha_ampsns->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_ampsns->maximum(127);
        WhaWha_ampsns->step(1);
        WhaWha_ampsns->textcolor(7);
        WhaWha_ampsns->callback((Fl_Callback*)cb_WhaWha_ampsns);
        WhaWha_ampsns->align(FL_ALIGN_LEFT);
        WhaWha_ampsns->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_ampsns
      { WhaWha_ampsnsinv = new SliderW(211, 179, 100, 10, gettext("Amp.S.I"));
        WhaWha_ampsnsinv->type(5);
        WhaWha_ampsnsinv->box(FL_FLAT_BOX);
        WhaWha_ampsnsinv->color((Fl_Color)178);
        WhaWha_ampsnsinv->selection_color((Fl_Color)62);
        WhaWha_ampsnsinv->labeltype(FL_NORMAL_LABEL);
        WhaWha_ampsnsinv->labelfont(0);
        WhaWha_ampsnsinv->labelsize(10);
        WhaWha_ampsnsinv->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_ampsnsinv->maximum(127);
        WhaWha_ampsnsinv->step(1);
        WhaWha_ampsnsinv->textcolor(7);
        WhaWha_ampsnsinv->callback((Fl_Callback*)cb_WhaWha_ampsnsinv);
        WhaWha_ampsnsinv->align(FL_ALIGN_LEFT);
        WhaWha_ampsnsinv->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_ampsnsinv
      { WhaWha_smooth = new SliderW(211, 191, 100, 10, gettext("Smooth"));
        WhaWha_smooth->type(5);
        WhaWha_smooth->box(FL_FLAT_BOX);
        WhaWha_smooth->color((Fl_Color)178);
        WhaWha_smooth->selection_color((Fl_Color)62);
        WhaWha_smooth->labeltype(FL_NORMAL_LABEL);
        WhaWha_smooth->labelfont(0);
        WhaWha_smooth->labelsize(10);
        WhaWha_smooth->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_smooth->maximum(127);
        WhaWha_smooth->step(1);
        WhaWha_smooth->textcolor(7);
        WhaWha_smooth->callback((Fl_Callback*)cb_WhaWha_smooth);
        WhaWha_smooth->align(FL_ALIGN_LEFT);
        WhaWha_smooth->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_smooth
      WHAWHA->end();
    } // Fl_Group* WHAWHA
    { ALIENWAH = new Fl_Group(356, 23, 158, 184, gettext("AlienWah"));
      ALIENWAH->box(FL_PLASTIC_DOWN_FRAME);
      ALIENWAH->color(FL_BACKGROUND2_COLOR);
      ALIENWAH->labelfont(1);
      ALIENWAH->labelcolor(FL_BACKGROUND2_COLOR);
      ALIENWAH->hide();
      { Alienwah_activar = new Fl_Light_Button(360, 27, 34, 18, gettext("On"));
        Alienwah_activar->shortcut(0x36);
        Alienwah_activar->color((Fl_Color)62);
        Alienwah_activar->selection_color((Fl_Color)1);
        Alienwah_activar->labelsize(10);
        Alienwah_activar->callback((Fl_Callback*)cb_Alienwah_activar);
        Alienwah_activar->align(68|FL_ALIGN_INSIDE);
        Alienwah_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Alienwah_activar
      { Alienwah_preset = new Fl_Choice(433, 27, 76, 18, gettext("Preset"));
        Alienwah_preset->down_box(FL_BORDER_BOX);
        Alienwah_preset->selection_color(FL_FOREGROUND_COLOR);
        Alienwah_preset->labelsize(10);
        Alienwah_preset->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_preset->textsize(10);
        Alienwah_preset->callback((Fl_Callback*)cb_Alienwah_preset);
        Alienwah_preset->when(FL_WHEN_RELEASE_ALWAYS);
        Alienwah_preset->menu(menu_Alienwah_preset);
      } // Fl_Choice* Alienwah_preset
      { Alienwah_WD = new SliderW(404, 52, 100, 10, gettext("Wet/Dry"));
        Alienwah_WD->type(5);
        Alienwah_WD->box(FL_FLAT_BOX);
        Alienwah_WD->color((Fl_Color)178);
        Alienwah_WD->selection_color((Fl_Color)62);
        Alienwah_WD->labeltype(FL_NORMAL_LABEL);
        Alienwah_WD->labelfont(0);
        Alienwah_WD->labelsize(10);
        Alienwah_WD->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_WD->minimum(-64);
        Alienwah_WD->maximum(63);
        Alienwah_WD->step(1);
        Alienwah_WD->textcolor(7);
        Alienwah_WD->callback((Fl_Callback*)cb_Alienwah_WD);
        Alienwah_WD->align(FL_ALIGN_LEFT);
        Alienwah_WD->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_WD
      { Alienwah_pan = new SliderW(404, 64, 100, 10, gettext("Pan"));
        Alienwah_pan->type(5);
        Alienwah_pan->box(FL_FLAT_BOX);
        Alienwah_pan->color((Fl_Color)178);
        Alienwah_pan->selection_color((Fl_Color)62);
        Alienwah_pan->labeltype(FL_NORMAL_LABEL);
        Alienwah_pan->labelfont(0);
        Alienwah_pan->labelsize(10);
        Alienwah_pan->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_pan->minimum(-64);
        Alienwah_pan->maximum(63);
        Alienwah_pan->step(1);
        Alienwah_pan->textcolor(7);
        Alienwah_pan->callback((Fl_Callback*)cb_Alienwah_pan);
        Alienwah_pan->align(FL_ALIGN_LEFT);
        Alienwah_pan->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_pan
      { Alienwah_freq = new SliderW(404, 76, 100, 10, gettext("Freq"));
        Alienwah_freq->type(5);
        Alienwah_freq->box(FL_FLAT_BOX);
        Alienwah_freq->color((Fl_Color)178);
        Alienwah_freq->selection_color((Fl_Color)62);
        Alienwah_freq->labeltype(FL_NORMAL_LABEL);
        Alienwah_freq->labelfont(0);
        Alienwah_freq->labelsize(10);
        Alienwah_freq->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_freq->maximum(127);
        Alienwah_freq->step(1);
        Alienwah_freq->textcolor(7);
        Alienwah_freq->callback((Fl_Callback*)cb_Alienwah_freq);
        Alienwah_freq->align(FL_ALIGN_LEFT);
        Alienwah_freq->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_freq
      { Alienwah_rnd = new SliderW(404, 88, 100, 10, gettext("Rnd"));
        Alienwah_rnd->type(5);
        Alienwah_rnd->box(FL_FLAT_BOX);
        Alienwah_rnd->color((Fl_Color)178);
        Alienwah_rnd->selection_color((Fl_Color)62);
        Alienwah_rnd->labeltype(FL_NORMAL_LABEL);
        Alienwah_rnd->labelfont(0);
        Alienwah_rnd->labelsize(10);
        Alienwah_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_rnd->maximum(127);
        Alienwah_rnd->step(1);
        Alienwah_rnd->textcolor(7);
        Alienwah_rnd->callback((Fl_Callback*)cb_Alienwah_rnd);
        Alienwah_rnd->align(FL_ALIGN_LEFT);
        Alienwah_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_rnd
      { Alienwah_lfotype = new Fl_Choice(416, 102, 72, 16, gettext("LFO Type"));
        Alienwah_lfotype->down_box(FL_BORDER_BOX);
        Alienwah_lfotype->selection_color(FL_FOREGROUND_COLOR);
        Alienwah_lfotype->labelsize(10);
        Alienwah_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_lfotype->textsize(10);
        Alienwah_lfotype->callback((Fl_Callback*)cb_Alienwah_lfotype);
        Alienwah_lfotype->menu(menu_Alienwah_lfotype);
      } // Fl_Choice* Alienwah_lfotype
      { Alienwah_phase = new SliderW(404, 128, 100, 10, gettext("Phase"));
        Alienwah_phase->type(5);
        Alienwah_phase->box(FL_FLAT_BOX);
        Alienwah_phase->color((Fl_Color)178);
        Alienwah_phase->selection_color((Fl_Color)62);
        Alienwah_phase->labeltype(FL_NORMAL_LABEL);
        Alienwah_phase->labelfont(0);
        Alienwah_phase->labelsize(10);
        Alienwah_phase->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_phase->maximum(127);
        Alienwah_phase->step(1);
        Alienwah_phase->textcolor(7);
        Alienwah_phase->callback((Fl_Callback*)cb_Alienwah_phase);
        Alienwah_phase->align(FL_ALIGN_LEFT);
        Alienwah_phase->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_phase
      { Alienwah_stdf = new SliderW(404, 140, 100, 10, gettext("St.df"));
        Alienwah_stdf->type(5);
        Alienwah_stdf->box(FL_FLAT_BOX);
        Alienwah_stdf->color((Fl_Color)178);
        Alienwah_stdf->selection_color((Fl_Color)62);
        Alienwah_stdf->labeltype(FL_NORMAL_LABEL);
        Alienwah_stdf->labelfont(0);
        Alienwah_stdf->labelsize(10);
        Alienwah_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_stdf->maximum(127);
        Alienwah_stdf->step(1);
        Alienwah_stdf->textcolor(7);
        Alienwah_stdf->callback((Fl_Callback*)cb_Alienwah_stdf);
        Alienwah_stdf->align(FL_ALIGN_LEFT);
        Alienwah_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_stdf
      { Alienwah_dpth = new SliderW(404, 152, 100, 10, gettext("Depth"));
        Alienwah_dpth->type(5);
        Alienwah_dpth->box(FL_FLAT_BOX);
        Alienwah_dpth->color((Fl_Color)178);
        Alienwah_dpth->selection_color((Fl_Color)62);
        Alienwah_dpth->labeltype(FL_NORMAL_LABEL);
        Alienwah_dpth->labelfont(0);
        Alienwah_dpth->labelsize(10);
        Alienwah_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_dpth->maximum(127);
        Alienwah_dpth->step(1);
        Alienwah_dpth->textcolor(7);
        Alienwah_dpth->callback((Fl_Callback*)cb_Alienwah_dpth);
        Alienwah_dpth->align(FL_ALIGN_LEFT);
        Alienwah_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_dpth
      { Alienwah_delay = new SliderW(404, 164, 100, 10, gettext("Delay"));
        Alienwah_delay->type(5);
        Alienwah_delay->box(FL_FLAT_BOX);
        Alienwah_delay->color((Fl_Color)178);
        Alienwah_delay->selection_color((Fl_Color)62);
        Alienwah_delay->labeltype(FL_NORMAL_LABEL);
        Alienwah_delay->labelfont(0);
        Alienwah_delay->labelsize(10);
        Alienwah_delay->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_delay->maximum(127);
        Alienwah_delay->step(1);
        Alienwah_delay->textcolor(7);
        Alienwah_delay->callback((Fl_Callback*)cb_Alienwah_delay);
        Alienwah_delay->align(FL_ALIGN_LEFT);
        Alienwah_delay->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_delay
      { Alienwah_fb = new SliderW(404, 176, 100, 10, gettext("Fb"));
        Alienwah_fb->type(5);
        Alienwah_fb->box(FL_FLAT_BOX);
        Alienwah_fb->color((Fl_Color)178);
        Alienwah_fb->selection_color((Fl_Color)62);
        Alienwah_fb->labeltype(FL_NORMAL_LABEL);
        Alienwah_fb->labelfont(0);
        Alienwah_fb->labelsize(10);
        Alienwah_fb->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_fb->maximum(127);
        Alienwah_fb->step(1);
        Alienwah_fb->textcolor(7);
        Alienwah_fb->callback((Fl_Callback*)cb_Alienwah_fb);
        Alienwah_fb->align(FL_ALIGN_LEFT);
        Alienwah_fb->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_fb
      { Alienwah_LR = new SliderW(404, 189, 100, 10, gettext("L/R.Cr"));
        Alienwah_LR->type(5);
        Alienwah_LR->box(FL_FLAT_BOX);
        Alienwah_LR->color((Fl_Color)178);
        Alienwah_LR->selection_color((Fl_Color)62);
        Alienwah_LR->labeltype(FL_NORMAL_LABEL);
        Alienwah_LR->labelfont(0);
        Alienwah_LR->labelsize(10);
        Alienwah_LR->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_LR->minimum(-64);
        Alienwah_LR->maximum(63);
        Alienwah_LR->step(1);
        Alienwah_LR->textcolor(7);
        Alienwah_LR->callback((Fl_Callback*)cb_Alienwah_LR);
        Alienwah_LR->align(FL_ALIGN_LEFT);
        Alienwah_LR->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_LR
      ALIENWAH->end();
    } // Fl_Group* ALIENWAH
    { CABINET = new Fl_Group(35, 44, 158, 184, gettext("Cabinet"));
      CABINET->box(FL_PLASTIC_DOWN_FRAME);
      CABINET->color(FL_BACKGROUND2_COLOR);
      CABINET->labelfont(1);
      CABINET->labelcolor(FL_BACKGROUND2_COLOR);
      CABINET->hide();
      { Cabinet_activar = new Fl_Light_Button(40, 48, 34, 18, gettext("On"));
        Cabinet_activar->shortcut(0x32);
        Cabinet_activar->color((Fl_Color)62);
        Cabinet_activar->selection_color((Fl_Color)1);
        Cabinet_activar->labelsize(10);
        Cabinet_activar->callback((Fl_Callback*)cb_Cabinet_activar);
        Cabinet_activar->align(68|FL_ALIGN_INSIDE);
        Cabinet_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Cabinet_activar
      { Cabinet_preset = new Fl_Choice(80, 89, 106, 18, gettext("Preset"));
        Cabinet_preset->down_box(FL_BORDER_BOX);
        Cabinet_preset->selection_color(FL_FOREGROUND_COLOR);
        Cabinet_preset->labelsize(10);
        Cabinet_preset->labelcolor(FL_BACKGROUND2_COLOR);
        Cabinet_preset->textsize(10);
        Cabinet_preset->callback((Fl_Callback*)cb_Cabinet_preset);
        Cabinet_preset->when(FL_WHEN_RELEASE_ALWAYS);
        Cabinet_preset->menu(menu_Cabinet_preset);
      } // Fl_Choice* Cabinet_preset
      { Cabinet_output = new SliderW(83, 136, 100, 10, gettext("Gain"));
        Cabinet_output->type(5);
        Cabinet_output->box(FL_FLAT_BOX);
        Cabinet_output->color((Fl_Color)178);
        Cabinet_output->selection_color((Fl_Color)62);
        Cabinet_output->labeltype(FL_NORMAL_LABEL);
        Cabinet_output->labelfont(0);
        Cabinet_output->labelsize(10);
        Cabinet_output->labelcolor(FL_BACKGROUND2_COLOR);
        Cabinet_output->minimum(-64);
        Cabinet_output->maximum(63);
        Cabinet_output->step(1);
        Cabinet_output->textcolor(7);
        Cabinet_output->callback((Fl_Callback*)cb_Cabinet_output);
        Cabinet_output->align(FL_ALIGN_LEFT);
        Cabinet_output->when(FL_WHEN_CHANGED);
      } // SliderW* Cabinet_output
      CABINET->end();
    } // Fl_Group* CABINET
    { PAN = new Fl_Group(3, 212, 158, 184, gettext("AutoPan/E.Stereo"));
      PAN->box(FL_PLASTIC_DOWN_FRAME);
      PAN->color(FL_BACKGROUND2_COLOR);
      PAN->labelfont(1);
      PAN->labelcolor(FL_BACKGROUND2_COLOR);
      PAN->hide();
      { pan_activar = new Fl_Light_Button(8, 216, 34, 18, gettext("On"));
        pan_activar->shortcut(0x36);
        pan_activar->color((Fl_Color)62);
        pan_activar->selection_color((Fl_Color)1);
        pan_activar->labelsize(10);
        pan_activar->callback((Fl_Callback*)cb_pan_activar);
        pan_activar->align(68|FL_ALIGN_INSIDE);
        pan_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* pan_activar
      { pan_preset = new Fl_Choice(79, 216, 76, 18, gettext("Preset"));
        pan_preset->down_box(FL_BORDER_BOX);
        pan_preset->selection_color(FL_FOREGROUND_COLOR);
        pan_preset->labelsize(10);
        pan_preset->labelcolor(FL_BACKGROUND2_COLOR);
        pan_preset->textsize(10);
        pan_preset->callback((Fl_Callback*)cb_pan_preset);
        pan_preset->when(FL_WHEN_RELEASE_ALWAYS);
        pan_preset->menu(menu_pan_preset);
      } // Fl_Choice* pan_preset
      { pan_WD = new SliderW(52, 241, 100, 10, gettext("Wet/Dry"));
        pan_WD->type(5);
        pan_WD->box(FL_FLAT_BOX);
        pan_WD->color((Fl_Color)178);
        pan_WD->selection_color((Fl_Color)62);
        pan_WD->labeltype(FL_NORMAL_LABEL);
        pan_WD->labelfont(0);
        pan_WD->labelsize(10);
        pan_WD->labelcolor(FL_BACKGROUND2_COLOR);
        pan_WD->minimum(-64);
        pan_WD->maximum(63);
        pan_WD->step(1);
        pan_WD->textcolor(7);
        pan_WD->callback((Fl_Callback*)cb_pan_WD);
        pan_WD->align(FL_ALIGN_LEFT);
        pan_WD->when(FL_WHEN_CHANGED);
      } // SliderW* pan_WD
      { pan_autopan = new Fl_Check_Button(38, 256, 64, 15, gettext("AutoPan"));
        pan_autopan->down_box(FL_DOWN_BOX);
        pan_autopan->labelsize(10);
        pan_autopan->labelcolor(FL_BACKGROUND2_COLOR);
        pan_autopan->callback((Fl_Callback*)cb_pan_autopan);
      } // Fl_Check_Button* pan_autopan
      { pan_pan = new SliderW(52, 273, 100, 10, gettext("Pan"));
        pan_pan->type(5);
        pan_pan->box(FL_FLAT_BOX);
        pan_pan->color((Fl_Color)178);
        pan_pan->selection_color((Fl_Color)62);
        pan_pan->labeltype(FL_NORMAL_LABEL);
        pan_pan->labelfont(0);
        pan_pan->labelsize(10);
        pan_pan->labelcolor(FL_BACKGROUND2_COLOR);
        pan_pan->minimum(-64);
        pan_pan->maximum(63);
        pan_pan->step(1);
        pan_pan->textcolor(7);
        pan_pan->callback((Fl_Callback*)cb_pan_pan);
        pan_pan->align(FL_ALIGN_LEFT);
        pan_pan->when(FL_WHEN_CHANGED);
      } // SliderW* pan_pan
      { pan_freq = new SliderW(52, 285, 100, 10, gettext("Freq"));
        pan_freq->type(5);
        pan_freq->box(FL_FLAT_BOX);
        pan_freq->color((Fl_Color)178);
        pan_freq->selection_color((Fl_Color)62);
        pan_freq->labeltype(FL_NORMAL_LABEL);
        pan_freq->labelfont(0);
        pan_freq->labelsize(10);
        pan_freq->labelcolor(FL_BACKGROUND2_COLOR);
        pan_freq->maximum(127);
        pan_freq->step(1);
        pan_freq->textcolor(7);
        pan_freq->callback((Fl_Callback*)cb_pan_freq);
        pan_freq->align(FL_ALIGN_LEFT);
        pan_freq->when(FL_WHEN_CHANGED);
      } // SliderW* pan_freq
      { pan_rnd = new SliderW(52, 297, 100, 10, gettext("Rnd"));
        pan_rnd->type(5);
        pan_rnd->box(FL_FLAT_BOX);
        pan_rnd->color((Fl_Color)178);
        pan_rnd->selection_color((Fl_Color)62);
        pan_rnd->labeltype(FL_NORMAL_LABEL);
        pan_rnd->labelfont(0);
        pan_rnd->labelsize(10);
        pan_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        pan_rnd->maximum(127);
        pan_rnd->step(1);
        pan_rnd->textcolor(7);
        pan_rnd->callback((Fl_Callback*)cb_pan_rnd);
        pan_rnd->align(FL_ALIGN_LEFT);
        pan_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* pan_rnd
      { pan_lfotype = new Fl_Choice(64, 315, 72, 16, gettext("LFO Type"));
        pan_lfotype->down_box(FL_BORDER_BOX);
        pan_lfotype->selection_color(FL_FOREGROUND_COLOR);
        pan_lfotype->labelsize(10);
        pan_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        pan_lfotype->textsize(10);
        pan_lfotype->callback((Fl_Callback*)cb_pan_lfotype);
        pan_lfotype->menu(menu_pan_lfotype);
      } // Fl_Choice* pan_lfotype
      { pan_stdf = new SliderW(52, 336, 100, 10, gettext("St.df"));
        pan_stdf->type(5);
        pan_stdf->box(FL_FLAT_BOX);
        pan_stdf->color((Fl_Color)178);
        pan_stdf->selection_color((Fl_Color)62);
        pan_stdf->labeltype(FL_NORMAL_LABEL);
        pan_stdf->labelfont(0);
        pan_stdf->labelsize(10);
        pan_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        pan_stdf->maximum(127);
        pan_stdf->step(1);
        pan_stdf->textcolor(7);
        pan_stdf->callback((Fl_Callback*)cb_pan_stdf);
        pan_stdf->align(FL_ALIGN_LEFT);
        pan_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* pan_stdf
      { pan_extraon = new Fl_Check_Button(38, 352, 64, 15, gettext("Extra Stereo"));
        pan_extraon->down_box(FL_DOWN_BOX);
        pan_extraon->labelsize(10);
        pan_extraon->labelcolor(FL_BACKGROUND2_COLOR);
        pan_extraon->callback((Fl_Callback*)cb_pan_extraon);
      } // Fl_Check_Button* pan_extraon
      { pan_extra = new SliderW(52, 373, 100, 10, gettext("E.S."));
        pan_extra->type(5);
        pan_extra->box(FL_FLAT_BOX);
        pan_extra->color((Fl_Color)178);
        pan_extra->selection_color((Fl_Color)62);
        pan_extra->labeltype(FL_NORMAL_LABEL);
        pan_extra->labelfont(0);
        pan_extra->labelsize(10);
        pan_extra->labelcolor(FL_BACKGROUND2_COLOR);
        pan_extra->maximum(127);
        pan_extra->step(1);
        pan_extra->textcolor(7);
        pan_extra->callback((Fl_Callback*)cb_pan_extra);
        pan_extra->align(FL_ALIGN_LEFT);
        pan_extra->when(FL_WHEN_CHANGED);
      } // SliderW* pan_extra
      PAN->end();
    } // Fl_Group* PAN
    { HAR = new Fl_Group(321, 212, 158, 184, gettext("Harmonizer"));
      HAR->box(FL_PLASTIC_DOWN_FRAME);
      HAR->color(FL_BACKGROUND2_COLOR);
      HAR->labelfont(1);
      HAR->labelcolor(FL_BACKGROUND2_COLOR);
      HAR->align(65);
      HAR->hide();
      { har_activar = new Fl_Light_Button(326, 216, 34, 18, gettext("On"));
        har_activar->shortcut(0x30);
        har_activar->color((Fl_Color)62);
        har_activar->selection_color((Fl_Color)1);
        har_activar->labelsize(10);
        har_activar->callback((Fl_Callback*)cb_har_activar);
        har_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* har_activar
      { har_preset = new Fl_Choice(396, 216, 76, 18, gettext("Preset"));
        har_preset->down_box(FL_BORDER_BOX);
        har_preset->selection_color(FL_FOREGROUND_COLOR);
        har_preset->labelsize(10);
        har_preset->labelcolor(FL_BACKGROUND2_COLOR);
        har_preset->textsize(10);
        har_preset->callback((Fl_Callback*)cb_har_preset);
        har_preset->when(FL_WHEN_RELEASE_ALWAYS);
        har_preset->menu(menu_har_preset);
      } // Fl_Choice* har_preset
      { har_WD = new SliderW(371, 242, 100, 10, gettext("Wet/Dry"));
        har_WD->type(5);
        har_WD->box(FL_FLAT_BOX);
        har_WD->color((Fl_Color)178);
        har_WD->selection_color((Fl_Color)62);
        har_WD->labeltype(FL_NORMAL_LABEL);
        har_WD->labelfont(0);
        har_WD->labelsize(10);
        har_WD->labelcolor(FL_BACKGROUND2_COLOR);
        har_WD->minimum(-64);
        har_WD->maximum(63);
        har_WD->step(1);
        har_WD->textcolor(7);
        har_WD->callback((Fl_Callback*)cb_har_WD);
        har_WD->align(FL_ALIGN_LEFT);
        har_WD->when(FL_WHEN_CHANGED);
      } // SliderW* har_WD
      { har_int = new SliderW(371, 255, 100, 10, gettext("Int."));
        har_int->type(5);
        har_int->box(FL_FLAT_BOX);
        har_int->color((Fl_Color)178);
        har_int->selection_color((Fl_Color)62);
        har_int->labeltype(FL_NORMAL_LABEL);
        har_int->labelfont(0);
        har_int->labelsize(10);
        har_int->labelcolor(FL_BACKGROUND2_COLOR);
        har_int->minimum(-12);
        har_int->maximum(12);
        har_int->step(1);
        har_int->textcolor(7);
        har_int->callback((Fl_Callback*)cb_har_int);
        har_int->align(FL_ALIGN_LEFT);
        har_int->when(FL_WHEN_CHANGED);
      } // SliderW* har_int
      { har_gan = new SliderW(371, 270, 100, 10, gettext("Gain"));
        har_gan->type(5);
        har_gan->box(FL_FLAT_BOX);
        har_gan->color((Fl_Color)178);
        har_gan->selection_color((Fl_Color)62);
        har_gan->labeltype(FL_NORMAL_LABEL);
        har_gan->labelfont(0);
        har_gan->labelsize(10);
        har_gan->labelcolor(FL_BACKGROUND2_COLOR);
        har_gan->minimum(-64);
        har_gan->maximum(63);
        har_gan->step(1);
        har_gan->textcolor(7);
        har_gan->callback((Fl_Callback*)cb_har_gan);
        har_gan->align(FL_ALIGN_LEFT);
        har_gan->when(FL_WHEN_CHANGED);
      } // SliderW* har_gan
      { har_pan = new SliderW(371, 283, 100, 10, gettext("Pan"));
        har_pan->type(5);
        har_pan->box(FL_FLAT_BOX);
        har_pan->color((Fl_Color)178);
        har_pan->selection_color((Fl_Color)62);
        har_pan->labeltype(FL_NORMAL_LABEL);
        har_pan->labelfont(0);
        har_pan->labelsize(10);
        har_pan->labelcolor(FL_BACKGROUND2_COLOR);
        har_pan->minimum(-64);
        har_pan->maximum(63);
        har_pan->step(1);
        har_pan->textcolor(7);
        har_pan->callback((Fl_Callback*)cb_har_pan);
        har_pan->align(FL_ALIGN_LEFT);
        har_pan->when(FL_WHEN_CHANGED);
      } // SliderW* har_pan
      { har_freq1 = new SliderW(372, 300, 100, 10, gettext("Freq"));
        har_freq1->type(5);
        har_freq1->box(FL_FLAT_BOX);
        har_freq1->color((Fl_Color)178);
        har_freq1->selection_color((Fl_Color)62);
        har_freq1->labeltype(FL_NORMAL_LABEL);
        har_freq1->labelfont(0);
        har_freq1->labelsize(10);
        har_freq1->labelcolor(FL_BACKGROUND2_COLOR);
        har_freq1->maximum(127);
        har_freq1->step(1);
        har_freq1->textcolor(7);
        har_freq1->callback((Fl_Callback*)cb_har_freq1);
        har_freq1->align(FL_ALIGN_LEFT);
        har_freq1->when(FL_WHEN_CHANGED);
      } // SliderW* har_freq1
      { har_gan1 = new SliderW(371, 312, 100, 10, gettext("Gain"));
        har_gan1->type(5);
        har_gan1->box(FL_FLAT_BOX);
        har_gan1->color((Fl_Color)178);
        har_gan1->selection_color((Fl_Color)62);
        har_gan1->labeltype(FL_NORMAL_LABEL);
        har_gan1->labelfont(0);
        har_gan1->labelsize(10);
        har_gan1->labelcolor(FL_BACKGROUND2_COLOR);
        har_gan1->minimum(-64);
        har_gan1->maximum(63);
        har_gan1->step(1);
        har_gan1->textcolor(7);
        har_gan1->callback((Fl_Callback*)cb_har_gan1);
        har_gan1->align(FL_ALIGN_LEFT);
        har_gan1->when(FL_WHEN_CHANGED);
      } // SliderW* har_gan1
      { har_q1 = new SliderW(371, 324, 100, 10, gettext("Q"));
        har_q1->type(5);
        har_q1->box(FL_FLAT_BOX);
        har_q1->color((Fl_Color)178);
        har_q1->selection_color((Fl_Color)62);
        har_q1->labeltype(FL_NORMAL_LABEL);
        har_q1->labelfont(0);
        har_q1->labelsize(10);
        har_q1->labelcolor(FL_BACKGROUND2_COLOR);
        har_q1->minimum(-64);
        har_q1->maximum(63);
        har_q1->step(1);
        har_q1->textcolor(7);
        har_q1->callback((Fl_Callback*)cb_har_q1);
        har_q1->align(FL_ALIGN_LEFT);
        har_q1->when(FL_WHEN_CHANGED);
      } // SliderW* har_q1
      { har_MIDI = new Fl_Check_Button(330, 336, 41, 15, gettext("MIDI"));
        har_MIDI->down_box(FL_DOWN_BOX);
        har_MIDI->labelsize(10);
        har_MIDI->labelcolor(FL_BACKGROUND2_COLOR);
        har_MIDI->callback((Fl_Callback*)cb_har_MIDI);
        har_MIDI->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
      } // Fl_Check_Button* har_MIDI
      { har_SELECT = new Fl_Check_Button(330, 354, 37, 15, gettext("SEL"));
        har_SELECT->down_box(FL_DOWN_BOX);
        har_SELECT->labelsize(10);
        har_SELECT->labelcolor(FL_BACKGROUND2_COLOR);
        har_SELECT->callback((Fl_Callback*)cb_har_SELECT);
        har_SELECT->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
      } // Fl_Check_Button* har_SELECT
      { har_chordname = new Fl_Box(377, 338, 98, 27);
        har_chordname->labelsize(12);
        har_chordname->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* har_chordname
      { har_note = new SliderW(371, 370, 100, 10, gettext("Note"));
        har_note->type(5);
        har_note->box(FL_FLAT_BOX);
        har_note->color((Fl_Color)178);
        har_note->selection_color((Fl_Color)62);
        har_note->labeltype(FL_NORMAL_LABEL);
        har_note->labelfont(0);
        har_note->labelsize(10);
        har_note->labelcolor(FL_BACKGROUND2_COLOR);
        har_note->maximum(23);
        har_note->step(1);
        har_note->textcolor(7);
        har_note->callback((Fl_Callback*)cb_har_note);
        har_note->align(FL_ALIGN_LEFT);
        har_note->when(FL_WHEN_CHANGED);
      } // SliderW* har_note
      { har_type = new SliderW(371, 382, 100, 10, gettext("Chord"));
        har_type->type(5);
        har_type->box(FL_FLAT_BOX);
        har_type->color((Fl_Color)178);
        har_type->selection_color((Fl_Color)62);
        har_type->labeltype(FL_NORMAL_LABEL);
        har_type->labelfont(0);
        har_type->labelsize(10);
        har_type->labelcolor(FL_BACKGROUND2_COLOR);
        har_type->maximum(33);
        har_type->step(1);
        har_type->textcolor(7);
        har_type->callback((Fl_Callback*)cb_har_type);
        har_type->align(FL_ALIGN_LEFT);
        har_type->when(FL_WHEN_CHANGED);
      } // SliderW* har_type
      HAR->end();
    } // Fl_Group* HAR
    { MUSDELAY = new Fl_Group(479, 211, 158, 184, gettext("Musical Delay"));
      MUSDELAY->box(FL_PLASTIC_DOWN_FRAME);
      MUSDELAY->color(FL_BACKGROUND2_COLOR);
      MUSDELAY->labelfont(1);
      MUSDELAY->labelcolor(FL_BACKGROUND2_COLOR);
      MUSDELAY->hide();
      { musdelay_activar = new Fl_Light_Button(484, 215, 34, 18, gettext("On"));
        musdelay_activar->shortcut(0x35);
        musdelay_activar->color((Fl_Color)62);
        musdelay_activar->selection_color((Fl_Color)1);
        musdelay_activar->labelsize(10);
        musdelay_activar->callback((Fl_Callback*)cb_musdelay_activar);
        musdelay_activar->align(68|FL_ALIGN_INSIDE);
        musdelay_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* musdelay_activar
      { musdelay_preset = new Fl_Choice(556, 215, 76, 18, gettext("Preset"));
        musdelay_preset->down_box(FL_BORDER_BOX);
        musdelay_preset->selection_color(FL_FOREGROUND_COLOR);
        musdelay_preset->labelsize(10);
        musdelay_preset->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_preset->textsize(10);
        musdelay_preset->callback((Fl_Callback*)cb_musdelay_preset);
        musdelay_preset->when(FL_WHEN_RELEASE_ALWAYS);
        musdelay_preset->menu(menu_musdelay_preset);
      } // Fl_Choice* musdelay_preset
      { musdelay_WD = new SliderW(532, 237, 100, 10, gettext("Wet/Dry"));
        musdelay_WD->type(5);
        musdelay_WD->box(FL_FLAT_BOX);
        musdelay_WD->color((Fl_Color)178);
        musdelay_WD->selection_color((Fl_Color)62);
        musdelay_WD->labeltype(FL_NORMAL_LABEL);
        musdelay_WD->labelfont(0);
        musdelay_WD->labelsize(10);
        musdelay_WD->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_WD->minimum(-64);
        musdelay_WD->maximum(63);
        musdelay_WD->step(1);
        musdelay_WD->textcolor(7);
        musdelay_WD->callback((Fl_Callback*)cb_musdelay_WD);
        musdelay_WD->align(FL_ALIGN_LEFT);
        musdelay_WD->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_WD
      { musdelay_LRc = new SliderW(532, 249, 100, 10, gettext("L/R.Cr"));
        musdelay_LRc->type(5);
        musdelay_LRc->box(FL_FLAT_BOX);
        musdelay_LRc->color((Fl_Color)178);
        musdelay_LRc->selection_color((Fl_Color)62);
        musdelay_LRc->labeltype(FL_NORMAL_LABEL);
        musdelay_LRc->labelfont(0);
        musdelay_LRc->labelsize(10);
        musdelay_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_LRc->minimum(-64);
        musdelay_LRc->maximum(63);
        musdelay_LRc->step(1);
        musdelay_LRc->textcolor(7);
        musdelay_LRc->callback((Fl_Callback*)cb_musdelay_LRc);
        musdelay_LRc->align(FL_ALIGN_LEFT);
        musdelay_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_LRc
      { musdelay_tempo = new SliderW(532, 314, 100, 10, gettext("Tempo"));
        musdelay_tempo->type(5);
        musdelay_tempo->box(FL_FLAT_BOX);
        musdelay_tempo->color((Fl_Color)178);
        musdelay_tempo->selection_color((Fl_Color)62);
        musdelay_tempo->labeltype(FL_NORMAL_LABEL);
        musdelay_tempo->labelfont(0);
        musdelay_tempo->labelsize(10);
        musdelay_tempo->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_tempo->minimum(10);
        musdelay_tempo->maximum(480);
        musdelay_tempo->step(1);
        musdelay_tempo->textcolor(7);
        musdelay_tempo->callback((Fl_Callback*)cb_musdelay_tempo);
        musdelay_tempo->align(FL_ALIGN_LEFT);
        musdelay_tempo->when(FL_WHEN_RELEASE);
      } // SliderW* musdelay_tempo
      { musdelay_pan1 = new SliderW(532, 261, 100, 10, gettext("Pan1"));
        musdelay_pan1->type(5);
        musdelay_pan1->box(FL_FLAT_BOX);
        musdelay_pan1->color((Fl_Color)178);
        musdelay_pan1->selection_color((Fl_Color)62);
        musdelay_pan1->labeltype(FL_NORMAL_LABEL);
        musdelay_pan1->labelfont(0);
        musdelay_pan1->labelsize(10);
        musdelay_pan1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_pan1->minimum(-64);
        musdelay_pan1->maximum(63);
        musdelay_pan1->step(1);
        musdelay_pan1->textcolor(7);
        musdelay_pan1->callback((Fl_Callback*)cb_musdelay_pan1);
        musdelay_pan1->align(FL_ALIGN_LEFT);
        musdelay_pan1->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_pan1
      { musdelay_pan2 = new SliderW(532, 273, 100, 10, gettext("Pan2"));
        musdelay_pan2->type(5);
        musdelay_pan2->box(FL_FLAT_BOX);
        musdelay_pan2->color((Fl_Color)178);
        musdelay_pan2->selection_color((Fl_Color)62);
        musdelay_pan2->labeltype(FL_NORMAL_LABEL);
        musdelay_pan2->labelfont(0);
        musdelay_pan2->labelsize(10);
        musdelay_pan2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_pan2->minimum(-64);
        musdelay_pan2->maximum(63);
        musdelay_pan2->step(1);
        musdelay_pan2->textcolor(7);
        musdelay_pan2->callback((Fl_Callback*)cb_musdelay_pan2);
        musdelay_pan2->align(FL_ALIGN_LEFT);
        musdelay_pan2->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_pan2
      { musdelay_delay1 = new Fl_Choice(489, 293, 38, 14);
        musdelay_delay1->down_box(FL_BORDER_BOX);
        musdelay_delay1->labelsize(10);
        musdelay_delay1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_delay1->textsize(10);
        musdelay_delay1->callback((Fl_Callback*)cb_musdelay_delay1);
        musdelay_delay1->menu(menu_musdelay_delay1);
      } // Fl_Choice* musdelay_delay1
      { musdelay_delay2 = new Fl_Choice(593, 293, 38, 14);
        musdelay_delay2->down_box(FL_BORDER_BOX);
        musdelay_delay2->labelsize(10);
        musdelay_delay2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_delay2->textsize(10);
        musdelay_delay2->callback((Fl_Callback*)cb_musdelay_delay2);
        musdelay_delay2->menu(menu_musdelay_delay2);
      } // Fl_Choice* musdelay_delay2
      { musdelay_delay3 = new Fl_Choice(541, 293, 38, 14);
        musdelay_delay3->down_box(FL_BORDER_BOX);
        musdelay_delay3->labelsize(10);
        musdelay_delay3->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_delay3->textsize(10);
        musdelay_delay3->callback((Fl_Callback*)cb_musdelay_delay3);
        musdelay_delay3->menu(menu_musdelay_delay3);
      } // Fl_Choice* musdelay_delay3
      { musdelay_gain1 = new SliderW(532, 333, 100, 10, gettext("Gain1"));
        musdelay_gain1->type(5);
        musdelay_gain1->box(FL_FLAT_BOX);
        musdelay_gain1->color((Fl_Color)178);
        musdelay_gain1->selection_color((Fl_Color)62);
        musdelay_gain1->labeltype(FL_NORMAL_LABEL);
        musdelay_gain1->labelfont(0);
        musdelay_gain1->labelsize(10);
        musdelay_gain1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_gain1->minimum(-64);
        musdelay_gain1->maximum(63);
        musdelay_gain1->step(1);
        musdelay_gain1->textcolor(7);
        musdelay_gain1->callback((Fl_Callback*)cb_musdelay_gain1);
        musdelay_gain1->align(FL_ALIGN_LEFT);
        musdelay_gain1->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_gain1
      { musdelay_gain2 = new SliderW(532, 345, 100, 10, gettext("Gain2"));
        musdelay_gain2->type(5);
        musdelay_gain2->box(FL_FLAT_BOX);
        musdelay_gain2->color((Fl_Color)178);
        musdelay_gain2->selection_color((Fl_Color)62);
        musdelay_gain2->labeltype(FL_NORMAL_LABEL);
        musdelay_gain2->labelfont(0);
        musdelay_gain2->labelsize(10);
        musdelay_gain2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_gain2->minimum(-64);
        musdelay_gain2->maximum(63);
        musdelay_gain2->step(1);
        musdelay_gain2->textcolor(7);
        musdelay_gain2->callback((Fl_Callback*)cb_musdelay_gain2);
        musdelay_gain2->align(FL_ALIGN_LEFT);
        musdelay_gain2->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_gain2
      { musdelay_fb1 = new SliderW(532, 357, 100, 10, gettext("Fb1."));
        musdelay_fb1->type(5);
        musdelay_fb1->box(FL_FLAT_BOX);
        musdelay_fb1->color((Fl_Color)178);
        musdelay_fb1->selection_color((Fl_Color)62);
        musdelay_fb1->labeltype(FL_NORMAL_LABEL);
        musdelay_fb1->labelfont(0);
        musdelay_fb1->labelsize(10);
        musdelay_fb1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_fb1->maximum(127);
        musdelay_fb1->step(1);
        musdelay_fb1->textcolor(7);
        musdelay_fb1->callback((Fl_Callback*)cb_musdelay_fb1);
        musdelay_fb1->align(FL_ALIGN_LEFT);
        musdelay_fb1->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_fb1
      { musdelay_fb2 = new SliderW(532, 369, 100, 10, gettext("Fb2."));
        musdelay_fb2->type(5);
        musdelay_fb2->box(FL_FLAT_BOX);
        musdelay_fb2->color((Fl_Color)178);
        musdelay_fb2->selection_color((Fl_Color)62);
        musdelay_fb2->labeltype(FL_NORMAL_LABEL);
        musdelay_fb2->labelfont(0);
        musdelay_fb2->labelsize(10);
        musdelay_fb2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_fb2->maximum(127);
        musdelay_fb2->step(1);
        musdelay_fb2->textcolor(7);
        musdelay_fb2->callback((Fl_Callback*)cb_musdelay_fb2);
        musdelay_fb2->align(FL_ALIGN_LEFT);
        musdelay_fb2->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_fb2
      { musdelay_damp = new SliderW(532, 381, 100, 10, gettext("Damp"));
        musdelay_damp->type(5);
        musdelay_damp->box(FL_FLAT_BOX);
        musdelay_damp->color((Fl_Color)178);
        musdelay_damp->selection_color((Fl_Color)62);
        musdelay_damp->labeltype(FL_NORMAL_LABEL);
        musdelay_damp->labelfont(0);
        musdelay_damp->labelsize(10);
        musdelay_damp->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_damp->maximum(127);
        musdelay_damp->step(1);
        musdelay_damp->textcolor(7);
        musdelay_damp->callback((Fl_Callback*)cb_musdelay_damp);
        musdelay_damp->align(FL_ALIGN_LEFT);
        musdelay_damp->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_damp
      MUSDELAY->end();
    } // Fl_Group* MUSDELAY
    { GATE = new Fl_Group(321, 413, 158, 184, gettext("NoiseGate"));
      GATE->box(FL_PLASTIC_DOWN_FRAME);
      GATE->color(FL_BACKGROUND2_COLOR);
      GATE->labelfont(1);
      GATE->labelcolor(FL_BACKGROUND2_COLOR);
      GATE->hide();
      { gate_activar = new Fl_Light_Button(326, 417, 34, 18, gettext("On"));
        gate_activar->shortcut(0x32);
        gate_activar->color((Fl_Color)62);
        gate_activar->selection_color((Fl_Color)1);
        gate_activar->labelsize(10);
        gate_activar->callback((Fl_Callback*)cb_gate_activar);
        gate_activar->align(68|FL_ALIGN_INSIDE);
        gate_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* gate_activar
      { gate_preset = new Fl_Choice(399, 417, 76, 18, gettext("Preset"));
        gate_preset->down_box(FL_BORDER_BOX);
        gate_preset->selection_color(FL_FOREGROUND_COLOR);
        gate_preset->labelsize(10);
        gate_preset->labelcolor(FL_BACKGROUND2_COLOR);
        gate_preset->textsize(10);
        gate_preset->callback((Fl_Callback*)cb_gate_preset);
        gate_preset->when(FL_WHEN_RELEASE_ALWAYS);
        gate_preset->menu(menu_gate_preset);
      } // Fl_Choice* gate_preset
      { gate_ATime = new SliderW(372, 452, 100, 10, gettext("A. Time"));
        gate_ATime->type(5);
        gate_ATime->box(FL_FLAT_BOX);
        gate_ATime->color((Fl_Color)178);
        gate_ATime->selection_color((Fl_Color)62);
        gate_ATime->labeltype(FL_NORMAL_LABEL);
        gate_ATime->labelfont(0);
        gate_ATime->labelsize(10);
        gate_ATime->labelcolor(FL_BACKGROUND2_COLOR);
        gate_ATime->minimum(1);
        gate_ATime->maximum(250);
        gate_ATime->step(1);
        gate_ATime->value(1);
        gate_ATime->textcolor(7);
        gate_ATime->callback((Fl_Callback*)cb_gate_ATime);
        gate_ATime->align(FL_ALIGN_LEFT);
        gate_ATime->when(FL_WHEN_CHANGED);
      } // SliderW* gate_ATime
      { gate_RTime = new SliderW(371, 474, 100, 10, gettext("R. Time"));
        gate_RTime->type(5);
        gate_RTime->box(FL_FLAT_BOX);
        gate_RTime->color((Fl_Color)178);
        gate_RTime->selection_color((Fl_Color)62);
        gate_RTime->labeltype(FL_NORMAL_LABEL);
        gate_RTime->labelfont(0);
        gate_RTime->labelsize(10);
        gate_RTime->labelcolor(FL_BACKGROUND2_COLOR);
        gate_RTime->minimum(2);
        gate_RTime->maximum(250);
        gate_RTime->step(1);
        gate_RTime->value(120);
        gate_RTime->textcolor(7);
        gate_RTime->callback((Fl_Callback*)cb_gate_RTime);
        gate_RTime->align(FL_ALIGN_LEFT);
        gate_RTime->when(FL_WHEN_CHANGED);
      } // SliderW* gate_RTime
      { gate_range = new SliderW(371, 496, 100, 10, gettext("Range"));
        gate_range->type(5);
        gate_range->box(FL_FLAT_BOX);
        gate_range->color((Fl_Color)178);
        gate_range->selection_color((Fl_Color)62);
        gate_range->labeltype(FL_NORMAL_LABEL);
        gate_range->labelfont(0);
        gate_range->labelsize(10);
        gate_range->labelcolor(FL_BACKGROUND2_COLOR);
        gate_range->minimum(-90);
        gate_range->maximum(0);
        gate_range->step(1);
        gate_range->textcolor(7);
        gate_range->callback((Fl_Callback*)cb_gate_range);
        gate_range->align(FL_ALIGN_LEFT);
        gate_range->when(FL_WHEN_CHANGED);
      } // SliderW* gate_range
      { gate_threshold = new SliderW(371, 518, 100, 10, gettext("Thrhold"));
        gate_threshold->type(5);
        gate_threshold->box(FL_FLAT_BOX);
        gate_threshold->color((Fl_Color)178);
        gate_threshold->selection_color((Fl_Color)62);
        gate_threshold->labeltype(FL_NORMAL_LABEL);
        gate_threshold->labelfont(0);
        gate_threshold->labelsize(10);
        gate_threshold->labelcolor(FL_BACKGROUND2_COLOR);
        gate_threshold->minimum(-70);
        gate_threshold->maximum(20);
        gate_threshold->step(1);
        gate_threshold->textcolor(7);
        gate_threshold->callback((Fl_Callback*)cb_gate_threshold);
        gate_threshold->align(FL_ALIGN_LEFT);
        gate_threshold->when(FL_WHEN_CHANGED);
      } // SliderW* gate_threshold
      { gate_hold = new SliderW(371, 540, 100, 10, gettext("Hold"));
        gate_hold->type(5);
        gate_hold->box(FL_FLAT_BOX);
        gate_hold->color((Fl_Color)178);
        gate_hold->selection_color((Fl_Color)62);
        gate_hold->labeltype(FL_NORMAL_LABEL);
        gate_hold->labelfont(0);
        gate_hold->labelsize(10);
        gate_hold->labelcolor(FL_BACKGROUND2_COLOR);
        gate_hold->minimum(2);
        gate_hold->maximum(500);
        gate_hold->step(1);
        gate_hold->textcolor(7);
        gate_hold->callback((Fl_Callback*)cb_gate_hold);
        gate_hold->align(FL_ALIGN_LEFT);
        gate_hold->when(FL_WHEN_CHANGED);
      } // SliderW* gate_hold
      { gate_LPF = new SliderW(371, 559, 100, 10, gettext("LPF"));
        gate_LPF->type(5);
        gate_LPF->box(FL_FLAT_BOX);
        gate_LPF->color((Fl_Color)178);
        gate_LPF->selection_color((Fl_Color)62);
        gate_LPF->labeltype(FL_NORMAL_LABEL);
        gate_LPF->labelfont(0);
        gate_LPF->labelsize(10);
        gate_LPF->labelcolor(FL_BACKGROUND2_COLOR);
        gate_LPF->maximum(127);
        gate_LPF->step(1);
        gate_LPF->value(127);
        gate_LPF->textcolor(7);
        gate_LPF->callback((Fl_Callback*)cb_gate_LPF);
        gate_LPF->align(FL_ALIGN_LEFT);
        gate_LPF->when(FL_WHEN_CHANGED);
      } // SliderW* gate_LPF
      { gate_HPF = new SliderW(371, 575, 100, 10, gettext("HPF"));
        gate_HPF->type(5);
        gate_HPF->box(FL_FLAT_BOX);
        gate_HPF->color((Fl_Color)178);
        gate_HPF->selection_color((Fl_Color)62);
        gate_HPF->labeltype(FL_NORMAL_LABEL);
        gate_HPF->labelfont(0);
        gate_HPF->labelsize(10);
        gate_HPF->labelcolor(FL_BACKGROUND2_COLOR);
        gate_HPF->maximum(127);
        gate_HPF->step(1);
        gate_HPF->textcolor(7);
        gate_HPF->callback((Fl_Callback*)cb_gate_HPF);
        gate_HPF->align(FL_ALIGN_LEFT);
        gate_HPF->when(FL_WHEN_CHANGED);
      } // SliderW* gate_HPF
      GATE->end();
    } // Fl_Group* GATE
    { Tuner = new Fl_Group(521, 84, 276, 58);
      Tuner->box(FL_PLASTIC_DOWN_FRAME);
      { tuner_activar = new Fl_Light_Button(526, 88, 38, 18, gettext("On"));
        tuner_activar->shortcut(0x74);
        tuner_activar->color((Fl_Color)62);
        tuner_activar->selection_color((Fl_Color)1);
        tuner_activar->labelsize(10);
        tuner_activar->callback((Fl_Callback*)cb_tuner_activar);
        tuner_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* tuner_activar
      { Fl_Progress* o = tuner_bar = new Fl_Progress(586, 91, 206, 14);
        tuner_bar->box(FL_FLAT_BOX);
        tuner_bar->selection_color(FL_RED);
        o->minimum(-32);
        o->maximum(32);
        o->value(-32);
      } // Fl_Progress* tuner_bar
      { WNote = new Fl_Box(676, 117, 28, 22);
        WNote->labelfont(1);
        WNote->labelcolor(FL_BACKGROUND2_COLOR);
        WNote->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* WNote
      { WRfreq = new Fl_Box(588, 117, 76, 22);
        WRfreq->labelfont(1);
        WRfreq->labelcolor(FL_BACKGROUND2_COLOR);
        WRfreq->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* WRfreq
      { WNfreq = new Fl_Box(714, 117, 76, 22);
        WNfreq->labelfont(1);
        WNfreq->labelcolor(FL_BACKGROUND2_COLOR);
        WNfreq->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* WNfreq
      { PINCHO = new Fl_Box(673, 108, 32, 5, gettext("@-4$8<"));
        PINCHO->box(FL_FLAT_BOX);
        PINCHO->color((Fl_Color)55);
        PINCHO->labelcolor((Fl_Color)4);
        PINCHO->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* PINCHO
      { TUNER_LABEL = new Fl_Box(527, 123, 57, 14, gettext("Tuner"));
        TUNER_LABEL->labelfont(1);
        TUNER_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* TUNER_LABEL
      Tuner->end();
    } // Fl_Group* Tuner
    { InOut = new Fl_Group(2, 24, 164, 170);
      InOut->box(FL_PLASTIC_DOWN_FRAME);
      InOut->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
      { ActivarGeneral = new Fl_Light_Button(6, 30, 52, 18, gettext("FX On"));
        ActivarGeneral->shortcut(0x72);
        ActivarGeneral->color((Fl_Color)62);
        ActivarGeneral->selection_color((Fl_Color)1);
        ActivarGeneral->labelsize(10);
        ActivarGeneral->callback((Fl_Callback*)cb_ActivarGeneral);
        ActivarGeneral->align(68|FL_ALIGN_INSIDE);
        ActivarGeneral->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* ActivarGeneral
      { Nivel_Entrada = new SliderW(32, 48, 19, 126, gettext("Input"));
        Nivel_Entrada->type(4);
        Nivel_Entrada->box(FL_FLAT_BOX);
        Nivel_Entrada->color((Fl_Color)178);
        Nivel_Entrada->selection_color((Fl_Color)62);
        Nivel_Entrada->labeltype(FL_NORMAL_LABEL);
        Nivel_Entrada->labelfont(0);
        Nivel_Entrada->labelsize(10);
        Nivel_Entrada->labelcolor(FL_BACKGROUND2_COLOR);
        Nivel_Entrada->minimum(50);
        Nivel_Entrada->maximum(-50);
        Nivel_Entrada->step(1);
        Nivel_Entrada->textcolor(7);
        Nivel_Entrada->callback((Fl_Callback*)cb_Nivel_Entrada);
        Nivel_Entrada->align(FL_ALIGN_BOTTOM);
        Nivel_Entrada->when(FL_WHEN_CHANGED);
      } // SliderW* Nivel_Entrada
      { Nivel_Salida = new SliderW(97, 48, 19, 126, gettext("Output"));
        Nivel_Salida->type(4);
        Nivel_Salida->box(FL_FLAT_BOX);
        Nivel_Salida->color((Fl_Color)178);
        Nivel_Salida->selection_color((Fl_Color)62);
        Nivel_Salida->labeltype(FL_NORMAL_LABEL);
        Nivel_Salida->labelfont(0);
        Nivel_Salida->labelsize(10);
        Nivel_Salida->labelcolor(FL_BACKGROUND2_COLOR);
        Nivel_Salida->minimum(50);
        Nivel_Salida->maximum(-50);
        Nivel_Salida->step(1);
        Nivel_Salida->value(50);
        Nivel_Salida->textcolor(7);
        Nivel_Salida->callback((Fl_Callback*)cb_Nivel_Salida);
        Nivel_Salida->align(FL_ALIGN_BOTTOM);
        Nivel_Salida->when(FL_WHEN_CHANGED);
      } // SliderW* Nivel_Salida
      { input_vu = new NewVum(60, 50, 15, 122);
        input_vu->type(2);
        input_vu->box(FL_NO_BOX);
        input_vu->color((Fl_Color)178);
        input_vu->selection_color((Fl_Color)90);
        input_vu->labeltype(FL_NORMAL_LABEL);
        input_vu->labelfont(0);
        input_vu->labelsize(14);
        input_vu->labelcolor(FL_FOREGROUND_COLOR);
        input_vu->minimum(15);
        input_vu->maximum(-48);
        input_vu->step(1);
        input_vu->value(-48);
        input_vu->align(FL_ALIGN_BOTTOM);
        input_vu->when(FL_WHEN_NEVER);
      } // NewVum* input_vu
      { output_vu = new NewVum(125, 50, 15, 122);
        output_vu->type(2);
        output_vu->box(FL_NO_BOX);
        output_vu->color((Fl_Color)178);
        output_vu->selection_color((Fl_Color)90);
        output_vu->labeltype(FL_NORMAL_LABEL);
        output_vu->labelfont(0);
        output_vu->labelsize(14);
        output_vu->labelcolor(FL_FOREGROUND_COLOR);
        output_vu->minimum(15);
        output_vu->maximum(-48);
        output_vu->step(1);
        output_vu->value(-48);
        output_vu->align(FL_ALIGN_BOTTOM);
        output_vu->when(FL_WHEN_NEVER);
      } // NewVum* output_vu
      { LABEL_IO = new Fl_Box(68, 30, 62, 14, gettext("In/Out"));
        LABEL_IO->labelfont(1);
        LABEL_IO->labelcolor(FL_BACKGROUND2_COLOR);
        LABEL_IO->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* LABEL_IO
      InOut->end();
    } // Fl_Group* InOut
    { Midi = new Fl_Group(521, 144, 276, 50);
      Midi->box(FL_PLASTIC_DOWN_FRAME);
      { nidi_activar = new Fl_Light_Button(526, 148, 38, 18, gettext("On"));
        nidi_activar->shortcut(0x6d);
        nidi_activar->color((Fl_Color)62);
        nidi_activar->selection_color((Fl_Color)1);
        nidi_activar->labelsize(10);
        nidi_activar->callback((Fl_Callback*)cb_nidi_activar);
        nidi_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* nidi_activar
      { Midi_out_Counter = new Fl_Counter(602, 154, 60, 20, gettext("Channel"));
        Midi_out_Counter->type(1);
        Midi_out_Counter->color((Fl_Color)62);
        Midi_out_Counter->labelsize(10);
        Midi_out_Counter->labelcolor(FL_BACKGROUND2_COLOR);
        Midi_out_Counter->minimum(1);
        Midi_out_Counter->maximum(16);
        Midi_out_Counter->step(1);
        Midi_out_Counter->value(1);
        Midi_out_Counter->textsize(11);
        Midi_out_Counter->callback((Fl_Callback*)cb_Midi_out_Counter);
      } // Fl_Counter* Midi_out_Counter
      { Trig_Adj = new SliderW(668, 159, 117, 11, gettext("Trigger"));
        Trig_Adj->type(5);
        Trig_Adj->box(FL_FLAT_BOX);
        Trig_Adj->color((Fl_Color)178);
        Trig_Adj->selection_color((Fl_Color)62);
        Trig_Adj->labeltype(FL_NORMAL_LABEL);
        Trig_Adj->labelfont(0);
        Trig_Adj->labelsize(8);
        Trig_Adj->labelcolor(FL_BACKGROUND2_COLOR);
        Trig_Adj->minimum(2);
        Trig_Adj->maximum(60);
        Trig_Adj->step(1);
        Trig_Adj->textcolor(7);
        Trig_Adj->callback((Fl_Callback*)cb_Trig_Adj);
        Trig_Adj->align(FL_ALIGN_TOP_RIGHT);
        Trig_Adj->when(FL_WHEN_CHANGED);
      } // SliderW* Trig_Adj
      { Vel_Adj = new SliderW(668, 178, 117, 11, gettext("Velocity"));
        Vel_Adj->type(5);
        Vel_Adj->box(FL_FLAT_BOX);
        Vel_Adj->color((Fl_Color)178);
        Vel_Adj->selection_color((Fl_Color)62);
        Vel_Adj->labeltype(FL_NORMAL_LABEL);
        Vel_Adj->labelfont(0);
        Vel_Adj->labelsize(8);
        Vel_Adj->labelcolor(FL_BACKGROUND2_COLOR);
        Vel_Adj->minimum(1);
        Vel_Adj->maximum(100);
        Vel_Adj->step(1);
        Vel_Adj->textcolor(7);
        Vel_Adj->callback((Fl_Callback*)cb_Vel_Adj);
        Vel_Adj->align(FL_ALIGN_TOP_RIGHT);
        Vel_Adj->when(FL_WHEN_CHANGED);
      } // SliderW* Vel_Adj
      { MIDI_LABEL = new Fl_Box(527, 174, 45, 13, gettext("MIDI"));
        MIDI_LABEL->labelfont(1);
        MIDI_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
        MIDI_LABEL->callback((Fl_Callback*)cb_MIDI_LABEL);
        MIDI_LABEL->when(FL_WHEN_NEVER);
      } // Fl_Box* MIDI_LABEL
      { Mled = new Fl_Box(572, 149, 10, 10);
        Mled->box(FL_ROUNDED_BOX);
        Mled->color(FL_RED);
        Mled->labelsize(18);
      } // Fl_Box* Mled
      Midi->end();
    } // Fl_Group* Midi
    { Presets = new Fl_Group(168, 24, 351, 118);
      Presets->box(FL_PLASTIC_DOWN_FRAME);
      { PRESETS_LABEL = new Fl_Box(174, 28, 62, 14, gettext("Presets"));
        PRESETS_LABEL->labelfont(1);
        PRESETS_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* PRESETS_LABEL
      { S_new = new Fl_Button(174, 44, 64, 18, gettext("New"));
        S_new->shortcut(0x6e);
        S_new->color((Fl_Color)62);
        S_new->labelsize(12);
        S_new->callback((Fl_Callback*)cb_S_new);
      } // Fl_Button* S_new
      { L_preset = new Fl_Button(240, 44, 64, 18, gettext("Load"));
        L_preset->shortcut(0x6c);
        L_preset->color((Fl_Color)62);
        L_preset->labelsize(12);
        L_preset->callback((Fl_Callback*)cb_L_preset);
      } // Fl_Button* L_preset
      { S_preset = new Fl_Button(306, 44, 64, 18, gettext("Save"));
        S_preset->shortcut(0x73);
        S_preset->color((Fl_Color)62);
        S_preset->labelsize(12);
        S_preset->callback((Fl_Callback*)cb_S_preset);
      } // Fl_Button* S_preset
      { Compare = new Fl_Light_Button(373, 44, 72, 18, gettext("Compare"));
        Compare->shortcut(0x70);
        Compare->color((Fl_Color)62);
        Compare->selection_color((Fl_Color)1);
        Compare->labelsize(12);
        Compare->callback((Fl_Callback*)cb_Compare);
        Compare->align(68|FL_ALIGN_INSIDE);
        Compare->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Compare
      { B_preset = new Fl_Button(448, 44, 64, 18, gettext("Bank"));
        B_preset->shortcut(0x62);
        B_preset->color((Fl_Color)62);
        B_preset->labelsize(12);
        B_preset->callback((Fl_Callback*)cb_B_preset);
      } // Fl_Button* B_preset
      { Fl_Input* o = WPreset_Name = new Fl_Input(174, 64, 338, 38);
        WPreset_Name->box(FL_UP_BOX);
        WPreset_Name->color((Fl_Color)62);
        WPreset_Name->labelcolor(FL_BACKGROUND2_COLOR);
        WPreset_Name->textsize(24);
        WPreset_Name->callback((Fl_Callback*)cb_WPreset_Name);
        o->maximum_size(22);
      } // Fl_Input* WPreset_Name
      { Preset_Counter = new Fl_Counter(174, 106, 60, 20, gettext("Preset"));
        Preset_Counter->type(1);
        Preset_Counter->color((Fl_Color)62);
        Preset_Counter->selection_color(FL_FOREGROUND_COLOR);
        Preset_Counter->labelsize(11);
        Preset_Counter->labelcolor(FL_BACKGROUND2_COLOR);
        Preset_Counter->minimum(1);
        Preset_Counter->maximum(80);
        Preset_Counter->step(1);
        Preset_Counter->value(1);
        Preset_Counter->textsize(11);
        Preset_Counter->callback((Fl_Callback*)cb_Preset_Counter);
      } // Fl_Counter* Preset_Counter
      { DAuthor = new Fl_Box(246, 107, 266, 18);
        DAuthor->box(FL_UP_BOX);
        DAuthor->color((Fl_Color)62);
      } // Fl_Box* DAuthor
      Presets->end();
    } // Fl_Group* Presets
    Principal->size_range(640, 480, 3200, 2400);
    Principal->end();
    Principal->resizable(Principal);
  } // Fl_Double_Window* Principal
  { BankWindow = new Fl_Double_Window(800, 600);
    BankWindow->color((Fl_Color)4);
    BankWindow->selection_color(FL_BACKGROUND2_COLOR);
    BankWindow->callback((Fl_Callback*)cb_BankWindow, (void*)(this));
    { MenuB = new Fl_Menu_Bar(0, 0, 800, 20);
      MenuB->down_box(FL_DOWN_BOX);
      MenuB->color((Fl_Color)4);
      MenuB->selection_color(FL_BACKGROUND2_COLOR);
      MenuB->labelcolor(FL_BACKGROUND2_COLOR);
      MenuB->textcolor(7);
      MenuB->menu(menu_MenuB);
    } // Fl_Menu_Bar* MenuB
    { ob = new Fl_Group(0, 20, 800, 580);
      ob->labelsize(18);
      ob->end();
    } // Fl_Group* ob
    BankWindow->size_range(640, 480, 3200, 2400);
    BankWindow->end();
    BankWindow->resizable(BankWindow);
  } // Fl_Double_Window* BankWindow
  { Order = new Fl_Double_Window(600, 400);
    Order->color((Fl_Color)178);
    Order->callback((Fl_Callback*)cb_Order, (void*)(this));
    { O_TITLE = new Fl_Box(88, 21, 438, 37, gettext("Put Order in your Rack"));
      O_TITLE->labelfont(1);
      O_TITLE->labelsize(33);
      O_TITLE->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* O_TITLE
    { Avail_Bro = new Fl_Browser(12, 77, 185, 225);
      Avail_Bro->type(2);
      Avail_Bro->labelsize(18);
      Avail_Bro->textsize(18);
    } // Fl_Browser* Avail_Bro
    { Pon = new Fl_Button(217, 168, 72, 25, gettext("@<->"));
      Pon->labelsize(18);
      Pon->callback((Fl_Callback*)cb_Pon);
    } // Fl_Button* Pon
    { Order_Bro = new Fl_Browser(305, 77, 185, 225);
      Order_Bro->type(2);
      Order_Bro->labelsize(18);
      Order_Bro->textsize(18);
    } // Fl_Browser* Order_Bro
    { Sube = new Fl_Button(508, 141, 72, 25, gettext("@$2->"));
      Sube->labelsize(18);
      Sube->callback((Fl_Callback*)cb_Sube);
    } // Fl_Button* Sube
    { Baja = new Fl_Button(510, 188, 72, 25, gettext("@$8->"));
      Baja->labelsize(18);
      Baja->callback((Fl_Callback*)cb_Baja);
    } // Fl_Button* Baja
    { ok_order = new Fl_Button(436, 354, 72, 26, gettext("Ok"));
      ok_order->callback((Fl_Callback*)cb_ok_order);
    } // Fl_Button* ok_order
    { Cancel_order = new Fl_Button(516, 354, 72, 26, gettext("Cancel"));
      Cancel_order->callback((Fl_Callback*)cb_Cancel_order);
    } // Fl_Button* Cancel_order
    Order->size_range(500, 400, 3200, 2400);
    Order->end();
    Order->resizable(Order);
  } // Fl_Double_Window* Order
  { Settings = new Fl_Double_Window(640, 480);
    Settings->color((Fl_Color)4);
    Settings->callback((Fl_Callback*)cb_Settings, (void*)(this));
    { Prefs_OK = new Fl_Button(535, 445, 90, 25, gettext("Ok"));
      Prefs_OK->callback((Fl_Callback*)cb_Prefs_OK);
    } // Fl_Button* Prefs_OK
    { Look = new Fl_Group(10, 20, 615, 50, gettext("Look & Feel"));
      Look->box(FL_PLASTIC_DOWN_FRAME);
      Look->color(FL_BACKGROUND2_COLOR);
      Look->labelfont(1);
      Look->labelcolor(FL_BACKGROUND2_COLOR);
      Look->align(FL_ALIGN_TOP_LEFT);
      { B_C = new Fl_Button(20, 30, 90, 30, gettext("Buttons"));
        B_C->callback((Fl_Callback*)cb_B_C);
      } // Fl_Button* B_C
      { L_C = new Fl_Button(120, 30, 90, 30, gettext("Leds"));
        L_C->callback((Fl_Callback*)cb_L_C);
      } // Fl_Button* L_C
      { K_C = new Fl_Button(220, 30, 90, 30, gettext("Background"));
        K_C->callback((Fl_Callback*)cb_K_C);
      } // Fl_Button* K_C
      { A_C = new Fl_Button(320, 30, 90, 30, gettext("Labels"));
        A_C->callback((Fl_Callback*)cb_A_C);
      } // Fl_Button* A_C
      { scheme_ch = new Fl_Choice(520, 35, 88, 20, gettext("schema"));
        scheme_ch->down_box(FL_BORDER_BOX);
        scheme_ch->labelsize(11);
        scheme_ch->labelcolor(FL_BACKGROUND2_COLOR);
        scheme_ch->textsize(12);
        scheme_ch->callback((Fl_Callback*)cb_scheme_ch);
        scheme_ch->menu(menu_scheme_ch);
      } // Fl_Choice* scheme_ch
      Look->end();
    } // Fl_Group* Look
    { AUDIO_SET = new Fl_Group(10, 90, 615, 35, gettext("Audio"));
      AUDIO_SET->box(FL_PLASTIC_DOWN_FRAME);
      AUDIO_SET->labelfont(1);
      AUDIO_SET->labelcolor(FL_BACKGROUND2_COLOR);
      AUDIO_SET->align(FL_ALIGN_TOP_LEFT);
      { Pre_Serve = new Fl_Check_Button(145, 100, 90, 20, gettext("Preserve Gain/Master"));
        Pre_Serve->down_box(FL_DOWN_BOX);
        Pre_Serve->labelsize(11);
        Pre_Serve->labelcolor(FL_BACKGROUND2_COLOR);
        Pre_Serve->callback((Fl_Callback*)cb_Pre_Serve);
        Pre_Serve->align(FL_ALIGN_LEFT);
      } // Fl_Check_Button* Pre_Serve
      { Har_Qual = new Fl_Choice(298, 100, 37, 18, gettext("Harmonizer Quality"));
        Har_Qual->down_box(FL_BORDER_BOX);
        Har_Qual->labelsize(10);
        Har_Qual->labelcolor(FL_BACKGROUND2_COLOR);
        Har_Qual->textsize(10);
        Har_Qual->callback((Fl_Callback*)cb_Har_Qual);
        Har_Qual->menu(menu_Har_Qual);
      } // Fl_Choice* Har_Qual
      AUDIO_SET->end();
    } // Fl_Group* AUDIO_SET
    { MIDI_SET = new Fl_Group(10, 150, 313, 195, gettext("MIDI"));
      MIDI_SET->box(FL_PLASTIC_DOWN_FRAME);
      MIDI_SET->labelfont(1);
      MIDI_SET->labelcolor(FL_BACKGROUND2_COLOR);
      MIDI_SET->align(FL_ALIGN_TOP_LEFT);
      { D_A_Connect = new Fl_Check_Button(140, 160, 105, 20, gettext("Auto Connect MIDI In"));
        D_A_Connect->down_box(FL_DOWN_BOX);
        D_A_Connect->labelsize(11);
        D_A_Connect->labelcolor(FL_BACKGROUND2_COLOR);
        D_A_Connect->callback((Fl_Callback*)cb_D_A_Connect);
        D_A_Connect->align(FL_ALIGN_LEFT);
      } // Fl_Check_Button* D_A_Connect
      { BMidiIn = new Fl_Browser(20, 195, 190, 140, gettext("ALSA Sequencer Ports"));
        BMidiIn->type(2);
        BMidiIn->selection_color(FL_FOREGROUND_COLOR);
        BMidiIn->labelsize(11);
        BMidiIn->labelcolor(FL_BACKGROUND2_COLOR);
        BMidiIn->textsize(12);
        BMidiIn->callback((Fl_Callback*)cb_BMidiIn);
        BMidiIn->align(FL_ALIGN_TOP_LEFT);
      } // Fl_Browser* BMidiIn
      { Midi_In_Counter = new Fl_Counter(236, 262, 60, 24, gettext("Channel"));
        Midi_In_Counter->type(1);
        Midi_In_Counter->color((Fl_Color)62);
        Midi_In_Counter->labelsize(10);
        Midi_In_Counter->labelcolor(FL_BACKGROUND2_COLOR);
        Midi_In_Counter->minimum(1);
        Midi_In_Counter->maximum(16);
        Midi_In_Counter->step(1);
        Midi_In_Counter->value(1);
        Midi_In_Counter->textsize(11);
        Midi_In_Counter->callback((Fl_Callback*)cb_Midi_In_Counter);
        Midi_In_Counter->align(FL_ALIGN_TOP);
      } // Fl_Counter* Midi_In_Counter
      { Har_In_Counter = new Fl_Counter(236, 309, 60, 24, gettext("Harmonizer Channel"));
        Har_In_Counter->type(1);
        Har_In_Counter->color((Fl_Color)62);
        Har_In_Counter->labelsize(10);
        Har_In_Counter->labelcolor(FL_BACKGROUND2_COLOR);
        Har_In_Counter->minimum(1);
        Har_In_Counter->maximum(16);
        Har_In_Counter->step(1);
        Har_In_Counter->value(1);
        Har_In_Counter->textsize(11);
        Har_In_Counter->callback((Fl_Callback*)cb_Har_In_Counter);
        Har_In_Counter->align(FL_ALIGN_TOP);
      } // Fl_Counter* Har_In_Counter
      MIDI_SET->end();
    } // Fl_Group* MIDI_SET
    { JACK_SET = new Fl_Group(333, 151, 293, 195, gettext("Jack"));
      JACK_SET->box(FL_PLASTIC_DOWN_FRAME);
      JACK_SET->labelfont(1);
      JACK_SET->labelcolor(FL_BACKGROUND2_COLOR);
      JACK_SET->align(FL_ALIGN_TOP_LEFT);
      { D_J_Connect = new Fl_Check_Button(455, 160, 105, 20, gettext("Auto Connect Jack"));
        D_J_Connect->down_box(FL_DOWN_BOX);
        D_J_Connect->labelsize(11);
        D_J_Connect->labelcolor(FL_BACKGROUND2_COLOR);
        D_J_Connect->callback((Fl_Callback*)cb_D_J_Connect);
        D_J_Connect->align(FL_ALIGN_LEFT);
      } // Fl_Check_Button* D_J_Connect
      { JackCo = new Fl_Browser(350, 195, 191, 142, gettext("Jack Ports"));
        JackCo->type(3);
        JackCo->selection_color(FL_FOREGROUND_COLOR);
        JackCo->labelsize(11);
        JackCo->labelcolor(FL_BACKGROUND2_COLOR);
        JackCo->textsize(12);
        JackCo->align(FL_ALIGN_TOP_LEFT);
      } // Fl_Browser* JackCo
      JACK_SET->end();
    } // Fl_Group* JACK_SET
    { MISC_SET = new Fl_Group(10, 365, 615, 35, gettext("Misc"));
      MISC_SET->box(FL_PLASTIC_DOWN_FRAME);
      MISC_SET->labelfont(1);
      MISC_SET->labelcolor(FL_BACKGROUND2_COLOR);
      MISC_SET->align(FL_ALIGN_TOP_LEFT);
      { Username = new Fl_Input(85, 373, 240, 21, gettext("Username:"));
        Username->labelsize(11);
        Username->labelcolor(FL_BACKGROUND2_COLOR);
        Username->textsize(11);
        Username->callback((Fl_Callback*)cb_Username);
      } // Fl_Input* Username
      MISC_SET->end();
    } // Fl_Group* MISC_SET
    { BANK_SET = new Fl_Group(10, 420, 510, 55, gettext("Bank"));
      BANK_SET->box(FL_PLASTIC_DOWN_FRAME);
      BANK_SET->labelfont(1);
      BANK_SET->labelcolor(FL_BACKGROUND2_COLOR);
      BANK_SET->align(FL_ALIGN_TOP_LEFT);
      { BFiname = new Fl_File_Input(20, 440, 390, 25, gettext("Bank Filename"));
        BFiname->labelsize(11);
        BFiname->labelcolor(FL_BACKGROUND2_COLOR);
        BFiname->textsize(12);
        BFiname->align(FL_ALIGN_TOP_LEFT);
      } // Fl_File_Input* BFiname
      { BF_Browser = new Fl_Button(415, 440, 65, 25, gettext("Browse"));
        BF_Browser->callback((Fl_Callback*)cb_BF_Browser);
      } // Fl_Button* BF_Browser
      BANK_SET->end();
    } // Fl_Group* BANK_SET
    Settings->size_range(640, 480);
    Settings->end();
    Settings->resizable(Settings);
  } // Fl_Double_Window* Settings
  { AboutWin = new Fl_Double_Window(420, 238, gettext("About Rakarrack"));
    AboutWin->color(FL_FOREGROUND_COLOR);
    AboutWin->callback((Fl_Callback*)cb_AboutWin, (void*)(this));
    { CU_IM = new Fl_Box(6, 2, 142, 196);
      CU_IM->color(FL_FOREGROUND_COLOR);
      CU_IM->image(image_icono_rakarrack_128x128);
      CU_IM->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* CU_IM
    { AB_Title = new Fl_Box(159, 0, 259, 41, gettext("Rakarrack"));
      AB_Title->labelfont(1);
      AB_Title->labelsize(40);
      AB_Title->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* AB_Title
    { AB_SubTitle = new Fl_Box(224, 39, 130, 22, gettext("Guitar Effects"));
      AB_SubTitle->labelfont(1);
      AB_SubTitle->labelsize(16);
      AB_SubTitle->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* AB_SubTitle
    { AB_Authors = new Fl_Box(175, 96, 221, 27, gettext("Copyrigth Josep Andreu,  Jose Luis Di Biase & Hern\341n Ordiales 2008"));
      AB_Authors->labelfont(1);
      AB_Authors->labelsize(8);
      AB_Authors->labelcolor(FL_BACKGROUND2_COLOR);
      AB_Authors->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_Authors
    { AB_A1 = new Fl_Box(162, 124, 251, 35, gettext("Code of Reverb, Chorus/Flanger, Phaser, Distortion/Overdrive & Echo taked fro\
m ZynAddSubFx by Paul Nasca Octavian"));
      AB_A1->labelfont(1);
      AB_A1->labelsize(8);
      AB_A1->labelcolor(FL_BACKGROUND2_COLOR);
      AB_A1->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_A1
    { AB_A2 = new Fl_Box(172, 159, 240, 19, gettext("Code of Tuner taked from tuneit by Mario Lang"));
      AB_A2->labelfont(1);
      AB_A2->labelsize(8);
      AB_A2->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* AB_A2
    { AB_A3 = new Fl_Box(166, 177, 244, 30, gettext("Code of Compressor based in ArtsCompresor by Matthias Kretz & Stefan Westerfe\
ld"));
      AB_A3->labelfont(1);
      AB_A3->labelsize(8);
      AB_A3->labelcolor(FL_BACKGROUND2_COLOR);
      AB_A3->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_A3
    { Fl_Button* o = new Fl_Button(316, 215, 92, 16, gettext("OK"));
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_OK);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(168, 215, 92, 16, gettext("LICENSE"));
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_LICENSE);
    } // Fl_Button* o
    { About_Version = new Fl_Box(238, 60, 95, 15);
      About_Version->labelsize(12);
      About_Version->labelcolor(FL_BACKGROUND2_COLOR);
      About_Version->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    } // Fl_Box* About_Version
    { AB_url = new Fl_Box(171, 76, 234, 22, gettext("http://rakarrack.sourceforge.net"));
      AB_url->labelfont(1);
      AB_url->labelsize(13);
      AB_url->labelcolor((Fl_Color)6);
    } // Fl_Box* AB_url
    AboutWin->end();
  } // Fl_Double_Window* AboutWin
  char tmp[64];
sprintf(tmp,"Version %s",VERSION);
About_Version->copy_label(tmp);


Mled->color(fl_darker(FL_RED));
  return AboutWin;
}

RKRGUI::RKRGUI(int argc, char**argv,RKR *rkr_) {
  fl_open_display();
XpmCreatePixmapFromData(fl_display, DefaultRootWindow(fl_display),(char **)icono_rakarrack_128x128,&p ,&mask, NULL);

Fl::visual(FL_RGB);
Fl::visual(FL_DOUBLE|FL_INDEX);
Fl::get_system_colors();

rkr=rkr_;
make_window();

Principal->icon((char *)p);
BankWindow->icon((char *)p);
Order->icon((char *)p);
Settings->icon((char *)p);
AboutWin->icon((char *)p);

made=0;

char tmp[128];
sprintf(tmp,"%s   v%s",rkr->jackcliname,VERSION); 
Principal->copy_label(tmp);
BankWin_Label(rkr->BankFilename);
bzero(tmp,sizeof(tmp));
sprintf(tmp,"%s   v%s - Effects Order",rkr->jackcliname,VERSION);
Order->copy_label(tmp);
bzero(tmp,sizeof(tmp));
sprintf(tmp,"%s   v%s - Settings",rkr->jackcliname,VERSION);
Settings->copy_label(tmp);
load_stat();
Put_Loaded();
Principal->show(argc,argv);
put_icon(Principal);


void * v=MT;

Fl::add_timeout(.04,tick,v);
}

void RKRGUI::Background_Color_Change(Fl_Color bcolor) {
  Principal->color(bcolor);
MenuP->color(bcolor);
BankWindow->color(bcolor);
MenuB->color(bcolor);
Order->color(bcolor);
Settings->color(bcolor);

eq_preset->selection_color(bcolor);
compress_preset->selection_color(bcolor);
dist_preset->selection_color(bcolor);
dist_tipo->selection_color(bcolor);
ovrd_preset->selection_color(bcolor);
ovrd_tipo->selection_color(bcolor);
echo_preset->selection_color(bcolor);
chorux_preset->selection_color(bcolor);
chorus_lfotype->selection_color(bcolor);
phaser_preset->selection_color(bcolor);
phaser_lfotype->selection_color(bcolor);
flanger_preset->selection_color(bcolor);
flanger_lfotype->selection_color(bcolor);
reverb_preset->selection_color(bcolor);
reverb_type->selection_color(bcolor);
eqp_preset->selection_color(bcolor);
WhaWha_preset->selection_color(bcolor);
WhaWha_lfotype->selection_color(bcolor);
Alienwah_preset->selection_color(bcolor);
Alienwah_lfotype->selection_color(bcolor);
Cabinet_preset->selection_color(bcolor);
pan_preset->selection_color(bcolor);
pan_lfotype->selection_color(bcolor);
har_preset->selection_color(bcolor);
musdelay_preset->selection_color(bcolor);
musdelay_delay1->selection_color(bcolor);
musdelay_delay2->selection_color(bcolor);
musdelay_delay3->selection_color(bcolor);
gate_preset->selection_color(bcolor);

scheme_ch->selection_color(bcolor);
Har_Qual->selection_color(bcolor);
BMidiIn->selection_color(bcolor);
JackCo->selection_color(bcolor);
BFiname->selection_color(bcolor);


Avail_Bro->selection_color(bcolor);
Order_Bro->selection_color(bcolor);







back_color = bcolor;

Fl::redraw();
}

void RKRGUI::Label_Color_Change(Fl_Color bcolor) {
  EQ->labelcolor(bcolor);
eq_preset->labelcolor(bcolor);

COMPRESS->labelcolor(bcolor);
compress_preset->labelcolor(bcolor);
Auto_Output->labelcolor(bcolor);

DIST->labelcolor(bcolor);
dist_preset->labelcolor(bcolor);
dist_tipo->labelcolor(bcolor);
dist_st->labelcolor(bcolor);
dist_neg->labelcolor(bcolor);
dist_pf->labelcolor(bcolor);


OVRD->labelcolor(bcolor);
ovrd_preset->labelcolor(bcolor);
ovrd_tipo->labelcolor(bcolor);
ovrd_st->labelcolor(bcolor);
ovrd_neg->labelcolor(bcolor);
ovrd_pf->labelcolor(bcolor);

ECHO->labelcolor(bcolor);
echo_preset->labelcolor(bcolor);


CHORUS->labelcolor(bcolor);
chorux_preset->labelcolor(bcolor);
chorus_lfotype->labelcolor(bcolor);
chorus_subs->labelcolor(bcolor);

PHASER->labelcolor(bcolor);
phaser_preset->labelcolor(bcolor);
phaser_lfotype->labelcolor(bcolor);
phaser_subs->labelcolor(bcolor);
phaser_stages->labelcolor(bcolor);

FLANGER->labelcolor(bcolor);
flanger_preset->labelcolor(bcolor);
flanger_subs->labelcolor(bcolor);
flanger_lfotype->labelcolor(bcolor);

REVERB->labelcolor(bcolor);
reverb_preset->labelcolor(bcolor);
reverb_type->labelcolor(bcolor);


PEQ->labelcolor(bcolor);
eqp_preset->labelcolor(bcolor);


WHAWHA->labelcolor(bcolor);
WhaWha_preset->labelcolor(bcolor);
WhaWha_lfotype->labelcolor(bcolor);

ALIENWAH->labelcolor(bcolor);
Alienwah_preset->labelcolor(bcolor);
Alienwah_lfotype->labelcolor(bcolor);


CABINET->labelcolor(bcolor);
Cabinet_preset->labelcolor(bcolor);



PAN->labelcolor(bcolor);
pan_preset->labelcolor(bcolor);
pan_lfotype->labelcolor(bcolor);
pan_extraon->labelcolor(bcolor);
pan_autopan->labelcolor(bcolor);


HAR->labelcolor(bcolor);
har_preset->labelcolor(bcolor);
har_SELECT->labelcolor(bcolor);
har_MIDI->labelcolor(bcolor);
har_chordname->labelcolor(bcolor);

MUSDELAY->labelcolor(bcolor);
musdelay_preset->labelcolor(bcolor);
musdelay_delay1->labelcolor(bcolor);
musdelay_delay3->labelcolor(bcolor);
musdelay_delay2->labelcolor(bcolor);


GATE->labelcolor(bcolor);
gate_preset->labelcolor(bcolor);


MIDI_LABEL->labelcolor(bcolor);
Midi_out_Counter->labelcolor(bcolor);

LABEL_IO->labelcolor(bcolor);

Preset_Counter->labelcolor(bcolor);
PRESETS_LABEL->labelcolor(bcolor);

TUNER_LABEL->labelcolor(bcolor);
WNote->labelcolor(bcolor);
WRfreq->labelcolor(bcolor);
WNfreq->labelcolor(bcolor);

TITTLE_L->labelcolor(bcolor);
DESC_L->labelcolor(bcolor);

O_TITLE->labelcolor(bcolor);

Look->labelcolor(bcolor);
scheme_ch->labelcolor(bcolor);
MIDI_SET->labelcolor(bcolor);
BMidiIn->labelcolor(bcolor);
D_A_Connect->labelcolor(bcolor);
JACK_SET->labelcolor(bcolor);
JackCo->labelcolor(bcolor);
D_J_Connect->labelcolor(bcolor);
Midi_In_Counter->labelcolor(bcolor);
Har_In_Counter->labelcolor(bcolor);
Har_Qual->labelcolor(bcolor);
AUDIO_SET->labelcolor(bcolor);
Pre_Serve->labelcolor(bcolor);
MISC_SET->labelcolor(bcolor);
Username->labelcolor(bcolor);
BANK_SET->labelcolor(bcolor);
BFiname->labelcolor(bcolor);


if (scheme_ch->value()==3)
{
About_Version->labelcolor(bcolor);
AB_Title->labelcolor(bcolor);
AB_SubTitle->labelcolor(bcolor);
AB_Authors->labelcolor(bcolor);
AB_A1->labelcolor(bcolor);
AB_A2->labelcolor(bcolor);
AB_A3->labelcolor(bcolor);
AB_url->labelcolor(bcolor);
}


label_color = bcolor;


Fl::redraw();
}

void RKRGUI::Buttons_Color_Change(Fl_Color bcolor) {
  ActivarGeneral->color(bcolor);
eq_activar->color(bcolor);
compress_activar->color(bcolor);
dist_activar->color(bcolor);
ovrd_activar->color(bcolor);
echo_activar->color(bcolor);
chorus_activar->color(bcolor);
phaser_activar->color(bcolor);
flanger_activar->color(bcolor);
reverb_activar->color(bcolor);
eqp_activar->color(bcolor);
WhaWha_activar->color(bcolor);
Alienwah_activar->color(bcolor);
pan_activar->color(bcolor);
har_activar->color(bcolor);
musdelay_activar->color(bcolor);
gate_activar->color(bcolor);
Cabinet_activar->color(bcolor);
tuner_activar->color(bcolor);
Preset_Counter->color(bcolor);
Midi_In_Counter->color(bcolor);
Har_In_Counter->color(bcolor);
Midi_out_Counter->color(bcolor);
DAuthor->color(bcolor);
WPreset_Name->color(bcolor);
Open_Order->color(bcolor);
S_new->color(bcolor);
S_preset->color(bcolor);
L_preset->color(bcolor);
B_preset->color(bcolor);
Compare->color(bcolor);
nidi_activar->color(bcolor);


if (made)
{
for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);
    long long temp = (long long) w->user_data();
    if (temp > 0) w->color(bcolor); 
  }



}

ok_order->color(bcolor);
Cancel_order->color(bcolor);
Sube->color(bcolor);
Baja->color(bcolor);
Pon->color(bcolor);

A_C->color(bcolor);
B_C->color(bcolor);
L_C->color(bcolor);
K_C->color(bcolor);
Prefs_OK->color(bcolor);
BF_Browser->color(bcolor);


fore_color= bcolor;

Fl::redraw();
}

void RKRGUI::Leds_Color_Change(Fl_Color bcolor) {
  ActivarGeneral->selection_color(bcolor);
eq_activar->selection_color(bcolor);
compress_activar->selection_color(bcolor);
dist_activar->selection_color(bcolor);
ovrd_activar->selection_color(bcolor);
echo_activar->selection_color(bcolor);
chorus_activar->selection_color(bcolor);
phaser_activar->selection_color(bcolor);
flanger_activar->selection_color(bcolor);
reverb_activar->selection_color(bcolor);
eqp_activar->selection_color(bcolor);
WhaWha_activar->selection_color(bcolor);
Alienwah_activar->selection_color(bcolor);
Cabinet_activar->selection_color(bcolor);
pan_activar->selection_color(bcolor);
har_activar->selection_color(bcolor);
musdelay_activar->selection_color(bcolor);
gate_activar->selection_color(bcolor);
tuner_activar->selection_color(bcolor);
nidi_activar->selection_color(bcolor);
Compare->selection_color(bcolor);



leds_color=bcolor;

Fl::redraw();
}

void RKRGUI::put_icon(Fl_Window* window) {
  if (hints == NULL)
hints = XGetWMHints(fl_display, fl_xid(window));

hints->icon_pixmap=p;
hints->icon_mask=mask; 
hints->flags = IconPixmapHint | IconMaskHint;
XSetWMHints(fl_display, fl_xid(window), hints);
}

void RKRGUI::load_stat() {
  int x,y,w,h,k,b,f,l,a;

Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

rakarrack.get(rkr->PrefNom("Principal X"),x,1);
rakarrack.get(rkr->PrefNom("Principal Y"),y,1);
rakarrack.get(rkr->PrefNom("Principal W"),w,800);
rakarrack.get(rkr->PrefNom("Principal H"),h,600);


rakarrack.get(rkr->PrefNom("Background Color"),b,(int) FL_BLUE);
rakarrack.get(rkr->PrefNom("Foreground Color"),f,(int) FL_GREEN);
rakarrack.get(rkr->PrefNom("Leds Color"),l, (int) FL_YELLOW);
rakarrack.get(rkr->PrefNom("Labels Color"),a, (int)FL_WHITE);
rakarrack.get(rkr->PrefNom("Schema"), k,0);
scheme_ch->value(k);
scheme_ch->do_callback();

Principal->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("BankWindow X"),x,1);
rakarrack.get(rkr->PrefNom("BankWindow Y"),y,1);
rakarrack.get(rkr->PrefNom("BankWindow W"),w,800);
rakarrack.get(rkr->PrefNom("BankWindow H"),h,600);

BankWindow->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("Order X"),x,1);
rakarrack.get(rkr->PrefNom("Order Y"),y,1);
rakarrack.get(rkr->PrefNom("Order W"),w,600);
rakarrack.get(rkr->PrefNom("Order H"),h,400);

Order->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("Settings X"),x,1);
rakarrack.get(rkr->PrefNom("Settings Y"),y,1);
rakarrack.get(rkr->PrefNom("Settings W"),w,640);
rakarrack.get(rkr->PrefNom("Settings H"),h,480);

Settings->resize(x,y,w,h);


back_color=(Fl_Color)b;
fore_color=(Fl_Color)f;
leds_color=(Fl_Color)l;
label_color=(Fl_Color)a;

Background_Color_Change(back_color);
Buttons_Color_Change(fore_color);
Leds_Color_Change(leds_color);
Label_Color_Change(label_color);

if (!commandline)
{
rakarrack.get(rkr->PrefNom("Preset Num"),k ,1);
Preset_Counter->value(k);
rkr->Bank_to_Preset(k);
}

rakarrack.get(rkr->PrefNom("UserName"),rkr->UserRealName,"",127);
rakarrack.get(rkr->PrefNom("Preserve Gain/Master"),rkr->actuvol,0);
rakarrack.get(rkr->PrefNom("MIDI IN Channel"),rkr->MidiCh,1);
rkr->MidiCh--;
rakarrack.get(rkr->PrefNom("MIDI IN Harmonizer"),rkr->HarCh,1);
rkr->HarCh--;


//MIDIConverter

rakarrack.get(rkr->PrefNom("Midi Out Channel"),k,1);
Midi_out_Counter->value(k);
rkr->efx_MIDIConverter->setmidichannel(k);
 
rakarrack.get(rkr->PrefNom("Trigger Adjust"),k,4);
Trig_Adj->value(k);
rkr->efx_MIDIConverter->setTriggerAdjust(k);


rakarrack.get(rkr->PrefNom("Velocity Adjust"),k,50);
Vel_Adj->value(k);
rkr->efx_MIDIConverter->setVelAdjust(k);
}

void RKRGUI::save_stat(int i) {
  Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

if (i==0)
{
rakarrack.set(rkr->PrefNom("Principal X"),Principal->x());
rakarrack.set(rkr->PrefNom("Principal Y"),Principal->y());
rakarrack.set(rkr->PrefNom("Principal W"),Principal->w());
rakarrack.set(rkr->PrefNom("Principal H"),Principal->h());

rakarrack.set(rkr->PrefNom("Background Color"), back_color);
rakarrack.set(rkr->PrefNom("Foreground Color"), fore_color);
rakarrack.set(rkr->PrefNom("Leds Color"), leds_color);
rakarrack.set(rkr->PrefNom("Labels Color"),label_color);
rakarrack.set(rkr->PrefNom("Schema"), (int) scheme_ch->value());

if ((Preset_Counter->value() >0) && (Preset_Counter->value() < 81))

rakarrack.set(rkr->PrefNom("Preset Num"),(int) Preset_Counter->value());

if (rkr->help_displayed)
{

rakarrack.set(rkr->PrefNom("Help X"),visor->x());
rakarrack.set(rkr->PrefNom("Help Y"),visor->y());
rakarrack.set(rkr->PrefNom("Help W"),visor->w());
rakarrack.set(rkr->PrefNom("Help H"),visor->h());
rakarrack.set(rkr->PrefNom("Help TextSize"),visor->textsize());
}

//MIDIConverter

rakarrack.set(rkr->PrefNom("Midi Out Channel"),(int)Midi_out_Counter->value()); 
rakarrack.set(rkr->PrefNom("Trigger Adjust"),(int)Trig_Adj->value());
rakarrack.set(rkr->PrefNom("Velocity Adjust"),(int)Vel_Adj->value());

}


if (i==1)
{
rakarrack.set(rkr->PrefNom("BankWindow X"),BankWindow->x());
rakarrack.set(rkr->PrefNom("BankWindow Y"),BankWindow->y());
rakarrack.set(rkr->PrefNom("BankWindow W"),BankWindow->w());
rakarrack.set(rkr->PrefNom("BankWindow H"),BankWindow->h());


}

if (i==2)
{
rakarrack.set(rkr->PrefNom("Order X"),Order->x());
rakarrack.set(rkr->PrefNom("Order Y"),Order->y());
rakarrack.set(rkr->PrefNom("Order W"),Order->w());
rakarrack.set(rkr->PrefNom("Order H"),Order->h());
}

if (i==3)
{
rakarrack.set(rkr->PrefNom("Settings X"),Settings->x());
rakarrack.set(rkr->PrefNom("Settings Y"),Settings->y());
rakarrack.set(rkr->PrefNom("Settings W"),Settings->w());
rakarrack.set(rkr->PrefNom("Settings H"),Settings->h());

rakarrack.set(rkr->PrefNom("UserName"),rkr->UserRealName);
rakarrack.set(rkr->PrefNom("Preserve Gain/Master"),rkr->actuvol);
rakarrack.set(rkr->PrefNom("Bank Filename"),rkr->BankFilename);
rakarrack.set(rkr->PrefNom("Auto Connect MIDI IN"),rkr->aconnect_MI);
rakarrack.set(rkr->PrefNom("Auto Connect Jack"),rkr->aconnect_JA);




i = BMidiIn->value();
char *temp;
temp = (char*) BMidiIn->text(i);
if (temp!=NULL)
rakarrack.set(rkr->PrefNom("MIDI IN Device"),temp);
rakarrack.set(rkr->PrefNom("MIDI IN Channel"),rkr->MidiCh+1);
rakarrack.set(rkr->PrefNom("MIDI IN Harmonizer"),rkr->HarCh+1);
rakarrack.set(rkr->PrefNom("Harmonizer Quality"),rkr->HarQual);


int k=1;
char temp1[128];


for(i=1; i<=JackCo->size();i++)
{ 
 
  if (JackCo->selected(i))
    {
      sprintf(temp1,"Jack Port %d",k);
      rakarrack.set(rkr->PrefNom(temp1),JackCo->text(i));
      k++;
    }
      
}   
      
 rakarrack.set(rkr->PrefNom("Auto Connect Num"),k-1); 
  
    



}
}

void RKRGUI::Put_Loaded() {
  //General



WPreset_Name->value(rkr->Preset_Name);
DAuthor->copy_label(rkr->Author);

Nivel_Entrada->value((int) (rkr->Input_Gain*100.0)-50);
rkr->calculavol(1);
Nivel_Salida->value((int) (rkr->Master_Volume*100.0)-50);
rkr->calculavol(2);


ActivarGeneral->value(rkr->Bypass);

if (rkr->Bypass==0)
{

rkr->val_i_sum=-50;
rkr->val_v_sum=-50;
input_vu->value(-50);
output_vu->value(-50);

}
//Reverb

reverb_WD->value(rkr->lv[0][0]-64);
reverb_pan->value(rkr->lv[0][1]-64);
reverb_time->value(rkr->lv[0][2]);
reverb_ldel->value(rkr->lv[0][3]);
reverb_ldelft->value(rkr->lv[0][4]);
reverb_RS->value(rkr->lv[0][11]);
reverb_LPF->value(rkr->lv[0][7]);
reverb_HPF->value(rkr->lv[0][8]);
reverb_damp->value(rkr->lv[0][9]);
reverb_type->value(rkr->lv[0][10]);
reverb_activar->value(rkr->Reverb_Bypass);

//Echo

echo_WD->value(rkr->lv[1][0]-64);
echo_pan->value(rkr->lv[1][1]-64);
echo_delay->value(rkr->lv[1][2]);
echo_LRdl->value(rkr->lv[1][3]);
echo_LRc->value(rkr->lv[1][4]-64);
echo_fb->value(rkr->lv[1][5]);
echo_damp->value(rkr->lv[1][6]);
echo_activar->value(rkr->Echo_Bypass);

//Chorus

chorus_WD->value(rkr->lv[2][0]-64);
chorus_lfotype->value(rkr->lv[2][4]);
chorus_subs->value(rkr->lv[2][11]);
chorus_pan->value(rkr->lv[2][1]-64);
chorus_freq->value(rkr->lv[2][2]);
chorus_rnd->value(rkr->lv[2][3]);
chorus_stdf->value(rkr->lv[2][5]);
chorus_dpth->value(rkr->lv[2][6]);
chorus_delay->value(rkr->lv[2][7]);
chorus_fb->value(rkr->lv[2][8]);
chorus_LR->value(rkr->lv[2][9]-64);
chorus_activar->value(rkr->Chorus_Bypass);


//Flanger

flanger_WD->value(rkr->lv[3][0]-64);
flanger_lfotype->value(rkr->lv[3][4]);
flanger_subs->value(rkr->lv[3][11]);
flanger_pan->value(rkr->lv[3][1]-64);
flanger_freq->value(rkr->lv[3][2]);
flanger_rnd->value(rkr->lv[3][3]);
flanger_stdf->value(rkr->lv[3][5]);
flanger_dpth->value(rkr->lv[3][6]);
flanger_delay->value(rkr->lv[3][7]);
flanger_fb->value(rkr->lv[3][8]);
flanger_LR->value(rkr->lv[3][9]-64);
flanger_activar->value(rkr->Flanger_Bypass);


//Phaser

phaser_WD->value(rkr->lv[4][0]-64);
phaser_lfotype->value(rkr->lv[4][4]);
phaser_subs->value(rkr->lv[4][10]);
phaser_pan->value(rkr->lv[4][1]-64);
phaser_freq->value(rkr->lv[4][2]);
phaser_rnd->value(rkr->lv[4][3]);
phaser_phase->value(rkr->lv[4][11]);
phaser_stdf->value(rkr->lv[4][5]);
phaser_dpth->value(rkr->lv[4][6]);
phaser_fb->value(rkr->lv[4][7]);
phaser_stages->value(rkr->lv[4][8]);
phaser_LR->value(rkr->lv[4][9]-64);
phaser_activar->value(rkr->Phaser_Bypass);

//Overdrive

ovrd_WD->value(rkr->lv[5][0]-64);
ovrd_tipo->value(rkr->lv[5][4]);
ovrd_neg->value(rkr->lv[5][6]);
ovrd_st->value(rkr->lv[5][9]);
ovrd_pf->value(rkr->lv[5][10]);
ovrd_LRc->value(rkr->lv[5][2]-64);
ovrd_drive->value(rkr->lv[5][3]);
ovrd_level->value(rkr->lv[5][4]);
ovrd_tipo->value(rkr->lv[5][5]);
ovrd_pan->value(rkr->lv[5][1]-64);
ovrd_lpf->value(rkr->lv[5][7]);
ovrd_hpf->value(rkr->lv[5][8]);
ovrd_activar->value(rkr->Overdrive_Bypass);


//Distorsion

dist_WD->value(rkr->lv[6][0]-64);
dist_tipo->value(rkr->lv[6][4]);
dist_neg->value(rkr->lv[6][6]);
dist_st->value(rkr->lv[6][9]);
dist_pf->value(rkr->lv[6][10]);
dist_LRc->value(rkr->lv[6][2]-64);
dist_drive->value(rkr->lv[6][3]);
dist_level->value(rkr->lv[6][4]);
dist_tipo->value(rkr->lv[6][5]);
dist_pan->value(rkr->lv[6][1]-64);
dist_lpf->value(rkr->lv[6][7]);
dist_hpf->value(rkr->lv[6][8]);
dist_activar->value(rkr->Distorsion_Bypass);

//EQ1

eq_1->value(rkr->lv[7][0]-64);
eq_2->value(rkr->lv[7][1]-64);
eq_3->value(rkr->lv[7][2]-64);
eq_4->value(rkr->lv[7][3]-64);
eq_5->value(rkr->lv[7][4]-64);
eq_6->value(rkr->lv[7][5]-64);
eq_7->value(rkr->lv[7][6]-64);
eq_8->value(rkr->lv[7][7]-64);
eq_9->value(rkr->lv[7][8]-64);
eq_10->value(rkr->lv[7][9]-64);
eq_Gain->value(rkr->lv[7][10]-64);
eq_Q->value(rkr->lv[7][11]-64);
eq_activar->value(rkr->EQ1_Bypass);


//EQ2

eqp_LF->value(rkr->lv[8][0]);
eqp_LFg->value(rkr->lv[8][1]-64);
eqp_LQ->value(rkr->lv[8][2]-64);
eqp_MF->value(rkr->lv[8][3]);
eqp_MFg->value(rkr->lv[8][4]-64);
eqp_MQ->value(rkr->lv[8][5]-64);
eqp_HF->value(rkr->lv[8][6]);
eqp_HFg->value(rkr->lv[8][7]-64);
eqp_HQ->value(rkr->lv[8][8]-64);
eqp_Gain->value(rkr->lv[8][9]-64);
eqp_activar->value(rkr->EQ2_Bypass);


//Compressor

compress_ATime->value(rkr->lv[9][3]);
compress_RTime->value(rkr->lv[9][4]);
compress_Ratio->value(rkr->lv[9][1]);
compress_threshold->value(rkr->lv[9][0]);
compress_output->value(rkr->lv[9][2]);
Auto_Output->value(rkr->lv[9][5]);
compress_activar->value(rkr->Compressor_Bypass);


//WahWah

WhaWha_WD->value(rkr->lv[11][0]-64);
WhaWha_lfotype->value(rkr->lv[11][4]);
WhaWha_pan->value(rkr->lv[11][1]-64);
WhaWha_freq->value(rkr->lv[11][2]);
WhaWha_rnd->value(rkr->lv[11][3]);
WhaWha_stdf->value(rkr->lv[11][5]);
WhaWha_dpth->value(rkr->lv[11][6]);
WhaWha_ampsns->value(rkr->lv[11][7]);
WhaWha_ampsnsinv->value(rkr->lv[11][8]);
WhaWha_smooth->value(rkr->lv[11][9]);
WhaWha_activar->value(rkr->WhaWha_Bypass);


//AlienWah

Alienwah_WD->value(rkr->lv[12][0]-64);
Alienwah_lfotype->value(rkr->lv[12][4]);
Alienwah_pan->value(rkr->lv[12][1]-64);
Alienwah_freq->value(rkr->lv[12][2]);
Alienwah_rnd->value(rkr->lv[12][10]);
Alienwah_phase->value(rkr->lv[12][10]);
Alienwah_stdf->value(rkr->lv[12][5]);
Alienwah_dpth->value(rkr->lv[12][6]);
Alienwah_fb->value(rkr->lv[12][7]);
Alienwah_delay->value(rkr->lv[12][8]);
Alienwah_LR->value(rkr->lv[12][9]-64);
Alienwah_activar->value(rkr->Alienwah_Bypass);


//Cabinet

Cabinet_output->value(rkr->lv[13][1]-64);
Cabinet_preset->value(rkr->lv[13][0]);
Cabinet_activar->value(rkr->Cabinet_Bypass);



//Pan

pan_WD->value(rkr->lv[14][0]-64);
pan_lfotype->value(rkr->lv[14][4]);
pan_autopan->value(rkr->lv[14][7]);
pan_extraon->value(rkr->lv[14][8]);
pan_pan->value(rkr->lv[14][1]-64);
pan_freq->value(rkr->lv[14][2]);
pan_rnd->value(rkr->lv[14][3]);
pan_stdf->value(rkr->lv[14][5]);
pan_extra->value(rkr->lv[14][6]);
pan_activar->value(rkr->Pan_Bypass);



//Har

har_WD->value(rkr->lv[15][0]-64);
har_pan->value(rkr->lv[15][1]-64);
har_gan->value(rkr->lv[15][2]-64);
har_int->value(rkr->lv[15][3]-12);
har_freq1->value(rkr->lv[15][4]);
har_gan1->value(rkr->lv[15][8]-64);
har_q1->value(rkr->lv[15][9]-64);
har_SELECT->value(rkr->lv[15][5]);
har_note->value(rkr->lv[15][6]);
har_type->value(rkr->lv[15][7]);
har_MIDI->value(rkr->lv[15][10]);
har_activar->value(rkr->Harmonizer_Bypass);
Chord();


//MusicalDelay
musdelay_WD->value(rkr->lv[16][0]-64);
musdelay_pan1->value(rkr->lv[16][1]-64);
musdelay_delay1->value(rkr->lv[16][2]-1);
musdelay_delay3->value(rkr->lv[16][3]-1);
musdelay_LRc->value(rkr->lv[16][4]-64);
musdelay_fb1->value(rkr->lv[16][5]);
musdelay_damp->value(rkr->lv[16][6]);
musdelay_pan2->value(rkr->lv[16][7]-64);
musdelay_delay2->value(rkr->lv[16][8]-1);
musdelay_fb2->value(rkr->lv[16][9]);
musdelay_tempo->value(rkr->lv[16][10]);
musdelay_gain1->value(rkr->lv[16][11]-64);
musdelay_gain2->value(rkr->lv[16][12]-64);
musdelay_activar->value(rkr->MusDelay_Bypass);


//NoiseGate

gate_ATime->value(rkr->lv[17][2]);
gate_RTime->value(rkr->lv[17][3]);
gate_range->value(rkr->lv[17][1]);
gate_hold->value(rkr->lv[17][6]);
gate_LPF->value(rkr->lv[17][4]);
gate_HPF->value(rkr->lv[17][5]);
gate_threshold->value(rkr->lv[17][0]);
gate_activar->value(rkr->Gate_Bypass);



reordena();
}

void RKRGUI::tick(void* v) {
  Fl_Box *o = (Fl_Box*)v;
o->do_callback();
Fl::repeat_timeout(.04,tick,v);
}

void RKRGUI::preset_click(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->preset_click_i(o,v);
}

inline void RKRGUI::preset_click_i(Fl_Button* o, void*) {
  int ok;

char temp2[128];
long long kk = (long long) o->user_data();
int num = (int) kk;
int tecla = Fl::event_key();


if (Fl::event_button()==3)
{

Fl_Widget *w = ob->child(num-1);


if (strlen(rkr->Bank[num].Preset_Name) >0)
{ 
  Fl_Widget *m = fl_message_icon();
  m->parent()->copy_label(rkr->jackcliname);
  sprintf(temp2,"Overwrite? \"%s\"",w->label());
  ok=fl_choice(temp2,"No","Yes",NULL);
 if (!ok) return;
}
   
  rkr->Preset_to_Bank(num);
  w->copy_label(rkr->Preset_Name);
  rkr->modified=1;

}



if ((Fl::event_button()==1) || tecla==32)
{
Preset_Counter->value(num);
rkr->Bank_to_Preset(num);
Put_Loaded();
}
}

void RKRGUI::make_window_banks() {
  int i,j,x,y,num;
int elw,elh;

elw=176*BankWindow->w()/800;
elh=24*BankWindow->h()/600;



ob->begin();

x=40;y=10;
num=1;

for (i=1;i<21;i++)
{
y +=elh+2;

for (j=1; j<5; j++)
{
   
     Fl_Button* butX = new Fl_Button(x+1, y+1, elw,elh,rkr->Bank[num].Preset_Name);
      butX->type(0);
      butX->color(fore_color);
      butX->box(FL_FLAT_BOX);
      butX->selection_color(leds_color);
      butX->labelsize(14);
      butX->align(68|FL_ALIGN_INSIDE);
      butX->user_data((void*) (num));
      butX->value(0);
      butX->callback((Fl_Callback *)preset_click);
      ob->add(butX);

x +=elw+4;
num++;

}
 x=40;

}


ob->end();

made=1;
}

void RKRGUI::reordena() {
  int i,j,k,t;
short x[10],y[10];
ulong s[10];

s[0]=49;
s[1]=50;
s[2]=51;
s[3]=52;
s[4]=53;
s[5]=54;
s[6]=55;
s[7]=56;
s[8]=57;
s[9]=48;


x[0]=E1->x();
x[1]=E2->x();
x[2]=E3->x();
x[3]=E4->x();
x[4]=E5->x();
x[5]=E6->x();
x[6]=E7->x();
x[7]=E8->x();
x[8]=E9->x();
x[9]=E10->x();

y[0]=E1->y();
y[1]=E2->y();
y[2]=E3->y();
y[3]=E4->y();
y[4]=E5->y();
y[5]=E6->y();
y[6]=E7->y();
y[7]=E8->y();
y[8]=E9->y();
y[9]=E10->y();


//Find to Hide


t=1;

for (i=0; i<17;i++)
{

 k=0;
 for (j=0;j<10;j++) if (rkr->efx_order[j]==i) k=1;
       
 if(!k)
 
 { 
  rkr->availables[t]=i;
  t++;
 }

}



//Hide


for (i=1; i<=7; i++)

 {


    switch ( rkr->availables[i])
      {


        case 0: 
        EQ->hide();
        break; 
        case 1: 
        COMPRESS->hide();
        break;
        case 2:
        DIST->hide();
        break;
        case 3:
        OVRD->hide(); 
        break;
        case 4:
        ECHO->hide();
        break;
        case 5:
        CHORUS->hide();
        break;
        case 6:
        PHASER->hide();
        break;
        case 7:
        FLANGER->hide();
        break;
        case 8:
        REVERB->hide();
        break;
        case 9:
        PEQ->hide();
        break;
        case 10:
        WHAWHA->hide();
        break;
        case 11:
        ALIENWAH->hide();        
        break;
        case 12:
        CABINET->hide();
        break;
        case 13:
        PAN->hide();
        break;
        case 14:
        HAR->hide();
        break;
        case 15:
        MUSDELAY->hide();
        break;
        case 16:
        GATE->hide();
        break;
      }
      
    }
    
    
    
    
    
 // Show   
    
    
         

for (i=0; i<10; i++)

switch ( rkr->efx_order[i])
  {
  
    case 0:
       
       EQ->position(x[i],y[i]);
       eq_activar->shortcut(s[i]);
       EQ->show();
       break;   
       
       
    case 1:
       
       COMPRESS->position(x[i],y[i]);
       compress_activar->shortcut(s[i]);
       COMPRESS->show();
       break;   
       
     case 2:
    
       DIST->position(x[i],y[i]);
       dist_activar->shortcut(s[i]);
       DIST->show();
       break;   
       
     case 3:
    
       OVRD->position(x[i],y[i]);
       ovrd_activar->shortcut(s[i]);
       OVRD->show();
       break;   
       
     case 4:
    
       ECHO->position(x[i],y[i]);
       echo_activar->shortcut(s[i]);
       ECHO->show();
       break;   
       
     case 5:
    
       CHORUS->position(x[i],y[i]);
       chorus_activar->shortcut(s[i]);
       CHORUS->show();
       break;   
       
     case 6:
    
       PHASER->position(x[i],y[i]);
       phaser_activar->shortcut(s[i]);
       PHASER->show();
       break;   
       
     case 7:
    
       FLANGER->position(x[i],y[i]);
       flanger_activar->shortcut(s[i]);
       FLANGER->show();
       break;    
                    
     case 8:
    
       REVERB->position(x[i],y[i]);
       reverb_activar->shortcut(s[i]);
       REVERB->show();
       break;     
       
       
     case 9:
    
       PEQ->position(x[i],y[i]);
       eqp_activar->shortcut(s[i]);
       PEQ->show();
       break;     
     
     case 10:
    
       WHAWHA->position(x[i],y[i]);
       WhaWha_activar->shortcut(s[i]);
       WHAWHA->show();
       break;  
       
     case 11:
    
       ALIENWAH->position(x[i],y[i]);
       Alienwah_activar->shortcut(s[i]);
       ALIENWAH->show();
       break;      
     
     case 12:
     
       CABINET->position(x[i],y[i]);   
       Cabinet_activar->shortcut(s[i]);
       CABINET->show();
       break;
    
     case 13:
     
       PAN->position(x[i],y[i]);   
       pan_activar->shortcut(s[i]);
       PAN->show();
       break;
     
     case 14:
       HAR->position(x[i],y[i]);
       har_activar->shortcut(s[i]);
       HAR->show();   
       break;
     
     case 15:
       MUSDELAY->position(x[i],y[i]);
       musdelay_activar->shortcut(s[i]);
       MUSDELAY->show();  
       break; 
       
     case 16:
       GATE->position(x[i],y[i]);
       gate_activar->shortcut(s[i]);
       GATE->show();
       break;  
       
 }
 
  Principal->init_sizes();
 
 
  Fl::redraw();
}

void RKRGUI::show_help() {
  char temp[128];

int x,y,w,h,k;

Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

if (rkr->help_displayed==0)
{
 visor = new Fl_Help_Dialog;

rakarrack.get(rkr->PrefNom("Help X"),x,1);
rakarrack.get(rkr->PrefNom("Help Y"),y,1);
rakarrack.get(rkr->PrefNom("Help W"),w,640);
rakarrack.get(rkr->PrefNom("Help H"),h,480);
rakarrack.get(rkr->PrefNom("Help TextSize"),k,11);
visor->resize(x,y,w,h);
visor->textsize((unsigned char)k);
}


bzero(temp,sizeof(temp));
sprintf(temp,"%s/html/help.html",HELPDIR);
visor->load(temp);

rkr->help_displayed=1;
visor->show();
}

void RKRGUI::show_lic() {
  char temp[128];

int x,y,w,h,k;

Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);



if (rkr->help_displayed==0)
{
 visor = new Fl_Help_Dialog;

rakarrack.get(rkr->PrefNom("Help X"),x,1);
rakarrack.get(rkr->PrefNom("Help Y"),y,1);
rakarrack.get(rkr->PrefNom("Help W"),w,640);
rakarrack.get(rkr->PrefNom("Help H"),h,480);
rakarrack.get(rkr->PrefNom("Help TextSize"),k,11);
visor->resize(x,y,w,h);
visor->textsize((unsigned char)k);
}


bzero(temp,sizeof(temp));
sprintf(temp,"%s/html/license.html",HELPDIR);
visor->load(temp);


rkr->help_displayed=1;

visor->show();
}

void RKRGUI::MiraClientes() {
  FILE *fp;
char temp[128];
char temp1[128];
char *masque;
char *name;

BMidiIn->clear();


if ((fp = fopen ("/proc/asound/seq/clients", "r")) != NULL)
  {
    bzero (temp, sizeof (temp));

      while (fgets (temp, sizeof temp, fp) != NULL)
           {
             
            if (strstr(temp,"Port") != NULL)
             
           {  
             
             strcpy(temp1,temp);
             strtok(temp1,"\"");
             name=strtok(NULL,"\"");
             masque=strtok(NULL,")");
             
             if ((masque[2]=='R') && (strstr(name,"rakarrack MC OUT")==0)) BMidiIn->add(name);
             
            } 
           } 
   }
   
   fclose(fp);
 
 
   
 JackCo->clear();
 
 const char **ports;
  
  
   if ((ports = jack_get_ports (rkr->jackclient, NULL, JACK_DEFAULT_AUDIO_TYPE, 
                               JackPortIsInput)) == NULL) {
                fprintf(stderr, "Cannot find any capture ports\n");
    
                
        }
  
  else
  {
  int i=0;
  
  while (ports[i] != NULL)
     {
      if((strstr(ports[i],"rakarrack:in_1")==0) && (strstr(ports[i],"rakarrack:in_2")==0))
      JackCo->add(ports[i]);
      i++; 
     }
     
    
         
   }  
   
   free(ports);
}

void RKRGUI::MiraConfig() {
  int i = 1;
int k;
while (BMidiIn->text(i) != NULL)
{
if (strcmp(BMidiIn->text(i),rkr->MID)==0 ) BMidiIn->select(i,1);
i++; 
}

i=1;

while (JackCo->text(i) != NULL)
{

for (k=0; k < rkr->cuan_jack; k++)
if (strcmp(JackCo->text(i),rkr->jack_po[k].name)==0 ) JackCo->select(i,1);

i++; 
}








BFiname->value(rkr->BankFilename);
Username->value(rkr->UserRealName);
Pre_Serve->value(rkr->actuvol);
D_A_Connect->value(rkr->aconnect_MI);
D_J_Connect->value(rkr->aconnect_JA);
Midi_In_Counter->value(rkr->MidiCh+1);
Har_In_Counter->value(rkr->HarCh+1);
Har_Qual->value((rkr->HarQual/4)-1);


if (rkr->aconnect_MI) BMidiIn->activate();
else BMidiIn->deactivate();

if (rkr->aconnect_JA) JackCo->activate();
else JackCo->deactivate();
}

void RKRGUI::BankWin_Label(char *filename) {
  char tmp[256];


bzero(tmp,sizeof(tmp));
sprintf(tmp,"%s   v%s - Bank Manager - %s",rkr->jackcliname,VERSION,fl_filename_name(filename));
BankWindow->copy_label(tmp);
}

void RKRGUI::is_modified() {
  int ok;


if (rkr->modified)
{

 Fl_Widget *w = fl_message_icon();
 w->parent()->copy_label(rkr->jackcliname);
 

 ok=fl_choice("Bank was modified, but not saved","Discard","Save",NULL);



 switch(ok)
  
    {
        case 0:
          break;

        case 1: 
          MIDI_LABEL->do_callback();
          break;  

    }

}
}

void RKRGUI::Put_Loaded_Bank() {
  int k=1;

for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);
    long long temp = (long long) w->user_data();
    if (temp > 0)
    {
     w->copy_label(rkr->Bank[k].Preset_Name);
     k++;
    }
  
  }
}

void RKRGUI::Chord() {
  int tipo=rkr->efx_Har->getpar(7);
int undi=rkr->efx_Har->getpar(6);

sprintf(rkr->RC->NombreAcorde,"%s%s", rkr->RC->NCE[undi].Nom,rkr->RC->ChN[tipo].Nom);

rkr->RC->ctipo=tipo;
rkr->RC->fundi=undi;
rkr->RC->cc=1;
}

void RKRGUI::ActMIDI() {
  if (rkr->Mvalue==0) return;

int i;

for (i=1; i<120; i++)

{

  
 if (rkr->Mcontrol[i]==0) continue;
 
 rkr->Mcontrol[i]=0;


switch (i)
{
     
     case 1:
     WhaWha_dpth->value(rkr->efx_WhaWha->getpar(6));
     break;
     case 20:
     Alienwah_dpth->value(rkr->efx_Alienwah->getpar(6));
     break;
     case 21:
     phaser_dpth->value(rkr->efx_Phaser->getpar(6));
     break;
     case 22:
     flanger_dpth->value(rkr->efx_Flanger->getpar(6));
     break;
     case 23:
     chorus_dpth->value(rkr->efx_Chorus->getpar(6));
     break;
     case 24:
     musdelay_gain1->value(rkr->efx_MusDelay->getpar(11)-64);
     break;
     case 25:
     musdelay_gain2->value(rkr->efx_MusDelay->getpar(12)-64);
     break;
     case 26:
     har_freq1->value(rkr->efx_Har->getpar(4));
     break;
     case 27:
     har_int->value(rkr->efx_Har->getpar(3)-12);
     break;
     case 28:
     WhaWha_WD->value(rkr->efx_WhaWha->getpar(0)-64);
     break;
     case 29:
     ovrd_WD->value(rkr->efx_Overdrive->getpar(0)-64);
     break;
     case 30:
     dist_WD->value(rkr->efx_Distorsion->getpar(0)-64);
     break;
     case 31:
     har_WD->value(rkr->efx_Har->getpar(0)-64);
     break;
     case 52:
     chorus_WD->value(rkr->efx_Chorus->getpar(0)-64);
     break;
     case 53:
     flanger_WD->value(rkr->efx_Flanger->getpar(0)-64);
     break;
     case 54:
     phaser_WD->value(rkr->efx_Phaser->getpar(0)-64);
     break;
     case 55:
     Alienwah_WD->value(rkr->efx_Alienwah->getpar(0)-64);
     break;
     case 56:
     musdelay_WD->value(rkr->efx_MusDelay->getpar(0)-64);
     break;
     case 57:
     reverb_WD->value(rkr->efx_Rev->getpar(0)-64);
     break;
     case 58:
     pan_WD->value(rkr->efx_Pan->getpar(0)-64);
     break;
     case 59:
     echo_WD->value(rkr->efx_Echo->getpar(0)-64);
     break;
     case 46:
     echo_pan->value(rkr->efx_Echo->getpar(1)-64);
     break;
     case 47:
     ovrd_pan->value(rkr->efx_Overdrive->getpar(1)-64);
     break;
     case 48:
     dist_pan->value(rkr->efx_Distorsion->getpar(1)-64);
     break;
     case 49:
     har_pan->value(rkr->efx_Har->getpar(1)-64);
     break;
     case 50:
     chorus_pan->value(rkr->efx_Chorus->getpar(1)-64);
     break;
     case 51:
     flanger_pan->value(rkr->efx_Flanger->getpar(1)-64);
     break;
     case 60:
     phaser_pan->value(rkr->efx_Phaser->getpar(1)-64);
     break;
     case 61:
     Alienwah_pan->value(rkr->efx_Alienwah->getpar(1)-64);
     break;
     case 62:
     musdelay_pan1->value(rkr->efx_MusDelay->getpar(1)-64);
     break;
     case 63:
     reverb_pan->value(rkr->efx_Rev->getpar(1)-64);
     break;
     case 65:
     musdelay_pan2->value(rkr->efx_MusDelay->getpar(7)-64);
     break;
     case 66:
     WhaWha_pan->value(rkr->efx_WhaWha->getpar(1)-64);
     break;
     case 67:
     pan_pan->value(rkr->efx_Pan->getpar(1)-64);
     break;
     case 68:
     ovrd_drive->value(rkr->efx_Overdrive->getpar(3));
     break;
     case 69:
     dist_drive->value(rkr->efx_Distorsion->getpar(3));
     break;
     case 70:
     ovrd_level->value(rkr->efx_Overdrive->getpar(4));
     break;
     case 71:
     dist_level->value(rkr->efx_Distorsion->getpar(4));
     break;
     case 72:
     chorus_freq->value(rkr->efx_Chorus->getpar(2));
     break;
     case 73:
     flanger_freq->value(rkr->efx_Flanger->getpar(2));
     break;
     case 74:
     phaser_freq->value(rkr->efx_Phaser->getpar(2));
     break;
     case 75:
     WhaWha_freq->value(rkr->efx_WhaWha->getpar(2));
     break;
     case 76:
     Alienwah_freq->value(rkr->efx_Alienwah->getpar(2));
     break;
     case 77:
     pan_freq->value(rkr->efx_Pan->getpar(2));
     break;
     case 78:
     echo_fb->value(rkr->efx_Echo->getpar(5));
     break;
     case 79:
     chorus_fb->value(rkr->efx_Chorus->getpar(8));
     break;
     case 80:
     flanger_fb->value(rkr->efx_Flanger->getpar(8));
     break;
     case 81:
     phaser_fb->value(rkr->efx_Phaser->getpar(7));
     break;
     case 82:
     Alienwah_fb->value(rkr->efx_Alienwah->getpar(7));
     break;
     case 83:
     musdelay_fb1->value(rkr->efx_MusDelay->getpar(5));
     break;
     case 84:
     musdelay_fb2->value(rkr->efx_MusDelay->getpar(9));
     break;
     case 85:
     ovrd_lpf->value(rkr->efx_Overdrive->getpar(7));
     break;
     case 86:
     dist_lpf->value(rkr->efx_Distorsion->getpar(7));
     break;
     case 87:
     reverb_LPF->value(rkr->efx_Rev->getpar(7));
     break;
     case 88:
     ovrd_hpf->value(rkr->efx_Overdrive->getpar(8));
     break;
     case 89:
     dist_hpf->value(rkr->efx_Distorsion->getpar(8));
     break;
     case 90:
     reverb_HPF->value(rkr->efx_Rev->getpar(8));
     break;
     case 91:
     chorus_LR->value(rkr->efx_Chorus->getpar(9)-64);
     break;
     case 92:
     flanger_LR->value(rkr->efx_Flanger->getpar(9)-64);
     break;
     case 93:
      phaser_LR->value(rkr->efx_Phaser->getpar(9)-64);
     break;
     case 94:
     ovrd_LRc->value(rkr->efx_Overdrive->getpar(2)-64);
     break;
     case 95:
     dist_LRc->value(rkr->efx_Distorsion->getpar(2)-64);
     break;
     case 96:
     Alienwah_LR->value(rkr->efx_Alienwah->getpar(9)-64);
     break;
     case 97:
     echo_LRc->value(rkr->efx_Echo->getpar(4)-64);
     break;
     case 98:
     musdelay_LRc->value(rkr->efx_MusDelay->getpar(4)-64);
     break;
     case 99:
     chorus_stdf->value(rkr->efx_Chorus->getpar(5));
     break;
     case 100:
     flanger_stdf->value(rkr->efx_Flanger->getpar(5));
     break;
     case 101:
     phaser_stdf->value(rkr->efx_Phaser->getpar(5));
     break;
     case 102:
     WhaWha_stdf->value(rkr->efx_WhaWha->getpar(5));
     break;
     case 103:
     Alienwah_stdf->value(rkr->efx_Alienwah->getpar(5));
     break;
     case 104:
     pan_stdf->value(rkr->efx_Pan->getpar(5));
     break;
     case 105:
     chorus_rnd->value(rkr->efx_Chorus->getpar(3));
     break;
     case 106:
     flanger_rnd->value(rkr->efx_Flanger->getpar(3));
     break;
     case 107:
     phaser_rnd->value(rkr->efx_Phaser->getpar(3));
     break;
     case 108:
     WhaWha_rnd->value(rkr->efx_WhaWha->getpar(3));
     break;
     case 109:
     Alienwah_rnd->value(rkr->efx_Alienwah->getpar(3));
     break;
     case 110:
     pan_rnd->value(rkr->efx_Pan->getpar(3));
     break;
     case 111:
     WhaWha_ampsns->value(rkr->efx_WhaWha->getpar(7));
     break;
     case 112:
     WhaWha_ampsnsinv->value(rkr->efx_WhaWha->getpar(8));
     break;
     case 113:
     WhaWha_smooth->value(rkr->efx_WhaWha->getpar(9));
     break;
     case 114:
     phaser_phase->value(rkr->efx_Phaser->getpar(11));
     break;
     case 115:
     Alienwah_phase->value(rkr->efx_Alienwah->getpar(10));
     break;
     case 116:
     
     break;
     
     case 117:
     
     break;
     case 118:
     
     break;
     
     case 119:
     
     break;
      
}


}


rkr->Mvalue=0;
}
