/*
 * Copyright (C) 2008-2010 The QXmpp developers
 *
 * Authors:
 *  Manjeet Dahiya
 *  Jeremy Lainé
 *
 * Source:
 *  http://code.google.com/p/qxmpp
 *
 * This file is a part of QXmpp library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 */

#include <QDomElement>
#include <QXmlStreamWriter>

#include "QXmppSession.h"
#include "QXmppConstants.h"
#include "QXmppUtils.h"

QXmppSession::QXmppSession()
{
}

QXmppSession::QXmppSession(QXmppIq::Type type)
    : QXmppIq(type)
{
}

bool QXmppSession::isSession(const QDomElement &element)
{
    QDomElement sessionElement = element.firstChildElement("session");
    return (sessionElement.namespaceURI() == ns_session);
}

void QXmppSession::toXmlElementFromChild(QXmlStreamWriter *writer) const
{
    writer->writeStartElement("session");;
    writer->writeAttribute("xmlns", ns_session);
    writer->writeEndElement();
}

