/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtHttpProxyLogin.h"

#include "ui_HttpProxyLoginWindow.h"

#include <qtutil/WidgetBackgroundImage.h>

#include <QtGui/QtGui>

QtHttpProxyLogin::QtHttpProxyLogin(QWidget * parent, const std::string & proxyAddress, unsigned proxyPort)
	: QObject(parent) {

	_httpProxyLoginWindow = new QDialog(parent);

	_ui = new Ui::HttpProxyLoginWindow();
	_ui->setupUi(_httpProxyLoginWindow);

	WidgetBackgroundImage::setBackgroundImage(_ui->httpProxyLabel, ":pics/headers/login.png", WidgetBackgroundImage::AdjustSize);

	//addressLineEdit
	_ui->addressLineEdit->setText(QString::fromUtf8(proxyAddress.c_str()));

	//portLineEdit
	_ui->portLineEdit->setText(QString::number(proxyPort));
}

std::string QtHttpProxyLogin::getLogin() const {
	return std::string(_ui->loginLineEdit->text().toUtf8());
}

std::string QtHttpProxyLogin::getPassword() const {
	return std::string(_ui->passwordLineEdit->text().toUtf8());
}

std::string QtHttpProxyLogin::getProxyAddress() const {
	return std::string(_ui->addressLineEdit->text().toUtf8());
}

unsigned QtHttpProxyLogin::getProxyPort() const {
	return _ui->portLineEdit->text().toUInt();
}

int QtHttpProxyLogin::show() {
	return _httpProxyLoginWindow->exec();
}
