/***************************************************************************
                          qscannersetupdlg.h  -  description
                             -------------------
    begin                : Thu Jun 29 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCANNERSETUPDLG_H
#define QSCANNERSETUPDLG_H

#include <qdialog.h>
#include <qimage.h>
#include <qmap.h>
/**
  *@author M. Herder
  */
//forward declarations
class QRadioButton;
class QWidget;
class QListView;
class QListViewItem;
class QPushButton;
class QString;
class QScanner;
class QScanDialog;
class QTranslator;

class QScannerSetupDlg : public QDialog
{
Q_OBJECT
public:
	QScannerSetupDlg(QScanner* scanner,QWidget *parent=0, const char *name=0);
	~QScannerSetupDlg();
  /**  */
  void clearList();
  /**  */
  QString device();
  /**  */
  virtual void show();
  /**  */
  QMap <QString,QString> optionMap();
private:
  /** */
  bool mIsSetup;
  /**  */
  QMap <QString,QString> mOptionMap;
  /**  */
  QScanner* mpScanner;
  /**  */
  QListView* mpListView;
  /**  */
  QPushButton *mpQuitButton;
  /**  */
  QRadioButton* mpLocalDevicesRadio;
  /**  */
  QRadioButton* mpAllDevicesRadio;
  /**  */
  QListViewItem* mpLastItem;
  /**  */
  int mQueryType;
  /**  */
  QPushButton* mpSelectButton;
  /** */
  QScanDialog* mpScanDialog;
  /** */
  QString mSanePath;
private://methods
  /** */
  void initScanner();
  /**  */
  void initDialog();
  /**  */
  void createContents(bool local_only);
  /**  */
  void createWhatsThisHelp();
  /** No descriptions */
  void loadBackendTranslation(QString name);
protected: // Protected methods
  /**  */
  virtual void showEvent(QShowEvent * e);
private slots: // Private slots
  /**  */
  void slotDeviceSelected();
  /**  */
  void slotDeviceSelected(QListViewItem*);
  /**  */
  void slotListViewClicked(QListViewItem*);
  /**  */
  void slotAllDevices();
  /**  */
  void slotLocalDevices();
  /**  */
  void slotDeviceGroup(int);
  /**  */
  void slotProcessEvents();
  /**  */
  void slotQuit();
};

#endif
