/***************************************************************************
                          previewwidget.h  -  description
                             -------------------
    begin                : Fri Jun 23 2000
    copyright            : (C) 2000 by M. Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef PREVIEWWIDGET_H
#define PREVIEWWIDGET_H

#include <qarray.h>
#include <qvaluelist.h>
#include <qvector.h>
#include <qwidget.h>

#include "quiteinsanenamespace.h"
extern "C"
{
	#include <sane/sane.h>
}
/**
  *@author M. Herder
  */
//forward declarations
class CheckListItemExt;
class ImageBuffer;
class QComboBox;
class QGridLayout;
class QHBox;
class QLabel;
class QListView;
class QListViewItem;
class QPushButton;
class QRect;
class QString;
class QWidgetStack;
class QToolButton;
class PreviewUpdateWidget;
class Ruler;
class ScanArea;
class ScanAreaTemplate;
class ScanAreaCanvas;

struct PredefinedSizes
{
  QString name;
  double width;
  double height;
};

class PreviewWidget : public QWidget
{
   Q_OBJECT
public:
  PreviewWidget(QWidget *parent=0, const char *name=0,WFlags f=0);
  ~PreviewWidget();
  /**  */
  void setMetrics(QIN::MetricSystem ms,SANE_Unit unit);
  /**  */
  void loadPreviewPixmap(QString path);
  /** Set the size of the rectangle */
  void setRectSize(double tlx,double tly,double brx,double bry);
  /**  */
  void changeLayout(bool toplevel);
  /** No descriptions */
  const QArray <double> selectedRects();
  /** No descriptions */
  void setAspectRatio(double aspect);
  /** No descriptions */
  void setSaneUnit(SANE_Unit unit);
  /** No descriptions */
  void setRange(double minx,double maxx,double miny,double maxy);
  /** No descriptions */
  void enableMultiSelection(bool state);
  /** No descriptions */
  void clearPreview();
  /** No descriptions */
  void setData(QByteArray& byte_array);
  /** No descriptions */
  void initPixmap(int rw,int rh);
  /** No descriptions */
  void enablePreviewMode(bool state);
  /** No descriptions */
  bool wasCancelled();
private:
  /** */
  QValueList <unsigned int> mFgColorList;
  /** */
  QValueList <unsigned int> mBgColorList;
  /** */
  QVector <ImageBuffer> mImageVector;
  /** */
  int mImageVectorIndex;
  /** */
  QVector <ScanAreaTemplate> mTemplateVector;
  /** */
  int mTemplateVectorIndex;
  /** */
  CheckListItemExt* mpCurrentItem;
  /**  */
  bool mCancelled;
  /**  */
  double mMinRangeX;
  /**  */
  double mMaxRangeX;
  /**  */
  double mMinRangeY;
  /**  */
  double mMaxRangeY;
  /**  */
  double mFactorX;
  /**  */
  double mFactorY;
  /**  */
  int mHeight;
  /**  */
  int mWidth;
  /**  */
  QIN::MetricSystem mMetricSystem;
  /**  */
  SANE_Unit mSaneUnit;
  /**  */
  QWidgetStack* mpPreviewStack;
  /**  */
  PreviewUpdateWidget* mpUpdateWidget;
  /**  */
  ScanAreaCanvas* mpScanAreaWidget;
  /**  */
  QGridLayout* mpMainLayout;
  /**  */
  int mInitialHeight;
  /**  */
  int mInitialWidth;
  /**  */
  QWidgetStack* mpButtonStack;
  /**  */
  QWidgetStack* mpComboStack;
  /**  */
  QPushButton* mpCancelButton;
  /**  */
  QComboBox* mpScanSizeCombo;
  /**  */
  QComboBox* mpScanTemplateCombo;
  /**  */
  QPushButton* mpCloseButton;
  /**  */
  QPushButton* mpPreviewButton;
  /**  */
  QArray <ScanArea*> mSizeArray;
  /**  */
  QArray <ScanArea*> mUserSizeArray;
  /**  */
  QArray <ScanAreaTemplate*> mUserSizeTemplateArray;
  /**  */
  QLabel* mpMetricLabel;
  /**  */
  QLabel* mpScanSizeLabel;
  /**  */
  Ruler* mpVRuler;
  /**  */
  Ruler* mpHRuler;
  /**  */
  QHBox* mpZoomHBox;
  /**  */
  QHBox* mpSizeHBox;
  /**  */
  QHBox* mpToolHBox;
  /**  */
  QToolButton* mpAutoSelectionButton;
  /**  */
  QToolButton* mpAutoSetupButton;
  /**  */
  QToolButton* mpZoomButton;
  /**  */
  QToolButton* mpZoomUndoButton;
  /**  */
  QToolButton* mpZoomRedoButton;
  /**  */
  QToolButton* mpZoomOffButton;
  /**  */
  QToolButton* mpMultiSelectionButton;
  /**  */
  QToolButton* mpAddButton;
  /**  */
  QToolButton* mpSubButton;
  /**  */
  QToolButton* mpDelTemplatesButton;
  /**  */
  QListView* mpListView;
  /**  */
  QWidget* mpResizeWidget;
  /**  */
  void initWidget();
  /**  */
  void createPredefinedSizes();
  /**  */
  void redrawRulers();
  /** */
  void addImageToQueue(QImage* image,bool overwrite_current=false);
  /** */
  bool undoAvailable();
  /**  */
  bool redoAvailable();
  /** No descriptions */
  void redrawZoomButtons();
  /** No descriptions */
  void forceOptionUpdate();
  /** No descriptions */
  void createWhatsThisHelp();
  /** No descriptions */
  void saveTemplates();
  /** No descriptions */
  void loadTemplates();
protected:
  /** */
  void resizeEvent(QResizeEvent* e);
  /** */
  void showEvent(QShowEvent* se);
private slots:
  /**  */
  void slotAutoSelectionSetup();
  /**  */
  void slotTlxPercent(double pval);
  /**  */
  void slotTlyPercent(double pval);
  /**  */
  void slotBrxPercent(double pval);
  /**  */
  void slotBryPercent(double pval);
  /**  */
  void slotSizeComboChanged(int index);
  /**  */
  void slotUserSize();
  /** No descriptions */
  void slotColorPopup(QListViewItem* li,const QPoint& p,int i);
  /** No descriptions */
  void slotShowListView(bool state);
  /** No descriptions */
  void slotZoom();
  /** No descriptions */
  void slotListItem(QListViewItem* li,const QPoint& p,int c);
  /** No descriptions */
  void slotNewActiveRect(int num);
  /** No descriptions */
  void slotZoomOff();
  /** No descriptions */
  void slotZoomRedo();
  /** No descriptions */
  void slotZoomUndo();
  /** No descriptions */
  void slotPreviewRequest();
  /** No descriptions */
  void slotDeleteAllTemplates();
  /** No descriptions */
  void slotDeleteTemplate();
  /** No descriptions */
  void slotAddTemplate();
  /** No descriptions */
  void slotTemplateSelected(int i);
public slots:
  /**  */
  void slotAutoSelection();
  /**  */
  void slotChangeMetricSystem(QIN::MetricSystem ms);
  /**  */
  void slotSetTlxPercent(double pval);
  /**  */
  void slotSetTlyPercent(double pval);
  /** No descriptions */
  void slotCancel();
  /**  */
  void slotSetBrxPercent(double pval);
  /**  */
  void slotSetBryPercent(double pval);
signals: // Signals
  /**  */
  void signalPreviewSize(QRect rect);
  /**  */
  void signalPreviewRequest(double tlx,double tly,double brx,double bry,int res);
  /**  */
  void signalPredefinedSize(ScanArea* sca);
  /**  */
  void signalUserSetSize();
  /**  */
  void signalHidePreview();
  /** */
  void signalTlxPercent(double val);
  /** */
  void signalTlyPercent(double val);
  /** */
  void signalBrxPercent(double val);
  /** */
  void signalBryPercent(double val);
  /** No descriptions */
  void signalMultiSelectionMode(bool on);
  /** No descriptions */
  void signalEnableScanAreaOptions(bool on);
};
#endif
