/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GAMESCENE_H
#define GAMESCENE_H

#include "gamegrammar.h"

#include <QtGui/QGraphicsView>

class QPainter ;
class QGraphicsItem ;
class QStyleOptionGraphicsItem ;
class GameObject ;

class GameScene: public QGraphicsView
{
    Q_OBJECT
public:
    GameScene(QWidget *parent = 0);
    ~GameScene();

    void addGameObject(AbstractGameObject *gameObject);
    void setEgoObject(AbstractGameObject *ego_object);
    bool inProximityOfEgo(const AbstractGameObject *o) const;
    void addToEgoInventory(AbstractGameObject *o);
    void lookAround();
    virtual void message(const QString &msg);

    inline QList<AbstractGameObject *> egoInventory() const { return m_ego_inventory; }
    inline void removeFromEgoInventory(AbstractGameObject *o) { m_ego_inventory.removeAll(o); }
    inline bool egoHasInInventory(AbstractGameObject *o) { return m_ego_inventory.contains(o); }
    inline QString description() const { return m_description; }
    inline QImage background() const { return m_current_background; }
    inline bool blocked() const { return !m_message.isEmpty(); }
    inline qreal closestZ() const { return m_closest_z; }
    inline qreal farthestZ() const { return m_farthest_z; }
    inline qreal horizon() const { return m_horizon; }
    inline GameGrammar *grammar() const { return m_grammar; }

    inline void setDescription(const QString &description) { m_description = description; }
    inline void setBackground(const QImage &image) { m_current_background = image; }
    inline void setFarthestZ(qreal z) { m_farthest_z = z; }
    inline void setClosestZ(qreal z) { m_closest_z = z; }
    inline void setHorizon(qreal y) { m_horizon = y; }

    inline void addNameToGameObject(AbstractGameObject *o, const QString &other_name)
    {
        m_grammar->addNameToGameObject(o, other_name);
    }

protected:
    virtual void keyPressEvent(QKeyEvent *e);
    virtual void drawForeground(QPainter *painter, const QRectF &);
    virtual void drawBackground(QPainter *painter, const QRectF &);

private:
    GameGrammar *m_grammar;
    QString m_description;
    AbstractGameObject *m_ego_object;
    QList<AbstractGameObject *> m_ego_inventory;
    QStringList m_message;
    QString m_current_input;
    QImage m_current_background;
    qreal m_horizon;
    qreal m_farthest_z;
    qreal m_closest_z;
};

#endif
