/****************************************************************************
 **
 ** Copyright (C) 1992-2008 Nokia. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.launcher;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

public class Delegate extends QItemDelegate {

    public static final int MARGE_HOR = 20; // Extra pixels on each side of text...
    public static final int MARGE_VER = 6;

    public Delegate(QSortFilterProxyModel model) {
        super(model);
        m_proxyModel = model;
    }

    private static String stripName(String s) {
        String[] tmp = s.split("\\.");
        return tmp[tmp.length - 1];
    }

    @Override
    public void paint(QPainter p, QStyleOptionViewItem option, QModelIndex index) {
        index = m_proxyModel.mapToSource(index);
        Launchable l = ((LaunchableListModel)m_proxyModel.sourceModel()).at(index);
        String text = stripName(l.name());
        boolean selected = (option.state().isSet(QStyle.StateFlag.State_Selected));
        QRectF rect = new QRectF(option.rect());
        rect.adjust(3, 1, -3, -1);
        if (selected) {
            Style.drawShadeButton(p, rect, new QStyle.State(QStyle.StateFlag.State_Enabled));
            Style.drawButtonOutline(p, rect, new QStyle.State(Style.StateFlag.State_Enabled));
        }

        Style.drawShadowText(p, rect.translated(0, -1), text, 2, 2);
    }

    @Override
    public QSize sizeHint(QStyleOptionViewItem option, QModelIndex index) {
        index = m_proxyModel.mapToSource(index);
        Launchable l = ((LaunchableListModel)m_proxyModel.sourceModel()).at(index);

        String text = stripName(l.name());

        QRect rect = option.fontMetrics().boundingRect(text);

        return new QSize(rect.width() + MARGE_HOR * 2, rect.height() + MARGE_VER * 2);
    }

    // Member variables...
    private QSortFilterProxyModel m_proxyModel;
}
