/****************************************************************************
**
** Copyright (C) 1992-2008 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** * Commercial Usage
* Licensees holding valid Qt Commercial licenses may use this file in
* accordance with the Qt Commercial License Agreement provided with the
* Software or, alternatively, in accordance with the terms contained in
* a written agreement between you and Nokia.
*
*
* GNU General Public License Usage
* Alternatively, this file may be used under the terms of the GNU
* General Public License versions 2.0 or 3.0 as published by the Free
* Software Foundation and appearing in the file LICENSE.GPL included in
* the packaging of this file.  Please review the following information
* to ensure GNU General Public Licensing requirements will be met:
* http://www.fsf.org/licensing/licenses/info/GPLv2.html and
* http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
* exception, Nokia gives you certain additional rights. These rights
* are described in the Nokia Qt GPL Exception version 1.2, included in
* the file GPL_EXCEPTION.txt in this package.
* 
* Qt for Windows(R) Licensees
* As a special exception, Nokia, as the sole copyright holder for Qt
* Designer, grants users of the Qt/Eclipse Integration plug-in the
* right for the Qt/Eclipse Integration to link to functionality
* provided by Qt Designer and its related libraries.
*
*
* If you are unsure which license is appropriate for your use, please
* contact the sales department at qt-sales@nokia.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.examples.qtconcurrent;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

import java.util.*;

public class Map {

    public static class MyMappedFunctor implements QtConcurrent.MappedFunctor<QImage, QImage> {
        public QImage map(QImage image) {
            System.err.println("Scaling image in thread: " + Thread.currentThread());
            return image.scaled(new QSize(100, 100), Qt.AspectRatioMode.IgnoreAspectRatio,
                    Qt.TransformationMode.SmoothTransformation);
        }
    }

    public static void main(String args[])
    {

        final int imageCount = 20;

        // Create a list containing imageCount images.
        List<QImage> images = new ArrayList<QImage>();
        for (int i = 0; i < imageCount; ++i)
            images.add(new QImage(1600, 1200, QImage.Format.Format_ARGB32_Premultiplied));

        MyMappedFunctor functor = new MyMappedFunctor();
        List<QImage> thumbnails = new ArrayList<QImage>();
        QTime time = new QTime();
        time.start();
        for (int i=0; i<imageCount; ++i) {
            thumbnails.add(functor.map(images.get(i)));
        }
        System.err.println("Time without QtConcurrent: " + time.elapsed() + "ms");

        // Use QtConcurrentBlocking::mapped to apply the scale function to all the
        // images in the list.
        time.restart();
        thumbnails = QtConcurrent.blockingMapped(images, functor);
        System.err.println("Time with QtConcurrent: " + time.elapsed() + "ms");

    }

}
