/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qtjambifunctiontable.h"
#include "qtjambi_cache.h"

#include <memory.h>

QtJambiFunctionTable::QtJambiFunctionTable(const QString &className,
                                         int size)
    : m_class_name(className),
      m_method_count(size),
      m_reference_count(1)
{
    m_method_ids = new jmethodID[size];

    for (int i=0; i<size; ++i)
        m_method_ids[i] = 0;
}

QtJambiFunctionTable::~QtJambiFunctionTable()
{
    removeFunctionTable(this);
    delete [] m_method_ids;
}

void QtJambiFunctionTable::ref()
{
    ++m_reference_count;
    Q_ASSERT(m_reference_count > 0);
}

void QtJambiFunctionTable::deref()
{
    --m_reference_count;
    Q_ASSERT(m_reference_count >= 0);
}
