/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GAMEACTION_H
#define GAMEACTION_H

#include "gamenamespace.h"

#include <QtCore/QVector>

class AbstractGameObject ;
class GameScene ;

class GameAction
{
public:
    inline GameAction(Game::ActionType type) : m_type(type) 
    {
    }
    virtual ~GameAction(){}

    virtual bool perform(GameScene *scene);
    virtual GameAction *clone() const = 0;

    inline void addObject(AbstractGameObject *o) { objects.append(o); }
    inline void addSubject(AbstractGameObject *o) { subjects.append(o); }

    inline Game::ActionType type() const { return m_type; }

protected:
    QVector<AbstractGameObject *> subjects;
    QVector<AbstractGameObject *> objects;

private:
    Game::ActionType m_type;

};

#endif
