/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.qt;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * QtPropertyDesignable specifies wether a proprety
 * is suitable for editing in a GUI builder (e.g., the Qt Designer).
 * It is the read method of the property that must be annotated.
 *
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface QtPropertyDesignable {
    /**
     * The value should be true or false depending on whether the
     * property is designable. It can also be the name of a boolean
     * method in the same class as the annotated method; it must
     * return true if the property is to be designable; otherwise,
     * false.
     */
    String value() default "true";
}
