#ifndef QTERMFRAME_H
#define QTERMFRAME_H


#include "statusBar.h"
#include <QPixmap>
#include <QByteArray>
#include <QString>
#include <QPaintEvent>
#include <QCloseEvent>
#include <QMainWindow>
#include <QEvent>
#include <QMenu>
#include <QSystemTrayIcon>

class QLineEdit;
class QToolButton;
class QMdiArea;
class QTabBar;
class QFontDialog;

namespace QTerm
{
class WndMgr;
class Window;
class QTermTimeLabel;
class Param;
class Config;

class Frame : public QMainWindow
{
    Q_OBJECT
public:
    Frame();
    ~Frame();
    static Frame * instance() {
        return s_instance;
    }

    void updateMenuToolBar();
    void enableMenuToolBar(bool);
    void popupFocusIn(Window * window = 0);
    void buzz();
    QMenu * genPopupMenu(QWidget * owner);
signals:
    void bossColor();
    void scrollChanged();
    void statusBarChanged(bool);

protected slots:
    void keyClicked(int);
    // Menu
    void addressBook();
    void quickLogin();
    void exitQTerm();

    void selectionChanged(int);
    void aboutQTerm();
    void homepage();
    void updateLang(QAction*);
    void defaultSetting();
    void preference();
    void reloadScript();
    void runScript();
    void stopScript();
    void debugConsole();

    // Toolbar
    void connectIt();
    void disconnect();
    void copy();
    void paste();
    void copyRect(bool);
    void copyColor(bool);
    void copyArticle();
    void autoCopy(bool);
    void wordWrap(bool);
    void updateESC(QAction*);
    void updateCodec(QAction*);
    void updateScroll(QAction*);
    void updateSwitchBar(bool);
    void updateStatusBar(bool);
    void appearance();
    void refresh();
    void triggerFullScreen(bool isFullScreen);
    void hideMenuBar(bool hide);
    void bosscolor();
    void uiFont();
    void antiIdle(bool);
    void autoReply(bool);
    void setting();
    void viewMessages();
    void updateMouse(bool);
    void updateBeep(bool);
    void reconnect(bool);
    void keySetup();
    void printScreen();

    void viewImages();

    void initThemesMenu();
    void themesMenuActivated(QAction *);
    void windowsMenuAboutToShow();
    void windowsMenuActivated();
    void connectMenuActivated(int);
    void popupConnectMenu();

    void trayActivated(QSystemTrayIcon::ActivationReason reason);
    void trayHide();
    void trayShow();
    void buildTrayMenu();

    void switchWin(int);
    void paintEvent(QPaintEvent *);

    void configShortcuts();
    void configToolbars();
    void slotShowQTerm();
public:
    QTabBar *tabBar;
    WndMgr * wndmgr;

    QMdiArea * m_MdiArea;
protected:
    //variables
    //QTermTimeLabel *labelTime;
    QMenu *windowsMenu;
    QMenu *themesMenu;

    QString theme;

    QToolBar * key;

    QMenu * escapeMenu;
    QMenu * langMenu;
    QMenu * connectMenu;

//  File
    QAction * m_connectAction;
    QAction * m_disconnectAction;
    QAction * m_addressAction;
    QAction * m_quickConnectAction;
    QAction * m_printAction;
    QAction * m_exitAction;

//  Edit
    QAction * m_copyAction;
    QAction * m_pasteAction;
    QAction * m_colorCopyAction;
    QAction * m_rectAction;
    QAction * m_autoCopyAction;
    QAction * m_wwrapAction;
    QAction * m_noescAction;
    QAction * m_escescAction;
    QAction * m_uescAction;
    QAction * m_customescAction;
    QAction * m_NoConvAction;
    QAction * m_S2TAction;
    QAction * m_T2SAction;

    QAction * m_appearanceAction;
    QAction * m_refreshAction;
    QAction * m_engAction;
    QAction * m_chsAction;
    QAction * m_chtAction;
    QAction * m_uiFontAction;
    QAction * m_fullAction;
    QAction * m_bossAction;
    QAction * m_scrollHideAction;
    QAction * m_scrollLeftAction;
    QAction * m_scrollRightAction;
    QAction * m_statusAction;
    QAction * m_switchAction;

//  View
    QAction * m_currentSessionAction;
    QAction * m_defaultAction;
    QAction * m_prefAction;
    QAction * m_copyArticleAction;
    QAction * m_antiIdleAction;
    QAction * m_autoReplyAction;
    QAction * m_viewMessageAction;
    QAction * m_beepAction;
    QAction * m_mouseAction;
    QAction * m_viewImageAction;
    QAction * m_menuBarAction;

    QAction * m_scriptReloadAction;
    QAction * m_scriptRunAction;
    QAction * m_scriptStopAction;
    QAction * m_scriptDebugAction;

    QAction * m_aboutAction;
    QAction * m_homepageAction;

    QAction * m_reconnectAction;
    QAction * m_shortcutsAction;
    QAction * m_toolbarsAction;

    StatusBar * m_pStatusBar;

    QToolButton *connectButton;

    QMenuBar * mainMenu;
    QToolBar *mdiconnectTools, *mdiTools;

//    bool m_bFullScreen;
//    bool m_bSwitchBar;

    QSystemTrayIcon *tray;
    QMenu *trayMenu;

    //function
    void newWindow(const Param& param, int index = -1);
    void closeEvent(QCloseEvent *);
    void selectStyleMenu(int , int);
    void iniSetting();
    void initActions();
    void initShortcuts();
    //void loadPref(Config *);
    void saveSetting();
    void saveShortcuts();
    void loadShortcuts();
    void saveToolbars();
    void loadToolbars();

    void addMainMenu();
    void addMainTool();

    void updateKeyToolBar();

    QAction * insertThemeItem(const QString &);
    void setUseTray(bool);
private:
    static Frame * s_instance;
};

} // namespace QTerm

#endif //QTERMFRAME_H

