/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (info@qt.nokia.com)
**
** GNU Lesser General Public License Usage
**
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this file.
** Please review the following information to ensure the GNU Lesser General
** Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** Other Usage
**
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#ifndef MAEMOPACKAGECREATIONSTEP_H
#define MAEMOPACKAGECREATIONSTEP_H

#include <projectexplorer/buildstep.h>

QT_BEGIN_NAMESPACE
class QDateTime;
class QFile;
class QProcess;
QT_END_NAMESPACE

namespace Qt4ProjectManager {
class Qt4BuildConfiguration;

namespace Internal {
class MaemoDeployStep;
class MaemoDeployableListModel;
class AbstractQt4MaemoTarget;
class AbstractDebBasedQt4MaemoTarget;
class AbstractRpmBasedQt4MaemoTarget;

class MaemoPackageCreationStep : public ProjectExplorer::BuildStep
{
    Q_OBJECT
    friend class MaemoPackageCreationFactory;
public:
    MaemoPackageCreationStep(ProjectExplorer::BuildStepList *bsl);
    ~MaemoPackageCreationStep();

    QString packageFilePath() const;
    bool isPackagingEnabled() const;
    void setPackagingEnabled(bool enabled) { m_packagingEnabled = enabled; }

    QString versionString(QString *error) const;
    bool setVersionString(const QString &version, QString *error);

    static void preparePackagingProcess(QProcess *proc,
        const Qt4BuildConfiguration *bc, const QString &workingDir);
    static QString packagingCommand(const Qt4BuildConfiguration *bc,
        const QString &commandName);
    static void ensureShlibdeps(QByteArray &rulesContent);

    QString projectName() const;
    const Qt4BuildConfiguration *qt4BuildConfiguration() const;
    AbstractQt4MaemoTarget *maemoTarget() const;
    AbstractDebBasedQt4MaemoTarget *debBasedMaemoTarget() const;
    AbstractRpmBasedQt4MaemoTarget *rpmBasedMaemoTarget() const;

    static const QLatin1String DefaultVersionNumber;

signals:
    void packageFilePathChanged();
    void qtVersionChanged();

private slots:
    void handleBuildOutput();
    void handleBuildConfigChanged();

private:
    MaemoPackageCreationStep(ProjectExplorer::BuildStepList *buildConfig,
                             MaemoPackageCreationStep *other);

    void ctor();
    virtual bool init();
    virtual void run(QFutureInterface<bool> &fi);
    virtual ProjectExplorer::BuildStepConfigWidget *createConfigWidget();
    virtual bool immutable() const { return true; }
    virtual QVariantMap toMap() const;
    virtual bool fromMap(const QVariantMap &map);

    bool createPackage(QProcess *buildProc);
    bool copyDebianFiles(bool inSourceBuild);
    static QString nativePath(const QFile &file);
    bool packagingNeeded() const;
    bool isFileNewerThan(const QString &filePath,
        const QDateTime &timeStamp) const;
    void raiseError(const QString &shortMsg,
                    const QString &detailedMsg = QString());
    QString buildDirectory() const;
    MaemoDeployStep * deployStep() const;
    void checkProjectName();
    void adaptRulesFile(const QString &rulesFilePath);
    void addWorkaroundForHarmattanBug(QByteArray &rulesFileContent,
        int &insertPos, const MaemoDeployableListModel *model,
        const QString &desktopFileDir);
    void addSedCmdToRulesFile(QByteArray &rulesFileContent, int &insertPos,
        const QString &desktopFilePath, const QByteArray &oldString,
        const QByteArray &newString);
    static QString replaceDots(const QString &name);
    static QString rpmBuildDir(const Qt4BuildConfiguration *bc);

    static const QLatin1String CreatePackageId;

    bool m_packagingEnabled;
    const Qt4BuildConfiguration *m_lastBuildConfig;
};

} // namespace Internal
} // namespace Qt4ProjectManager

#endif // MAEMOPACKAGECREATIONSTEP_H
