/* Copyright (C) 2004 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef QTADSCVMMAINCLIENTCONSOLE_H
#define QTADSCVMMAINCLIENTCONSOLE_H

#include "config.h"

#include <qmessagebox.h>

#include "vmmaincn.h"

#include "qtadscharmap.h"


/* We don't customize anything in this subclass, but we might at some
 * point.  Also useful for quick&dirty tests.
 */
class QTadsCVmConsoleMain: public CVmConsoleMain
{
  public:
	QTadsCVmConsoleMain( VMG0_ )
	: CVmConsoleMain(vmg0_)
	{ }
};


/* QTads-specific client services interface for the T3 VM.
 *
 * TODO: Maybe override display_error() to show errors using dialogs.
 */
class QTadsCVmMainClientConsole: public CVmMainClientConsole {
  public:
	//virtual void
	//display_error( struct vmglobals* globals, const char* msg, int );

	// Create our customized version of the console.
	virtual class CVmConsoleMain*
	create_console( VMG0_ )
	{
		return new QTadsCVmConsoleMain(vmg0_);
	}
};


/*
inline void
QTadsCVmMainClientConsole::display_error( struct vmglobals* globals, const char* msg, int )
{
	QMessageBox::critical(0, QObject::tr("VM Error"), msg,
			      QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
}
*/

#endif // QTADSCVMMAINCLIENTCONSOLE_H
