/***************************************************************************
                          configdiag.cpp  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "configdiag.h"
#include <stdlib.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qdatetime.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qapplication.h>
#include "qsstvglobal.h" 
#include "dirdialog.h"
#include "sstvtx.h"
#include "sstvparam.h"
#include "dspfunc.h"
#include "sstvrx.h"


configDialog::configDialog(QWidget *parent, const char *name,bool modal) : configForm(parent,name,modal)
{
	int i;
	for (i=0;i<NUMBEROFIMAGEFORMATS;i++)
    {
      defaultImageFormatComboBox->insertItem(imageFormatStr[i]);
			ftpDefaultImageFormatComboBox->insertItem(imageFormatStr[i]);
    }

	for (i=0;i<NUMBEROFTXMODES;i++)
		{
			repeaterTxModeComboBox->insertItem(TXModesText[i]);
		}
	initialize();
}




void configDialog::initialize()
{
  int ttemp,i;
  char temp[255];


  sprintf(temp,"%4f",fRXsamplingrate);
  rxClockLineEdit->setText(temp);
  sprintf(temp,"%4f",fTXsamplingrate);
  txClockLineEdit->setText(temp);

  utcCheckBox->setChecked(bUTC);

  rxImageLineEdit->setText(configFile.readOption("ImageRxDir"));
  txImageLineEdit->setText(configFile.readOption("ImageTxDir"));
  audioRecordsLineEdit->setText(configFile.readOption("SoundDir"));
	docPathLineEdit->setText(configFile.readOption("PathUserGuide"));
  const char *stemp=configFile.readOption("ImageFormat");
  defaultImageFormatComboBox->setCurrentItem(0);
  for (i=0;i<NUMBEROFIMAGEFORMATS;i++)
    {
      if(strcmp(imageFormatStr[i],stemp)==0)
				{
				 defaultImageFormatComboBox->setCurrentItem(i);
				 break;
				}
    }
  	
  tn1LineEdit->setText(configFile.readOption("Thumbnailr1c1"));
  tn2LineEdit->setText(configFile.readOption("Thumbnailr1c2"));
  tn3LineEdit->setText(configFile.readOption("Thumbnailr1c3"));
  tn4LineEdit->setText(configFile.readOption("Thumbnailr1c4"));
  tn5LineEdit->setText(configFile.readOption("Thumbnailr1c5"));
  tn6LineEdit->setText(configFile.readOption("Thumbnailr1c6"));
  audioDeviceLineEdit->setText(configFile.readOption("Audiodev"));
  serialPortLineEdit->setText(configFile.readOption("Comdev"));
  bn1LineEdit->setText(configFile.readOption("Bannerimage1"));
  bn2LineEdit->setText(configFile.readOption("Bannerimage2"));
  bn3LineEdit->setText(configFile.readOption("Bannerimage3"));
  bn4LineEdit->setText(configFile.readOption("Bannerimage4"));

  textToSendLineEdit->setText(configFile.readOption("CWText"));
  wpmSpinBox->setValue(iCWWPM);
  toneSpinBox->setValue(iCWHz);

  repeaterTxModeComboBox->setCurrentItem(lookupModeString(configFile.readOption("RepeaterMode")));
  repeaterImage1LineEdit->setText(configFile.readOption("Repeaterimage1"));
  repeaterImage2LineEdit->setText(configFile.readOption("Repeaterimage2"));
  repeaterImage3LineEdit->setText(configFile.readOption("Repeaterimage3"));
  repeaterImage4LineEdit->setText(configFile.readOption("Repeaterimage4"));
  acknowledgeLineEdit->setText(configFile.readOption("RepeaterAckText"));
  identificationLineEdit->setText(configFile.readOption("RepeaterIDText"));
  configFile.readOption("RepeaterImageInterval",ttemp);
  imageIntervalSpinBox->setValue(ttemp);

  configFile.readOption("FTP",ttemp);
  enableFTPCheckBox->setChecked(ttemp);
	configFile.readOption("FTPPort",ttemp);
  ftpPortSpinBox->setValue(ttemp);

  remoteHostLineEdit->setText(configFile.readOption("FTPHost"));
  remoteDirectoryLineEdit->setText(configFile.readOption("FTPRemDirectory"));
  ftpLoginLineEdit->setText(configFile.readOption("FTPUser"));
  ftpPasswordLineEdit->setText(configFile.readOption("FTPPassword"));
  ftpFilenameLineEdit->setText(configFile.readOption("FTPFilename"));
  stemp=configFile.readOption("FTPImageFormat");
  ftpDefaultImageFormatComboBox->setCurrentItem(0);
  for (i=0;i<NUMBEROFIMAGEFORMATS;i++)
    {
      if(strcmp(imageFormatStr[i],stemp)==0)
				{
	 				ftpDefaultImageFormatComboBox->setCurrentItem(i);
	 				break;
				}
    }
 	// FAX
 	faxName1->setText(configFile.readOption("faxName1"));
 	lpm1SpinBox->setValue(faxlpm1);
	ioc1SpinBox->setValue(faxioc1);
	colors1ComboBox->setCurrentItem(faxColors1);
  lines1SpinBox->setValue(faxLines1);
  polarity1CheckBox->setChecked(faxInvp1);

  faxName2->setText(configFile.readOption("faxName2"));
 	lpm2SpinBox->setValue(faxlpm2);
	ioc2SpinBox->setValue(faxioc2);
	colors2ComboBox->setCurrentItem(faxColors2);
  lines2SpinBox->setValue(faxLines2);
  polarity2CheckBox->setChecked(faxInvp2);


  faxName3->setText(configFile.readOption("faxName3"));
	lpm3SpinBox->setValue(faxlpm3);
	ioc3SpinBox->setValue(faxioc3);
	colors3ComboBox->setCurrentItem(faxColors3);
  lines3SpinBox->setValue(faxLines3);
  polarity3CheckBox->setChecked(faxInvp3);

  faxName4->setText(configFile.readOption("faxName4"));
	lpm4SpinBox->setValue(faxlpm4);
	ioc4SpinBox->setValue(faxioc4);
	colors4ComboBox->setCurrentItem(faxColors4);
  lines4SpinBox->setValue(faxLines4);
  polarity4CheckBox->setChecked(faxInvp4);
}


void configDialog::apply()
{
  sscanf(rxClockLineEdit->text(),"%f",&fRXsamplingrate);
  sscanf(txClockLineEdit->text(),"%f",&fTXsamplingrate);
  configFile.setOption("RXSamplingRate",fRXsamplingrate);
  configFile.setOption("TXSamplingRate",fTXsamplingrate);
  configFile.setOption("ImageRxDir", rxImageLineEdit->text());
  configFile.setOption("ImageTxDir", txImageLineEdit->text());
  configFile.setOption("SoundDir", audioRecordsLineEdit->text());
  configFile.setOption("PathUserGuide", docPathLineEdit->text());
  configFile.setOption("ImageFormat",
		       imageFormatStr[defaultImageFormatComboBox->currentItem()]);

  configFile.setOption("Thumbnailr1c1",tn1LineEdit->text());
  configFile.setOption("Thumbnailr1c2",tn2LineEdit->text());
  configFile.setOption("Thumbnailr1c3",tn3LineEdit->text());
  configFile.setOption("Thumbnailr1c4",tn4LineEdit->text());
  configFile.setOption("Thumbnailr1c5",tn5LineEdit->text());
  configFile.setOption("Thumbnailr1c6",tn6LineEdit->text());

  configFile.setOption("Bannerimage1",bn1LineEdit->text());
  configFile.setOption("Bannerimage2",bn2LineEdit->text());
  configFile.setOption("Bannerimage3",bn3LineEdit->text());
  configFile.setOption("Bannerimage4",bn4LineEdit->text());



  configFile.setOption("Audiodev",audioDeviceLineEdit->text());
  configFile.setOption("Comdev",serialPortLineEdit->text());
	configFile.setOption("CWText",textToSendLineEdit->text());
	iCWWPM=wpmSpinBox->value();
	iCWHz=toneSpinBox->value();

  configFile.setOption("Repeaterimage1",repeaterImage1LineEdit->text());
  configFile.setOption("Repeaterimage2",repeaterImage2LineEdit->text());
  configFile.setOption("Repeaterimage3",repeaterImage3LineEdit->text());
  configFile.setOption("Repeaterimage4",repeaterImage4LineEdit->text());
  configFile.setOption("RepeaterMode",getMode(repeaterTxModeComboBox->currentItem()));
  configFile.setOption("RepeaterImageInterval",imageIntervalSpinBox->value());
  configFile.setOption("RepeaterAckText",acknowledgeLineEdit->text());
  configFile.setOption("RepeaterIDText",identificationLineEdit->text());

  configFile.setOption("FTPHost",remoteHostLineEdit->text());
  configFile.setOption("FTPRemDirectory",remoteDirectoryLineEdit->text());
  configFile.setOption("FTPUser",ftpLoginLineEdit->text());
  configFile.setOption("FTPPassword",ftpPasswordLineEdit->text());
	configFile.setOption("FTPPort",ftpPortSpinBox->value());
  configFile.setOption("FTPFilename",ftpFilenameLineEdit->text());
  configFile.setOption("FTPImageFormat",
		       imageFormatStr[ftpDefaultImageFormatComboBox->currentItem()]);
	
	bUTC=utcCheckBox->isChecked();
	bftp=enableFTPCheckBox->isChecked();

  tx->setupBanners();

  //Fax
	configFile.setOption("faxName1",faxName1->text());
	faxlpm1=lpm1SpinBox->value();
	faxioc1=ioc1SpinBox->value();
	faxColors1=colors1ComboBox->currentItem();
	faxLines1=lines1SpinBox->value();
	faxInvp1=polarity1CheckBox->isChecked();
	
	configFile.setOption("faxName2",faxName2->text());
	faxlpm2=lpm2SpinBox->value();
	faxioc2=ioc2SpinBox->value();
	faxColors2=colors2ComboBox->currentItem();
	faxLines2=lines2SpinBox->value();
	faxInvp2=polarity2CheckBox->isChecked();
	
	configFile.setOption("faxName3",faxName3->text());
	faxlpm3=lpm3SpinBox->value();
	faxioc3=ioc3SpinBox->value();
	faxColors3=colors3ComboBox->currentItem();
	faxLines3=lines3SpinBox->value();	
	faxInvp3=polarity3CheckBox->isChecked();
	
	configFile.setOption("faxName4",faxName4->text());
	faxlpm4=lpm4SpinBox->value();
	faxioc4=ioc4SpinBox->value();
	faxColors4=colors4ComboBox->currentItem();
	faxLines4=lines4SpinBox->value();
	faxInvp4=polarity4CheckBox->isChecked();
	rx->slotFaxTypeChanged(faxType);
}


void configDialog::setDirectory(QLineEdit *d)
{
	QString fn;
  dirDialog dd(0,0,TRUE);
  fn=dd.openDirName(getenv("HOME"));
  if(!fn.isNull())
    {
      d->setText(fn);
    }
}

void configDialog::setFileName(QLineEdit *d)
{
	QString fn;
  dirDialog dd(0,0,TRUE);
  fn=dd.openFileName(getenv("HOME"));
  if(!fn.isNull())
    {
      d->setText(fn);
    }
}


void configDialog::setFileNameTXImage(QLineEdit *d)
{
	QString fn;
  dirDialog dd(0,0,TRUE);
  fn=dd.openFileName(txImageLineEdit->text());
	 if(!fn.isNull())
    {
      d->setText(fn);
    }
}

void configDialog::audioRecords_slot()
{
	setDirectory(audioRecordsLineEdit);
}

void configDialog::rxImage_slot()
{
	setDirectory(rxImageLineEdit);
}

void configDialog::txImage_slot()
{
	setDirectory(txImageLineEdit);
}


void configDialog::docPath_slot()
{
	setDirectory(docPathLineEdit);
}

void configDialog::bn1_slot()
{
	setFileNameTXImage(bn1LineEdit);
}
void configDialog::bn2_slot()
{
	setFileNameTXImage(bn2LineEdit);
}
void configDialog::bn3_slot()
{
	setFileNameTXImage(bn3LineEdit);
}
void configDialog::bn4_slot()
{
	setFileNameTXImage(bn4LineEdit);
}

void configDialog::tn1_slot()
{
	setFileNameTXImage(tn1LineEdit);
}
void configDialog::tn2_slot()
{
	setFileNameTXImage(tn2LineEdit);
}
void configDialog::tn3_slot()
{
	setFileNameTXImage(tn3LineEdit);
}
void configDialog::tn4_slot()
{
	setFileNameTXImage(tn4LineEdit);
}
void configDialog::tn5_slot()
{
	setFileNameTXImage(tn5LineEdit);
}
void configDialog::tn6_slot()
{
	setFileNameTXImage(tn6LineEdit);
}

void configDialog::im1_slot()
{
	setFileName(repeaterImage1LineEdit);
}
void configDialog::im2_slot()
{
	setFileName(repeaterImage2LineEdit);
}
void configDialog::im3_slot()
{
	setFileName(repeaterImage3LineEdit);
}
void configDialog::im4_slot()
{
	setFileName(repeaterImage4LineEdit);
}

void configDialog::accept()
{
	apply();
	QDialog::accept();
}
