/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.text.DecimalFormat;
import molikin.AtomIDer;

public class PrekinIDer
implements AtomIDer {
    static final DecimalFormat df2 = Strings.usDecimalFormat("0.00");

    public String identifyAtom(AtomState atomState) {
        Residue residue = atomState.getResidue();
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(atomState.getName());
        stringBuffer.append(atomState.getAltConf());
        stringBuffer.append(residue.getName());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getChain());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getSequenceNumber().trim());
        stringBuffer.append(residue.getInsertionCode());
        if (atomState.getTempFactor() > 0.0 || atomState.getOccupancy() < 1.0) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length() + 8);
            stringBuffer2.append(stringBuffer.toString().toLowerCase());
            if (atomState.getOccupancy() < 1.0) {
                stringBuffer2.append(" " + df2.format(atomState.getOccupancy()) + "B");
            } else {
                stringBuffer2.append(" B");
            }
            stringBuffer2.append(df2.format(atomState.getTempFactor()));
            return stringBuffer2.toString();
        }
        return stringBuffer.toString().toLowerCase();
    }
}

